/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.rule;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IMultiImportValidatorService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.constant.HcfCandidateConstants;
import kd.hr.hom.common.entity.ErrorMsgSyncProcessor;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.IDCardUtils;

public class OnbrdMultiImportValidator
implements IMultiImportValidatorService,
Serializable {
    private static final Log logger = LogFactory.getLog(OnbrdMultiImportValidator.class);
    private static final long serialVersionUID = 29146256047307837L;
    private static final Map<String, String> hcfBaseInfoFieldMap = ImmutableMap.builder().put((Object)"name", (Object)"name").put((Object)"gender", (Object)"gender").put((Object)"birthday", (Object)"birthday").put((Object)"folk", (Object)"folk").put((Object)"nationality", (Object)"nationality").put((Object)"nameen", (Object)"nameen").put((Object)"engname", (Object)"engname").put((Object)"nativeplace", (Object)"nativeplace").put((Object)"marriagestatus", (Object)"marriagestatus").put((Object)"beginservicedate", (Object)"beginservicedate").build();
    private static final Map<String, String> hcfOthoerinfoFieldMap = ImmutableMap.builder().build();
    private static final Map<String, String> hcfContactinfoFieldMap = ImmutableMap.builder().put((Object)"phone", (Object)"phone").put((Object)"peremail", (Object)"peremail").put((Object)"commucountry", (Object)"commucountry").put((Object)"commuaddress", (Object)"commuaddress").build();
    private static final Map<String, String> hcfCretificateFieldMap = ImmutableMap.builder().put((Object)"certificatetype", (Object)"credentialstype").put((Object)"certificatenumber", (Object)"number").build();
    protected static final Map<String, Map<String, String>> HCF_ENTITY_FIELD_MAP = ImmutableMap.builder().put((Object)"hcf_canbaseinfo", hcfBaseInfoFieldMap).put((Object)"hcf_canotherinfo", hcfOthoerinfoFieldMap).put((Object)"hcf_cancontactinfo", hcfContactinfoFieldMap).put((Object)"hcf_cancre", hcfCretificateFieldMap).build();

    @Override
    public void validate(String optionCode, List<MultiEntityRowData> rowDataList, ImportLogger importLogger) {
        Set<Long> candidateIdSet;
        MultiImportErrorMsgSynchronizer multiImportErrorMsgSynchronizer = new MultiImportErrorMsgSynchronizer();
        List<HomCommonWrapper> rowDataWrapperList = rowDataList.stream().map(rowData -> new HomCommonWrapper(rowData.getOpEntity(), rowData, rowData.getRownum().intValue(), (Object)importLogger, (ErrorMsgSyncProcessor)multiImportErrorMsgSynchronizer)).collect(Collectors.toList());
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        onbrdCommonValidator.setDefaultValueBeforeValidate(rowDataWrapperList);
        onbrdCommonValidator.validateImportMustInput(rowDataWrapperList);
        IOnbrdInfoInitService.getInstance().initFieldValue(rowDataWrapperList, InitTypeEnum.ONBRD_NEW_IMPORT.getValue());
        onbrdCommonValidator.validAjobScmOrgPermission(rowDataWrapperList);
        onbrdCommonValidator.validateDataFormat(rowDataWrapperList);
        onbrdCommonValidator.judgeIfDuplicate(rowDataWrapperList);
        onbrdCommonValidator.checkChgevent(rowDataWrapperList);
        onbrdCommonValidator.checkEmpgroup(rowDataWrapperList);
        onbrdCommonValidator.validateCadre(rowDataWrapperList);
        onbrdCommonValidator.validPreOnbrd(rowDataWrapperList);
        onbrdCommonValidator.validateVirtuallyOrg(rowDataWrapperList);
        onbrdCommonValidator.validateDepartPerson(rowDataWrapperList);
        Set errorRows = importLogger.getLogCache().keySet();
        if (HRStringUtils.equals((String)optionCode, (String)"new") && !CollectionUtils.isEmpty(candidateIdSet = rowDataList.stream().filter(rowData -> errorRows.contains(rowData.getRownum())).map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet()))) {
            Map<Long, DynamicObject> relatedCandidateIds = IOnbrdBillDomainService.getInstance().queryByCandidateId(candidateIdSet, "candidate");
            relatedCandidateIds.forEach((key, value) -> candidateIdSet.remove(key));
            new HcfDataDomainService().deleteByIds(candidateIdSet, "hcf_candidate");
        }
        List<HomCommonWrapper> onbrdBillWrapperList = rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() == 0).collect(Collectors.toList());
        IOnbrdInfoInitService.getInstance().initFieldValue(onbrdBillWrapperList, InitTypeEnum.ONBRD_NEW_IMPORT.getValue());
        this.setValueByCertNumber(onbrdBillWrapperList);
        onbrdCommonValidator.validNumber(onbrdBillWrapperList);
        onbrdCommonValidator.validIsInBlackList(onbrdBillWrapperList);
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(onbrdBillWrapperList);
        List<MultiEntityRowData> validatePassList = rowDataList.stream().filter(rowData -> !errorRows.contains(rowData.getRownum())).collect(Collectors.toList());
        for (Map.Entry<String, Map<String, String>> entry : HCF_ENTITY_FIELD_MAP.entrySet()) {
            logger.info("saveSingleRowEntity:" + entry.getKey());
            this.saveSingleRowEntity(optionCode, validatePassList, entry.getKey(), entry.getValue());
        }
        logger.info("saveCanAddressInfo:" + validatePassList.size());
        this.saveCanAddressInfo(optionCode, validatePassList);
    }

    private void setValueByCertNumber(List<HomCommonWrapper> onbrdBillWrapperList) {
        DynamicObject nationalityChina = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_nationality", BaseDataIdConstants.HBSS_NATIONALITY_1010, "number");
        DynamicObject sexMan = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1010, "number");
        DynamicObject sexWoman = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1020, "number");
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
            IDCardInfo idCardInfo = null;
            if (!HRObjectUtils.isEmpty((Object)certificateType)) {
                long cerTypeNum = certificateType.getLong("id");
                if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == cerTypeNum) {
                    idCardInfo = IDCardUtils.parse((String)onbrdBill.getString("certificatenumber"));
                }
            }
            if (idCardInfo == null) continue;
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"nationality", (Object)nationalityChina);
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"gender", (Object)(idCardInfo.getGender() ? sexMan : sexWoman));
            HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)onbrdBill, (String)"birthday", (Object)idCardInfo.getBirthDay());
        }
    }

    private void saveSingleRowEntity(String optionCode, List<MultiEntityRowData> validatePassList, String entityName, Map<String, String> hcfFieldMap) {
        Set<Long> candidateIds = validatePassList.stream().map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet());
        Map<Object, Object> singleRowEntityMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        StringBuilder properties = new StringBuilder("id");
        if (!CollectionUtils.isEmpty(hcfFieldMap)) {
            hcfFieldMap.values().forEach(fieldName -> properties.append(',').append((String)fieldName));
        }
        if (!HRStringUtils.equals((String)optionCode, (String)"new")) {
            singleRowEntityMap = hcfDataDomainService.querySingleRowEntity(candidateIds, entityName, properties.toString());
        }
        for (MultiEntityRowData rowData2 : validatePassList) {
            DynamicObject onbrdBill = rowData2.getOpEntity();
            Long candidateId = onbrdBill.getLong("candidate.id");
            DynamicObject singleRowEntity = (DynamicObject)singleRowEntityMap.get(candidateId);
            if (HRObjectUtils.isEmpty((Object)singleRowEntity)) {
                singleRowEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                singleRowEntity.set("candidate", (Object)candidateId);
            }
            for (Map.Entry<String, String> entry : hcfFieldMap.entrySet()) {
                singleRowEntity.set(entry.getValue(), onbrdBill.get(entry.getKey()));
            }
            if (HRStringUtils.equals((String)"hcf_cancre", (String)entityName)) {
                singleRowEntity.set("ismajor", (Object)Boolean.TRUE);
                singleRowEntity.set("percardname", (Object)onbrdBill.getString("name"));
                singleRowEntity.set("gender", (Object)onbrdBill.getString("gender"));
            }
            singleRowEntityMap.put(candidateId, singleRowEntity);
        }
        hcfDataDomainService.saveHcfAttachedData(entityName, singleRowEntityMap.values().toArray(new DynamicObject[singleRowEntityMap.size()]));
    }

    private void saveCanAddressInfo(String optionCode, List<MultiEntityRowData> validatePassList) {
        Set<Long> candidateIds = validatePassList.stream().map(rowData -> rowData.getOpEntity().getLong("candidate.id")).collect(Collectors.toSet());
        Map<Object, Object> multiRowEntityMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        if (!HRStringUtils.equals((String)optionCode, (String)"new")) {
            StringBuilder properties = new StringBuilder("id").append(",").append("addresstype").append(",").append("countrycode").append(",").append("addressinfo");
            multiRowEntityMap = hcfDataDomainService.queryMultiRowEntity(candidateIds, "hcf_canaddress", properties.toString());
        }
        Map<Long, DynamicObject> addressTypeMap = this.getAddressTypeMap();
        ArrayList<DynamicObject> addressSaveList = new ArrayList<DynamicObject>(3);
        for (MultiEntityRowData rowData2 : validatePassList) {
            DynamicObject regresidenceAddressDy;
            DynamicObject liveAddressDy;
            DynamicObject commuAddressDy;
            DynamicObject onbrdBill = rowData2.getOpEntity();
            Long candidateId = onbrdBill.getLong("candidate.id");
            DynamicObjectCollection multiRowEntity = (DynamicObjectCollection)multiRowEntityMap.get(candidateId);
            Map<Object, Object> addressMap = Maps.newHashMapWithExpectedSize((int)3);
            if (!CollectionUtils.isEmpty((Collection)multiRowEntity)) {
                addressMap = multiRowEntity.stream().collect(Collectors.toMap(rowEntity -> rowEntity.getLong("addresstype.id"), rowEntity -> rowEntity, (oldValue, newValue) -> newValue));
            }
            if (HRObjectUtils.isEmpty((Object)(commuAddressDy = (DynamicObject)addressMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID)))) {
                commuAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
                commuAddressDy.set("candidate", (Object)candidateId);
                commuAddressDy.set("addresstype", (Object)addressTypeMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID));
            }
            if (HRObjectUtils.isEmpty((Object)(liveAddressDy = (DynamicObject)addressMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID)))) {
                liveAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
                liveAddressDy.set("candidate", (Object)candidateId);
                liveAddressDy.set("addresstype", (Object)addressTypeMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID));
            }
            if (HRObjectUtils.isEmpty((Object)(regresidenceAddressDy = (DynamicObject)addressMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID)))) {
                regresidenceAddressDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hcf_canaddress"));
                regresidenceAddressDy.set("candidate", (Object)candidateId);
                regresidenceAddressDy.set("addresstype", (Object)addressTypeMap.get(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID));
            }
            if (onbrdBill.get("commucountry") != null || HRStringUtils.isNotEmpty((String)onbrdBill.getString("commuaddress"))) {
                commuAddressDy.set("countrycode", onbrdBill.get("commucountry"));
                commuAddressDy.set("addressinfo", onbrdBill.get("commuaddress"));
                addressSaveList.add(commuAddressDy);
            }
            if (onbrdBill.get("livecountry") != null || HRStringUtils.isNotEmpty((String)onbrdBill.getString("liveaddressdetail"))) {
                liveAddressDy.set("countrycode", onbrdBill.get("livecountry"));
                liveAddressDy.set("addressinfo", onbrdBill.get("liveaddressdetail"));
                addressSaveList.add(liveAddressDy);
            }
            if (onbrdBill.get("regresidencecountry") == null && !HRStringUtils.isNotEmpty((String)onbrdBill.getString("regresidenceaddressdetail"))) continue;
            regresidenceAddressDy.set("countrycode", onbrdBill.get("regresidencecountry"));
            regresidenceAddressDy.set("addressinfo", onbrdBill.get("regresidenceaddressdetail"));
            addressSaveList.add(regresidenceAddressDy);
        }
        hcfDataDomainService.saveHcfAttachedData("hcf_canaddress", addressSaveList.toArray(new DynamicObject[addressSaveList.size()]));
    }

    private Map<Long, DynamicObject> getAddressTypeMap() {
        HashMap<Long, DynamicObject> addressTypeMap = new HashMap<Long, DynamicObject>();
        addressTypeMap.put(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID, IHcfDataDomainService.getInstance().getAddressTypeById(HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID));
        addressTypeMap.put(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID, IHcfDataDomainService.getInstance().getAddressTypeById(HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID));
        addressTypeMap.put(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID, IHcfDataDomainService.getInstance().getAddressTypeById(HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID));
        return addressTypeMap;
    }

    public static class MultiImportErrorMsgSynchronizer
    implements ErrorMsgSyncProcessor<ImportLogger, MultiEntityRowData> {
        public void process(ImportLogger importLogger, MultiEntityRowData rowData, String errorMsg) {
            importLogger.log(rowData.getRownum(), errorMsg);
        }
    }
}

