/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.staff;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.model.org.staff.StaffUseInParam;
import kd.hr.hbp.common.model.org.staff.StaffUseParam;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hom.business.onbrd.IStaffOnbrdExtendService;
import kd.sdk.hr.hpfs.business.config.service.IDevParamConfigService;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import org.apache.commons.lang3.time.DateUtils;

public class StaffUseServiceImpl
implements IStaffUseService {
    private final Log LOGGER = LogFactory.getLog(StaffUseServiceImpl.class);
    public static final String OPCODE_NEW = "NEW";
    public static final String OPCODE_UPDATE = "UPDATE";
    public static final String SELECT_PROPERTIES = "id,name,employeeno,billno,candidate,aadminorg,apositiontype,aposition,stdposition,ajob,ajoblevel,laborreltype,effectdate,viewtype,personfield";
    private static final Set<String> SELECT_PROPERTIES_SET = Sets.newHashSet((Object[])new String[]{"id", "name", "employeeno", "billno", "candidate", "aadminorg", "apositiontype", "aposition", "stdposition", "ajob", "ajoblevel", "laborreltype", "effectdate", "viewtype", "personfield", "personindexid", "createtime"});
    private static final Set<String> DIMENSION_FIELDS = ImmutableSet.of((Object)"aadminorg", (Object)"aposition", (Object)"ajob", (Object)"ajoblevel", (Object)"laborreltype", (Object)"effectdate", (Object[])new String[0]);

    @Override
    public StaffQueryOutParam queryStaffUseInfo(DynamicObject onbrdBill, String opCode) {
        Map<Long, StaffQueryOutParam> resultMap = this.queryStaffUseInfos(new DynamicObject[]{onbrdBill}, opCode);
        return resultMap.get(onbrdBill.getLong("candidate.id"));
    }

    @Override
    public Map<Long, StaffQueryOutParam> queryStaffUseInfos(DynamicObject[] onbrdBills, String opCode) {
        StaffResponse staffResponse;
        List<StaffQueryInParam> staffQueryInParams = this.getStaffUseInParamForQuery(onbrdBills, opCode);
        if (HRCollUtil.isEmpty(staffQueryInParams)) {
            return Collections.emptyMap();
        }
        try {
            staffResponse = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"getStaffUseInfoDetail", (Object[])new Object[]{staffQueryInParams});
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7f16\u5236\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"StaffUseServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (!staffResponse.isSuccess() || CollectionUtils.isEmpty((Map)((Map)staffResponse.getData()))) {
            this.LOGGER.error("###StaffUseServiceImpl.queryStaffUseInfos, staffResponse:{}", (Object)HOMObjectUtils.toJSONString((Object)staffResponse));
            return new HashMap<Long, StaffQueryOutParam>();
        }
        Map dataMap = (Map)staffResponse.getData();
        return dataMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong(((String)entry.getKey()).substring(1)), Map.Entry::getValue, (oldValue, newValue) -> newValue));
    }

    private List<StaffQueryInParam> getStaffUseInParamForQuery(DynamicObject[] onbrdBills, String opCode) {
        ArrayList<StaffQueryInParam> staffQueryInParams = new ArrayList<StaffQueryInParam>(onbrdBills.length);
        List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        boolean extendStaff = !HRStringUtils.isBlank((CharSequence)staffAdminOrg);
        int dimensionSize = dimension == null || dimension.isEmpty() ? 0 : dimension.size();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IStaffOnbrdExtendService.class, (String)"kd.sdk.hr.hom.business.onbrd.IStaffOnbrdExtendService", null);
        for (DynamicObject onbrdBill : onbrdBills) {
            List occupyStaff = hrPluginProxy.callReplace(hrPlugin -> hrPlugin.occupyStaffOrNot(onbrdBill));
            this.LOGGER.info("IStaffOnbrdExtendService.occupyStaff={}", (Object)occupyStaff);
            if (!HRCollUtil.isEmpty((Collection)occupyStaff) && Boolean.FALSE.equals(occupyStaff.get(0))) {
                this.LOGGER.warn("IStaffOnbrdExtendService.occupyStaffOrNot, onbrdid:{}", (Object)onbrdBill.getLong("id"));
                continue;
            }
            StaffQueryInParam staffQueryInParam = new StaffQueryInParam();
            if (HRStringUtils.equals((String)OPCODE_UPDATE, (String)opCode)) {
                staffQueryInParam.setUpdate(true);
            }
            staffQueryInParam.setCandidateId(Long.valueOf(onbrdBill.getLong("candidate.id")));
            long orgTeamId = onbrdBill.getLong("aadminorg.id");
            if (extendStaff && onbrdBill.containsProperty(staffAdminOrg) && !HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject(staffAdminOrg))) {
                orgTeamId = onbrdBill.getLong(staffAdminOrg + ".id");
            }
            staffQueryInParam.setOrgTeamId(Long.valueOf(orgTeamId));
            String apositionType = onbrdBill.getString("apositiontype");
            if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
                staffQueryInParam.setDutyWorkRoleId(Long.valueOf(onbrdBill.getLong("aposition.id")));
            }
            if (!HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
                staffQueryInParam.setJobId(Long.valueOf(onbrdBill.getLong("ajob.id")));
            }
            staffQueryInParam.setLaborRelTypeId(Long.valueOf(onbrdBill.getLong("laborreltype.id")));
            Date effectDate = onbrdBill.getDate("effectdate");
            staffQueryInParam.setEffDate(effectDate == null ? new Date() : effectDate);
            HashMap other = Maps.newHashMapWithExpectedSize((int)2);
            if (!HRCollUtil.isEmpty((Collection)occupyStaff)) {
                other.put("isOccupyStaff", occupyStaff.get(0));
            }
            if (dimensionSize != 0) {
                dimension.forEach(item -> other.put(item.get("staffdimension"), this.getDimensionValue((String)item.get("mapfield"), onbrdBill)));
            }
            staffQueryInParam.setOther((Map)other);
            this.LOGGER.info("staffQueryInParam:{}", (Object)HOMObjectUtils.toJSONString((Object)staffQueryInParam));
            staffQueryInParams.add(staffQueryInParam);
        }
        return staffQueryInParams;
    }

    private Object getDimensionValue(String mapField, DynamicObject onbrdBill) {
        this.LOGGER.info("StaffUseServiceImpl.getDimensionValue start mapField:{}", (Object)mapField);
        if (HRStringUtils.isEmpty((String)mapField) || !onbrdBill.containsProperty(mapField.split("\\.")[0])) {
            this.LOGGER.info("StaffUseServiceImpl.getDimensionValue invalid mapField:{}", (Object)mapField);
            return null;
        }
        Object value = null;
        try {
            value = onbrdBill.get(mapField);
        }
        catch (ORMDesignException exception) {
            this.LOGGER.error("StaffUseServiceImpl.getDimensionValue invalid mapField", (Throwable)exception);
        }
        this.LOGGER.info("StaffUseServiceImpl.getDimensionValue mapField:{},value:{}", (Object)mapField, value);
        if (value == null) {
            return null;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).get("id");
        }
        if (value instanceof MulBasedataDynamicObjectCollection) {
            return ((MulBasedataDynamicObjectCollection)value).stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
        }
        return value;
    }

    @Override
    public StaffUseParam getStaffUseParamsForTCC(DynamicObject[] onbrdBills, String opCode) {
        ArrayList<StaffUseInParam> allStaffUseInParams = new ArrayList<StaffUseInParam>(onbrdBills.length * 2);
        StaffUseParam staffUseParam = new StaffUseParam();
        if (HRStringUtils.equals((String)OPCODE_NEW, (String)opCode)) {
            allStaffUseInParams.addAll(this.buildStaffUseInParams(onbrdBills, false, false));
        } else {
            List onbrdBillIds = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", onbrdBillIds);
            DynamicObject[] onbrdBillFromDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{filter});
            List<Tuple<DynamicObject, DynamicObject>> changedList = this.getBillListChanged(onbrdBillFromDBs, onbrdBills);
            if (CollectionUtils.isEmpty(changedList)) {
                this.LOGGER.info("These datas no change, size:{}", (Object)onbrdBills.length);
            } else {
                allStaffUseInParams.addAll(this.buildStaffUseInParams((DynamicObject[])changedList.stream().map(tuple -> (DynamicObject)tuple.item1).toArray(DynamicObject[]::new), true, true));
                allStaffUseInParams.addAll(this.buildStaffUseInParams((DynamicObject[])changedList.stream().map(tuple -> (DynamicObject)tuple.item2).toArray(DynamicObject[]::new), false, true));
            }
        }
        staffUseParam.setStaffUseInParamList(allStaffUseInParams);
        return staffUseParam;
    }

    private List<StaffUseInParam> buildStaffUseInParams(DynamicObject[] onbrdBills, boolean beforeChange, boolean update) {
        ArrayList<StaffUseInParam> staffUseInParams = new ArrayList<StaffUseInParam>(onbrdBills.length);
        List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
        int dimensionSize = dimension == null || dimension.isEmpty() ? 0 : dimension.size();
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        boolean extendStaff = !HRStringUtils.isBlank((CharSequence)staffAdminOrg);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IStaffOnbrdExtendService.class, (String)"kd.sdk.hr.hom.business.onbrd.IStaffOnbrdExtendService", null);
        for (DynamicObject onbrdBill : onbrdBills) {
            List occupyStaff = hrPluginProxy.callReplace(hrPlugin -> hrPlugin.occupyStaffOrNot(onbrdBill));
            this.LOGGER.info("IStaffOnbrdExtendService.occupyStaff={}", (Object)occupyStaff);
            if (!HRCollUtil.isEmpty((Collection)occupyStaff) && Boolean.FALSE.equals(occupyStaff.get(0))) {
                this.LOGGER.warn("IStaffOnbrdExtendService.occupyStaffOrNot, onbrdid:{}", (Object)onbrdBill.getLong("id"));
                continue;
            }
            StaffUseInParam staffUseInParam = new StaffUseInParam();
            staffUseInParam.setUpdate(update);
            staffUseInParam.setCandidateId(Long.valueOf(onbrdBill.getLong("candidate.id")));
            long orgTeamId = onbrdBill.getLong("aadminorg.id");
            if (extendStaff && onbrdBill.containsProperty(staffAdminOrg) && !HRObjectUtils.isEmpty((Object)onbrdBill.getDynamicObject(staffAdminOrg))) {
                orgTeamId = onbrdBill.getLong(staffAdminOrg + ".id");
            }
            staffUseInParam.setOrgTeamId(Long.valueOf(orgTeamId));
            staffUseInParam.setDutyWorkRoleId(Long.valueOf(onbrdBill.getLong("aposition.id")));
            staffUseInParam.setJobId(Long.valueOf(onbrdBill.getLong("ajob.id")));
            staffUseInParam.setJobLevelId(Long.valueOf(onbrdBill.getLong("ajoblevel.id")));
            staffUseInParam.setLaborRelTypeId(Long.valueOf(onbrdBill.getLong("laborreltype.id")));
            Date effectDate = onbrdBill.getDate("effectdate");
            staffUseInParam.setEffDate(effectDate == null ? new Date() : effectDate);
            staffUseInParam.setChangeEventNumber("1010_S");
            staffUseInParam.setBizBillId(Long.valueOf(onbrdBill.getLong("id")));
            staffUseInParam.setBeforeChange(Boolean.valueOf(beforeChange));
            if (dimensionSize != 0) {
                HashMap other = Maps.newHashMapWithExpectedSize((int)dimensionSize);
                dimension.stream().forEach(item -> other.put(item.get("staffdimension"), this.getDimensionValue((String)item.get("mapfield"), onbrdBill)));
                staffUseInParam.setOther((Map)other);
                this.LOGGER.info("StaffUseServiceImpl.buildStaffUseInParams set other end,{}", (Object)other);
            }
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setStaffUseInParamExtend(staffUseInParam, onbrdBill);
                return null;
            });
            staffUseInParams.add(staffUseInParam);
        }
        return staffUseInParams;
    }

    @Override
    public List<Tuple<DynamicObject, DynamicObject>> getBillListChanged(DynamicObject[] oldOnbrdBills, DynamicObject[] newOnbrdBills) {
        ArrayList<Tuple<DynamicObject, DynamicObject>> changedList = new ArrayList<Tuple<DynamicObject, DynamicObject>>(newOnbrdBills.length);
        Map<Long, DynamicObject> newOnbrdBillMap = Stream.of(newOnbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        Set<String> dimensionSet = this.getDimensionSet();
        for (DynamicObject oldOnbrdBill : oldOnbrdBills) {
            DynamicObject newOnbrdBill = newOnbrdBillMap.get(oldOnbrdBill.getLong("id"));
            if (!this.judgeIfChangedWithDimension(oldOnbrdBill, newOnbrdBill, dimensionSet)) continue;
            changedList.add((Tuple<DynamicObject, DynamicObject>)Tuple.create((Object)oldOnbrdBill, (Object)newOnbrdBill));
        }
        this.LOGGER.info("changedList, size:{}", (Object)changedList.size());
        return changedList;
    }

    @Override
    public Set<String> getDimensionSet() {
        Set<String> dimensionSet = this.getMapFieldSet();
        dimensionSet.addAll(DIMENSION_FIELDS);
        String staffAdminorg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        if (!HRStringUtils.isBlank((CharSequence)staffAdminorg)) {
            dimensionSet.add(staffAdminorg);
        }
        return dimensionSet;
    }

    @Override
    public Set<String> getMapFieldSet() {
        List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
        HashSet<String> mapFieldSet = new HashSet<String>(16);
        if (dimension != null && !dimension.isEmpty()) {
            dimension.forEach(item -> mapFieldSet.add((String)item.get("mapfield")));
        }
        return mapFieldSet;
    }

    @Override
    public String getSelectProperties() {
        Set<String> selectProperties = this.getMapFieldSet();
        selectProperties.addAll(SELECT_PROPERTIES_SET);
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        if (!HRStringUtils.isBlank((CharSequence)staffAdminOrg)) {
            selectProperties.add(staffAdminOrg);
        }
        return String.join((CharSequence)",", selectProperties);
    }

    @Override
    public boolean judgeIfChangedWithDimension(DynamicObject oldOnbrdBill, DynamicObject newOnbrdBill, Set<String> dimensionSet) {
        boolean flag = false;
        Map<String, IDataEntityProperty> propertyMap = newOnbrdBill.getDataEntityType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (oldValue, newValue) -> newValue));
        for (String field : dimensionSet) {
            Object newValue2;
            Object oldValue2;
            if (!newOnbrdBill.containsProperty(field.split("\\.")[0])) continue;
            try {
                oldValue2 = oldOnbrdBill.get(field);
                newValue2 = newOnbrdBill.get(field);
            }
            catch (ORMDesignException exception) {
                this.LOGGER.error("StaffUseServiceImpl.judgeIfChangedWithDimension invalid mapField", (Throwable)exception);
                continue;
            }
            if (HOMObjectUtils.isEmpty((Object)oldValue2) && HOMObjectUtils.isEmpty((Object)newValue2)) continue;
            IDataEntityProperty property2 = propertyMap.get(field);
            if (property2 instanceof BasedataProp) {
                oldValue2 = oldValue2 == null ? Long.valueOf(0L) : oldValue2;
                newValue2 = newValue2 == null ? Long.valueOf(0L) : newValue2;
            }
            String fieldDyIdName = field + ".id";
            if (!(HOMObjectUtils.isEmpty((Object)oldValue2) ^ HOMObjectUtils.isEmpty((Object)newValue2) || (oldValue2 instanceof DynamicObject || property2 instanceof BasedataProp) && oldOnbrdBill.getLong(fieldDyIdName) != newOnbrdBill.getLong(fieldDyIdName) || oldValue2 instanceof Date && !DateUtils.isSameDay((Date)oldOnbrdBill.getDate(field), (Date)newOnbrdBill.getDate(field)) || oldValue2 instanceof String && !HRStringUtils.equals((String)oldOnbrdBill.getString(field), (String)newOnbrdBill.getString(field))) && (!(oldValue2 instanceof Integer) || oldOnbrdBill.getInt(field) == newOnbrdBill.getInt(field))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void sendMsgForOnbrdActivity(Map<Long, List<String>> onbrdActivityNumberMap) {
        try {
            Set<Long> onbrdBillIds = onbrdActivityNumberMap.keySet();
            QFilter filter = new QFilter("id", "in", onbrdBillIds);
            Object[] onbrdBillInfos = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{filter});
            if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
                this.LOGGER.info("====sendMsgForOnbrdActivity cannot find onbrdbill:{}===", (Object)HOMObjectUtils.toJSONString(onbrdBillIds));
                return;
            }
            Date currentDate = new Date();
            List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
            for (Object onbrdBillInfo : onbrdBillInfos) {
                Long onbrdBillId = onbrdBillInfo.getLong("id");
                HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)10);
                List<String> activityNumberList = onbrdActivityNumberMap.get(onbrdBillId);
                for (String onbrdActivityNumber : activityNumberList) {
                    String msgNumber = onbrdBillInfo.getString("id") + onbrdActivityNumber + currentDate.getTime();
                    actionInfo.put("msgNumber", msgNumber.length() > 60 ? msgNumber.substring(0, 60) : msgNumber);
                    actionInfo.put("actionId", 12703L);
                    actionInfo.put("msgPubNo", "MP20220926002004");
                    String title = String.format(ResManager.loadKDString((String)"\u5165\u804c%1$s\u7f16\u5236\u6d3b\u52a8\u63d0\u4ea4", (String)"StaffUseServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("billno"));
                    actionInfo.put("msgTitle", title.length() > 50 ? title.substring(0, 50) : title);
                    actionInfo.put("msgDesc", String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5165\u804c\u6d3b\u52a8%3$s\u5360\u7f16\u6d88\u606f", (String)"StaffUseServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("name"), onbrdBillInfo.getString("employeeno"), onbrdActivityNumber));
                    actionInfo.put("msgTag", "");
                    actionInfo.put("senderId", RequestContext.get().getCurrUserId());
                    actionInfo.put("sendTime", currentDate);
                    Map<String, Object> paramsInfo = this.getParamsForOnbrdActivity((DynamicObject)onbrdBillInfo, onbrdActivityNumber, dimension);
                    this.LOGGER.info("paramsInfo:{}", paramsInfo);
                    actionInfo.put("params", SerializationUtils.serializeToBase64((Object)ImmutableList.of(paramsInfo)));
                    HRProducerServiceHelper.publishAction((Map)actionInfo);
                }
            }
        }
        catch (Exception exception) {
            this.LOGGER.error((Throwable)exception);
            this.LOGGER.error("fail to sendMsgForOnbrdActivity");
        }
    }

    private Map<String, Object> getParamsForOnbrdActivity(DynamicObject onbrdBillInfo, String activityNumber, List<Map<String, String>> dimension) {
        int size;
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)10);
        paramMap.put("candidateId", onbrdBillInfo.getLong("candidate.id"));
        long orgTeamId = onbrdBillInfo.getLong("aadminorg.id");
        if (!HRStringUtils.isBlank((CharSequence)staffAdminOrg) && onbrdBillInfo.containsProperty(staffAdminOrg) && !HRObjectUtils.isEmpty((Object)onbrdBillInfo.getDynamicObject(staffAdminOrg))) {
            orgTeamId = onbrdBillInfo.getLong(staffAdminOrg + ".id");
        }
        paramMap.put("orgTeamId", orgTeamId);
        String apositionType = onbrdBillInfo.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            paramMap.put("dutyWorkRoleId", onbrdBillInfo.getLong("aposition.id"));
        }
        if (!HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
            paramMap.put("jobId", onbrdBillInfo.getLong("ajob.id"));
        }
        paramMap.put("joblevelId", onbrdBillInfo.getLong("ajoblevel.id"));
        paramMap.put("laborRelTypeId", onbrdBillInfo.getLong("laborreltype.id"));
        Date effectDate = onbrdBillInfo.getDate("effectdate");
        paramMap.put("effDate", effectDate == null ? new Date() : effectDate);
        paramMap.put("bizBillId", onbrdBillInfo.getLong("id"));
        paramMap.put("changeEventNumber", activityNumber);
        int n = size = dimension == null || dimension.isEmpty() ? 0 : dimension.size();
        if (size != 0) {
            HashMap other = Maps.newHashMapWithExpectedSize((int)size);
            dimension.stream().forEach(item -> other.put(item.get("staffdimension"), this.getDimensionValue((String)item.get("mapfield"), onbrdBillInfo)));
            paramMap.put("other", other);
        }
        return paramMap;
    }

    @Override
    public void sendMsgForOnbrdConfirm(List<PerChgBizResult> perChgBizResults) {
        try {
            List onbrdBillIds = perChgBizResults.stream().map(PerChgBizResult::getBillId).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", onbrdBillIds);
            Object[] onbrdBillInfos = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{filter});
            if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
                this.LOGGER.info("====sendMsgForOnbrdConfirm cannot find onbrdbill:{}===", (Object)HOMObjectUtils.toJSONString(onbrdBillIds));
                return;
            }
            Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBillInfos).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
            List<Map<String, String>> dimension = this.queryStaffDynamicdimension();
            for (PerChgBizResult perChgBizResult : perChgBizResults) {
                if (!perChgBizResult.getSuccess().booleanValue()) {
                    this.LOGGER.info("perChgBizResult.getSuccess():{}", (Object)perChgBizResult.getSuccess());
                    continue;
                }
                DynamicObject onbrdBillInfo = onbrdBillMap.get(perChgBizResult.getBillId());
                HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)10);
                actionInfo.put("msgNumber", perChgBizResult.getBillId().toString());
                actionInfo.put("actionId", 12701L);
                actionInfo.put("msgPubNo", "MP20220926002002");
                String title = String.format(ResManager.loadKDString((String)"\u5165\u804c%1$s\u7f16\u5236\u751f\u6548", (String)"StaffUseServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("billno"));
                actionInfo.put("msgTitle", title.length() > 50 ? title.substring(0, 50) : title);
                actionInfo.put("msgDesc", String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5165\u804c\u7f16\u5236\u751f\u6548\u6d88\u606f", (String)"StaffUseServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("name"), onbrdBillInfo.getString("employeeno")));
                actionInfo.put("msgTag", "");
                actionInfo.put("senderId", RequestContext.get().getCurrUserId());
                actionInfo.put("sendTime", new Date());
                Map<String, Object> paramsInfo = this.getParamsForOnbrdConfirm(perChgBizResult, onbrdBillInfo, dimension);
                this.LOGGER.info("paramsInfo:{}", paramsInfo);
                actionInfo.put("params", SerializationUtils.serializeToBase64((Object)ImmutableList.of(paramsInfo)));
                HRProducerServiceHelper.publishAction((Map)actionInfo);
            }
        }
        catch (Exception exception) {
            this.LOGGER.error((Throwable)exception);
            this.LOGGER.error("fail to sendMsgForOnbrdConfirm");
        }
    }

    private Map<String, Object> getParamsForOnbrdConfirm(PerChgBizResult perChgBizResult, DynamicObject onbrdBillInfo, List<Map<String, String>> dimension) {
        String staffAdminOrg = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("staff_adminorg");
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)10);
        paramMap.put("candidateId", onbrdBillInfo.getLong("candidate.id"));
        paramMap.put("personId", Optional.ofNullable(perChgBizResult.getNewPersonId()).orElseGet(() -> onbrdBillInfo.getLong("personindexid")));
        paramMap.put("depEmpId", perChgBizResult.getNewDepEmpId());
        long orgTeamId = onbrdBillInfo.getLong("aadminorg.id");
        if (!HRStringUtils.isBlank((CharSequence)staffAdminOrg) && onbrdBillInfo.containsProperty(staffAdminOrg) && !HRObjectUtils.isEmpty((Object)onbrdBillInfo.getDynamicObject(staffAdminOrg))) {
            orgTeamId = onbrdBillInfo.getLong(staffAdminOrg + ".id");
        }
        paramMap.put("orgTeamId", orgTeamId);
        String apositionType = onbrdBillInfo.getString("apositiontype");
        if (HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_POSITION.getValue(), (String)apositionType)) {
            paramMap.put("dutyWorkRoleId", onbrdBillInfo.getLong("aposition.id"));
        }
        if (!HRStringUtils.equals((String)PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue(), (String)apositionType)) {
            paramMap.put("jobId", onbrdBillInfo.getLong("ajob.id"));
        }
        paramMap.put("joblevelId", onbrdBillInfo.getLong("ajoblevel.id"));
        paramMap.put("laborRelTypeId", onbrdBillInfo.getLong("laborreltype.id"));
        paramMap.put("effDate", onbrdBillInfo.getDate("effectdate"));
        paramMap.put("bizBillId", onbrdBillInfo.getLong("id"));
        paramMap.put("changeEventNumber", "1020_S");
        if (dimension != null && !dimension.isEmpty()) {
            HashMap other = Maps.newHashMapWithExpectedSize((int)dimension.size());
            dimension.stream().forEach(item -> other.put(item.get("staffdimension"), this.getDimensionValue((String)item.get("mapfield"), onbrdBillInfo)));
            paramMap.put("other", other);
        }
        return paramMap;
    }

    @Override
    public void sendMsgForOnbrdBreakUp(List<Long> onbrdBillIds) {
        try {
            QFilter filter = new QFilter("id", "in", onbrdBillIds);
            Object[] onbrdBillInfos = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{filter});
            if (HRArrayUtils.isEmpty((Object[])onbrdBillInfos)) {
                this.LOGGER.info("====sendMsgForOnbrdBreakUp cannot find onbrdbill:{}===", (Object)HOMObjectUtils.toJSONString(onbrdBillIds));
                return;
            }
            Date currentDate = new Date();
            for (Object onbrdBillInfo : onbrdBillInfos) {
                HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)10);
                String msgNumber = onbrdBillInfo.getString("id") + "-" + currentDate.getTime();
                actionInfo.put("msgNumber", msgNumber);
                actionInfo.put("actionId", 12702L);
                actionInfo.put("msgPubNo", "MP20220926002003");
                String title = String.format(ResManager.loadKDString((String)"\u5165\u804c%1$s\u7f16\u5236\u5e9f\u5f03", (String)"StaffUseServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("billno"));
                actionInfo.put("msgTitle", title.length() > 50 ? title.substring(0, 50) : title);
                actionInfo.put("msgDesc", String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u5165\u804c\u7f16\u5236\u91ca\u653e\u6d88\u606f", (String)"StaffUseServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]), onbrdBillInfo.getString("name"), onbrdBillInfo.getString("employeeno")));
                actionInfo.put("msgTag", "");
                actionInfo.put("senderId", RequestContext.get().getCurrUserId());
                actionInfo.put("sendTime", new Date());
                Map<String, Object> paramsInfo = this.getParamsForOnbrdBreakUp((DynamicObject)onbrdBillInfo);
                this.LOGGER.info("paramsInfo:{}", paramsInfo);
                actionInfo.put("params", SerializationUtils.serializeToBase64((Object)ImmutableList.of(paramsInfo)));
                HRProducerServiceHelper.publishAction((Map)actionInfo);
            }
        }
        catch (Exception exception) {
            this.LOGGER.error((Throwable)exception);
            this.LOGGER.error("fail to sendMsgForOnbrdBreakUp");
        }
    }

    @Override
    public StaffUseParam getStaffUseParamTCCBeforeOnbrd(List<Long> onbrdBillIds) {
        StaffUseParam staffUseParam = new StaffUseParam();
        ArrayList<StaffUseInParam> allStaffUseInParams = new ArrayList<StaffUseInParam>(onbrdBillIds.size() * 2);
        QFilter filter = new QFilter("id", "in", onbrdBillIds);
        DynamicObject[] onbrdBillFromDBs = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{filter});
        allStaffUseInParams.addAll(this.buildStaffUseInParams(onbrdBillFromDBs, true, true));
        allStaffUseInParams.addAll(this.buildStaffUseInParams(onbrdBillFromDBs, false, true));
        staffUseParam.setStaffUseInParamList(allStaffUseInParams);
        return staffUseParam;
    }

    @Override
    public List<Map<String, String>> queryStaffDynamicdimension() throws KDBizException {
        String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u4e1a\u52a1\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"StaffUseServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]);
        try {
            StaffResponse<List<Map<String, String>>> result = IHrmpExternalService.getInstance().queryStaffDynamicdimension("hom_onbrdinfo");
            this.LOGGER.info("queryStaffDynamicdimension end,result={}", result);
            if (!result.isSuccess()) {
                List errorList = result.getErrorMsg();
                if (errorList != null && !errorList.isEmpty()) {
                    errorMsg = (String)errorList.get(0);
                }
                throw new KDBizException(errorMsg);
            }
            return (List)result.getData();
        }
        catch (Exception e) {
            this.LOGGER.error("queryStaffDynamicdimension error", (Throwable)e);
            throw new KDBizException(errorMsg);
        }
    }

    @Override
    public Map<Long, Optional<String>> validateStaffUse(Collection<Long> onbrdBillIds, String opCode) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBillIds.size());
        QFilter idFilter = new QFilter("id", "in", onbrdBillIds);
        DynamicObject[] onbrdBillsFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBills(this.getSelectProperties(), new QFilter[]{idFilter});
        Map<Long, StaffQueryOutParam> queryOutParamMap = this.queryStaffUseInfos(onbrdBillsFromDB, opCode);
        for (DynamicObject onbrdBillInfo : onbrdBillsFromDB) {
            Long candidateId = onbrdBillInfo.getLong("candidate.id");
            StaffQueryOutParam staffQueryOutParam = queryOutParamMap.get(candidateId);
            if (staffQueryOutParam == null || staffQueryOutParam.isAllow() || CollectionUtils.isEmpty((Collection)staffQueryOutParam.getReasonList())) continue;
            this.LOGGER.info("staffQueryOutParam:{}", (Object)HOMObjectUtils.toJSONString((Object)staffQueryOutParam));
            StringJoiner stringJoiner = new StringJoiner("\r\n");
            staffQueryOutParam.getReasonList().forEach(stringJoiner::add);
            resultMap.put(onbrdBillInfo.getLong("id"), Optional.of(stringJoiner.toString()));
        }
        return resultMap;
    }

    @Override
    public String getErrorTipWithException(Exception exception) {
        KDBizException kdBizException = null;
        Throwable throwable = exception;
        if (throwable instanceof TCCTryException) {
            do {
                if (!((throwable = throwable.getCause()) instanceof KDBizException)) continue;
                kdBizException = (KDBizException)throwable;
                break;
            } while (throwable != null);
        } else if (throwable instanceof KDBizException) {
            kdBizException = (KDBizException)throwable;
        } else {
            this.LOGGER.error((Throwable)exception);
        }
        String errorTip = ResManager.loadKDString((String)"\u8d85\u7f16\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u4e1a\u52a1\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"StaffUseServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]);
        if (kdBizException != null && kdBizException.getErrorCode() != null && HRStringUtils.equals((String)"hrmp.haos.wrongParams", (String)kdBizException.getErrorCode().getCode())) {
            errorTip = ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7f16\u5236\u4e1a\u52a1\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"StaffUseServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        return errorTip;
    }

    private Map<String, Object> getParamsForOnbrdBreakUp(DynamicObject onbrdBillInfo) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)4);
        paramMap.put("candidateId", onbrdBillInfo.getLong("candidate.id"));
        paramMap.put("bizBillId", onbrdBillInfo.getLong("id"));
        return paramMap;
    }
}

