/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.impl.tsc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.business.datamodel.DynamicFormModelProxy;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.impl.rule.OnbrdCommonValidator;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.tsc.IOnbrdBillService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.impl.onbrd.OnbrdInfoInitService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.business.domain.service.tsc.ICreateOnbrdBillDomainService;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.entity.tsc.OnboardReqDTO;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.InitTypeEnum;

public class OnbrdBillServiceImpl
implements IOnbrdBillService {
    private static final Log log = LogFactory.getLog(OnbrdBillServiceImpl.class);

    @Override
    public void createOnbrdBill(DynamicObject onbrdBill) {
        ICreateOnbrdBillDomainService.getInstance().createOnbrdBill(onbrdBill);
    }

    @Override
    public void updateOnbrdBill(DynamicObject onbrdBill) {
        ICreateOnbrdBillDomainService.getInstance().updateOnbrdBill(onbrdBill);
    }

    @Override
    public DynamicObject getOnbrdBillByCandidateId(Long candidateId) {
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidateId);
        return IOnbrdBillDomainService.getInstance().findOnbrdBill(null, qFilter.toArray());
    }

    @Override
    public DynamicObject getOnbrdBillByBillNo(String billNo) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        return IOnbrdBillDomainService.getInstance().findOnbrdBill(null, qFilter.toArray());
    }

    @Override
    public DynamicObject generateOnbrdBill(OnboardReqDTO reqDTO) {
        DynamicObject onbrdBill = this.getOnbrdBillHandle();
        this.convertTSC2OnbrdBillHandle(onbrdBill, reqDTO);
        this.setOnbrdBillHandle(onbrdBill);
        return onbrdBill;
    }

    @Override
    public DynamicObject generateOnbrdBill(Map<String, Object> requestMap) {
        DynamicObject onbrdBill = this.getOnbrdBillHandle();
        for (Map.Entry<String, Object> stringObjectEntry : requestMap.entrySet()) {
            DynamicObject dynamicObject;
            if (!onbrdBill.getDataEntityType().getProperties().containsKey((Object)stringObjectEntry.getKey())) {
                log.warn(String.format("onbrdBill has not attr %s", stringObjectEntry.getKey()));
                continue;
            }
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)onbrdBill.getDataEntityType().getProperties().get((Object)stringObjectEntry.getKey());
            if (iDataEntityProperty instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)iDataEntityProperty;
                String baseEntityId = basedataProp.getBaseEntityId();
                if (stringObjectEntry.getValue() instanceof String) {
                    dynamicObject = HomCommonRepository.queryDynamicObjectByNumber(baseEntityId, "", stringObjectEntry.getValue());
                    onbrdBill.set(stringObjectEntry.getKey(), (Object)dynamicObject);
                    continue;
                }
                onbrdBill.set(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                continue;
            }
            if (stringObjectEntry.getKey().endsWith("_id")) {
                String substring = stringObjectEntry.getKey().substring(0, stringObjectEntry.getKey().length() - 3);
                IDataEntityProperty iDataEntityProp = (IDataEntityProperty)onbrdBill.getDataEntityType().getProperties().get((Object)substring);
                if (HRObjectUtils.isEmpty((Object)iDataEntityProp)) {
                    onbrdBill.set(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                    continue;
                }
                if (iDataEntityProp instanceof BasedataProp) {
                    dynamicObject = HomCommonRepository.queryDynamicObjectByPk(((BasedataProp)iDataEntityProp).getBaseEntityId(), "", stringObjectEntry.getValue());
                    onbrdBill.set(substring, (Object)dynamicObject);
                    continue;
                }
                onbrdBill.set(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                continue;
            }
            onbrdBill.set(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        this.setOnbrdBillHandle(onbrdBill);
        return onbrdBill;
    }

    @Override
    public void initRoleAndJobInfoHandle(DynamicObject onbrdBill) {
        ArrayList<HomCommonWrapper> rowDataWrapperList = new ArrayList<HomCommonWrapper>();
        HomCommonWrapper homCommonWrapper = new HomCommonWrapper(onbrdBill);
        rowDataWrapperList.add(homCommonWrapper);
        OnbrdCommonValidator validator = new OnbrdCommonValidator();
        validator.initRoleByAposition(rowDataWrapperList);
        log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initRoleByAposition -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (!"2".equals(onbrdBill.getString("apositiontype"))) {
            IOnbrdCommonValidator.getInstance().initAndCheckJobInfo(rowDataWrapperList);
            log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initAndCheckJobInfo -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        }
        IOnbrdInfoInitService.getInstance().initFieldValue(rowDataWrapperList, InitTypeEnum.ONBRD_NEW_INTEGERATE_TSC.getValue());
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(rowDataWrapperList);
        log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initFieldValue -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            throw new RuntimeException("initRoleByAposition or initJobInfos error!");
        }
    }

    private void setOnbrdBillHandle(DynamicObject onbrdBill) {
        String billNo = new OnbrdInfoInitService().getNumberByCodeRule("hom_onbrdbillbase", "", onbrdBill);
        onbrdBill.set("billno", (Object)billNo);
        onbrdBill.set("processstatus", (Object)"1");
        onbrdBill.set("creator", (Object)1L);
        onbrdBill.set("modifier", (Object)1L);
    }

    private DynamicObject getOnbrdBillHandle() {
        DynamicFormModelProxy modelProxy = new DynamicFormModelProxy("hom_onbrdbilltpl", UUID.randomUUID().toString(), new HashMap());
        return (DynamicObject)modelProxy.createNewData();
    }

    private DynamicObject getCertificateTypeHandle(Long certificateTypeId) {
        if (null == certificateTypeId || 0L == certificateTypeId) {
            return null;
        }
        return HomCommonRepository.queryDynamicObjectByPk("hbss_credentialstype", null, certificateTypeId);
    }

    private void convertTSC2OnbrdBillHandle(DynamicObject onbrdBill, OnboardReqDTO reqDTO) {
        onbrdBill.set("name", (Object)reqDTO.getAppFileName());
        onbrdBill.set("candidatenumber", (Object)reqDTO.getAppFileNumber());
        onbrdBill.set("candidate", (Object)reqDTO.getCandidateId());
        onbrdBill.set("phone", (Object)reqDTO.getPhone());
        onbrdBill.set("peremail", (Object)reqDTO.getEmail());
        onbrdBill.set("certificatetype", (Object)this.getCertificateTypeHandle(reqDTO.getCertificateType()));
        onbrdBill.set("certificatenumber", (Object)reqDTO.getCertificateNumber());
        onbrdBill.set("nationality", (Object)reqDTO.getNatreg());
        onbrdBill.set("gender", (Object)reqDTO.getGender());
        onbrdBill.set("aadminorg", (Object)reqDTO.getPeadminorg());
        onbrdBill.set("baselocation", (Object)reqDTO.getPlacework());
        onbrdBill.set("contractlocation", (Object)reqDTO.getAgreePlacework());
        onbrdBill.set("org", (Object)reqDTO.getOrg());
        if ("2".equals(reqDTO.getPostassignmode())) {
            onbrdBill.set("apositiontype", (Object)"1");
            onbrdBill.set("aposition", (Object)reqDTO.getPeposition());
        } else if ("3".equals(reqDTO.getPostassignmode())) {
            onbrdBill.set("apositiontype", (Object)"0");
            onbrdBill.set("stdposition", (Object)reqDTO.getPestdposition());
        } else {
            onbrdBill.set("apositiontype", (Object)"2");
        }
        onbrdBill.set("ajob", (Object)reqDTO.getPejob());
        onbrdBill.set("ajoblevel", (Object)reqDTO.getJoblevel());
        onbrdBill.set("ajobgrade", (Object)reqDTO.getJobgrade());
        onbrdBill.set("laborreltype", (Object)reqDTO.getEmprelationtype());
        onbrdBill.set("onbrdtype", (Object)reqDTO.getLaborRelTypeCls());
        onbrdBill.set("effectdate", (Object)reqDTO.getPemploymenttime());
        onbrdBill.set("isprobation", (Object)reqDTO.getHavePeriodTerm());
        onbrdBill.set("validuntil", (Object)reqDTO.getValidityTerm());
        onbrdBill.set("probationtime", (Object)reqDTO.getPperiodterm());
        onbrdBill.set("perprobationtime", (Object)reqDTO.getPperiodtermunit());
        onbrdBill.set("recruittype", (Object)reqDTO.getRecrutyp());
        onbrdBill.set("recruitsource", (Object)reqDTO.getResacqmthd());
        onbrdBill.set("resumeno", (Object)reqDTO.getAppFileNumber());
        onbrdBill.set("offernumber", (Object)reqDTO.getOfferNumber());
        onbrdBill.set("offerid", (Object)reqDTO.getOfferId());
        onbrdBill.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
        onbrdBill.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
    }
}

