/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.onbrd;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.common.enums.AgainCheckResultsEnum;
import kd.hr.hom.common.enums.EmployeeNoSchemeEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.ServiceAgeSchemeEnum;
import kd.hr.hom.common.util.SceneResultUtil;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class OnbrdAgainRuleUtils {
    private static final String VALUE_N = "N";
    private static final String PERMISSION = "permission";
    private static final String TIPS = "tips";
    public static Log LOGGER = LogFactory.getLog(OnbrdAgainRuleUtils.class);
    public static final String EMPLOYEENO_CONNECTION_SWITCH = "employeeno_connection_switch";
    public static final String SENIORITY_CONNECTION_SWITCH = "seniority_connection_switch";
    public static final String AUTOMATICINFO_SWITCH = "automaticinfo_switch";
    private static final String HOM_REENTRYTIPS = "hom_reentrytips";

    public static boolean checkParam(IFormView view, DynamicObject data) {
        StringBuilder builder = new StringBuilder();
        String apositionType = data.getString("apositiontype");
        if (Objects.isNull(data.get("personfield"))) {
            builder.append(ResManager.loadKDString((String)"\u59d3\u540d", (String)"AgainOnbrdInfoEdit_11", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("org"))) {
            builder.append(ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"AgainOnbrdInfoEdit_2", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("enterprise"))) {
            builder.append(ResManager.loadKDString((String)"\u7528\u4eba\u5355\u4f4d", (String)"AgainOnbrdInfoEdit_3", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("managementscope"))) {
            builder.append(ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u8303\u56f4", (String)"AgainOnbrdInfoEdit_4", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("aadminorg"))) {
            builder.append(ResManager.loadKDString((String)"\u5165\u804c\u90e8\u95e8", (String)"AgainOnbrdInfoEdit_5", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("baselocation"))) {
            builder.append(ResManager.loadKDString((String)"\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"AgainOnbrdInfoEdit_7", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (Objects.isNull(data.get("laborreltype"))) {
            builder.append(ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"AgainOnbrdInfoEdit_8", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(apositionType) && Objects.isNull(data.get("aposition"))) {
            builder.append(ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"AgainOnbrdInfoEdit_21", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(apositionType) && Objects.isNull(data.get("stdposition"))) {
            builder.append(ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"AgainOnbrdInfoEdit_22", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (PositionTypeEnum.POSITIONTYPE_JOB.getValue().equals(apositionType) && Objects.isNull(data.get("ajob"))) {
            builder.append(ResManager.loadKDString((String)"\u804c\u4f4d", (String)"AgainOnbrdInfoEdit_23", (String)"hr-hom-business", (Object[])new Object[0])).append(',');
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
            String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652270893646372864L, null);
            String msg = ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584{0}\u7b49\u5b57\u6bb5\u540e", (String)"AgainOnbrdInfoEdit_10", (String)"hr-hom-business", (Object[])new Object[]{builder.toString()});
            view.showErrorNotification(msg + tipByHRCS);
            return false;
        }
        return true;
    }

    public static String reentryLureCheck(Map<String, Object> inputParams, IFormView view, DynamicObject data) {
        List<Map<String, Object>> ruleResult = OnbrdAgainRuleUtils.getRuleResult(inputParams, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_EXAMINE.getSceneNumber(), data);
        if (CollectionUtils.isEmpty(ruleResult)) {
            return AgainCheckResultsEnum.PASS.getCode();
        }
        ArrayList warningList = new ArrayList(ruleResult.size());
        ArrayList errorList = new ArrayList(ruleResult.size());
        ruleResult.stream().filter(map -> map.get(PERMISSION) != null).forEach(map -> {
            if (VALUE_N.equals(map.get(PERMISSION))) {
                errorList.add((String)map.get(TIPS));
            } else {
                warningList.add((String)map.get(TIPS));
            }
        });
        IFormView parentView = view.getEntityId().equals("hom_onbrdinfo") ? view.getParentView() : view;
        HRPageCache pageCache = new HRPageCache(view.getParentView());
        if (!CollectionUtils.isEmpty(errorList)) {
            OnbrdAgainRuleUtils.hideTipsAndShow(parentView, "errorcloseap");
            parentView.setVisible(Boolean.FALSE, new String[]{"tipflexpanelap", "warnflexpanelap"});
            pageCache.put("tipsType", (Object)AgainCheckResultsEnum.PROHIBIT.getCode());
            pageCache.put("tipslist", errorList);
            OnbrdAgainRuleUtils.showTips(parentView);
            view.sendFormAction(parentView);
            return AgainCheckResultsEnum.PROHIBIT.getCode();
        }
        if (!CollectionUtils.isEmpty(warningList)) {
            OnbrdAgainRuleUtils.hideTipsAndShow(parentView, "rulewarncloseap");
            parentView.setVisible(Boolean.FALSE, new String[]{"tipflexpanelap", "warnflexpanelap"});
            view.sendFormAction(parentView);
            pageCache.put("tipsType", (Object)AgainCheckResultsEnum.RISK_TIP.getCode());
            pageCache.put("tipslist", warningList);
            view.sendFormAction(parentView);
            return AgainCheckResultsEnum.RISK_TIP.getCode();
        }
        pageCache.put("tipsType", (Object)AgainCheckResultsEnum.PASS.getCode());
        view.sendFormAction(parentView);
        return AgainCheckResultsEnum.PASS.getCode();
    }

    private static void hideTipsAndShow(IFormView parentView, String closeKey) {
        Button control = (Button)parentView.getControl(closeKey);
        parentView.addClientCallBack(closeKey, Integer.valueOf(500));
        control.click();
    }

    public static String getReentryCheckResult(Map<String, Object> inputParams, DynamicObject data) {
        List<Map<String, Object>> ruleResult = OnbrdAgainRuleUtils.getRuleResult(inputParams, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_EXAMINE.getSceneNumber(), data);
        return OnbrdAgainRuleUtils.getCode(ruleResult);
    }

    private static String getCode(List<Map<String, Object>> ruleResult) {
        if (CollectionUtils.isEmpty(ruleResult)) {
            return AgainCheckResultsEnum.PASS.getCode();
        }
        ArrayList warningList = new ArrayList(ruleResult.size());
        ArrayList errorList = new ArrayList(ruleResult.size());
        ruleResult.stream().filter(map -> map.get(PERMISSION) != null).forEach(map -> {
            if (VALUE_N.equals(map.get(PERMISSION))) {
                errorList.add((String)map.get(TIPS));
            } else {
                warningList.add((String)map.get(TIPS));
            }
        });
        if (!CollectionUtils.isEmpty(errorList)) {
            return AgainCheckResultsEnum.PROHIBIT.getCode();
        }
        if (!CollectionUtils.isEmpty(warningList)) {
            return AgainCheckResultsEnum.RISK_TIP.getCode();
        }
        return AgainCheckResultsEnum.PASS.getCode();
    }

    public static Map<Long, String> batchGetReentryCheckResult(List<Map<String, Object>> inputParams, String buNumber) {
        List<Map<String, Object>> ruleResults = OnbrdAgainRuleUtils.bacthGetRuleResult(inputParams, buNumber, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_EXAMINE.getSceneNumber());
        HashMap<Long, String> resultMap = new HashMap<Long, String>();
        if (CollectionUtils.isEmpty(ruleResults)) {
            return resultMap;
        }
        for (int i = 0; i < ruleResults.size(); ++i) {
            SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(ruleResults.get(i));
            List respResultList = SceneResultUtil.getRespResultList((SceneResult)sceneResult);
            DynamicObject reboard = (DynamicObject)inputParams.get(i).get("reboard");
            if ("200".equals(sceneResult.getResponseCode())) {
                resultMap.put(reboard.getLong("id"), OnbrdAgainRuleUtils.getCode(respResultList));
                continue;
            }
            LOGGER.info("batchGetReentryCheckResult error:billId={}, errorMsg={}", (Object)reboard.getLong("id"), (Object)sceneResult.getErrorMsg());
        }
        return resultMap;
    }

    public static boolean checkResultBeforeStart(Map<String, Object> rule, DynamicObject pageData, IFormView view) {
        String ecSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, EMPLOYEENO_CONNECTION_SWITCH, EMPLOYEENO_CONNECTION_SWITCH);
        String scSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, SENIORITY_CONNECTION_SWITCH, SENIORITY_CONNECTION_SWITCH);
        String acSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, AUTOMATICINFO_SWITCH, AUTOMATICINFO_SWITCH);
        return OnbrdAgainRuleUtils.checkResultBeforeStart(rule, pageData, ecSwitch, scSwitch, acSwitch);
    }

    public static boolean checkResultBeforeStart(Map<String, Object> rule, DynamicObject pageData, String ecSwitch, String scSwitch, String acSwitch) {
        Object ruleNumber = rule.get("number");
        Object ruleServiceAge = rule.get("service_age");
        Object ruleAuto = rule.get("automatic");
        String pageNumber = pageData.getString("employeenoscheme");
        String pageServiceAge = pageData.getString("serviceagescheme");
        String pageAuto = pageData.getString("automaticinfo");
        LOGGER.info("rule=={},pageData=={}", rule, (Object)pageData);
        return OnbrdAgainRuleUtils.isFieldEquals(ruleNumber, pageNumber, ecSwitch) && OnbrdAgainRuleUtils.isFieldEquals(ruleServiceAge, pageServiceAge, scSwitch) && OnbrdAgainRuleUtils.isFieldEquals(ruleAuto, pageAuto, acSwitch);
    }

    public static boolean isFieldEquals(Object value1, Object value2, String isOpened) {
        if (Boolean.FALSE.equals(Boolean.valueOf(isOpened))) {
            return true;
        }
        return value1 == null || value2 == null || HRStringUtils.equals((String)value1.toString(), (String)value2.toString());
    }

    public static List<Map<String, Object>> getRuleResult(Map<String, Object> inputParams, String sceName, DynamicObject data) {
        DynamicObject personfield = data.getDynamicObject("personfield");
        if (Objects.isNull(personfield)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        LOGGER.info("AgainOnbrdInfoEdit_getRuleResult:{}", (Object)personfield.getLong("id"));
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        List<Map<String, Object>> mapList = service.callRuleEngineResultList(sceName, data.getString("org.number"), inputParams);
        LOGGER.info("OnbrdAgainRuleUtils_getRuleResult:{}", mapList);
        return mapList;
    }

    public static List<Map<String, Object>> bacthGetRuleResult(List<Map<String, Object>> inputParams, String buNumber, String sceneNumber) {
        ArrayList requestMapList = new ArrayList(inputParams.size());
        inputParams.forEach(map -> {
            HashMap requestMap = Maps.newHashMapWithExpectedSize((int)5);
            requestMap.put("bizApp", "hom");
            requestMap.put("sceneNumber", sceneNumber);
            requestMap.put("buNumber", buNumber);
            requestMap.put("serialNumber", ((DynamicObject)map.get("reboard")).getString("id"));
            if (!CollectionUtils.isEmpty((Collection)inputParams)) {
                requestMap.put("inputParams", map);
            }
            try {
                LOGGER.info("OnbrdAgainRuleUtils_inputParams:{}", (Object)LogPrivacyUtil.filterPrivacyProp((Map)map, (List)Lists.newArrayList((Object[])new String[]{"aphone", "aemail", "bphone", "bemail", "phone", "email"})));
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e);
            }
            requestMapList.add(requestMap);
        });
        List sceneResultList = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngine", (Object[])new Object[]{requestMapList});
        LOGGER.info("OnbrdAgainRuleUtils_getRuleResult:{}", (Object)sceneResultList);
        return sceneResultList;
    }

    public static Map<String, Object> reentryCheckHandle(Map<String, Object> inputParams, IFormView view, DynamicObject data) {
        Object autoObj;
        String parseRegexTip;
        String tipByHRCS;
        String ecSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, EMPLOYEENO_CONNECTION_SWITCH, EMPLOYEENO_CONNECTION_SWITCH);
        String scSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, SENIORITY_CONNECTION_SWITCH, SENIORITY_CONNECTION_SWITCH);
        String acSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig(view, AUTOMATICINFO_SWITCH, AUTOMATICINFO_SWITCH);
        List<Map<String, Object>> ruleResult = OnbrdAgainRuleUtils.getRuleResult(inputParams, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_SUCCEED.getSceneNumber(), data);
        LOGGER.info("againOnbrd rule=={}", ruleResult);
        if (CollectionUtils.isEmpty(ruleResult)) {
            OnbrdAgainRuleUtils.isEnable(view, ecSwitch, scSwitch, acSwitch);
            OnbrdAgainRuleUtils.mutexHandle(false, view);
            return null;
        }
        boolean isSame = OnbrdAgainRuleUtils.isIdentical(ruleResult, ecSwitch, scSwitch);
        if (!isSame) {
            if ("hom_onbrdinfo".equals(view.getEntityId())) {
                OnbrdAgainRuleUtils.isEnable(view, ecSwitch, scSwitch, acSwitch);
                OnbrdAgainRuleUtils.mutexHandle(true, view);
            }
            return null;
        }
        IDataModel model = view.getModel();
        Map<String, Object> rule = ruleResult.get(0);
        if (!CollectionUtils.isEmpty(ruleResult)) {
            if (ruleResult.size() == 1 && !OnbrdAgainRuleUtils.isHasResult(ruleResult, view)) {
                OnbrdAgainRuleUtils.isEnable(view, ecSwitch, scSwitch, acSwitch);
                OnbrdAgainRuleUtils.mutexHandle(false, view);
                Object autoObj2 = rule.get("automatic");
                if (autoObj2 != null) {
                    view.setEnable(Boolean.FALSE, new String[]{"automaticinfo"});
                    OnbrdAgainRuleUtils.setValue(model, "automaticinfo", Boolean.parseBoolean((String)autoObj2));
                    return rule;
                }
                return null;
            }
            if (Boolean.parseBoolean(ecSwitch) && rule.get("number") != null) {
                view.setEnable(Boolean.FALSE, new String[]{"employeenoscheme", "oldemployeeno"});
            }
            if (Boolean.parseBoolean(scSwitch) && rule.get("service_age") != null) {
                view.setEnable(Boolean.FALSE, new String[]{"serviceagescheme"});
            }
            if (Boolean.parseBoolean(acSwitch)) {
                if (rule.get("automatic") != null) {
                    view.setEnable(Boolean.FALSE, new String[]{"automaticinfo"});
                } else {
                    view.setEnable(Boolean.TRUE, new String[]{"automaticinfo"});
                }
            }
        }
        Object number = rule.get("number");
        Object serviceAge = rule.get("service_age");
        if ("true".equals(ecSwitch) && "true".equals(scSwitch)) {
            OnbrdAgainRuleUtils.succeedHandleForbidNone(rule, view);
        }
        if ("false".equals(ecSwitch) && "true".equals(scSwitch)) {
            if (!HRObjectUtils.isEmpty((Object)serviceAge)) {
                tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(view, 1645760631460158464L, null);
                parseRegexTip = OnbrdAgainRuleUtils.parseRegexTip((String)number, (String)serviceAge, tipByHRCS);
                OnbrdAgainRuleUtils.succeedHandleForbidOne(rule, SENIORITY_CONNECTION_SWITCH, parseRegexTip, view);
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"serviceagescheme"});
            }
        }
        if ("true".equals(ecSwitch) && "false".equals(scSwitch)) {
            if (!HRObjectUtils.isEmpty((Object)number)) {
                tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(view, 1645763332851982336L, null);
                parseRegexTip = OnbrdAgainRuleUtils.parseRegexTip((String)number, (String)serviceAge, tipByHRCS);
                OnbrdAgainRuleUtils.succeedHandleForbidOne(rule, EMPLOYEENO_CONNECTION_SWITCH, parseRegexTip, view);
            } else {
                view.setEnable(Boolean.TRUE, new String[]{"employeenoscheme"});
            }
        }
        if ((autoObj = rule.get("automatic")) != null) {
            OnbrdAgainRuleUtils.setValue(model, "automaticinfo", Boolean.parseBoolean((String)autoObj));
        }
        return rule;
    }

    private static String parseRegexTip(String number, String serviceAge, String tipByHRCS) {
        if (tipByHRCS == null) {
            return tipByHRCS;
        }
        String regex = "\u2460#\\{([\\s\\S]*?)}#";
        Pattern compile = Pattern.compile(regex);
        Matcher matcher = compile.matcher(tipByHRCS);
        while (matcher.find()) {
            String group = matcher.group(0);
            if (group.contains("employeenoscheme")) {
                tipByHRCS = tipByHRCS.replace(group, EmployeeNoSchemeEnum.getEnum((String)number).getName());
            }
            if (!group.contains("serviceagescheme")) continue;
            tipByHRCS = tipByHRCS.replace(group, ServiceAgeSchemeEnum.getEnum((String)serviceAge).getName());
        }
        return tipByHRCS;
    }

    private static boolean isHasResult(List<Map<String, Object>> ruleResult, IFormView view) {
        Map<String, Object> rule = ruleResult.get(0);
        IPageCache pageCache = view.getPageCache();
        boolean ecSwitch = Boolean.parseBoolean(pageCache.get(EMPLOYEENO_CONNECTION_SWITCH));
        boolean scSwitch = Boolean.parseBoolean(pageCache.get(SENIORITY_CONNECTION_SWITCH));
        return !ecSwitch && !scSwitch || ecSwitch && rule.get("number") != null || scSwitch && rule.get("service_age") != null;
    }

    private static void isEnable(IFormView view, String ecSwitch, String scSwitch, String acSwitch) {
        if ("true".equals(ecSwitch)) {
            view.setEnable(Boolean.TRUE, new String[]{"employeenoscheme"});
        }
        if ("true".equals(scSwitch)) {
            view.setEnable(Boolean.TRUE, new String[]{"serviceagescheme"});
        }
        if ("true".equals(acSwitch)) {
            view.setEnable(Boolean.TRUE, new String[]{"automaticinfo"});
        }
    }

    public static boolean isIdentical(List<Map<String, Object>> list, String ecSwitch, String scSwitch) {
        boolean isNumberSame = true;
        boolean isAgeSame = true;
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        list.stream().forEach(map -> map.keySet().forEach(key -> {
            ArrayList<String> valueList = (ArrayList<String>)result.get(key);
            if (CollectionUtils.isEmpty((Collection)valueList)) {
                valueList = new ArrayList<String>();
                result.put((String)key, (List<String>)valueList);
            }
            valueList.add((String)map.get(key));
        }));
        if ("true".equals(ecSwitch) && !CollectionUtils.isEmpty((Collection)((Collection)result.get("number")))) {
            isNumberSame = OnbrdAgainRuleUtils.isTheSame(list, result, "number");
        }
        if ("true".equals(scSwitch) && !CollectionUtils.isEmpty((Collection)((Collection)result.get("service_age")))) {
            isAgeSame = OnbrdAgainRuleUtils.isTheSame(list, result, "service_age");
        }
        boolean isAutoSame = OnbrdAgainRuleUtils.isTheSame(list, result, "automatic");
        return isNumberSame && isAgeSame && isAutoSame;
    }

    public static boolean isTheSame(List<Map<String, Object>> list, Map<String, List<String>> result, String key) {
        if (list.size() == 1) {
            return true;
        }
        List<String> stringList = result.get(key);
        if (stringList == null) {
            return true;
        }
        if (stringList.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < stringList.size(); ++i) {
            String compareValue;
            String firstValue = stringList.get(0);
            if (i > stringList.size() - 2 || HRStringUtils.equals((String)firstValue, (String)(compareValue = stringList.get(i + 1)))) continue;
            return false;
        }
        return true;
    }

    public static void mutexHandle(boolean isSame, IFormView view) {
        IDataModel model = view.getModel();
        OnbrdAgainRuleUtils.setValue(model, "automaticinfo", Boolean.FALSE);
        boolean isOnbrdInfoPage = view.getEntityId().equals("hom_onbrdinfo");
        IFormView parentView = isOnbrdInfoPage ? view.getParentView() : view;
        Label label = (Label)parentView.getControl("cerrorlabelap");
        String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652271177508478976L, null);
        label.setText(tipByHRCS);
        if (!isSame) {
            label.setText(IMobCommonAppService.getInstance().getTipByHRCS(null, 1652271512926969856L, null));
        }
        if (isOnbrdInfoPage) {
            OnbrdAgainRuleUtils.hideTipsAndShow(parentView, "cerrorcloseap");
            view.sendFormAction(parentView);
        }
    }

    private static void setValue(IDataModel model, String key, Object value) {
        Map allFields = model.getDataEntityType().getAllFields();
        if (allFields.containsKey(key)) {
            model.setValue(key, value);
        }
    }

    public static void succeedHandleForbidNone(Map<String, Object> rule, IFormView view) {
        String parseRegexTip;
        String tipByHRCS;
        IDataModel model = view.getModel();
        Object number = rule.get("number");
        Object serviceAge = rule.get("service_age");
        if (!HRObjectUtils.isEmpty((Object)number) && !HRObjectUtils.isEmpty((Object)serviceAge)) {
            OnbrdAgainRuleUtils.setValue(model, "employeenoscheme", number);
            OnbrdAgainRuleUtils.setValue(model, "serviceagescheme", serviceAge);
            tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(view, 1645753415042685952L, null);
            parseRegexTip = OnbrdAgainRuleUtils.parseRegexTip((String)number, (String)serviceAge, tipByHRCS);
            OnbrdAgainRuleUtils.showTips(rule, parseRegexTip, view);
        }
        if (!HRObjectUtils.isEmpty((Object)number) && HRObjectUtils.isEmpty((Object)serviceAge)) {
            OnbrdAgainRuleUtils.setValue(model, "employeenoscheme", number);
            view.setEnable(Boolean.TRUE, new String[]{"serviceagescheme"});
            tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(view, 1645756439672740864L, null);
            parseRegexTip = OnbrdAgainRuleUtils.parseRegexTip((String)number, (String)serviceAge, tipByHRCS);
            OnbrdAgainRuleUtils.showTips(rule, parseRegexTip, view);
        }
        if (HRObjectUtils.isEmpty((Object)number) && !HRObjectUtils.isEmpty((Object)serviceAge)) {
            OnbrdAgainRuleUtils.setValue(model, "serviceagescheme", serviceAge);
            view.setEnable(Boolean.TRUE, new String[]{"employeenoscheme"});
            tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(view, 1645758262550813696L, null);
            parseRegexTip = OnbrdAgainRuleUtils.parseRegexTip((String)number, (String)serviceAge, tipByHRCS);
            OnbrdAgainRuleUtils.showTips(rule, parseRegexTip, view);
        }
    }

    public static void succeedHandleForbidOne(Map<String, Object> rule, String noForbidKey, String tips, IFormView view) {
        IDataModel model = view.getModel();
        Object number = rule.get("number");
        Object serviceAge = rule.get("service_age");
        if (HRStringUtils.equals((String)noForbidKey, (String)SENIORITY_CONNECTION_SWITCH) && !HRObjectUtils.isEmpty((Object)serviceAge)) {
            OnbrdAgainRuleUtils.setValue(model, "serviceagescheme", serviceAge);
        } else if (HRStringUtils.equals((String)noForbidKey, (String)EMPLOYEENO_CONNECTION_SWITCH) && !HRObjectUtils.isEmpty((Object)number)) {
            OnbrdAgainRuleUtils.setValue(model, "employeenoscheme", number);
        }
        OnbrdAgainRuleUtils.showTips(rule, tips, view);
    }

    public static void showTips(Map<String, Object> rule, String tips, IFormView view) {
        IFormView parentView = view.getEntityId().equals("hom_onbrdinfo") ? view.getParentView() : view;
        Label label = (Label)parentView.getControl("cwarniinglabelap");
        label.setText(tips);
        OnbrdAgainRuleUtils.hideTipsAndShow(parentView, "cwarncloseap");
        view.sendFormAction(parentView);
    }

    public static void showTips(IFormView view) {
        HRPageCache cache = new HRPageCache(view);
        String tepy = (String)cache.get("tipsType", String.class);
        FormShowParameter formShowParameter = new FormShowParameter();
        String pageName = ResManager.loadKDString((String)"\u518d\u5165\u804c\u98ce\u9669\u63d0\u793a", (String)"TipCloseEdit_0", (String)"hr-hom-business", (Object[])new Object[0]);
        if (AgainCheckResultsEnum.PROHIBIT.getCode().equals(tepy)) {
            pageName = ResManager.loadKDString((String)"\u7981\u6b62\u518d\u5165\u804c\u539f\u56e0", (String)"TipCloseEdit_1", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setFormId(HOM_REENTRYTIPS);
        formShowParameter.setCaption(pageName);
        view.showForm(formShowParameter);
    }
}

