/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.blacklist.IBlackListService;
import kd.hr.hom.business.application.utils.BlackListConfigUtil;
import kd.hr.hom.common.entity.BlacklistConfigDTO;

public class BlackListValidUtil {
    private static final Log LOGGER = LogFactory.getLog(BlackListValidUtil.class);
    private static BlackListValidUtil blackListValidUtil = new BlackListValidUtil();

    public static BlackListValidUtil getInstance() {
        return blackListValidUtil;
    }

    public Map<Long, String> blackListValidBatch(DynamicObject[] onbrdBills) {
        LOGGER.info("BlackListValidUtil.blackListValid.param={0}", (Object[])onbrdBills);
        if (onbrdBills == null || onbrdBills.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(onbrdBills.length);
        BlacklistConfigDTO config = BlackListConfigUtil.getBlackListConfig(onbrdBills[0].getLong("org.id"));
        if (Boolean.FALSE.equals(config.getEnableBlacklistValid())) {
            return Collections.emptyMap();
        }
        IBlackListService blackListService = IBlackListService.getInstance();
        BlacklistConfigDTO.ValidFieldDTO wConfigDto = config.getWarnValidFieldDto();
        LOGGER.info("BlackListValidUtil.blackListValid.warnConfigDto={0}", (Object)wConfigDto);
        Map<String, Object> assembleParamWarnMap = this.buildValidFieldDto(wConfigDto, onbrdBills);
        if (!HRMapUtils.isEmpty(assembleParamWarnMap)) {
            Map<String, Object> blackListWarnMap = blackListService.queryBlackList(assembleParamWarnMap);
            Set<Map.Entry<String, Object>> entries = blackListWarnMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (HRObjectUtils.isEmpty((Object)value) || !(value instanceof Map)) continue;
                Map dyMap = (Map)value;
                String warnTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff0c\u5982\u9700\u7ee7\u7eed\u529e\u7406\uff0c\u8bf7\u624b\u52a8\u586b\u5199\u5165\u804c\u5355\u5e76\u7533\u8bf7\u5ffd\u7565\u9ed1\u540d\u5355\u62e6\u622a\u539f\u56e0\u3002\uff08\u539f\u56e0\uff1a%1$s\uff0c\u5907\u6ce8\uff1a%2$s\uff0c\u9ed1\u540d\u5355\u7ba1\u7406\u7ec4\u7ec7\uff1a%3$s\uff0c\u6dfb\u52a0\u4eba\uff1a%4$s\uff0c\u6dfb\u52a0\u65f6\u95f4\uff1a%5$s\uff09\u3002", (String)"BlackListValidUtil_0", (String)"hr-hom-business", (Object[])new Object[0]), dyMap.get("toreason"), dyMap.get("reasondetail"), dyMap.get("adminororg"), dyMap.get("creator"), dyMap.get("createtime"));
                resultMap.put(Long.valueOf(key), warnTip);
            }
        }
        LOGGER.info("BlackListValidUtil.blackListValid.resultMap.after.warn.valid={0}", resultMap);
        BlacklistConfigDTO.ValidFieldDTO eConfigDto = config.getErrorValidFieldDto();
        LOGGER.info("BlackListValidUtil.blackListValid.errConfigDto={0}", (Object)eConfigDto);
        Map<String, Object> assembleParamErrMap = this.buildValidFieldDto(eConfigDto, onbrdBills);
        if (!HRMapUtils.isEmpty(assembleParamErrMap)) {
            Map<String, Object> blackListErrMap = blackListService.queryBlackList(assembleParamErrMap);
            Set<Map.Entry<String, Object>> entries = blackListErrMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (HRObjectUtils.isEmpty((Object)value) || !(value instanceof Map)) continue;
                Map dyMap = (Map)value;
                String warnTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff0c\u65e0\u6cd5\u5165\u804c\u3002\uff08\u6dfb\u52a0\u539f\u56e0\uff1a%1$s\uff0c\u5907\u6ce8\uff1a%2$s\uff0c\u9ed1\u540d\u5355\u7ba1\u7406\u7ec4\u7ec7\uff1a%3$s\uff0c\u6dfb\u52a0\u4eba\uff1a%4$s\uff0c\u6dfb\u52a0\u65f6\u95f4\uff1a%5$s\uff09\u3002", (String)"BlackListValidUtil_1", (String)"hr-hom-business", (Object[])new Object[0]), dyMap.get("toreason"), dyMap.get("reasondetail"), dyMap.get("adminororg"), dyMap.get("creator"), dyMap.get("createtime"));
                resultMap.put(Long.valueOf(key), warnTip);
            }
        }
        LOGGER.info("BlackListValidUtil.blackListValid.result={0}", resultMap);
        return resultMap;
    }

    public Map<Long, String> blackListValid(DynamicObject[] onbrdBills) {
        LOGGER.info("BlackListValidUtil.blackListValid.param={0}", (Object[])onbrdBills);
        if (onbrdBills == null || onbrdBills.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> resultMap = new HashMap<Long, String>(onbrdBills.length);
        for (DynamicObject onbrdBill : onbrdBills) {
            long aLong = onbrdBill.getLong("id");
            BlacklistConfigDTO config = BlackListConfigUtil.getBlackListConfig(onbrdBill.getLong("org.id"));
            if (Boolean.FALSE.equals(config.getEnableBlacklistValid())) continue;
            IBlackListService blackListService = IBlackListService.getInstance();
            BlacklistConfigDTO.ValidFieldDTO wConfigDto = config.getWarnValidFieldDto();
            LOGGER.info("BlackListValidUtil.blackListValid.warnConfigDto={}", (Object)wConfigDto);
            Map<String, Object> assembleParamWarnMapSignle = this.buildValidFieldDtoSingle(wConfigDto, onbrdBill);
            if (!HRMapUtils.isEmpty(assembleParamWarnMapSignle)) {
                Map<String, Object> blackListWarnMap = blackListService.queryBlackListSingle(assembleParamWarnMapSignle);
                LOGGER.info("BlackListValidUtil.blackListValid.blackListWarnMap={}", blackListWarnMap);
                if (!HRMapUtils.isEmpty(blackListWarnMap)) {
                    String warnTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff0c\u5982\u9700\u7ee7\u7eed\u529e\u7406\uff0c\u8bf7\u624b\u52a8\u586b\u5199\u5165\u804c\u5355\u5e76\u7533\u8bf7\u5ffd\u7565\u9ed1\u540d\u5355\u62e6\u622a\u539f\u56e0\u3002\uff08\u539f\u56e0\uff1a%1$s\uff0c\u5907\u6ce8\uff1a%2$s\uff0c\u9ed1\u540d\u5355\u7ba1\u7406\u7ec4\u7ec7\uff1a%3$s\uff0c\u6dfb\u52a0\u4eba\uff1a%4$s\uff0c\u6dfb\u52a0\u65f6\u95f4\uff1a%5$s\uff09\u3002", (String)"BlackListValidUtil_0", (String)"hr-hom-business", (Object[])new Object[0]), blackListWarnMap.get("toreason"), blackListWarnMap.get("reasondetail"), blackListWarnMap.get("adminororg"), blackListWarnMap.get("creator"), blackListWarnMap.get("createtime"));
                    resultMap.put(aLong, warnTip);
                }
            }
            LOGGER.info("BlackListValidUtil.blackListValid.resultMap.after.warn.valid={}", resultMap);
            BlacklistConfigDTO.ValidFieldDTO eConfigDto = config.getErrorValidFieldDto();
            LOGGER.info("BlackListValidUtil.blackListValid.errConfigDto={}", (Object)eConfigDto);
            Map<String, Object> assembleParamErrMap = this.buildValidFieldDtoSingle(eConfigDto, onbrdBill);
            if (HRMapUtils.isEmpty(assembleParamErrMap)) continue;
            Map<String, Object> blackListErrMap = blackListService.queryBlackListSingle(assembleParamErrMap);
            LOGGER.info("BlackListValidUtil.blackListValid.blackListErrMap={}", blackListErrMap);
            if (HRMapUtils.isEmpty(blackListErrMap)) continue;
            String warnTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u88ab\u5217\u5165\u9ed1\u540d\u5355\uff0c\u65e0\u6cd5\u5165\u804c\u3002\uff08\u6dfb\u52a0\u539f\u56e0\uff1a%1$s\uff0c\u5907\u6ce8\uff1a%2$s\uff0c\u9ed1\u540d\u5355\u7ba1\u7406\u7ec4\u7ec7\uff1a%3$s\uff0c\u6dfb\u52a0\u4eba\uff1a%4$s\uff0c\u6dfb\u52a0\u65f6\u95f4\uff1a%5$s\uff09\u3002", (String)"BlackListValidUtil_1", (String)"hr-hom-business", (Object[])new Object[0]), blackListErrMap.get("toreason"), blackListErrMap.get("reasondetail"), blackListErrMap.get("adminororg"), blackListErrMap.get("creator"), blackListErrMap.get("createtime"));
            resultMap.put(aLong, warnTip);
        }
        LOGGER.info("BlackListValidUtil.blackListValid.result={}", resultMap);
        return resultMap;
    }

    private Map<String, Object> buildValidFieldDto(BlacklistConfigDTO.ValidFieldDTO configDto, DynamicObject[] onbrdBills) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(onbrdBills.length);
        for (DynamicObject onbrdBill : onbrdBills) {
            long pkId = onbrdBill.getLong("id");
            HashMap<String, Object> checkedFieldMap = new HashMap<String, Object>(8);
            String name = onbrdBill.getString("name");
            Long certificateType = onbrdBill.getLong("certificatetype.id");
            String certificateNumber = onbrdBill.getString("certificatenumber");
            String phone = onbrdBill.getString("phone");
            String email = onbrdBill.getString("peremail");
            if (Boolean.TRUE.equals(configDto.getName())) {
                if (HRStringUtils.isBlank((CharSequence)onbrdBill.getString("name"))) continue;
                checkedFieldMap.put("name", name);
            }
            if (Boolean.TRUE.equals(configDto.getCertificate())) {
                if (HRStringUtils.isBlank((CharSequence)certificateNumber) || HRObjectUtils.isEmpty((Object)certificateType)) continue;
                checkedFieldMap.put("cardtype", certificateType);
                checkedFieldMap.put("cardnumber", certificateNumber);
            }
            if (Boolean.TRUE.equals(configDto.getPhone())) {
                if (HRStringUtils.isBlank((CharSequence)phone)) continue;
                checkedFieldMap.put("phone", phone);
            }
            if (Boolean.TRUE.equals(configDto.getEmail())) {
                if (HRStringUtils.isBlank((CharSequence)email)) continue;
                checkedFieldMap.put("email", email);
            }
            resultMap.put(String.valueOf(pkId), checkedFieldMap);
        }
        return resultMap;
    }

    private Map<String, Object> buildValidFieldDtoSingle(BlacklistConfigDTO.ValidFieldDTO configDto, DynamicObject dataEntity) {
        HashMap<String, Object> checkedFieldMap = new HashMap<String, Object>(8);
        String name = dataEntity.getString("name");
        Long certificateType = dataEntity.getLong("certificatetype.id");
        String certificateNumber = dataEntity.getString("certificatenumber");
        String phone = dataEntity.getString("phone");
        String email = dataEntity.getString("peremail");
        if (Boolean.TRUE.equals(configDto.getName())) {
            if (!HRStringUtils.isBlank((CharSequence)dataEntity.getString("name"))) {
                checkedFieldMap.put("name", name);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getCertificate())) {
            if (!HRStringUtils.isBlank((CharSequence)certificateNumber) && !HRObjectUtils.isEmpty((Object)certificateType)) {
                checkedFieldMap.put("cardtype", certificateType);
                checkedFieldMap.put("cardnumber", certificateNumber);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getPhone())) {
            if (!HRStringUtils.isBlank((CharSequence)phone)) {
                checkedFieldMap.put("phone", phone);
            } else {
                return Collections.emptyMap();
            }
        }
        if (Boolean.TRUE.equals(configDto.getEmail())) {
            if (!HRStringUtils.isBlank((CharSequence)email)) {
                checkedFieldMap.put("email", email);
            } else {
                return Collections.emptyMap();
            }
        }
        return checkedFieldMap;
    }
}

