/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.ORMUtil;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.onbrd.OnbrdCommonAppServiceImpl;
import kd.hr.hom.common.util.PreOnBrdCommonUtil;

public class PreOnbrdUtil {
    private static final PreOnbrdUtil PRE_ONBRD_UTILS = new PreOnbrdUtil();

    public static PreOnbrdUtil getInstance() {
        return PRE_ONBRD_UTILS;
    }

    public String checkFormat(DynamicObject preApplyObject, boolean phoneBool) {
        boolean permailBool;
        OnbrdCommonAppServiceImpl onbrdCommonAppService;
        Optional<String> numMsg;
        boolean cerBool;
        String mergeAttrName;
        StringBuilder errMsg = new StringBuilder();
        String peremail = preApplyObject.getString("peremail");
        boolean email = Boolean.TRUE;
        if (HRStringUtils.isNotEmpty((String)peremail)) {
            email = StringUtils.isEmail((String)peremail);
        }
        if (HRStringUtils.isNotEmpty((String)(mergeAttrName = PreOnBrdCommonUtil.getMergeAttrName((boolean)(cerBool = (numMsg = (onbrdCommonAppService = new OnbrdCommonAppServiceImpl()).validateCertificateNum(preApplyObject.getDynamicObject("certificatetype"), preApplyObject.getString("certificatenumber"))).isPresent()), (!phoneBool ? 1 : 0) != 0, (boolean)(permailBool = !email))))) {
            return errMsg.append(mergeAttrName).append(ResManager.loadKDString((String)"\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PreOnbrdUtil_0", (String)"hr-hom-business", (Object[])new Object[0])).toString();
        }
        return "";
    }

    public String checkFormatForImport(JSONObject preApplyObject, boolean phoneError) {
        StringBuilder errMsg = new StringBuilder();
        OnbrdCommonAppServiceImpl onbrdCommonAppService = new OnbrdCommonAppServiceImpl();
        Optional<String> numMsg = onbrdCommonAppService.validateCertificateNum(preApplyObject.getJSONObject("certificatetype"), preApplyObject.getString("certificatenumber"));
        String locationCode = preApplyObject.getString("locationcode");
        if (HRStringUtils.isNotEmpty((String)locationCode) && !locationCode.startsWith("+")) {
            locationCode = "+" + locationCode;
        }
        String phoneCode = preApplyObject.getString("phonecode");
        preApplyObject.put("phone", (Object)(locationCode + "-" + phoneCode));
        boolean cerBool = numMsg.isPresent();
        String mergeAttrName = PreOnBrdCommonUtil.getMergeAttrName((boolean)cerBool, (!phoneError ? 1 : 0) != 0, (boolean)Boolean.FALSE);
        if (HRStringUtils.isNotEmpty((String)mergeAttrName)) {
            return errMsg.append(mergeAttrName).append(ResManager.loadKDString((String)"\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PreOnbrdUtil_0", (String)"hr-hom-business", (Object[])new Object[0])).toString();
        }
        return "";
    }

    public Map<String, Boolean> telephoneVerify(List<String> phones) {
        HashMap telephoneVerifyResultMap = Maps.newHashMapWithExpectedSize((int)phones.size());
        ArrayList areaCodeInfos = Lists.newArrayListWithCapacity((int)phones.size());
        ORMUtil.getCountryAndAreaCode().values().forEach(areaCodeInfos::addAll);
        Set areaCodes = areaCodeInfos.stream().map(info -> info.get("id")).collect(Collectors.toSet());
        phones.removeIf(phone -> {
            String areaCode = HRStringUtils.substringBeforeLast((String)phone, (String)"-");
            if (!areaCodes.contains(areaCode)) {
                telephoneVerifyResultMap.put(phone, Boolean.FALSE);
                return true;
            }
            return false;
        });
        List telephoneVerifyResults = I18nServiceHelper.batchVerifyTelephoneNumber(phones);
        for (int index = 0; index < telephoneVerifyResults.size(); ++index) {
            String phone2 = phones.get(index);
            TelephoneVerifyResult telephoneVerifyResult = (TelephoneVerifyResult)telephoneVerifyResults.get(index);
            telephoneVerifyResultMap.put(phone2, telephoneVerifyResult.isVerifySuccess());
        }
        return telephoneVerifyResultMap;
    }
}

