/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.application.utils;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hpfs.IDevParamConfigExternalService;
import kd.hr.hom.business.application.utils.MessageParamBuildUtil;
import kd.hr.hom.business.domain.repository.common.BosUserRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.impl.common.MessageTemplateParser;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.MessageDTO;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class SendMessageUtil {
    private static final Log LOGGER = LogFactory.getLog(SendMessageUtil.class);

    public static void sendMessageWithUrl(DynamicObject[] dys, List<Long> personIds, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        Set onbrdIds = Stream.of(dys).map(dy -> dy.getLong("onbrdid.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("", new QFilter[]{qFilter});
        Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        for (DynamicObject dy2 : dys) {
            if (dy2.containsProperty("taskswitch") && "2".equals(dy2.getString("taskswitch"))) {
                LOGGER.info("SendMessageUtil.sendMessageWithUrl end,need not send message");
                continue;
            }
            String buNumber = dy2.getString("onbrdid.org.number");
            LOGGER.info("sendMessageWithUrl_buNumber:{}", (Object)buNumber);
            DynamicObject onbrdBill2 = onbrdBillMap.get(dy2.getLong("onbrdid.id"));
            String billNo = onbrdBill2.getString("billno");
            String templateNumber = ServiceFactory.getService(ISendMessageService.class).getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill2);
            long bizId = dy2.getLong("id");
            LOGGER.info("sendMessageWithUrl_templateNumber:{}", (Object)(templateNumber == null ? "null" : templateNumber));
            if (!HRStringUtils.isNotEmpty((String)templateNumber)) continue;
            String handlerUrl = IActivityDomainService.getInstance().buildHandlerUrl(dy2, bizId);
            Tuple<String, String> messageContext = MessageTemplateParser.getMessageContextTuple(templateNumber, bizId);
            LocaleString localeStringTag = ResManager.getLocaleString((String)"\u901a\u77e5", (String)"SendMessageUtil_0", (String)"hr-hom-business");
            MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO((Long)bizId, templateNumber, personIds, billNo, (ILocaleString)localeStringTag);
            messageDto.setTitle((String)messageContext.item1);
            messageDto.setContent((String)messageContext.item2);
            messageDto.setContentUrl(handlerUrl);
            SendMessageUtil.sendMessage(messageDto);
        }
    }

    @Deprecated
    public static void sendMessageByTemplate(Map<String, String> messageTextMap, String url, List<Long> userIds, DynamicObject templateDyn) {
        List<Long> bosUserIdsByPersonIds;
        MessageInfo message = new MessageInfo();
        message.setMessageType(templateDyn.getString("msgtype"));
        if (!SendMessageUtil.getMsgChannel(templateDyn.getString("msgchannel"))) {
            return;
        }
        message.setNotifyType(templateDyn.getString("msgchannel"));
        for (Map.Entry<String, String> stringStringEntry : messageTextMap.entrySet()) {
            String str = stringStringEntry.getKey().toLowerCase(Locale.ENGLISH);
            if (str.endsWith("title")) {
                message.setMessageTitle((ILocaleString)new LocaleString(stringStringEntry.getValue()));
                continue;
            }
            if (!str.endsWith("content")) continue;
            message.setMessageContent((ILocaleString)new LocaleString(stringStringEntry.getValue()));
        }
        if (HRStringUtils.isNotEmpty((String)url)) {
            message.setContentUrl(url);
        }
        if ((bosUserIdsByPersonIds = SendMessageUtil.getBosUserIdsByPersonIds(userIds)) == null) {
            return;
        }
        List<Long> filterIds = SendMessageUtil.getFilterIds(bosUserIdsByPersonIds);
        if (HRCollUtil.isEmpty(filterIds)) {
            return;
        }
        message.setUserIds(filterIds);
        message.setSendTime(new Date());
        MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
    }

    public static void sendMessageByTemplate(Long bizId, Map<String, String> messageTextMap, String url, List<Long> userIds, DynamicObject templateDyn) {
        SendMessageUtil.sendMessageByTemplate(bizId, messageTextMap, url, userIds, templateDyn, null);
    }

    public static void sendMessageByTemplate(Long bizId, Map<String, String> messageTextMap, String url, List<Long> userIds, DynamicObject templateDyn, Map<String, Object> params) {
        List<Long> bosUserIdsByPersonIds;
        MessageInfo message = new MessageInfo();
        message.setMessageType(templateDyn.getString("msgtype"));
        if (!SendMessageUtil.getMsgChannel(templateDyn.getString("msgchannel"))) {
            return;
        }
        message.setNotifyType(templateDyn.getString("msgchannel"));
        for (Map.Entry<String, String> stringStringEntry : messageTextMap.entrySet()) {
            String str = stringStringEntry.getKey().toLowerCase(Locale.ENGLISH);
            if (str.endsWith("title")) {
                message.setMessageTitle((ILocaleString)new LocaleString(stringStringEntry.getValue()));
                continue;
            }
            if (!str.endsWith("content")) continue;
            message.setMessageContent((ILocaleString)new LocaleString(stringStringEntry.getValue()));
        }
        if (HRStringUtils.isNotEmpty((String)url)) {
            message.setContentUrl(url);
        }
        if ((bosUserIdsByPersonIds = SendMessageUtil.getBosUserIdsByPersonIds(userIds)) == null) {
            return;
        }
        List<Long> filterIds = SendMessageUtil.getFilterIds(bosUserIdsByPersonIds);
        if (HRCollUtil.isEmpty(filterIds)) {
            return;
        }
        message.setUserIds(filterIds);
        message.setSendTime(new Date());
        String dentityid = templateDyn.getDynamicObject("msgentity").getString("id");
        message.setEntityNumber(dentityid);
        message.setTemplateNumber(templateDyn.getString("number"));
        Map<String, Object> paramsParse = MessageTemplateParser.parserMessageTplParam(templateDyn.getString("number"), bizId, new HashMap<String, Object>(), templateDyn);
        if (params.containsKey("phone")) {
            paramsParse.put("model_phone", params.get("phone"));
        }
        if (params.containsKey("email")) {
            paramsParse.put("model_email", params.get("email"));
        }
        params.putAll(paramsParse);
        if (!HRMapUtils.isEmpty(params)) {
            message.setParams(params);
        }
        MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
    }

    public static Tuple<String, String> smsWhiteList() {
        IDevParamConfigExternalService externalService = IDevParamConfigExternalService.getInstance();
        String configValue = externalService.getValueByKey("sms_whitelist_enable");
        LOGGER.info("###SendMessageUtil.smsWhiteList getValueByKey, [sms_whitelist_enable] is:{}", (Object)configValue);
        boolean whitelistEnable = Boolean.parseBoolean(configValue);
        if (whitelistEnable) {
            String smsWhiteListStr = externalService.getValueByKey("sms_whitelist_str");
            return Tuple.create((Object)"1", (Object)smsWhiteListStr);
        }
        return Tuple.create((Object)"0", (Object)"");
    }

    public static boolean getMsgChannel(String channel) {
        if (HRStringUtils.isEmpty((String)channel)) {
            return false;
        }
        String messageChannel = ServiceFactory.getService(IHomConfigService.class).getConfVal("message_channel", "");
        if (HRStringUtils.isEmpty((String)messageChannel)) {
            return true;
        }
        String[] split = messageChannel.split(",");
        return Arrays.asList(split).contains(channel);
    }

    public static List<Long> getFilterIds(List<Long> idList) {
        Tuple<String, String> sysWhiteListConfig = SendMessageUtil.smsWhiteList();
        if (HRCollUtil.isEmpty(idList) || !HRStringUtils.equals((String)((String)sysWhiteListConfig.item1), (String)"1") || HRStringUtils.isEmpty((String)((String)sysWhiteListConfig.item2))) {
            return idList;
        }
        String item2 = (String)sysWhiteListConfig.item2;
        List<String> split = Arrays.asList(item2.split(","));
        List<Long> result = idList.stream().filter(id -> !HRObjectUtils.isEmpty((Object)id)).filter(id -> split.contains(id.toString())).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(result)) {
            result = new ArrayList<Long>();
        }
        return result;
    }

    public static List<String> getFilterStrList(List<String> strList) {
        Tuple<String, String> sysWhiteListConfig = SendMessageUtil.smsWhiteList();
        if (HRCollUtil.isEmpty(strList) || !HRStringUtils.equals((String)((String)sysWhiteListConfig.item1), (String)"1") || HRStringUtils.isEmpty((String)((String)sysWhiteListConfig.item2))) {
            return strList;
        }
        String item2 = (String)sysWhiteListConfig.item2;
        List<String> split = Arrays.asList(item2.split(","));
        List<String> result = strList.stream().filter(id -> !HRObjectUtils.isEmpty((Object)id)).filter(split::contains).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(result)) {
            result = new ArrayList<String>();
        }
        return result;
    }

    public static List<Long> getBosUserIdsByPersonIds(List<Long> personIds) {
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(1);
        idMaps.put("person", personIds);
        Map userIdMaps = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (Boolean.FALSE.equals(userIdMaps.get("success"))) {
            return Collections.emptyList();
        }
        Map data = (Map)userIdMaps.get("data");
        if (data == null) {
            return Collections.emptyList();
        }
        return data.entrySet().stream().map(entry -> (Long)((Map)entry.getValue()).get("user")).collect(Collectors.toList());
    }

    public static List<Long> getBosUserIds(List<String> personNumberList) {
        QFilter numberFilter = new QFilter("number", "in", personNumberList);
        QFilter enabelFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] bosUsers = BosUserRepository.getInstance().query("id", new QFilter[]{numberFilter, enabelFilter});
        ArrayList<Long> bosUserIdList = new ArrayList<Long>(bosUsers.length);
        for (DynamicObject bosUser : bosUsers) {
            bosUserIdList.add(bosUser.getLong("id"));
        }
        return bosUserIdList;
    }

    public static String buildURL(DynamicObject dynamicObject, Map<String, String> params) {
        String contentUrl = UrlService.getDomainContextUrl();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put("cooperationId", String.valueOf(dynamicObject.getLong("id")));
        parameterMap.putAll(params);
        String paramString = parameterMap.entrySet().stream().map(entry -> String.format(Locale.ROOT, "%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
        return String.format(Locale.ROOT, "%s/?%s", contentUrl, paramString);
    }

    public static boolean sendMessage(MessageDTO messageDto) {
        List receiverBosUserIds = messageDto.getReceiverBosUserIds();
        List phones = messageDto.getPhonesFromParams();
        List emails = messageDto.getEmailsFromParams();
        String templateNumber = messageDto.getTemplateNumber();
        if (HRCollUtil.isEmpty((Collection)receiverBosUserIds) && HRCollUtil.isEmpty((Collection)phones) && HRCollUtil.isEmpty((Collection)emails)) {
            LOGGER.warn("###SendMessageUtil.sendMessage bosUserIds && emails && phones is empty!");
            return true;
        }
        if (HRStringUtils.isBlank((CharSequence)templateNumber)) {
            LOGGER.warn("###SendMessageUtil.sendMessage templateNumb is empty! templateNumber:{}", (Object)templateNumber);
            return true;
        }
        List<Long> filterUserIds = SendMessageUtil.getFilterIds(receiverBosUserIds);
        List<String> filterPhones = SendMessageUtil.getFilterStrList(phones);
        List<String> filterEmails = SendMessageUtil.getFilterStrList(emails);
        if (HRCollUtil.isEmpty(filterUserIds) && HRCollUtil.isEmpty(filterPhones) && HRCollUtil.isEmpty(filterEmails)) {
            LOGGER.warn("###SendMessageUtil.sendMessage filterUserIds is empty!");
            return true;
        }
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (HRObjectUtils.isEmpty((Object)templateDyn)) {
            LOGGER.warn("###SendMessageUtil.sendMessage templateDyn not find!, templateNumber:{}", (Object)templateNumber);
            return true;
        }
        String msgChannel = templateDyn.getString("msgchannel");
        if (HRStringUtils.isBlank((CharSequence)msgChannel)) {
            LOGGER.warn("###SendMessageUtil.sendMessage msgchannel is blank!");
            return true;
        }
        MessageInfo message = new MessageInfo();
        message.setUserIds(filterUserIds);
        if (HRObjectUtils.isEmpty((Object)messageDto.getLocaleStringTag())) {
            message.setMessageTag(templateDyn.getLocaleString("name"));
        } else {
            message.setMessageTag(messageDto.getLocaleStringTag());
        }
        String dentityid = templateDyn.getDynamicObject("msgentity").getString("id");
        messageDto.setEntityNumber(dentityid);
        message.setContentUrl(messageDto.getContentUrl());
        message.setTemplateNumber(templateNumber);
        message.setMessageSenderName((ILocaleString)ResManager.getLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"SendMessageUtil_3", (String)"hr-hom-business"));
        message.setNotifyType(msgChannel);
        Map<String, Object> params = MessageTemplateParser.parserMessageTplParam(templateNumber, messageDto.getBizDataId(), new HashMap<String, Object>(), templateDyn);
        if (params.containsKey("phone")) {
            params.put("model_phone", params.get("phone"));
        }
        if (params.containsKey("email")) {
            params.put("model_email", params.get("email"));
        }
        if (!CollectionUtils.isEmpty((Map)messageDto.getParams())) {
            params.putAll(messageDto.getParams());
        }
        MessageParamBuildUtil.buildSpecialParam(params, messageDto);
        message.setParams(params);
        Map<String, String> jsonContent = MessageTemplateParser.parserMessageEntity(templateNumber, messageDto.getBizDataId(), params, templateDyn);
        for (Map.Entry<String, String> stringStringEntry : jsonContent.entrySet()) {
            if (HRObjectUtils.isEmpty((Object)stringStringEntry.getValue())) continue;
            if (stringStringEntry.getKey().toLowerCase(Locale.ENGLISH).endsWith("title")) {
                message.setMessageTitle((ILocaleString)new LocaleString(stringStringEntry.getValue()));
                continue;
            }
            if (!stringStringEntry.getKey().toLowerCase(Locale.ENGLISH).endsWith("content")) continue;
            message.setMessageContent((ILocaleString)new LocaleString(stringStringEntry.getValue()));
        }
        if (HRObjectUtils.isEmpty((Object)message.getMessageTitle())) {
            if (!HRStringUtils.isBlank((CharSequence)messageDto.getTitle())) {
                message.setMessageTitle((ILocaleString)new LocaleString(messageDto.getTitle()));
            } else if (!HRObjectUtils.isEmpty((Object)message.getMessageTag())) {
                message.setMessageTitle(message.getMessageTag());
            } else {
                message.setMessageTitle((ILocaleString)new LocaleString(message.getContent()));
            }
        }
        message.setSource("hom");
        LOGGER.info("###SendMessageUtil.sendMessage message");
        Map sendResult = MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
        if (Boolean.FALSE.equals(sendResult.get("success"))) {
            LOGGER.error("###SendMessageUtil.sendMessage,send result:{}", (Object)JSON.toJSONString(sendResult.get("data")));
            return false;
        }
        return true;
    }

    public static MessageDTO buildBaseMessageDTO(Long bizDataId, String templateNumber, List<Long> userIds, String nestBillNo, String msgTag) {
        MessageDTO messageDto = new MessageDTO();
        messageDto.setReceiverBosUserIds(userIds);
        messageDto.setBizDataId(bizDataId);
        messageDto.setTag(msgTag);
        messageDto.setTemplateNumber(templateNumber);
        messageDto.setNestBillNo(nestBillNo);
        messageDto.setNestBillId(bizDataId);
        return messageDto;
    }

    public static MessageDTO buildBaseMessageDTO(Long bizDataId, String templateNumber, List<Long> userIds, String nestBillNo, ILocaleString msgTag) {
        MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(bizDataId, templateNumber, userIds, nestBillNo, "");
        messageDto.setLocaleStringTag(msgTag);
        return messageDto;
    }
}

