/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.repository;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;

public class HcfRepository {
    private static final Log logger = LogFactory.getLog(HcfRepository.class);

    public static Map<String, Object> saveCandidateData(String hcfEntityName, DynamicObjectCollection collection) {
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        map.put(hcfEntityName, collection);
        ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>(1);
        list.add(map);
        return HcfRepository.saveCandidateData(list);
    }

    public static Map<String, Object> saveCandidateData(List<Map<String, DynamicObjectCollection>> candidateInfoList) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"saveOrUpdateCandidates", (Object[])new Object[]{candidateInfoList});
    }

    public static Map<Long, Map<String, Object>> deleteByIds(Set<Long> ids, String entityName) {
        logger.info(entityName + ",ids.size():" + ids.size());
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"deleteByIds", (Object[])new Object[]{ids, entityName});
    }

    public static void deleteHcfAttachedData(String entityName, List<Long> candidateIds) {
        HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"deleteRowEntity", (Object[])new Object[]{entityName, candidateIds});
    }

    public static Map<Long, Map<String, DynamicObjectCollection>> getCandidateBatch(List<Long> candidateIds, Map<String, String> entityFieldsMap) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"getCandidateBatch", (Object[])new Object[]{candidateIds, entityFieldsMap});
    }

    public static DynamicObject[] queryCandidate(String propertiesSelected, QFilter[] qFilters) {
        return HcfRepository.queryHcfAttachedData("hcf_candidate", propertiesSelected, qFilters);
    }

    public static DynamicObject[] queryHcfAttachedData(String hcfEntityName, String hcfProperties, QFilter[] qFilters) {
        if (HRStringUtils.isEmpty((String)hcfProperties)) {
            hcfProperties = "id";
        }
        try {
            Set<String> noHisTable = ServiceFactory.getService(IHomConfigDomainService.class).getConfigOfSet("no_his_table");
            if (!noHisTable.contains(hcfEntityName)) {
                List<QFilter> qFilterList = Stream.of(qFilters).collect(Collectors.toList());
                qFilterList.add(new QFilter("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus()));
                qFilterList.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
                qFilters = qFilterList.toArray(new QFilter[qFilterList.size()]);
                hcfProperties = hcfProperties + ",boid";
            }
            return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hcf", (String)"IHCFService", (String)"queryHcfAttachedData", (Object[])new Object[]{hcfEntityName, hcfProperties, qFilters});
        }
        catch (Exception exception) {
            logger.info("Cannot find method --- queryHcfAttachedData");
            logger.error((Throwable)exception);
            return new HRBaseServiceHelper(hcfEntityName).query(hcfProperties, qFilters);
        }
    }

    public static DynamicObject[] queryHcfAttachedData(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        QFilter qfilter = new QFilter("candidate", "in", candidateIds);
        return HcfRepository.queryHcfAttachedData(hcfEntityName, hcfProperties, new QFilter[]{qfilter});
    }

    public static DynamicObject[] queryHcfAttachedData(DynamicObject[] onbrdBillInfoArray, String hcfEntityName, String hcfProperties) {
        HashSet candidateIdSet = Sets.newHashSetWithExpectedSize((int)onbrdBillInfoArray.length);
        for (DynamicObject onbrdBillInfo : onbrdBillInfoArray) {
            Long candidateId = onbrdBillInfo.getLong("candidate.id");
            candidateIdSet.add(candidateId);
        }
        return HcfRepository.queryHcfAttachedData(candidateIdSet, hcfEntityName, hcfProperties);
    }

    public static Map<Long, DynamicObject> querySingleRowEntity(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        DynamicObject[] singleRowDataCollection = HcfRepository.queryHcfAttachedData(candidateIds, hcfEntityName, hcfProperties);
        return Stream.of(singleRowDataCollection).collect(Collectors.toMap(singleRowData -> singleRowData.getLong("candidate.id"), singleRowData -> singleRowData, (oldValue, newValue) -> newValue));
    }

    public static Map<Long, DynamicObjectCollection> queryMultiRowEntity(Collection<Long> candidateIds, String hcfEntityName, String hcfProperties) {
        DynamicObject[] multiRowDataCollection = HcfRepository.queryHcfAttachedData(candidateIds, hcfEntityName, hcfProperties);
        HashMap multiRowDataMap = Maps.newHashMapWithExpectedSize((int)multiRowDataCollection.length);
        for (DynamicObject multiRowData : multiRowDataCollection) {
            Long candidateId = multiRowData.getLong("candidate.id");
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)multiRowDataMap.get(candidateId);
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                dynamicObjectCollection = new DynamicObjectCollection();
            }
            dynamicObjectCollection.add((Object)multiRowData);
            multiRowDataMap.put(candidateId, dynamicObjectCollection);
        }
        return multiRowDataMap;
    }

    public static DynamicObject getAddressType(String addressTypeNumber) {
        HRBaseServiceHelper addressTypeServiceHelper = new HRBaseServiceHelper("hbss_addresstype");
        QFilter filter = new QFilter("number", "=", (Object)addressTypeNumber);
        String selectProperties = "id,number,name";
        return addressTypeServiceHelper.queryOne(selectProperties, filter);
    }

    public static DynamicObject getAddressTypeById(Long addressTypeId) {
        HRBaseServiceHelper addressTypeServiceHelper = new HRBaseServiceHelper("hbss_addresstype");
        QFilter filter = new QFilter("id", "=", (Object)addressTypeId);
        String selectProperties = "id,number,name";
        return addressTypeServiceHelper.queryOne(selectProperties, filter);
    }
}

