/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.repository.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class BrmDataRepository {
    public static final HRBaseServiceHelper SERVICE_HELPER = new HRBaseServiceHelper("brm_scene");
    private static final BrmDataRepository BOSUSER_REPOSITORY = new BrmDataRepository();

    public static BrmDataRepository getInstance() {
        return BOSUSER_REPOSITORY;
    }

    public static List<String> getSceneParams(String sceneNumber, String paramNumber) {
        ArrayList<String> params = new ArrayList<String>();
        DynamicObject scene = SERVICE_HELPER.loadDynamicObject(new QFilter("number", "=", (Object)sceneNumber));
        DynamicObjectCollection sceneInputParams = scene.getDynamicObjectCollection("sceneinputparams");
        if (CollectionUtil.isEmpty((Collection)sceneInputParams)) {
            return params;
        }
        Optional<DynamicObject> onbrd = BrmDataRepository.getOnbrdDy(sceneInputParams, paramNumber);
        if (!onbrd.isPresent()) {
            return params;
        }
        List propMapList = SerializationUtils.fromJsonStringToList((String)onbrd.get().getString("inputdynprop"), Map.class);
        if (CollectionUtil.isNotEmpty((Collection)propMapList)) {
            return propMapList.stream().map(map -> (String)map.get("Name")).collect(Collectors.toList());
        }
        return params;
    }

    public static Optional<DynamicObject> getOnbrdDy(DynamicObjectCollection sceneInputParams, String paramNumber) {
        if (CollectionUtil.isEmpty((Collection)sceneInputParams)) {
            return Optional.empty();
        }
        Optional<DynamicObject> dy = sceneInputParams.stream().filter(dynamicObject -> BrmDataRepository.checkDy(dynamicObject, paramNumber)).findFirst();
        return dy;
    }

    private static boolean checkDy(DynamicObject dy, String paramNumber) {
        boolean type = "dynamicObject".equals(dy.getString("inputparamstype"));
        if (!type || HRStringUtils.isEmpty((String)paramNumber)) {
            return false;
        }
        return paramNumber.equals(dy.getString("inputnumber"));
    }
}

