/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.repository.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;

public class HomConfigRepository {
    private static final HRBaseServiceHelper HOM_CONFIG_SERVICE_HELPER = new HRBaseServiceHelper("hom_config");

    public static String queryValueByBusinessKey(String businessKey) {
        DynamicObject query = HOM_CONFIG_SERVICE_HELPER.queryOne("businessvalue,largebusinessvalue_tag", new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        if (businessKey.contains("desensitize_field")) {
            return HRObjectUtils.isEmpty((Object)query) ? "" : query.getString("largebusinessvalue_tag");
        }
        return HRObjectUtils.isEmpty((Object)query) ? "" : query.getString("businessvalue");
    }

    public static DynamicObjectCollection queryConfigEntityByBusinessKey(String businessKey) {
        DynamicObject query = HOM_CONFIG_SERVICE_HELPER.queryOne("configentity.entitykey,configentity.entityvalue", new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        return query.getDynamicObjectCollection("configentity");
    }

    public static Map<String, String> getConfigMap(String businessKey) {
        DynamicObjectCollection configentity = HomConfigRepository.queryConfigEntityByBusinessKey(businessKey);
        if (CollectionUtil.isEmpty((Collection)configentity)) {
            return new HashMap<String, String>();
        }
        return configentity.stream().collect(Collectors.toMap(map -> map.getString("entitykey"), map -> map.getString("entityvalue"), (k1, k2) -> k1));
    }
}

