/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hom.business.application.hpfs.IPersonFileIntegrateService;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.EmpBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.common.bean.PersonBean;
import kd.sdk.hr.hpfs.business.config.repository.DevParamConfigRepository;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.service.impl.PerSaveSuccessService;
import kd.sdk.hr.hpfs.utils.HpfsSetSysAndEnddateUtils;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.PersonParamsBuilder;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;

public abstract class HPFSTemplatePropertyHandler {
    private static final Log LOGGER = LogFactory.getLog(HPFSTemplatePropertyHandler.class);
    private static final List<String> PERSON_ATTACHM_ENTENTITY = Arrays.asList("hcf_cancre", "hcf_canlgability", "hcf_canprework", "hcf_rsmpatinv", "hcf_educertificate");
    private static final List<String> PERSON_ATTACHMENT_HISENTITY = Arrays.asList("hcf_cancre", "hcf_canlgability", "hcf_canprework");
    private static final String HCF_EDUCERTIFICATE = "hcf_educertificate";

    public void saveHPFSEffectMessage(DynamicObject[] bills) {
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(bills.length);
        Arrays.stream(bills).forEach(bill -> {
            billMap.put(bill.getLong("id"), (DynamicObject)bill);
            this.setPreProperty((DynamicObject)bill);
            PerChgNewBillUtils.setEntryAndBillFields((DynamicObject)bill);
            this.setBillProperty((DynamicObject)bill);
            PerChgNewBillUtils.setEntryFields((DynamicObject)bill);
        });
        this.saveEntryFields(bills);
        List<PerChgBizInfoNew> perChgBizInfoNews = this.buildPersonParams(bills);
        HpfsSetSysAndEnddateUtils.setSysDateAndEnddate(perChgBizInfoNews);
        this.saveBatchPersonAttach(perChgBizInfoNews, billMap);
        OnbrdBillRepository.saveOnbrdBillInfos(bills);
    }

    public abstract void setPreProperty(DynamicObject var1);

    private void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews, Map<Long, DynamicObject> billMap) {
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            PerChgBizResult perChgBizResult = null;
            try (TXHandle txHandle = TX.requiresNew();){
                List depempBeanList = perChgBizInfoNew.getDepempList();
                DepempBean depempBean = (DepempBean)depempBeanList.get(depempBeanList.size() - 1);
                Long aErfileId = depempBean.getaErfileId();
                Long billId = perChgBizInfoNew.getBillId();
                LOGGER.info("IHRPIPersonGenericService.saveBatch start");
                Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericService", (String)"saveBatch", (Object[])new Object[]{perChgBizInfoNew.getPersonParams()});
                LOGGER.info("IHRPIPersonGenericService.saveBatch result:{}", (Object)result);
                Map delPersonParams = perChgBizInfoNew.getDelPersonParams();
                if (delPersonParams != null && delPersonParams.size() > 0) {
                    long eventId = ORM.create().genLongId("hrpi_event");
                    delPersonParams.put("eventId", eventId);
                    LOGGER.info("invokeDiscardBO start eventId:{}", (Object)eventId);
                    Map discardBatchResult = AttacheHandlerService.getInstance().invokeDiscardBO(delPersonParams);
                    LOGGER.info("invokeDiscardBO discardBatchResult:{}", (Object)discardBatchResult);
                    if (((Boolean)discardBatchResult.get("success")).booleanValue()) {
                        DynamicObject bill = (DynamicObject)billMap.get(billId);
                        LOGGER.info("invokeDiscardBO success billId:{} eventId:{}", (Object)billId, (Object)eventId);
                        bill.set("discardevent", (Object)eventId);
                    } else {
                        LOGGER.error("invokeDiscardBO error result:{}", (Object)SerializationUtils.toJsonString((Object)result));
                    }
                }
                perChgBizResult = new PerChgBizResult();
                perChgBizResult.setBillId(billId);
                perChgBizResult.setBillSource(perChgBizInfoNew.getBillNo());
                perChgBizResult.setErrMsg(result.get("errinfos") == null ? null : result.get("errinfos").toString());
                boolean success = (Boolean)result.get("success");
                perChgBizResult.setSuccess(Boolean.valueOf(success));
                perChgBizResult.setMsgSynActionId(perChgBizInfoNew.getChgActionId());
                perChgBizResult.setNewDepEmpId(depempBean.getaDeempId());
                List personBeans = perChgBizInfoNew.getPersonList();
                PersonBean personBean = (PersonBean)personBeans.get(personBeans.size() - 1);
                perChgBizResult.setNewPersonId(personBean.getaPersonId());
                List empList = perChgBizInfoNew.getEmpList();
                EmpBean empBean = (EmpBean)empList.get(empList.size() - 1);
                perChgBizResult.setNewEmployeeId(empBean.getaEmpId());
                perChgBizResult.setNewErfileId(aErfileId);
                perChgBizResult.setRecordId(perChgBizInfoNew.getChgRecordId());
                if (success) {
                    this.setChargePerson((PerChgBizInfoNew)perChgBizInfoNew);
                }
                new PerSaveSuccessService().doIfPerSaveSuccessOperate(perChgBizInfoNew, result);
            }
            IPersonFileIntegrateService.getInstance().updateMessageRecordToDB(Collections.singletonList(perChgBizResult));
        });
    }

    private void setChargePerson(PerChgBizInfoNew perChgBizInfoNew) {
        new PersonParamsBuilder().setChargePersonByPerChgNew(perChgBizInfoNew);
    }

    private List<PerChgBizInfoNew> buildPersonParams(DynamicObject[] bills) {
        List<PerChgBizInfoNew> perChgBizInfoNews = this.personParamsBuilder(bills);
        this.buildCustomPersonParams(perChgBizInfoNews, bills);
        return perChgBizInfoNews;
    }

    private List<PerChgBizInfoNew> personParamsBuilder(DynamicObject[] bills) {
        PersonParamsBuilder builder = new PersonParamsBuilder();
        ArrayList<PerChgBizInfoNew> allPerList = new ArrayList<PerChgBizInfoNew>();
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = new PerChgBizInfoNew();
            perChgBizInfoNew.setEffectivedate(bill.getDate("effectdate"));
            perChgBizInfoNew.setBillId(Long.valueOf(bill.getLong("id")));
            perChgBizInfoNew.setBillNo(bill.getString("billno"));
            perChgBizInfoNew.setBillSource(bill.getDataEntityType().getName());
            perChgBizInfoNew.setChgActionId(Long.valueOf(bill.getLong("affaction.id")));
            ArrayList<Map<String, Set<String>>> entityAndAttachIds = new ArrayList<Map<String, Set<String>>>();
            for (String entityName : PERSON_ATTACHM_ENTENTITY) {
                this.AddEntityAndAttachIds(entityAndAttachIds, bill.getLong("candidate.id"), entityName);
            }
            perChgBizInfoNew.setEntityAndAttachIds(entityAndAttachIds);
            allPerList.add(perChgBizInfoNew);
        });
        builder.validParamsAndBuildParams(allPerList);
        return allPerList;
    }

    private void AddEntityAndAttachIds(List<Map<String, Set<String>>> entityAndAttachIds, Long candidateId, String entityName) {
        if (candidateId == null) {
            return;
        }
        QFilter filter = new QFilter("candidate", "=", (Object)candidateId);
        if (PERSON_ATTACHMENT_HISENTITY.contains(entityName)) {
            filter.and("iscurrentversion", "=", (Object)"1");
        }
        DynamicObject[] attachEntities = RepositoryUtils.queryDynamicObjects((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter});
        if (HCF_EDUCERTIFICATE.equals(entityName)) {
            attachEntities = RepositoryUtils.queryDynamicObjects((String)"hcf_caneduexp", (String)"id", (QFilter[])new QFilter[]{filter.and("iscurrentversion", "=", (Object)"1")});
        }
        if (attachEntities == null || attachEntities.length == 0) {
            return;
        }
        Set attachEntitiesIdSet = Arrays.stream(attachEntities).map(c -> c.getString("id")).collect(Collectors.toSet());
        HashMap map = new HashMap(16);
        if (HCF_EDUCERTIFICATE.equals(entityName)) {
            QFilter edufilter = new QFilter("edu", "in", Arrays.stream(attachEntities).map(c -> c.getLong("id")).collect(Collectors.toSet()));
            DynamicObject[] eduDys = RepositoryUtils.queryDynamicObjects((String)entityName, (String)"id", (QFilter[])new QFilter[]{edufilter});
            Set eduAttachEntitiesIdSet = Arrays.stream(eduDys).map(c -> c.getString("id")).collect(Collectors.toSet());
            map.put(entityName, eduAttachEntitiesIdSet);
        } else {
            map.put(entityName, attachEntitiesIdSet);
        }
        entityAndAttachIds.add(map);
    }

    public abstract void saveEntryFields(DynamicObject[] var1);

    public abstract void setBillProperty(DynamicObject var1);

    public abstract void buildCustomPersonParams(List<PerChgBizInfoNew> var1, DynamicObject[] var2);

    public static boolean isNewChgAction(String devConfigKey) {
        DynamicObject dynamicObject = DevParamConfigRepository.queryConfigByBusinessKey((String)devConfigKey);
        boolean isNewChgAction = false;
        if (dynamicObject != null) {
            isNewChgAction = dynamicObject.getBoolean("businessvalue");
        }
        return isNewChgAction;
    }
}

