/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.handler;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hom.business.onbrd.INewPerChgBizParam;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.utils.ChgActionUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HomHPFSTemplatePropertyHandler
extends HPFSTemplatePropertyHandler {
    private static final Log LOGGER = LogFactory.getLog(HomHPFSTemplatePropertyHandler.class);
    private static final HomHPFSTemplatePropertyHandler handler = new HomHPFSTemplatePropertyHandler();
    private static final String[] CUSTOM_PARAM_ENTITY_NUMBERS = new String[]{"hrpi_cmpemp", "hrpi_managingscope", "hrpi_baselocation", "hrpi_empjobrel", "hrpi_contrworkloc", "hrpi_workcalenrel", "hrpi_emptutor", "hrpi_empcadre", "hrpi_trialperiod", "hrpi_trialperiodrst"};
    private static final String[] CMPEMP_PARAM_ENTITY_NUMBERS = new String[]{"hspm_ermanfile", "hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall"};

    private HomHPFSTemplatePropertyHandler() {
    }

    public static HomHPFSTemplatePropertyHandler getInstance() {
        return handler;
    }

    @Override
    public void setPreProperty(DynamicObject dy) {
        if (HRStringUtils.equals((String)dy.getString("viewtype"), (String)"2")) {
            long personfieldId = dy.getDynamicObject("personfield").getLong("person.id");
            DynamicObject erManFile = this.getErManFile(personfieldId);
            dy.set("b_ermanfile", (Object)erManFile);
            dy.set("bb_p_tid", (Object)personfieldId);
            dy.set("bb_p_chgtype", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        } else {
            dy.set("bb_p_chgtype", null);
        }
        dy.set("b_effectivedate", dy.get("effectdate"));
        dy.set("ba_e_candidateid", dy.get("candidate.id"));
    }

    private DynamicObject getErManFile(Long personId) {
        DynamicObject dy = IHrmpExternalService.getInstance().getQuitErManFile(personId);
        if (dy == null) {
            throw new KDBizException("sync person error , getErManFile size is zero!  ");
        }
        return dy;
    }

    @Override
    public void saveEntryFields(DynamicObject[] dys) {
        OnbrdBillRepository.saveOnbrdBillInfos(dys);
    }

    @Override
    public void setBillProperty(DynamicObject dy) {
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashMap perChgBizInfoNewMap = Maps.newHashMapWithExpectedSize((int)perChgBizInfoNews.size());
        for (PerChgBizInfoNew perChgBizInfoNew : perChgBizInfoNews) {
            if (!perChgBizInfoNew.isSuccess()) {
                throw new KDBizException(perChgBizInfoNew.getErrMsg());
            }
            perChgBizInfoNewMap.put(perChgBizInfoNew.getBillId(), perChgBizInfoNew);
        }
        this.setCustomPersonParams(bills, perChgBizInfoNewMap);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, INewPerChgBizParam.class, (String)"kd.sdk.hr.hom.business.onbrd.INewPerChgBizParam", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setCustomPersonParams(bills, perChgBizInfoNewMap);
            return null;
        });
    }

    private void setCustomPersonParams(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            List hspmErmanfiles;
            List hrpiEmployees;
            List hrpiEmpEntrels;
            List hrpiEmpposorgrels;
            List pernontsprops;
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            this.setPrimaryForEmpposrel(perChgBizInfoNew);
            Map entityRecord = perChgBizInfoNew.getEntityRecord();
            List hrpiPersons = (List)entityRecord.get("hrpi_person");
            if (CollectionUtils.isNotEmpty((Collection)hrpiPersons)) {
                hrpiPersons.forEach(p -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(p.getChgMode())) {
                        DynamicObject personDataDy = p.getDataDy();
                        personDataDy.set("name", (Object)bill.getString("name"));
                        personDataDy.set("headsculpture", (Object)bill.getString("picturefield"));
                        if (HRStringUtils.equals((String)bill.getString("viewtype"), (String)"2")) {
                            personDataDy.set("personindexid", (Object)bill.getLong("personindexid"));
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(pernontsprops = (List)entityRecord.get("hrpi_pernontsprop")))) {
                pernontsprops.forEach(p -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(p.getChgMode())) {
                        p.getDataDy().set("name", (Object)bill.getString("name"));
                        p.getDataDy().set("headsculpture", (Object)bill.getString("picturefield"));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(hrpiEmpposorgrels = (List)entityRecord.get("hrpi_empposorgrel")))) {
                hrpiEmpposorgrels.forEach(h -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(h.getChgMode())) {
                        h.getDataDy().set("apositiontype", bill.get("apositiontype"));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(hrpiEmpEntrels = (List)entityRecord.get("hrpi_empentrel")))) {
                hrpiEmpEntrels.forEach(h -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(h.getChgMode())) {
                        DynamicObject empEntrels = h.getDataDy();
                        empEntrels.set("isprobation", (Object)bill.getBoolean("isprobation"));
                        empEntrels.set("preemployee", bill.get("personfield"));
                        empEntrels.set("oldempnumber", bill.get("oemployeeno"));
                        empEntrels.set("firststartdate", bill.get("firstemtstartdate"));
                        empEntrels.set("labrelstatusprd", bill.get("laborrelstatus.labrelstatusprd"));
                        empEntrels.set("candidate", bill.get("candidate"));
                        empEntrels.set("serviceagescheme", bill.get("serviceagescheme"));
                        empEntrels.set("mid", bill.get("mid"));
                        empEntrels.set("inheritnumber", bill.get("employeenoscheme"));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(hrpiEmployees = (List)entityRecord.get("hrpi_employee")))) {
                hrpiEmployees.forEach(e -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(e.getChgMode())) {
                        DynamicObject employee = e.getDataDy();
                        employee.set("mid", bill.get("mid"));
                        employee.set("candidate", bill.get("candidate"));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(hspmErmanfiles = (List)entityRecord.get("hspm_ermanfile")))) {
                hspmErmanfiles.forEach(h -> {
                    if (ChgModeEnum.ADD_NEW.getChgMode().equals(h.getChgMode())) {
                        DynamicObject ermanfile = h.getDataDy();
                        ermanfile.set("name", (Object)bill.getString("name"));
                        ermanfile.set("dependency", (Object)bill.getDynamicObject("dependency"));
                        ermanfile.set("dependencytype", (Object)bill.getDynamicObject("dependencytype"));
                        ermanfile.set("hbsscmpemp", (Object)bill.getDynamicObject("managementscope"));
                    }
                });
            }
        });
        this.setCadreInfo(bills, perChgBizInfoNewMap);
        List chgActionIds = perChgBizInfoNewMap.values().stream().map(PerChgBizInfoNew::getChgActionId).collect(Collectors.toList());
        Map actionTypeMap = ChgActionUtils.getChgCategoryActionType(chgActionIds);
        this.setCmpEmp(bills, perChgBizInfoNewMap, actionTypeMap);
        this.setBaseLocation(bills, perChgBizInfoNewMap);
        this.setWorkCalendar(bills, perChgBizInfoNewMap);
        this.setJobInfo(bills, perChgBizInfoNewMap, actionTypeMap);
        this.setProbationtimeBaseInfo(bills, perChgBizInfoNewMap);
        this.setProbationtimeRegResult(bills, perChgBizInfoNewMap);
        this.setContractLocation(bills, perChgBizInfoNewMap);
        this.setTeacherInfo(bills, perChgBizInfoNewMap);
        this.setServiceTime(bills, perChgBizInfoNewMap);
        perChgBizInfoNewMap.values().forEach(perChgBizInfoNew -> {
            LOGGER.info("setCustomPersonParams_CUSTOM_PARAM_ENTITY_NUMBERS:{}", (Object[])CUSTOM_PARAM_ENTITY_NUMBERS);
            this.setPersonParams((PerChgBizInfoNew)perChgBizInfoNew, CUSTOM_PARAM_ENTITY_NUMBERS);
        });
    }

    private void setProbationtimeBaseInfo(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            if (bill.getBoolean("isprobation")) {
                DynamicObject newProbationtimeBaseInfo = this.createProbationtimeBaseInfo(perChgBizInfoNew, (DynamicObject)bill);
                HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newProbationtimeBaseInfo);
                ChgRecordHelper.addChgIdRecord((String)"hrpi_trialperiod", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newProbationtimeBaseInfo.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newProbationtimeBaseInfo);
            } else {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_trialperiod");
            }
        });
    }

    private DynamicObject createProbationtimeBaseInfo(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject probationtimeBaseInfo = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_trialperiod");
        probationtimeBaseInfo.set("probationunit", bill.get("perprobationtime"));
        probationtimeBaseInfo.set("preregulardate", (Object)bill.getDate("transdate"));
        probationtimeBaseInfo.set("probation", bill.get("probationtime"));
        probationtimeBaseInfo.set("enddate", (Object)bill.getDate("transdate"));
        probationtimeBaseInfo.set("entrydate", (Object)bill.getDate("effectdate"));
        if (Boolean.TRUE.equals(bill.getBoolean("isprobation"))) {
            probationtimeBaseInfo.set("regstatus", (Object)"1010");
        }
        return probationtimeBaseInfo;
    }

    private void setProbationtimeRegResult(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            DynamicObject newProbationtimeRegResult = this.createProbationtimeRegResult(perChgBizInfoNew, (DynamicObject)bill);
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newProbationtimeRegResult);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_trialperiodrst", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newProbationtimeRegResult.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newProbationtimeRegResult);
        });
    }

    private DynamicObject createProbationtimeRegResult(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        return this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_trialperiodrst");
    }

    private void setContractLocation(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            DynamicObject newContractlocation = this.createContractLocation(perChgBizInfoNew, (DynamicObject)bill);
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newContractlocation);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_contrworkloc", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newContractlocation.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newContractlocation);
        });
    }

    private DynamicObject createContractLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject contractLocation = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_contrworkloc");
        contractLocation.set("agreedlocation", bill.get("contractlocation"));
        return contractLocation;
    }

    private void setTeacherInfo(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            if (ObjectUtils.isEmpty((Object)bill.getDynamicObject("teacher"))) {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_emptutor");
                return;
            }
            DynamicObject newTeacherInfo = this.createTeacherInfo(perChgBizInfoNew, (DynamicObject)bill);
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newTeacherInfo);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_emptutor", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newTeacherInfo.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newTeacherInfo);
        });
    }

    private DynamicObject createTeacherInfo(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject dataEntity = ChgRecordHelper.createDynamicObject((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_emptutor");
        dataEntity.set("createtime", (Object)bill.getDate("effectdate"));
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("datastatus", (Object)"1");
        dataEntity.set("tutor", bill.get("teacher"));
        return dataEntity;
    }

    private void setServiceTime(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            List serviceLengths = (List)perChgBizInfoNew.getEntityRecord().get("hrpi_perserlen");
            if (null == serviceLengths || serviceLengths.size() == 0) {
                DynamicObject newServiceTime = this.createServiceTime((DynamicObject)bill);
                HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newServiceTime);
                ChgRecordHelper.addChgIdRecord((String)"hrpi_perserlen", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newServiceTime.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newServiceTime);
            } else {
                DynamicObject serviceLength = ((ChgRecordEntryDto)serviceLengths.get(0)).getDataDy();
                this.fillFieldServiceTime((DynamicObject)bill, serviceLength);
            }
        });
    }

    private DynamicObject fillFieldServiceTime(DynamicObject bill, DynamicObject serviceLength) {
        long id = ORM.create().genLongId("hrpi_perserlen");
        serviceLength.set("id", (Object)id);
        serviceLength.set("createtime", (Object)bill.getDate("effectdate"));
        serviceLength.set("initstatus", (Object)"2");
        serviceLength.set("businessstatus", (Object)"1");
        serviceLength.set("datastatus", (Object)"1");
        DynamicObject candidate = bill.getDynamicObject("candidate");
        HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("hcf_canbaseinfo");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidate.getLong("id"));
        DynamicObject candidateInfo = appServiceHelper.loadDynamicObject(qFilter);
        serviceLength.set("joinworktime", (Object)candidateInfo.getDate("beginservicedate"));
        serviceLength.set("joincomdate", (Object)bill.getDate("effectdate"));
        if (HRStringUtils.equals((String)bill.getString("viewtype"), (String)"2")) {
            QFilter cfilter = new QFilter("employee", "=", (Object)bill.getLong("mid"));
            cfilter.and("iscurrentversion", "=", (Object)"1");
            cfilter.and("datastatus", "=", (Object)"1");
            DynamicObject[] serviceTimes = RepositoryUtils.queryDynamicObjects((String)"hrpi_perserlen", (String)"id,person,employee,firstjoincomdate", (QFilter[])new QFilter[]{cfilter});
            if (serviceTimes.length > 0) {
                serviceLength.set("firstjoincomdate", (Object)serviceTimes[0].getDate("firstjoincomdate"));
            }
        } else {
            serviceLength.set("firstjoincomdate", (Object)bill.getDate("effectdate"));
        }
        return serviceLength;
    }

    private DynamicObject createServiceTime(DynamicObject bill) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hrpi_perserlen");
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)dataEntityType, null);
        long id = ORM.create().genLongId("hrpi_perserlen");
        dataEntity.set("id", (Object)id);
        dataEntity.set("createtime", (Object)bill.getDate("effectdate"));
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("businessstatus", (Object)"1");
        dataEntity.set("datastatus", (Object)"1");
        DynamicObject candidate = bill.getDynamicObject("candidate");
        HRBaseServiceHelper appServiceHelper = new HRBaseServiceHelper("hcf_canbaseinfo");
        QFilter qFilter = new QFilter("candidate", "=", (Object)candidate.getLong("id"));
        DynamicObject candidateInfo = appServiceHelper.loadDynamicObject(qFilter);
        dataEntity.set("joinworktime", (Object)candidateInfo.getDate("beginservicedate"));
        dataEntity.set("joincomdate", (Object)bill.getDate("effectdate"));
        if (HRStringUtils.equals((String)bill.getString("viewtype"), (String)"2")) {
            QFilter cfilter = new QFilter("employee", "=", (Object)bill.getLong("mid"));
            cfilter.and("iscurrentversion", "=", (Object)"1");
            cfilter.and("datastatus", "=", (Object)"1");
            DynamicObject[] serviceTimes = RepositoryUtils.queryDynamicObjects((String)"hrpi_perserlen", (String)"id,person,employee,firstjoincomdate", (QFilter[])new QFilter[]{cfilter});
            if (serviceTimes.length > 0) {
                dataEntity.set("firstjoincomdate", (Object)serviceTimes[0].getDate("firstjoincomdate"));
            }
        } else {
            dataEntity.set("firstjoincomdate", (Object)bill.getDate("effectdate"));
        }
        return dataEntity;
    }

    private void setJobInfo(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap, Map<Long, DynamicObject> actionTypeMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            if (bill.getDynamicObject("ajoblevel") != null || bill.getDynamicObject("ajobgrade") != null) {
                DynamicObject newJobInfo = this.createJobInfo(perChgBizInfoNew, (DynamicObject)bill);
                DynamicObject chgActionDy = perChgBizInfoNew.getChgActionDy();
                if (actionTypeMap != null && !actionTypeMap.isEmpty()) {
                    newJobInfo.set("variationtype", actionTypeMap.get(chgActionDy.getLong("id")));
                }
                HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newJobInfo);
                ChgRecordHelper.addChgIdRecord((String)"hrpi_empjobrel", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newJobInfo.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newJobInfo);
            } else {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_empjobrel");
            }
        });
    }

    private DynamicObject createJobInfo(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject jobInfo = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_empjobrel");
        jobInfo.set("adminorg", (Object)bill.getDynamicObject("aadminorg"));
        jobInfo.set("jobclass", (Object)bill.getDynamicObject("jobclass"));
        jobInfo.set("joblevel", (Object)bill.getDynamicObject("ajoblevel"));
        jobInfo.set("jobscm", (Object)bill.getDynamicObject("ajobscm"));
        DynamicObject hrbu = bill.getDynamicObject("hrbu");
        if (HRObjectUtils.isEmpty((Object)hrbu)) {
            DynamicObject position;
            String positionType = bill.getString("apositiontype");
            if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(positionType)) {
                position = bill.getDynamicObject("aposition");
                hrbu = position.getDynamicObject("org");
            }
            if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(positionType)) {
                position = bill.getDynamicObject("stdposition");
                hrbu = position.getDynamicObject("createorg");
            }
        }
        jobInfo.set("hrbu", (Object)hrbu);
        jobInfo.set("jobseq", (Object)bill.getDynamicObject("jobseq"));
        jobInfo.set("jobgradescm", (Object)bill.getDynamicObject("jobgradescm"));
        jobInfo.set("jobgrade", (Object)bill.getDynamicObject("ajobgrade"));
        jobInfo.set("jobfamily", (Object)bill.getDynamicObject("jobfamily"));
        jobInfo.set("joblevelscm", (Object)bill.getDynamicObject("joblevelscm"));
        jobInfo.set("company", (Object)bill.getDynamicObject("acompany"));
        jobInfo.set("position", (Object)bill.getDynamicObject("aposition"));
        jobInfo.set("job", (Object)bill.getDynamicObject("ajob"));
        return jobInfo;
    }

    private void setWorkCalendar(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            DynamicObject newWorkCalendar = this.createWorkCalendar(perChgBizInfoNew, (DynamicObject)bill);
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newWorkCalendar);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_workcalenrel", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newWorkCalendar.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newWorkCalendar);
        });
    }

    private DynamicObject createWorkCalendar(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject workCalendar = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_workcalenrel");
        workCalendar.set("ismainwork", (Object)"1");
        workCalendar.set("workcalendar", (Object)bill.getDynamicObject("workcalendar"));
        return workCalendar;
    }

    private void setCadreInfo(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            if (ObjectUtils.isEmpty((Object)bill.getBoolean("iscadre"))) {
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_empcadre");
                return;
            }
            if (bill.getBoolean("iscadre")) {
                DynamicObject newCadreInfo = this.createCadreInfo(perChgBizInfoNew, (DynamicObject)bill);
                HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newCadreInfo);
                ChgRecordHelper.addChgIdRecord((String)"hrpi_empcadre", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newCadreInfo.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newCadreInfo);
            }
        });
    }

    private DynamicObject createCadreInfo(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject cadreInfo = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_empcadre");
        cadreInfo.set("iscadre", (Object)bill.getBoolean("iscadre"));
        cadreInfo.set("cadretype", bill.get("cadretype"));
        return cadreInfo;
    }

    private void setPersonParams(PerChgBizInfoNew perChgBizInfoNew, String[] entityNumbers) {
        List data = (List)perChgBizInfoNew.getPersonParams().get("data");
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        Arrays.stream(entityNumbers).forEach(entityNumber -> {
            List chgRecordEntryList = (List)entityRecordMap.get(entityNumber);
            if (HRCollUtil.isNotEmpty((Collection)chgRecordEntryList)) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)chgRecordEntryList.size());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
                chgRecordEntryList.forEach(chgRecordEntry -> dynamicObjects.add((Object)chgRecordEntry.getDataDy()));
                map.put("hisDyns", dynamicObjects);
                data.add(map);
            }
        });
    }

    private void setPrimaryForEmpposrel(PerChgBizInfoNew perChgBizInfoNew) {
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        List chgRecordEntryList = (List)entityRecordMap.get("hrpi_empposorgrel");
        if (HRCollUtil.isNotEmpty((Collection)chgRecordEntryList)) {
            chgRecordEntryList.forEach(chgRecordEntry -> {
                if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntry.getChgMode())) {
                    chgRecordEntry.getDataDy().set("isprimary", (Object)"1");
                }
            });
        }
    }

    private void setCmpEmp(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap, Map<Long, DynamicObject> actionTypeMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            DynamicObject newManagingScope = this.createManagingScope(perChgBizInfoNew, (DynamicObject)bill);
            DynamicObject chgActionDy = perChgBizInfoNew.getChgActionDy();
            if (actionTypeMap != null && !actionTypeMap.isEmpty()) {
                newManagingScope.set("variationtype", actionTypeMap.get(chgActionDy.getLong("id")));
            }
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newManagingScope);
            DynamicObject newCmpEmp = this.createCmpEmp(perChgBizInfoNew, newManagingScope, (DynamicObject)bill);
            newManagingScope.set("cmpemp", (Object)newCmpEmp);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_managingscope", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newManagingScope.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newManagingScope);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_cmpemp", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newCmpEmp.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newCmpEmp);
            Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
            this.updateCmpEmp(CMPEMP_PARAM_ENTITY_NUMBERS, newCmpEmp, entityRecordMap);
        });
    }

    private void updateCmpEmp(String[] entityNames, DynamicObject newCmpEmp, Map<String, List<ChgRecordEntryDto>> entityRecordMap) {
        Arrays.stream(entityNames).forEach(entityName -> {
            LOGGER.info("###HomHPFSTemplatePropertyHandler.updateCmpEmp, entityName:{}", entityName);
            List chgRecordEntryDTOs = (List)entityRecordMap.get(entityName);
            LOGGER.info("###HomHPFSTemplatePropertyHandler.updateCmpEmp, chgRecordEntryDTOs is null? :{}", (Object)HRCollUtil.isEmpty((Collection)chgRecordEntryDTOs));
            Optional<ChgRecordEntryDto> optional = chgRecordEntryDTOs.stream().filter(chgRecordEntryDTO -> ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntryDTO.getChgMode())).findFirst();
            optional.ifPresent(chgRecordEntryDto -> chgRecordEntryDto.getDataDy().set("cmpemp", (Object)newCmpEmp));
        });
    }

    private DynamicObject createDynamicObject(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, String entityNumber) {
        DynamicObject dataEntity = ChgRecordHelper.createDynamicObject((PerChgBizInfoNew)perChgBizInfoNew, (String)entityNumber);
        dataEntity.set("startdate", (Object)bill.getDate("effectdate"));
        dataEntity.set("bsed", (Object)bill.getDate("effectdate"));
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"person")) {
            dataEntity.set("person_id", bill.get("ba_p_tid"));
        }
        if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"employee")) {
            dataEntity.set("employee_id", bill.get("ba_e_tid"));
        }
        dataEntity.set("bsled", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dataEntity.set("enddate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        dataEntity.set("businessstatus", (Object)"1");
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("datastatus", (Object)"1");
        return dataEntity;
    }

    private DynamicObject createManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject managingScope = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_managingscope");
        managingScope.set("managingscope", (Object)bill.getDynamicObject("managementscope"));
        managingScope.set("workplace", (Object)bill.getDynamicObject("baselocation"));
        managingScope.set("cmpemp_id", (Object)ORM.create().genLongId("hrpi_cmpemp"));
        managingScope.set("isprimaryscope", (Object)Character.valueOf('1'));
        managingScope.set("lastworkdate", (Object)DateUtils.stringToDate((String)"2999-12-31", (DatePattern)DatePattern.YYYY_MM_DD));
        return managingScope;
    }

    private DynamicObject createLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject location = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_baselocation");
        location.set("location", (Object)bill.getDynamicObject("baselocation"));
        return location;
    }

    private DynamicObject createCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject managingScope, DynamicObject bill) {
        DynamicObject cmpEmp = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_cmpemp");
        cmpEmp.set("id", (Object)managingScope.getLong("cmpemp_id"));
        cmpEmp.set("managingscope", (Object)managingScope.getDynamicObject("managingscope"));
        cmpEmp.set("person", managingScope.get("person"));
        cmpEmp.set("employee", managingScope.get("employee"));
        cmpEmp.set("isprimaryscope", (Object)Character.valueOf('1'));
        cmpEmp.set("company", (Object)bill.getDynamicObject("acompany"));
        return cmpEmp;
    }

    private void setBaseLocation(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        Arrays.stream(bills).forEach(bill -> {
            PerChgBizInfoNew perChgBizInfoNew = (PerChgBizInfoNew)perChgBizInfoNewMap.get(bill.getLong("id"));
            DynamicObject newLocation = this.createLocation(perChgBizInfoNew, (DynamicObject)bill);
            HPFSNewChgHelper.setIdFromCache((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)newLocation);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_baselocation", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newLocation.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newLocation);
        });
    }
}

