/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.activity;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.activity.ActivityNum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.ActivityinsTaskSwitchEnum;
import kd.sdk.hr.hom.business.activity.IActivityDomainService;

public class ActivityCommonInfoServiceImpl
implements IActivityCommonInfoService {
    private static final Log LOGGER = LogFactory.getLog(ActivityCommonInfoServiceImpl.class);
    static final HRBaseServiceHelper BASE_SERVICE_HELPER = new HRBaseServiceHelper("hom_activeinfobody");
    static final String ENTRY_ID = "id";
    private static ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"ActivityCommonInfoServiceImpl", (int)30);
    private static final String TRANSFER_SELECT_FIELDS = "id,activityins,activity,onbrdid,finishdate,modifier,modifytime";
    static Map<String, String> tipsMap = new HashMap<String, String>();

    @Override
    public DynamicObject getActivityDetail(Long entryId) {
        return BASE_SERVICE_HELPER.loadSingle((Object)entryId);
    }

    @Override
    public void updateDataOne(DynamicObject dynamicObject) {
        BASE_SERVICE_HELPER.updateDataOne(dynamicObject);
    }

    @Override
    public void updateDatas(DynamicObject[] dynamicObjects) {
        BASE_SERVICE_HELPER.updateDatas(dynamicObjects);
    }

    @Override
    public void showTransfer(IFormView view, IFormPlugin plugin, String callBackKey, String entryId) {
        AtomicReference<Boolean> isList = new AtomicReference<Boolean>();
        isList.set(Boolean.FALSE);
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<String> expectStatus = new ArrayList<String>();
        String page = this.setPageInfo(view, isList, expectStatus, activityIds);
        Boolean checkHandler = ActivityNum.HANDLE_PAGE.contains(page);
        if (activityIds.isEmpty()) {
            return;
        }
        Map<String, Object> checkMap = this.activityCheck(activityIds, expectStatus, checkHandler);
        boolean isSuccess = Boolean.TRUE.equals(checkMap.get("IS_SUCCESS"));
        boolean statusSuccess = Boolean.TRUE.equals(checkMap.get("NO_ACCEPTED_HANDLER"));
        if (isSuccess || !checkHandler.booleanValue() && statusSuccess) {
            if (!this.isRequire(view, isList.get())) {
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(entryId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack(plugin, callBackKey));
            view.showForm(showParameter);
            return;
        }
        String operationName = ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"ActivityCommonInfoServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]);
        String errorMsg = this.getFailTipMsg(checkMap, operationName, isList.get(), checkHandler);
        view.showErrorNotification(errorMsg);
        view.invokeOperation("refresh");
    }

    private boolean isRequire(IFormView view, boolean isList) {
        if (isList) {
            IListView listView = (IListView)view;
            String opName = ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"ActivityCommonInfoServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]);
            return this.getBatchLock(listView, opName);
        }
        return this.require(view, "hom_collaborationdetail", "donothing_tran");
    }

    @Override
    public boolean getBatchLock(IListView listView, String opName) {
        ListSelectedRowCollection selectRows = listView.getSelectedRows();
        if (selectRows == null || selectRows.size() == 0) {
            return false;
        }
        List<Long> ids = selectRows.stream().map(selRow -> Long.valueOf(selRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        Map<Long, Boolean> batchRequireResult = IHomDataMutexService.getInstance().batchRequire(ids, "hom_collaborationdetail", "donothing_tran", true);
        List<Long> failLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
        List<Long> successLockIds = batchRequireResult.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (Long)entry.getKey()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(failLockIds)) {
            IHomDataMutexService.getInstance().batchRelease(successLockIds, "hom_collaborationdetail", "donothing_tran");
            String msg = this.getLockMsg(failLockIds, opName);
            listView.showTipNotification(msg);
            return false;
        }
        return true;
    }

    private String getLockMsg(List<Long> ids, String opName) {
        DynamicObject[] dynamicObjects = this.getActivityInfo(ids);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u88ab\u7f16\u8f91\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ActivityCommonInfoServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        StringBuilder nameStr = new StringBuilder();
        Arrays.stream(dynamicObjects).filter(dy -> dy.get("onbrdid") != null).forEach(dy -> nameStr.append(dy.getString("onbrdid.name")).append(','));
        nameStr.deleteCharAt(nameStr.length() - 1);
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u7684\u6570\u636e\u6b63\u5728\u88ab\u5904\u7406\uff0c\u65e0\u6cd5\u6267\u884c\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"ActivityCommonInfoServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]), nameStr.toString(), opName);
    }

    @Override
    public boolean require(IFormView view, String entityName, String operKey) {
        return IHomDataMutexService.getInstance().requireLock(String.valueOf(this.getActivityId(view)), entityName, view, operKey, true, "1");
    }

    @Override
    public Long getActivityId(IFormView view) {
        Object entryId = view.getFormShowParameter().getCustomParam("cooperationId");
        if (entryId == null) {
            entryId = ((BillShowParameter)view.getFormShowParameter()).getPkId();
        }
        return HRJSONUtils.getLongValOfCustomParam((Object)entryId);
    }

    @Override
    public Long getId(IFormView view) {
        Object pkId = view.getFormShowParameter().getCustomParam(ENTRY_ID);
        if (pkId == null) {
            pkId = ((BillShowParameter)view.getFormShowParameter()).getPkId();
        }
        return HRJSONUtils.getLongValOfCustomParam((Object)pkId);
    }

    @Override
    public void linkLoad(IFormView formView, String entryId, Long cooperationId) {
        BaseShowParameter showParameter = new BaseShowParameter();
        DynamicObject onbrdDyObj = ICooperationManageService.getInstance().queryCooperationById("id,onbrdid,activity.name", cooperationId);
        String name = onbrdDyObj.getString("onbrdid.name");
        String activityName = onbrdDyObj.getString("activity.name");
        showParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"{0}-{1}", (String)"ActivityCommonInfoServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), activityName, name));
        showParameter.setFormId(entryId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)cooperationId);
        showParameter.setCustomParam("cooperationId", (Object)cooperationId);
        StringBuilder pageId = new StringBuilder();
        pageId.append(formView.getParentView().getPageId()).append(entryId).append('_').append("hom").append('_').append(cooperationId);
        showParameter.setPageId(pageId.toString());
        formView.showForm((FormShowParameter)showParameter);
    }

    @Override
    public Map<String, Object> activityCheck(List<Long> activityBodyIds, List<String> expectStatus, Boolean checkHandler) {
        Object[] dynamicObjects = this.getActivityInfo(activityBodyIds);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return map;
        }
        HashSet set = new HashSet();
        ArrayList linkSscTaskActivityIds = new ArrayList();
        AtomicReference<Boolean> handlerIsChange = new AtomicReference<Boolean>();
        handlerIsChange.set(Boolean.FALSE);
        Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
            DynamicObject activityIns;
            if (!this.checkInfo((DynamicObject)dynamicObject, expectStatus, set).booleanValue() && checkHandler.booleanValue()) {
                handlerIsChange.set(Boolean.TRUE);
            }
            if ((activityIns = dynamicObject.getDynamicObject("activityins")).containsProperty("taskswitch") && ActivityinsTaskSwitchEnum.STR_THREE.getValue().equals(activityIns.getString("taskswitch"))) {
                linkSscTaskActivityIds.add(dynamicObject.getLong(ENTRY_ID));
            }
        });
        map.put("IS_SUCCESS", Boolean.TRUE);
        if (!CollectionUtils.isEmpty(set) || ((Boolean)handlerIsChange.get()).booleanValue() || !HRCollUtil.isEmpty(linkSscTaskActivityIds)) {
            map.put("IS_SUCCESS", Boolean.FALSE);
        }
        map.put("NO_ACCEPTED_STATUS", set);
        map.put("NO_ACCEPTED_HANDLER", handlerIsChange.get());
        map.put("LINK_SSC_ACTIVITY_IDS", linkSscTaskActivityIds);
        return map;
    }

    public String getFailTipMsg(Map<String, Object> map, String operationName, Boolean isList, Boolean checkHandler) {
        Set status;
        if (Objects.isNull(map)) {
            return "Fail";
        }
        Boolean has_no_accepted_handler = Objects.nonNull(map.get("NO_ACCEPTED_HANDLER")) && (Boolean)map.get("NO_ACCEPTED_HANDLER") != false;
        if (has_no_accepted_handler.booleanValue() && checkHandler.booleanValue()) {
            return ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u4eba\u5df2\u7ecf\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u91cd\u8bd5\u3002", (String)"ActivityCommonInfoServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Set set = status = Objects.isNull(map.get("NO_ACCEPTED_STATUS")) ? null : (Set)map.get("NO_ACCEPTED_STATUS");
        if (null != status && !HRCollUtil.isEmpty((Collection)status)) {
            status.forEach(str -> stringBuilder.append(tipsMap.get(str)));
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (!CollectionUtils.isEmpty((Collection)status) && Boolean.TRUE.equals(isList)) {
            return MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301{0}{1}\u7684\u6d3b\u52a8\uff0c\u8bf7\u91cd\u9009\u52fe\u9009", (String)"ActivityCommonInfoServiceImpl_9", (String)"hr-hom-business", (Object[])new Object[0]), operationName, stringBuilder.toString());
        }
        if (!CollectionUtils.isEmpty((Collection)status) && Boolean.FALSE.equals(isList)) {
            return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6d3b\u52a8\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u3002", (String)"ActivityCommonInfoServiceImpl_10", (String)"hr-hom-business", (Object[])new Object[0]), operationName, stringBuilder);
        }
        if (!HRCollUtil.isEmpty((Collection)((List)map.get("LINK_SSC_ACTIVITY_IDS")))) {
            return ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u5df2\u8fdb\u5165HR\u5171\u4eab\u4e2d\u5fc3\u5904\u7406\uff0c\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\uff0c\u5982\u6709\u9700\u8981\u8bf7\u8054\u7cfbHR\u5171\u4eab\u4e2d\u5fc3\u7ba1\u7406\u5458\u3002", (String)"ActivityCommonInfoServiceImpl_20", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff01", (String)"ActivityCommonInfoServiceImpl_11", (String)"hr-hom-business", (Object[])new Object[0]);
    }

    @Override
    public DynamicObject[] getActivityInfo(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            LOGGER.info("getActivityInfo_is_null");
            return null;
        }
        QFilter filter = new QFilter(ENTRY_ID, "in", ids);
        DynamicObject[] dynamicObjects = BASE_SERVICE_HELPER.query(TRANSFER_SELECT_FIELDS, new QFilter[]{filter});
        return dynamicObjects;
    }

    private Boolean checkInfo(DynamicObject dy, List<String> expectStatus, Set<String> set) {
        DynamicObjectCollection collection;
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject dynamicObject = dy.getDynamicObject("activityins");
        if (Objects.isNull(dynamicObject)) {
            LOGGER.info("checkInfo_activityins_is_null");
            throw new KDBizException(ResManager.loadKDString((String)"\u6d3b\u52a8\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ActivityCommonInfoServiceImpl_12", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        String status = dynamicObject.getString("taskstatus");
        if (!CollectionUtils.isEmpty(expectStatus) && !expectStatus.contains(status)) {
            set.add(status);
        }
        if ((collection = dynamicObject.getDynamicObjectCollection("handlers")) == null || collection.size() == 0) {
            return Boolean.FALSE;
        }
        if (collection.stream().anyMatch(userDy -> userId.compareTo(userDy.getLong("fbasedataid.id")) == 0)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Map<String, Object> transferTask(IFormView view, String operationName, List<Long> activityBodyIds, List<String> expectStatus, List<Long> transferUserIds, String remakes, Boolean checkHandler) {
        if (transferUserIds == null || transferUserIds.size() == 0) {
            LOGGER.error("transferTask_transfer_is_null");
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u4ea4\u7ed9 \u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ActivityCommonInfoServiceImpl_17", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        LOGGER.info("handleTransfer_transferTask_start");
        Map<String, Object> checkMap = this.activityCheck(activityBodyIds, expectStatus, checkHandler);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Boolean is_success = Objects.isNull(checkMap.get("IS_SUCCESS")) ? Boolean.FALSE : (Boolean)checkMap.get("IS_SUCCESS");
        Boolean status_success = Objects.isNull(checkMap.get("NO_ACCEPTED_HANDLER")) ? Boolean.FALSE : (Boolean)checkMap.get("NO_ACCEPTED_HANDLER");
        LOGGER.info("handleTransfer_transferTask_end");
        if (!(is_success.booleanValue() || !checkHandler.booleanValue() && status_success.booleanValue())) {
            Boolean isList = view instanceof IListView ? Boolean.TRUE : Boolean.FALSE;
            String errorMsg = this.getFailTipMsg(checkMap, operationName, isList, checkHandler);
            resultMap.put("IS_SUCCESS", Boolean.FALSE);
            resultMap.put("MSG", errorMsg);
            return resultMap;
        }
        try {
            if (checkHandler.booleanValue()) {
                this.asynDealTransfer(view, activityBodyIds, transferUserIds, remakes);
            } else {
                this.asynBatchAssignTask(view, activityBodyIds, transferUserIds, remakes);
            }
            resultMap.put("IS_SUCCESS", Boolean.TRUE);
        }
        catch (Exception exception) {
            LOGGER.error("ActivityCommonInfoServiceImpl_transferTask_error:", (Throwable)exception);
            resultMap.put("IS_SUCCESS", Boolean.FALSE);
            resultMap.put("MSG", exception.getMessage());
        }
        return resultMap;
    }

    private void asynDealTransfer(IFormView view, List<Long> activityBodyIds, List<Long> transferUserIds, String remakes) {
        if (view instanceof IListView) {
            HRPageCache pageCache = new HRPageCache(view);
            pageCache.put("transferUserIds", transferUserIds);
            pageCache.put("activityBodyIds", activityBodyIds);
            pageCache.put("remakes", (Object)remakes);
            view.addClientCallBack("asynDealTransfer", Integer.valueOf(100));
            return;
        }
        try {
            IHomToHrcsAppService.getInstance().dealTransfer(activityBodyIds, transferUserIds.get(0), remakes);
        }
        catch (Exception e) {
            LOGGER.error("asynDealTransfer", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    private void asynBatchAssignTask(IFormView view, List<Long> activityBodyIds, List<Long> transferUserIds, String remakes) {
        if (view instanceof IListView) {
            HRPageCache pageCache = new HRPageCache(view);
            pageCache.put("transferUserIds", transferUserIds);
            pageCache.put("activityBodyIds", activityBodyIds);
            pageCache.put("remakes", (Object)remakes);
            view.addClientCallBack("batchAssignTask", Integer.valueOf(100));
            return;
        }
        try {
            IHomToHrcsAppService.getInstance().batchAssignTask(activityBodyIds, transferUserIds, remakes);
        }
        catch (Exception e) {
            LOGGER.error("asynBatchAssignTask_error:", (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public void handleTransfer(IFormView view, Map<String, Object> resultMap) {
        LOGGER.info("handleTransfer_check_start");
        List ids = (List)resultMap.get("personid");
        if (ids == null || ids.size() == 0) {
            LOGGER.info("handleTransfer_user_null");
            throw new KDBizException("handleTransfer_user_null");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        ids.stream().forEach(obj -> userIds.add(Long.valueOf(obj.toString())));
        String remakes = (String)resultMap.get("transferremake");
        String operationName = ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"ActivityCommonInfoServiceImpl_18", (String)"hr-hom-business", (Object[])new Object[0]);
        AtomicReference<Boolean> isList = new AtomicReference<Boolean>();
        isList.set(Boolean.FALSE);
        ArrayList<Long> activityIds = new ArrayList<Long>();
        ArrayList<String> expectStatus = new ArrayList<String>();
        String page = this.setPageInfo(view, isList, expectStatus, activityIds);
        Boolean checkHandler = ActivityNum.HANDLE_PAGE.contains(page) ? Boolean.TRUE : Boolean.FALSE;
        LOGGER.info("handleTransfer_check_end");
        Map<String, Object> msgMap = this.transferTask(view, operationName, activityIds, expectStatus, userIds, remakes, checkHandler);
        if (Objects.nonNull(msgMap) && Objects.nonNull(msgMap.get("IS_SUCCESS"))) {
            Boolean isSuccess = (Boolean)msgMap.get("IS_SUCCESS");
            String msg = ResManager.loadKDString((String)"\u8f6c\u4ea4\u6210\u529f", (String)"ActivityCommonInfoServiceImpl_14", (String)"hr-hom-business", (Object[])new Object[0]);
            if (isSuccess.booleanValue() && isList.get().booleanValue()) {
                msg = ResManager.loadKDString((String)"\u8f6c\u4ea4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u6570\u636e\u3002", (String)"ActivityCommonInfoServiceImpl_13", (String)"hr-hom-business", (Object[])new Object[0]);
                view.showSuccessNotification(msg);
            } else if (isSuccess.booleanValue()) {
                view.showSuccessNotification(msg);
            } else {
                IHomDataMutexService.getInstance().batchRelease(activityIds, "hom_collaborationdetail", "donothing_tran");
                msg = (String)msgMap.get("MSG");
                LOGGER.error("handleTransfer_error:", (Object)msg);
                throw new KDBizException(msg);
            }
        }
    }

    private String setPageInfo(IFormView view, AtomicReference<Boolean> isList, List<String> expectStatus, List<Long> activityIds) {
        String page;
        if (view instanceof IListView) {
            isList.set(Boolean.TRUE);
            IListView listView = (IListView)view;
            expectStatus.addAll((Collection<String>)ActivityNum.STATUS_MAP.get(listView.getBillFormId()));
            page = listView.getBillFormId();
            activityIds.addAll(this.getKeyList(listView));
        } else {
            Long entryId = this.getActivityId(view);
            page = view.getFormShowParameter().getFormId();
            activityIds.add(entryId);
            expectStatus.add(view.getPageCache().get("taskstatus"));
        }
        return page;
    }

    @Override
    public List<Long> getKeyList(IListView view) {
        ArrayList<Long> ids = new ArrayList<Long>();
        Object[] pkKeys = view.getSelectedRows().getPrimaryKeyValues();
        if (pkKeys == null || pkKeys.length == 0) {
            return ids;
        }
        Arrays.stream(pkKeys).forEach(key -> ids.add((Long)key));
        return ids;
    }

    @Override
    public Boolean handleConsentTask(IFormView view, List<Long> activityIds, List<String> expectStatus, boolean isList) {
        Boolean isSuccess;
        Map<String, Object> checkMap = this.activityCheck(activityIds, expectStatus, Boolean.TRUE);
        Boolean bl = isSuccess = Objects.isNull(checkMap.get("IS_SUCCESS")) ? Boolean.FALSE : (Boolean)checkMap.get("IS_SUCCESS");
        if (isSuccess.booleanValue()) {
            try {
                this.asynActivityCommit(view, activityIds);
                HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IActivityDomainService.class, (String)"kd.sdk.hr.hom.business.activity.IActivityDomainService", null);
                hrPluginProxy.callReplace(hrplugin -> {
                    hrplugin.handleTrdActivity(activityIds);
                    return null;
                });
                String msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"ActivityCommonInfoServiceImpl_15", (String)"hr-hom-business", (Object[])new Object[0]);
                if (isList) {
                    msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u6570\u636e\u3002", (String)"ActivityCommonInfoServiceImpl_19", (String)"hr-hom-business", (Object[])new Object[0]);
                    view.showSuccessNotification(msg);
                    return Boolean.TRUE;
                }
                view.showSuccessNotification(msg);
                return Boolean.TRUE;
            }
            catch (Exception exception) {
                LOGGER.error("handleConsentTask_error:", (Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
        String operationName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ActivityCommonInfoServiceImpl_16", (String)"hr-hom-business", (Object[])new Object[0]);
        String errorMsg = this.getFailTipMsg(checkMap, operationName, isList, Boolean.TRUE);
        LOGGER.error("handleConsentTask_fail_msg:", (Object)errorMsg);
        throw new KDBizException(errorMsg);
    }

    private void asynActivityCommit(IFormView view, List<Long> activityIds) {
        if (view instanceof IListView) {
            HRPageCache pageCache = new HRPageCache(view);
            pageCache.put("activityBodyIds", activityIds);
            view.addClientCallBack("asynActivityCommit", Integer.valueOf(100));
            return;
        }
        this.activityCommit(activityIds);
    }

    @Override
    public void activityCommit(List<Long> activityIds) {
        DynamicObject[] dynamicObjects = this.getActivityInfo(activityIds);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            LOGGER.info("dynamicObjects_can_not_be_null");
            throw new KDBizException("dynamicObjects can not be null");
        }
        List<Long> taskIds = Arrays.stream(dynamicObjects).map(item -> item.getLong("activityins.id")).collect(Collectors.toList());
        StringBuilder errorStr = new StringBuilder();
        OperationResult operationResult = null;
        try {
            LOGGER.info("activityCommit_batchConsentTask_star");
            operationResult = IHomToHrcsAppService.getInstance().batchConsentTask(taskIds, "");
        }
        catch (Exception exception) {
            LOGGER.error("activityCommit_batchConsentTask_error:", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        boolean success = operationResult != null && operationResult.isSuccess();
        LOGGER.info(MessageFormat.format("activityCommit->: ids:{0},msg:{1}", taskIds, operationResult != null ? operationResult.getMessage() : "not_msg"));
        if (success) {
            LOGGER.info("batchConsentTask success");
            errorStr.append(operationResult.getMessage());
            HashMap onbrdActivityNumberMap = Maps.newHashMapWithExpectedSize((int)activityIds.size());
            Stream.of(dynamicObjects).forEach(homActiveInfo -> {
                long onbrdBillId = homActiveInfo.getLong("onbrdid.id");
                ArrayList<String> activityNumberList = (ArrayList<String>)onbrdActivityNumberMap.get(onbrdBillId);
                if (activityNumberList == null) {
                    activityNumberList = new ArrayList<String>();
                }
                activityNumberList.add(homActiveInfo.getString("activity.number"));
                onbrdActivityNumberMap.put(onbrdBillId, activityNumberList);
            });
            THREAD_POOL.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdActivity(onbrdActivityNumberMap), RequestContext.getOrCreate());
        }
        if (!success) {
            LOGGER.info("activityCommit_fail", (Object)errorStr.toString());
            throw new KDBizException(errorStr.toString());
        }
    }

    @Override
    public DynamicObject[] getActivityInfo(QFilter[] qFilters) {
        return BASE_SERVICE_HELPER.query(TRANSFER_SELECT_FIELDS, qFilters);
    }

    static {
        tipsMap.put(ActivityStatusEnum.REJECTED.getValue(), ResManager.loadKDString((String)"\u5df2\u9a73\u56de\u548c", (String)"ActivityCommonInfoServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
        tipsMap.put(ActivityStatusEnum.COMPLETED.getValue(), ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u548c", (String)"ActivityCommonInfoServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
        tipsMap.put(ActivityStatusEnum.TERMINATED.getValue(), ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62\u548c", (String)"ActivityCommonInfoServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
    }
}

