/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.activity;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.dynprocess.freeflow.WFBaseElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.exception.WFEngineException;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.activity.ActivityRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityCommonInfoService;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.activity.IActivityManageService;
import kd.hr.hom.business.domain.service.collect.ICooperationManageService;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.MessageDTO;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.util.ErrorInfoUtils;
import kd.hr.hom.common.util.RequestContextUtils;
import kd.hr.hpfs.common.utils.ObjectUtils;

public class ActivityDomainService
implements IActivityDomainService {
    private static final Log LOGGER = LogFactory.getLog(ActivityDomainService.class);
    private static final String SELECT_PROPERTIES = "id,activityscheme,entryentity.activity,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline,entryentity.handlers,onbrd";
    private static final String HOM_ACCEPTMANAGEPASS = "hom_acceptmanagepass";
    private static final String HOM_ACCEPTMANAGEUNPASS = "hom_acceptmanageunpass";
    private static final String HOM_ACCEPTMANAGEING = "hom_acceptmanageing";
    private static final String FORM_ID = "formId";
    private static final String OPERATION_STATUS = "operationStatus";
    private static final String CAPTION = "caption";
    private static final String PK_ID = "pkId";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ActivityDomainService", (int)30);

    @Override
    public DynamicObject findActivityInfo(String selectProperties, QFilter qFilter) {
        return ActivityRepository.findActivityInfo(selectProperties, qFilter);
    }

    @Override
    public OperationResult batchConsentTask(List<Long> ids, String number) {
        return null;
    }

    @Override
    public OperationResult batchConsentTask(List<Long> ids, ActivityNumberEnum activityNumberEnum) {
        OperationResult operationResult = new OperationResult();
        try {
            LOGGER.info(MessageFormat.format("batchConsentTask-start ids is {0} id is {1}", String.valueOf(ids), activityNumberEnum.getId()));
            QFilter onbrdFilter = new QFilter("onbrd", "in", ids);
            DynamicObject[] activityOverviewDys = this.findActivityInfos(SELECT_PROPERTIES, onbrdFilter);
            ArrayList<Long> activityTaskIds = new ArrayList<Long>(ids.size());
            HashMap onbrdActivityNumberMap = Maps.newHashMapWithExpectedSize((int)ids.size());
            block3: for (DynamicObject activityOverviewDy : activityOverviewDys) {
                DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
                for (DynamicObject entryEntityDy : entryEntityDys) {
                    String activityNumber = entryEntityDy.getString("activity.number");
                    Long activityId = entryEntityDy.getLong("activity.id");
                    DynamicObject activityInsDy = entryEntityDy.getDynamicObject("activityins");
                    if (activityInsDy == null || !activityNumberEnum.getId().equals(activityId)) continue;
                    String taskStatus = activityInsDy.getString("taskstatus");
                    if (!ActivityStatusEnum.PROCESSING.getValue().equals(taskStatus)) continue;
                    long instanceId = activityInsDy.getLong("id");
                    activityTaskIds.add(instanceId);
                    long onbrdBillId = activityOverviewDy.getLong("onbrd.id");
                    ArrayList<String> activityNumberList = (ArrayList<String>)onbrdActivityNumberMap.get(onbrdBillId);
                    if (activityNumberList == null) {
                        activityNumberList = new ArrayList<String>();
                    }
                    activityNumberList.add(activityNumber);
                    onbrdActivityNumberMap.put(onbrdBillId, activityNumberList);
                    continue block3;
                }
            }
            if (CollectionUtils.isEmpty(activityTaskIds)) {
                operationResult.isSuccess();
                LOGGER.info(MessageFormat.format("batchConsentTask-end empty ids is {0} id is {1}", String.valueOf(ids), activityNumberEnum.getId()));
                return operationResult;
            }
            RequestContext requestContext = ActivityDomainService.getInstanceIdHandlerRequestContext((Long)activityTaskIds.get(0));
            Future future = threadPool.submit(() -> {
                try (TXHandle txHandle = TX.notSupported((String)"batchConsentTask");){
                    LOGGER.info("not Tx, userId:{},userName:{}", (Object)RequestContext.get().getCurrUserId(), (Object)RequestContext.get().getUserName());
                    OperationResult operationResult = IHomToHrcsAppService.getInstance().batchConsentTask(activityTaskIds, "");
                    return operationResult;
                }
            }, requestContext);
            operationResult = (OperationResult)future.get();
            if (operationResult.isSuccess()) {
                LOGGER.info(MessageFormat.format("batchConsentTask-end operationResult success,activityTaskIds is {1},ids is {2},id is {3}", String.valueOf(activityTaskIds), String.valueOf(ids), activityNumberEnum.getId()));
                threadPool.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdActivity(onbrdActivityNumberMap), requestContext);
            } else {
                String message = ErrorInfoUtils.getMessage((OperationResult)operationResult);
                LOGGER.info(MessageFormat.format("batchConsentTask-end operationResult is {0},activityTaskIds is {1},ids is {2},id is {3}", message, String.valueOf(activityTaskIds), String.valueOf(ids), activityNumberEnum.getId()));
            }
            return operationResult;
        }
        catch (InterruptedException exception) {
            LOGGER.error("batchConsentTask_end_InterruptedException", (Throwable)exception);
            operationResult.setSuccess(false);
            return operationResult;
        }
        catch (ExecutionException exception) {
            LOGGER.error("batchConsentTask_end_ExecutionException", (Throwable)exception);
            operationResult.setSuccess(false);
            return operationResult;
        }
    }

    @Override
    public OperationResult batchConsentTask(List<Long> ids, long instanceId) {
        LOGGER.info("batchConsentTask-start");
        OperationResult operationResult = new OperationResult();
        try {
            ArrayList<Long> activityTaskIds = new ArrayList<Long>(ids.size());
            activityTaskIds.add(instanceId);
            RequestContext requestContext = ActivityDomainService.getInstanceIdHandlerRequestContext((Long)activityTaskIds.get(0));
            Future future = threadPool.submit(() -> {
                LOGGER.info("userId:" + RequestContext.get().getCurrUserId() + ",userName:" + RequestContext.get().getUserName());
                return IHomToHrcsAppService.getInstance().batchConsentTask(activityTaskIds, "");
            }, requestContext);
            operationResult = (OperationResult)future.get();
            Map<Long, DynamicObject> activityinsMap = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("hrcs_activityins", (Collection<Long>)ImmutableList.of((Object)instanceId), "activity");
            HashMap onbrdActivityNumberMap = Maps.newHashMapWithExpectedSize((int)ids.size());
            String activityNumber = activityinsMap.get(instanceId).getString("activity.number");
            onbrdActivityNumberMap.put(ids.get(0), ImmutableList.of((Object)activityNumber));
            LOGGER.info("batchConsentTask-activityNumber:{}", (Object)activityNumber);
            threadPool.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdActivity(onbrdActivityNumberMap), requestContext);
        }
        catch (InterruptedException exception) {
            LOGGER.error("batchConsentTask_end_InterruptedException", (Throwable)exception);
            operationResult.setSuccess(false);
            return operationResult;
        }
        catch (ExecutionException exception) {
            LOGGER.error("batchConsentTask_end_ExecutionException", (Throwable)exception);
            operationResult.setSuccess(false);
            return operationResult;
        }
        operationResult.setSuccess(true);
        LOGGER.info("batchConsentTask-end");
        return operationResult;
    }

    public static RequestContext getHandlerRequestContext(Long onbrdBillId) {
        RequestContext requestContext = RequestContext.getOrCreate();
        if (requestContext.getCurrUserId() == -1L) {
            IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
            QFilter qFilter = new QFilter("id", "=", (Object)onbrdBillId);
            DynamicObject onbrdBill = onbrdBillDomainService.findOnbrdBill("handler", new QFilter[]{qFilter});
            DynamicObject handler = onbrdBill.getDynamicObject("handler");
            if (!HRObjectUtils.isEmpty((Object)handler)) {
                String sysPersonId = handler.getString("id");
                String sysPersonName = handler.getLocaleString("name").getLocaleValue();
                LOGGER.info("sysPersonId:" + sysPersonId + ",sysPersonName:" + sysPersonName);
                requestContext = RequestContextUtils.copyRequestContext((RequestContext)requestContext, (String)sysPersonId, (String)sysPersonName);
            }
        }
        return requestContext;
    }

    public static RequestContext getInstanceIdHandlerRequestContext(Long instanceId) {
        RequestContext requestContext = RequestContext.getOrCreate();
        if (requestContext.getCurrUserId() == -1L) {
            DynamicObject activityInsByIdObj = IHomToHrcsAppService.getInstance().getActivityInsById("handlers,activity", instanceId);
            DynamicObjectCollection handlersDys = activityInsByIdObj.getDynamicObjectCollection("handlers");
            Optional<DynamicObject> userIds = handlersDys.stream().map(user -> user.getDynamicObject("fbasedataid")).findFirst();
            if (userIds.isPresent()) {
                DynamicObject handler = userIds.get();
                String sysPersonId = handler.getString("id");
                String sysPersonName = handler.getLocaleString("name").getLocaleValue();
                LOGGER.info("sysPersonId:" + sysPersonId + ",sysPersonName:" + sysPersonName);
                requestContext = RequestContextUtils.copyRequestContext((RequestContext)requestContext, (String)sysPersonId, (String)sysPersonName);
            }
            QFilter activityins = new QFilter("activityins", "=", (Object)instanceId);
            DynamicObject activeInfoBodyObj = HomCommonRepository.queryDynamicObject("hom_activeinfobody", "iscandidatehandle", activityins);
            if (activeInfoBodyObj != null) {
                activeInfoBodyObj.set("iscandidatehandle", (Object)"1");
                HomCommonRepository.updateDynamicObject("hom_activeinfobody", activeInfoBodyObj);
            }
        }
        return requestContext;
    }

    @Override
    public OperationResult batchTerminateTask(List<Long> ids) {
        LOGGER.info(MessageFormat.format("batchTerminateTask-start ids is {0} ", String.valueOf(ids)));
        QFilter onbrdFilter = new QFilter("onbrd", "in", ids);
        DynamicObject[] activityOverviewDys = this.findActivityInfos(SELECT_PROPERTIES, onbrdFilter);
        ArrayList<Long> activityTaskIds = new ArrayList<Long>(ids.size());
        for (DynamicObject activityOverviewDy : activityOverviewDys) {
            DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntityDy : entryEntityDys) {
                DynamicObject activityInsDy = entryEntityDy.getDynamicObject("activityins");
                if (activityInsDy == null) continue;
                String taskStatus = activityInsDy.getString("taskstatus");
                if (!ActivityStatusEnum.PROCESSING.getValue().equals(taskStatus) && !ActivityStatusEnum.TOASSIGN.getValue().equals(taskStatus)) continue;
                long instanceId = activityInsDy.getLong("id");
                activityTaskIds.add(instanceId);
            }
        }
        OperationResult operationResult = IHomToHrcsAppService.getInstance().batchTerminateTask(activityTaskIds, "");
        if (operationResult.isSuccess()) {
            LOGGER.info(MessageFormat.format("batchTerminateTask-end operationResult success,activityTaskIds is {1},ids is {2}", String.valueOf(activityTaskIds), String.valueOf(ids)));
        } else {
            String message = ErrorInfoUtils.getMessage((OperationResult)operationResult);
            LOGGER.info(MessageFormat.format("batchTerminateTask-end operationResult is {0},activityTaskIds is {1},ids is {2}", message, String.valueOf(activityTaskIds), String.valueOf(ids)));
        }
        return operationResult;
    }

    @Override
    public void batchTerminateFlow(List<Long> ids) {
        LOGGER.info(MessageFormat.format("batchTerminateFlow-start ids is {0} ", String.valueOf(ids)));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
        ArrayList failList = Lists.newArrayListWithCapacity((int)3);
        for (Long billId : ids) {
            Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)String.valueOf(billId));
            if (Objects.isNull(instanceId) || instanceId.equals(0L)) continue;
            try {
                WorkflowServiceHelper.abandon((Long)instanceId);
            }
            catch (WFEngineException exception) {
                failList.add(instanceId);
                LOGGER.error((Throwable)exception);
            }
        }
        if (CollectionUtils.isEmpty((Collection)failList)) {
            return;
        }
        for (Long instanceId : failList) {
            this.abandonWorkflow(instanceId);
        }
    }

    private void abandonWorkflow(Long instanceId) {
        for (int i = 0; i < 3; ++i) {
            try {
                Thread.sleep(3000L);
                WorkflowServiceHelper.abandon((Long)instanceId);
                return;
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e);
                continue;
            }
        }
    }

    @Override
    public void updateOne(DynamicObject dynamicObject) {
        ActivityRepository.updateOne(dynamicObject);
    }

    @Override
    public DynamicObject[] findActivityInfos(String selectProperties, QFilter qFilter) {
        return ActivityRepository.findActivityInfos(selectProperties, qFilter);
    }

    @Override
    public void workflowToDealActivityData(Map<String, String> map, QFilter onbrdFilter) {
        Long activityId = HRJSONUtils.getLongValOfCustomParam((Object)map.get("activityId"));
        Long instanceId = HRJSONUtils.getLongValOfCustomParam((Object)map.get("instanceId"));
        Long bizBillId = HRJSONUtils.getLongValOfCustomParam((Object)map.get("bizBillId"));
        int sla = Integer.parseInt(String.valueOf(map.get("sla")));
        DynamicObject activitySchemeObj = IHomToHrcsAppService.getInstance().getLatestActivityTask(bizBillId, activityId);
        DynamicObject activityOverviewDy = this.findActivityInfo("id,activityscheme,entryentity.activity,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline,entryentity.bindbizbillid,entryentity.onbrdid,entryentity.org,entryentity.handlers", onbrdFilter);
        DynamicObjectCollection entryEntityDys = activityOverviewDy.getDynamicObjectCollection("entryentity");
        IOnbrdBillDomainService onbrdBillDomainService = IOnbrdBillDomainService.getInstance();
        DynamicObject onbrdBill = onbrdBillDomainService.findOnbrdBillById("org,billno", bizBillId);
        for (DynamicObject entryEntityDy2 : entryEntityDys) {
            DynamicObject activityDy = entryEntityDy2.getDynamicObject("activity");
            if (!activityId.equals(activityDy.getLong("id"))) continue;
            entryEntityDy2.set("activityins", (Object)instanceId);
            Date createTime = activitySchemeObj.getDate("createtime");
            entryEntityDy2.set("latestdeadline", (Object)HRDateTimeUtils.addHour((Date)createTime, (long)sla));
            entryEntityDy2.set("onbrdid", (Object)bizBillId);
            entryEntityDy2.set("org", onbrdBill.get("org"));
            DynamicObject onbrdBillByIdDy = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "", bizBillId);
            LOGGER.info("###ActivityDomainService.workflowToDealActivityData activityId:{}", (Object)activityId);
            ActivityNumberEnum activityEnum = ActivityNumberEnum.getEnumById((Long)activityId);
            if (!Objects.isNull(activityEnum)) {
                switch (activityEnum) {
                    case APPOINTMENT: {
                        ServiceFactory.getService(IActivityManageService.class).triggerAppointmentManageActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                    case INFOCOLLECTION: {
                        bizBillId = ServiceFactory.getService(IActivityManageService.class).triggerCollectManageActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                    case INFOAUDIT: {
                        bizBillId = ServiceFactory.getService(IActivityManageService.class).triggerCollectApproveActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                    case DATAACCEPTANCE: {
                        bizBillId = ServiceFactory.getService(IActivityManageService.class).triggerAcceptManageActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                    case INDUCTIONINVITATION: {
                        bizBillId = ServiceFactory.getService(IActivityManageService.class).triggerInviteManageActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                    case CHECKININFO: {
                        ServiceFactory.getService(IActivityManageService.class).triggerCheckInActivity(onbrdBillByIdDy, instanceId);
                        break;
                    }
                }
            }
            LOGGER.info("###ActivityDomainService.workflowToDealActivityData exec hrPluginProxy");
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, kd.sdk.hr.hom.business.activity.IActivityDomainService.class, (String)"kd.sdk.hr.hom.business.activity.IActivityDomainService", null);
            hrPluginProxy.callReplace(hrplugin -> {
                hrplugin.triggerTrdActivity(activityDy, onbrdBillByIdDy, instanceId);
                return null;
            });
            List billList = hrPluginProxy.callReplace(hrplugin -> hrplugin.triggerTrdActivityNew(activityDy, onbrdBillByIdDy, instanceId));
            LOGGER.info("ActivityDomainService.workflowToDealActivityData call IActivityDomainService end,billId:{}", (Object)billList);
            if (billList != null && billList.size() > 0 && !ObjectUtils.isEmpty(billList.get(0))) {
                bizBillId = (Long)billList.get(0);
            }
            entryEntityDy2.set("bindbizbillid", (Object)bizBillId);
            break;
        }
        this.updateOne(activityOverviewDy);
        DynamicObject activityInsByIdObj = IHomToHrcsAppService.getInstance().getActivityInsById("handlers,activity", instanceId);
        List<Long> handlers = activityInsByIdObj.getDynamicObjectCollection("handlers").stream().map(handler -> (Long)handler.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        List collect = entryEntityDys.stream().filter(entryEntityDy -> entryEntityDy.getDynamicObject("activity").getLong("id") == activityId.longValue()).collect(Collectors.toList());
        String taskSwitch = map.get("taskSwitch");
        if (!"2".equals(taskSwitch) && !"3".equals(taskSwitch)) {
            this.sendCollectDealMessage((DynamicObject)collect.get(0), onbrdBill, handlers, "OBD020");
        }
        try (TXHandle notSupported = TX.notSupported();){
            ActivityNumberEnum activityEnum = ActivityNumberEnum.getEnumById((Long)activityId);
            boolean isActiveHandle = null != activityEnum && "hom_activehandle".equals(activityEnum.getPageNumber());
            Long finalBizBillId = isActiveHandle ? Long.valueOf(((DynamicObject)collect.get(0)).getLong("id")) : bizBillId;
            threadPool.execute(() -> HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSActivityService", (String)"updateTaskBindBillInfo", (Object[])new Object[]{instanceId, String.valueOf(finalBizBillId), onbrdBill.getString("billno")}), RequestContext.getOrCreate());
        }
        LOGGER.info("###handleMessage end bizBillId:{},instanceId:{}", (Object)bizBillId, (Object)instanceId);
    }

    public void sendCollectDealMessage(DynamicObject activityDetailDy, DynamicObject onbrdBill, List<Long> bosUserIds, String templateNumber) {
        HashMap<String, String> params = this.setMapForParams(activityDetailDy, onbrdBill.getLong("id"));
        MessageDTO messageDto = new MessageDTO();
        messageDto.setReceiverBosUserIds(bosUserIds);
        messageDto.setBizDataId(Long.valueOf(activityDetailDy.getLong("id")));
        ILocaleString activityName = activityDetailDy.getDynamicObject("activity").getLocaleString("name");
        messageDto.setLocaleStringTag(activityName);
        messageDto.setTitle(messageDto.getTag());
        messageDto.setContent(messageDto.getTag());
        messageDto.setContentUrl(SendMessageUtil.buildURL(activityDetailDy, params));
        messageDto.setTemplateNumber(templateNumber);
        messageDto.setNestBillNo(onbrdBill.getString("billno"));
        LOGGER.info("###ActivityDomainService.sendCollectDealMessage message:{}", (Object)JSON.toJSONString((Object)messageDto));
        ServiceFactory.getService(ISendMessageService.class).sendMessageByTemplateNumber(messageDto);
    }

    @Override
    public void dealHcdmActivity(Long onBrdId, Long activityId, Long activityInsId, int sla) {
        QFilter filter = new QFilter("onbrd.id", "=", (Object)onBrdId);
        DynamicObject activityOverviewDy = this.findActivityInfo("id,activityscheme,entryentity.activity,entryentity.activityins,entryentity.createtime,entryentity.latestdeadline,entryentity.bindbizbillid,entryentity.onbrdid,entryentity.org,entryentity.handlers", filter);
        DynamicObject activityIns = IHomToHrcsAppService.getInstance().getLatestActivityTask(onBrdId, activityId);
        DynamicObjectCollection activities = activityOverviewDy.getDynamicObjectCollection("entryentity");
        activities.stream().filter(dy -> dy.getLong("activity.id") == activityId.longValue()).forEach(activityInfo -> {
            activityInfo.set("activityins", (Object)activityInsId);
            activityInfo.set("latestdeadline", (Object)HRDateTimeUtils.addHour((Date)activityIns.getDate("createtime"), (long)sla));
            activityInfo.set("onbrdid", (Object)onBrdId);
            DynamicObject onBrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBillById("org", onBrdId);
            if (!HRObjectUtils.isEmpty((Object)onBrdBill)) {
                activityInfo.set("org", onBrdBill.get("org"));
            }
        });
        this.updateOne(activityOverviewDy);
    }

    @Override
    public String buildHandlerUrl(DynamicObject activityDetailDy, Long bizBillIdCopy) {
        HashMap<String, String> params = new HashMap<String, String>();
        Long activityId = activityDetailDy.getLong("activity.id");
        HashMap<Long, Runnable> map = new HashMap<Long, Runnable>();
        map.put(ActivityNumberEnum.APPOINTMENT.getId(), () -> this.appointment(activityDetailDy, params));
        map.put(ActivityNumberEnum.CHECKININFO.getId(), () -> this.checkinInfo(activityDetailDy, params));
        map.put(ActivityNumberEnum.INFOCOLLECTION.getId(), () -> this.infocollectionOrInfoaudit(activityDetailDy, params));
        map.put(ActivityNumberEnum.INFOAUDIT.getId(), () -> this.infocollectionOrInfoaudit(activityDetailDy, params));
        map.put(ActivityNumberEnum.INDUCTIONINVITATION.getId(), () -> this.inductioninvitation(activityDetailDy, params));
        map.put(ActivityNumberEnum.DATAACCEPTANCE.getId(), () -> this.dataacceptance(activityDetailDy, params));
        map.getOrDefault(activityId, () -> this.defaultMethod(activityDetailDy, params, bizBillIdCopy)).run();
        return SendMessageUtil.buildURL(activityDetailDy, params);
    }

    @Override
    public boolean isHasAuditFlow(DynamicObject bill) {
        List<WFFlowElement> auditTaskList = this.getWfFlowElements(bill);
        return !CollectionUtils.isEmpty(auditTaskList);
    }

    private List<WFFlowElement> getWfFlowElements(DynamicObject bill) {
        LOGGER.info("getWfFlowElements  start");
        List processElements = WorkflowServiceHelper.getProcessElements((DynamicObject)bill, (String)"submit");
        if (CollectionUtils.isEmpty((Collection)processElements)) {
            processElements = Collections.emptyList();
        }
        LOGGER.info("getWfFlowElements end {}}", (Object)processElements.toString());
        return processElements.stream().filter(processElement -> "YunzhijiaTask".equals(processElement.getType()) || "AuditTask".equals(processElement.getType())).collect(Collectors.toList());
    }

    @Override
    public boolean isAuditNodeAllComplete(DynamicObject bill) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException exception) {
            LOGGER.info("isAuditNodeAllComplete exception {}", (Object)exception);
        }
        List<String> nodeIds = this.tobeExecutedNodeIds(bill);
        if (CollectionUtils.isEmpty(nodeIds)) {
            return true;
        }
        Map<String, List<Map<String, Object>>> auditTaskResult = this.getActInstInfo(bill, nodeIds);
        LOGGER.info("isAuditNodeAllComplete auditTaskResult {}", auditTaskResult);
        if (CollectionUtils.isEmpty(auditTaskResult)) {
            return false;
        }
        for (Map.Entry<String, List<Map<String, Object>>> auditTask : auditTaskResult.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)auditTask.getValue())) {
                return false;
            }
            Map<String, Object> auditTaskMap = auditTask.getValue().get(0);
            LOGGER.info("isAuditNodeAllComplete auditTaskMap {}", auditTaskMap);
            if (this.isSkipOrAuto(auditTaskMap) || this.isComplete(auditTaskMap)) continue;
            return false;
        }
        return true;
    }

    private List<String> tobeExecutedNodeIds(DynamicObject bill) {
        List<WFFlowElement> auditTaskList = this.getWfFlowElements(bill);
        List allNodeIds = auditTaskList.stream().map(WFBaseElement::getId).collect(Collectors.toList());
        LOGGER.info("allAuditNodeAll nodeIds: {}", allNodeIds);
        List processWindowRecords = WorkflowServiceHelper.getProcessWindowRecords((String)bill.getString("id"));
        LOGGER.info("processWindowRecords result: {}", (Object)processWindowRecords);
        List<String> todoNodeIds = new ArrayList<String>();
        if (HRCollUtil.isNotEmpty((Collection)processWindowRecords)) {
            todoNodeIds = processWindowRecords.stream().filter(map -> (Boolean)map.get("executed") == false).map(map -> String.valueOf(map.get("nodeId"))).collect(Collectors.toList());
            todoNodeIds = todoNodeIds.stream().filter(allNodeIds::contains).collect(Collectors.toList());
            LOGGER.info("processWindowRecords todoNodeIds: {}", todoNodeIds);
        }
        return todoNodeIds;
    }

    private Map<String, List<Map<String, Object>>> getActInstInfo(DynamicObject bill, List<String> nodeIds) {
        return WorkflowServiceHelper.getActInstInfo((String)bill.getString("id"), nodeIds, (boolean)false);
    }

    private boolean isComplete(Map<String, Object> auditTaskMap) {
        List resultNumbers;
        String executionType;
        String string = executionType = auditTaskMap.get("executionType") == null ? "" : auditTaskMap.get("executionType").toString().toLowerCase(Locale.ROOT);
        if (!StringUtils.isEmpty((Object)executionType)) {
            return false;
        }
        List commentList = new ArrayList();
        if (auditTaskMap.get("commentList") instanceof List) {
            commentList = (List)auditTaskMap.get("commentList");
        }
        return !CollectionUtils.isEmpty(resultNumbers = commentList.stream().filter(resultNumber -> "consent".equalsIgnoreCase(resultNumber.get("resultNumber") == null ? "" : resultNumber.get("resultNumber").toString())).collect(Collectors.toList()));
    }

    private boolean isSkipOrAuto(Map<String, Object> stringObjectMap) {
        String executionType = stringObjectMap.get("executionType") == null ? "" : stringObjectMap.get("executionType").toString().toLowerCase(Locale.ROOT);
        List<String> strings = Arrays.asList("jump", "skip", "byexpireauto", "byauto");
        return strings.contains(executionType);
    }

    private HashMap<String, String> setMapForParams(DynamicObject activityDetailDy, Long bizBillIdCopy) {
        HashMap<String, String> params = new HashMap<String, String>();
        Long activityId = activityDetailDy.getLong("activity.id");
        HashMap<Long, Runnable> map = new HashMap<Long, Runnable>();
        map.put(ActivityNumberEnum.APPOINTMENT.getId(), () -> this.appointment(activityDetailDy, params));
        map.put(ActivityNumberEnum.CHECKININFO.getId(), () -> this.checkinInfo(activityDetailDy, params));
        map.put(ActivityNumberEnum.INFOCOLLECTION.getId(), () -> this.infocollectionOrInfoaudit(activityDetailDy, params));
        map.put(ActivityNumberEnum.INFOAUDIT.getId(), () -> this.infocollectionOrInfoaudit(activityDetailDy, params));
        map.put(ActivityNumberEnum.INDUCTIONINVITATION.getId(), () -> this.inductioninvitation(activityDetailDy, params));
        map.put(ActivityNumberEnum.DATAACCEPTANCE.getId(), () -> this.dataacceptance(activityDetailDy, params));
        map.getOrDefault(activityId, () -> this.defaultMethod(activityDetailDy, params, bizBillIdCopy)).run();
        return params;
    }

    @Override
    public List<Long> findWorkTableOnbrd(String enrollstatus, List<Long> adminorgids, List<Long> hrbuids) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        QFilter enrollQFilter = new QFilter("enrollstatus", "=", (Object)enrollstatus);
        list.add(enrollQFilter);
        if (!CollectionUtils.isEmpty(adminorgids)) {
            list.add(new QFilter("affiliateadminorg", "in", adminorgids));
        }
        if (!CollectionUtils.isEmpty(hrbuids)) {
            list.add(new QFilter("hrbu", "in", hrbuids));
        }
        list.add(ServiceFactory.getService(IOnbrdWorkTableService.class).getDataPermissionFilter());
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_onbrdinfo", "id", list.toArray(new QFilter[0]));
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    private void appointment(DynamicObject activityDetailDy, HashMap<String, String> params) {
        long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
        params.put(FORM_ID, "hom_reservationbody");
        params.put("type", "1");
        params.put("onbrdid", String.valueOf(bindBizBillId));
        params.put(OPERATION_STATUS, OperationStatus.EDIT.name().toLowerCase());
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "name", bindBizBillId);
        String name = dynamicObject.getString("name");
        String tableName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u9884\u7ea6-%s", (String)"ActivityDomainService_0", (String)"hr-hom-business", (Object[])new Object[0]), name);
        params.put(CAPTION, tableName);
    }

    private void checkinInfo(DynamicObject activityDetailDy, HashMap<String, String> params) {
        long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
        params.put(FORM_ID, "hom_onbrdcheckinbody");
        params.put("type", "2");
        params.put("onbrdid", String.valueOf(bindBizBillId));
        params.put(OPERATION_STATUS, OperationStatus.EDIT.name().toLowerCase());
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "name", bindBizBillId);
        String name = dynamicObject.getString("name");
        String tableName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5165\u804c\u62a5\u5230-%s", (String)"ActivityDomainService_1", (String)"hr-hom-business", (Object[])new Object[0]), name);
        params.put(CAPTION, tableName);
    }

    private void infocollectionOrInfoaudit(DynamicObject activityDetailDy, HashMap<String, String> params) {
        String formId;
        long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", bindBizBillId);
        Long activityId = activityDetailDy.getLong("activity.id");
        String candidateName = dynamicObject.getString("onboard.name");
        String tableName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fe1\u606f\u91c7\u96c6-%s", (String)"CollectActivityListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName);
        if (ActivityNumberEnum.INFOAUDIT.getId().equals(activityId)) {
            formId = CollectApproveStatusEnum.valueByStatus((String)dynamicObject.getString("approvestatus")).getPageId();
            params.put("approve", "1");
            tableName = String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u5ba1\u6838-%s", (String)"CollectActivityListPlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]), candidateName);
        } else {
            formId = CollectManageStatusEnum.valueByStatus((String)dynamicObject.getString("collectstatus")).getPageId();
        }
        params.put(PK_ID, String.valueOf(bindBizBillId));
        params.put(FORM_ID, formId);
        params.put(CAPTION, tableName);
    }

    private void inductioninvitation(DynamicObject activityDetailDy, HashMap<String, String> params) {
        long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_invitesendbill", "onbrd,onbrd.name", bindBizBillId);
        String name = dynamicObject.getDynamicObject("onbrd").getString("name");
        params.put(OPERATION_STATUS, OperationStatus.EDIT.name().toLowerCase());
        params.put(PK_ID, String.valueOf(bindBizBillId));
        params.put(FORM_ID, "hom_invitesendbill");
        params.put(CAPTION, String.format(ResManager.loadKDString((String)"\u5165\u804c\u9080\u7ea6-%s", (String)"OnbrdInviteListPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), name));
        params.put("onbrdid", dynamicObject.getString("onbrd.id"));
        params.put("id", String.valueOf(bindBizBillId));
    }

    private void dataacceptance(DynamicObject activityDetailDy, HashMap<String, String> params) {
        long bindBizBillId = activityDetailDy.getLong("bindbizbillid");
        DynamicObject dyo = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "acceptstatus,onboard.id,onboard.enrollstatus,templateresult", bindBizBillId);
        String acceptStatus = dyo.getString("acceptstatus");
        params.put(CAPTION, MessageFormat.format(ResManager.loadKDString((String)"\u8d44\u6599\u9a8c\u6536-{0}", (String)"ACCEPTMANAGE_5", (String)"hr-hom-formplugin", (Object[])new Object[0]), dyo.getString("onboard.name")));
        params.put(PK_ID, String.valueOf(bindBizBillId));
        String biilFormId = "";
        if ("10".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEING;
        }
        if ("20".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEPASS;
        }
        if ("30".equals(acceptStatus)) {
            biilFormId = HOM_ACCEPTMANAGEUNPASS;
        }
        params.put(FORM_ID, biilFormId);
    }

    private void defaultMethod(DynamicObject activityDetailDy, HashMap<String, String> params, Long bizBillIdCopy) {
        QFilter typeFilter = new QFilter("activity.id", "=", (Object)activityDetailDy.getLong("activity.id"));
        QFilter onbFilter = new QFilter("onbrdid", "=", (Object)bizBillIdCopy);
        params.put(FORM_ID, "hom_activehandle");
        params.put("activity.id", String.valueOf(activityDetailDy.getLong("activity.id")));
        DynamicObject[] dynamicObjects = IActivityCommonInfoService.getInstance().getActivityInfo(new QFilter[]{typeFilter, onbFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        long aLong = dynamicObjects[0].getLong("id");
        DynamicObject onbrdDyObj = ICooperationManageService.getInstance().queryCooperationById("id,onbrdid,activity.name", aLong);
        params.put(PK_ID, String.valueOf(aLong));
        if (onbrdDyObj != null) {
            String name1 = onbrdDyObj.getString("onbrdid.name");
            String activityName = onbrdDyObj.getString("activity.name");
            params.put(CAPTION, MessageFormat.format(ResManager.loadKDString((String)"{0}-{1}", (String)"ActivityCommonInfoServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), activityName, name1));
            params.put("cooperationId", String.valueOf(aLong));
        }
    }

    @Override
    public OperationResult autoConsentTask(Long onBrdId, Long instanceId, ActivityNumberEnum activityNumberEnum) {
        OperationResult operationResult = new OperationResult();
        try {
            Long id = activityNumberEnum.getId();
            IHomToHrcsAppService instance = IHomToHrcsAppService.getInstance();
            LOGGER.info("autoConsentTask-start onBrdId:{} id:{}", (Object)onBrdId, (Object)id);
            DynamicObject activityInsDy = instance.getActivityInsById(null, instanceId);
            HashMap onBrdActivityNumberMap = Maps.newHashMapWithExpectedSize((int)2);
            long activityId = activityInsDy.getLong("activity.id");
            String taskStatus = activityInsDy.getString("taskstatus");
            RequestContext requestContext = RequestContext.getOrCreate();
            if (activityId == activityNumberEnum.getId() && ActivityStatusEnum.PROCESSING.getValue().equals(taskStatus)) {
                String activityNumber = activityInsDy.getString("activity.number");
                onBrdActivityNumberMap.put(onBrdId, Lists.newArrayList((Object[])new String[]{activityNumber}));
                try (TXHandle txHandle = TX.notSupported((String)"batchConsentTask");){
                    DynamicObjectCollection handlers = activityInsDy.getDynamicObjectCollection("handlers");
                    if (!handlers.isEmpty()) {
                        long handlerUserId = ((DynamicObject)handlers.get(0)).getLong("fbasedataId.id");
                        requestContext = RequestContextUtils.copyRequestContext((RequestContext)requestContext, (String)(handlerUserId + ""), (String)"");
                        RequestContext.set((RequestContext)requestContext);
                        operationResult = instance.batchConsentTask(Lists.newArrayList((Object[])new Long[]{instanceId}), handlerUserId, "");
                    }
                }
            }
            if (operationResult.isSuccess()) {
                LOGGER.info("autoConsentTask-end operationResult success instanceId:{},onBrdId:{},id:{}", new Object[]{instanceId, onBrdId, id});
                threadPool.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdActivity(onBrdActivityNumberMap), requestContext);
            } else {
                String message = ErrorInfoUtils.getMessage((OperationResult)operationResult);
                LOGGER.info("autoConsentTask-end operationResult message:{},instanceId:{},onBrdId:{},id:{}", new Object[]{message, instanceId, onBrdId, id});
            }
            return operationResult;
        }
        catch (Exception exception) {
            LOGGER.error("autoConsentTask_end_Exception", (Throwable)exception);
            operationResult.setSuccess(false);
            return operationResult;
        }
    }

    @Override
    public Map<Long, List<Long>> getActivityHandlerMap(List<Long> onbrdIds, ActivityNumberEnum activityEnum) {
        QFilter qFilter = new QFilter("onbrdid", "in", onbrdIds);
        qFilter.and("activity.id", "in", (Object)activityEnum.getId());
        qFilter.and("activityins.taskstatus", "in", (Object)ActivityStatusEnum.PROCESSING.getValue());
        String selectFields = "onbrdid,activityins.handlers,activityins.taskstatus";
        DynamicObject[] activityDyns = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", selectFields, qFilter);
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(activityDyns.length);
        for (DynamicObject activityDyn : activityDyns) {
            long onbrdId = activityDyn.getLong("onbrdid");
            activityDyn.get("activityins.handlers");
            List handlerIds = resultMap.getOrDefault(onbrdId, new ArrayList(4));
            resultMap.put(onbrdId, handlerIds);
        }
        for (Long onbrdId : onbrdIds) {
            List handlerIds = resultMap.getOrDefault(onbrdId, Collections.emptyList());
            if (!HRCollUtil.isEmpty(handlerIds)) continue;
            resultMap.put(onbrdId, handlerIds);
        }
        return resultMap;
    }
}

