/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.activity;

import com.google.common.collect.ImmutableSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.activity.IActivityManageService;
import kd.hr.hom.business.domain.service.collect.ICollectApproveLogService;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.InviteMessageSendStatusEnum;
import kd.hr.hom.common.enums.LoginStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.SendModeEnum;
import kd.hr.hom.common.enums.SendStatusEnum;
import kd.hr.hom.common.enums.WelcomeLetterSendStatusEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class ActivityManageServiceImpl
implements IActivityManageService {
    private static final Log LOG = LogFactory.getLog(ActivityManageServiceImpl.class);
    public static final String TEMPLATE_RESULT = "templateresult";
    public static final String ONBOARD = "onboard";

    @Override
    public long triggerCollectManageActivity(DynamicObject onbrdBillDyn, Long instanceId) {
        LOG.info(MessageFormat.format("triggerCollectManageActivity start id is {0}", onbrdBillDyn.getLong("id")));
        HomCommonRepository.deleteByFilter("hom_collect", new QFilter(ONBOARD, "=", (Object)onbrdBillDyn.getLong("id")));
        DynamicObject collectActivity = this.buildCollectActivity(onbrdBillDyn);
        collectActivity.set("collectstatus", (Object)CollectManageStatusEnum.SUBMIT.getStatus());
        collectActivity.set("sendtext", (Object)"0");
        collectActivity.set("createtime", (Object)new Date());
        collectActivity.set("modifytime", (Object)new Date());
        collectActivity.set("collectins", (Object)instanceId);
        HomCommonRepository.updateDynamicObject("hom_collect", collectActivity);
        LOG.info(MessageFormat.format("triggerCollectManageActivity end id is {0}", onbrdBillDyn.getLong("id")));
        ServiceFactory.getService(ICollectGroupStatusService.class).saveCollectGroupStatus(collectActivity);
        return collectActivity.getLong("id");
    }

    public DynamicObject buildCollectActivity(DynamicObject onbrdBillDyn) {
        onbrdBillDyn = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "", onbrdBillDyn.get("id"));
        DynamicObject collectActivity = new HRBaseServiceHelper("hom_collect").generateEmptyDynamicObject();
        collectActivity.set(ONBOARD, onbrdBillDyn.get("id"));
        collectActivity.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
        collectActivity.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
        collectActivity.set("org", onbrdBillDyn.get("org"));
        collectActivity.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        collectActivity.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("onbrdbill", onbrdBillDyn);
        try {
            Map<String, Object> resultResp = service.callRuleEngineResult(RuleEngineSceneNumberEnum.RULE_COLLECT_TEMPLATE.getSceneNumber(), onbrdBillDyn.getString("org.number"), map);
            if (HRObjectUtils.isEmpty(resultResp)) {
                collectActivity.set(TEMPLATE_RESULT, (Object)"0");
            } else {
                DynamicObject dynamicObject;
                Object result = resultResp.get("result");
                if (!HRObjectUtils.isEmpty((Object)result) && result instanceof DynamicObject) {
                    dynamicObject = (DynamicObject)result;
                    LOG.info("templateresult is {}", (Object)dynamicObject.toString());
                    dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_infocollectconfig", "", dynamicObject.getLong("id"));
                } else {
                    dynamicObject = HomCommonRepository.queryDynamicObjectByNumber("hom_infocollectconfig", "", result);
                }
                if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                    collectActivity.set(TEMPLATE_RESULT, (Object)"0");
                } else {
                    collectActivity.set("collectconfig", (Object)dynamicObject);
                    collectActivity.set("collectconfighis", (Object)dynamicObject.getLong("vid"));
                    collectActivity.set(TEMPLATE_RESULT, (Object)"1");
                }
                InfoGroupConfigEntity infoGroupConfigEntity = ServiceFactory.getService(ICollectService.class).transferDynToEntity(dynamicObject);
                collectActivity.set("submitpro", (Object)ServiceFactory.getService(ICollectService.class).getSubmitPro(infoGroupConfigEntity, onbrdBillDyn.getLong("id")));
            }
        }
        catch (Exception ex) {
            collectActivity.set(TEMPLATE_RESULT, (Object)"0");
            LOG.error("invoke rule engine error", (Throwable)ex);
        }
        return collectActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long triggerCollectApproveActivity(DynamicObject onbrdbillDyn, Long instanceId) {
        try (TXHandle txHandle = TX.required();){
            DynamicObject dynamicObject = HomCommonRepository.queryDynamicObject("hom_collect", "", new QFilter(ONBOARD, "=", (Object)onbrdbillDyn.getLong("id")));
            if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
                dynamicObject = this.buildCollectActivity(onbrdbillDyn);
            }
            dynamicObject.set("approvecreator", (Object)RequestContext.getOrCreate().getCurrUserId());
            dynamicObject.set("approvemodifier", (Object)RequestContext.getOrCreate().getCurrUserId());
            dynamicObject.set("approveins", (Object)instanceId);
            dynamicObject.set("approvecreatetime", (Object)new Date());
            dynamicObject.set("approvemodifytime", (Object)new Date());
            if (this.needApproveOrAccept(dynamicObject.getLong("collectconfig.id"), "1")) {
                dynamicObject.set("approvestatus", (Object)CollectApproveStatusEnum.APPROVING.getStatus());
            } else {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                dynamicObject.set("approvestatus", (Object)CollectApproveStatusEnum.REMIT.getStatus());
                ServiceFactory.getService(ICollectApproveLogService.class).remitApproveCollectLog(dynamicObject.getLong("id"));
                atomicBoolean.set(true);
                if (atomicBoolean.get()) {
                    IActivityDomainService.getInstance().batchConsentTask(Collections.singletonList(dynamicObject.getLong("onboard.id")), instanceId);
                }
            }
            HomCommonRepository.updateDynamicObject("hom_collect", dynamicObject);
            ServiceFactory.getService(ICollectGroupStatusService.class).saveCollectGroupStatus(dynamicObject);
            txHandle.commit();
            long l = dynamicObject.getLong("id");
            return l;
        }
        return 0L;
    }

    private boolean needApproveOrAccept(Long collectConfigId, String type) {
        DynamicObject collectConfig = HomCommonRepository.queryDynamicObjectByPk("hom_infocollectconfig", "", collectConfigId);
        if (HRObjectUtils.isEmpty((Object)collectConfig)) {
            return true;
        }
        InfoGroupConfigEntity infoGroupConfigEntity = ServiceFactory.getService(ICollectService.class).transferDynToEntity(collectConfig);
        for (InfoGroupEntity infoGroupEntity : infoGroupConfigEntity.getInfoGroupEntityList()) {
            if (!this.checkApprOrAccept(type, infoGroupEntity)) continue;
            return true;
        }
        return false;
    }

    private boolean checkApprOrAccept(String type, InfoGroupEntity infoGroupEntity) {
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
            if (!(HRStringUtils.equals((String)type, (String)"1") ? infoGroupField.isFieldApprove() : infoGroupField.isFieldRecheck())) continue;
            return true;
        }
        return false;
    }

    @Override
    public long triggerAcceptManageActivity(DynamicObject onbrdbillDyn, Long instanceId) {
        DynamicObject dyo = HomCommonRepository.queryDynamicObject("hom_collect", "", new QFilter(ONBOARD, "=", (Object)onbrdbillDyn.getLong("id")));
        if (HRObjectUtils.isEmpty((Object)dyo)) {
            dyo = this.buildCollectActivity(onbrdbillDyn);
        }
        dyo.set("acceptcreator", (Object)RequestContext.getOrCreate().getCurrUserId());
        dyo.set("acceptmodifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        dyo.set("acceptcreatetime", (Object)new Date());
        dyo.set("acceptmodifytime", (Object)new Date());
        dyo.set("accteptins", (Object)instanceId);
        dyo.set("acceptstatus", (Object)"10");
        HomCommonRepository.updateDynamicObject("hom_collect", dyo);
        ServiceFactory.getService(ICollectGroupStatusService.class).saveCollectGroupStatus(dyo);
        return dyo.getLong("id");
    }

    @Override
    public long triggerInviteManageActivity(DynamicObject onbrdbillDyn, Long instanceId) {
        long onBrdId = onbrdbillDyn.getLong("id");
        HomCommonRepository.deleteByFilter("hom_invitesendbill", new QFilter("onbrd", "=", (Object)onBrdId));
        DynamicObject onbrdInviteObj = this.initOnbrdInviteObj(onbrdbillDyn);
        onbrdInviteObj.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
        onbrdInviteObj.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
        Date date = new Date();
        onbrdInviteObj.set("createtime", (Object)date);
        onbrdInviteObj.set("modifytime", (Object)date);
        onbrdInviteObj.set("inviteins", (Object)instanceId);
        onbrdInviteObj.set("sendstatus", (Object)SendStatusEnum.WAIT_SEND.getValue());
        onbrdInviteObj.set("welcomelettersendstatus", (Object)WelcomeLetterSendStatusEnum.WAIT_SEND.getValue());
        HomCommonRepository.saveDynamicObjects("hom_invitesendbill", new DynamicObject[]{onbrdInviteObj});
        IHomConfigService configService = ServiceFactory.getService(IHomConfigService.class);
        String autoSendInvite = configService.getConfVal("auto_send_invite", "false");
        if (Boolean.parseBoolean(autoSendInvite)) {
            DynamicObject inviteSendBillObj = HomCommonRepository.queryDynamicObjectByPk("hom_invitesendbill", null, onbrdInviteObj.getLong("id"));
            boolean result = IOnbrdInviteDomainService.getInstance().sendInvite(onbrdbillDyn, inviteSendBillObj);
            if (result) {
                inviteSendBillObj.set("sendstatus", (Object)SendStatusEnum.HAS_SEND.getValue());
                inviteSendBillObj.set("sendtime", (Object)new Date());
                inviteSendBillObj.set("welcomelettersendstatus", (Object)WelcomeLetterSendStatusEnum.HAS_SEND.getValue());
                inviteSendBillObj.set("invitemessagesendstatus", (Object)InviteMessageSendStatusEnum.HAS_SEND.getValue());
                HomCommonRepository.updateDynamicObject("hom_invitesendbill", inviteSendBillObj);
            }
        }
        return onbrdInviteObj.getLong("id");
    }

    private DynamicObject initOnbrdInviteObj(DynamicObject onbrdbillDyn) {
        DynamicObject onbrdInviteObj = new HRBaseServiceHelper("hom_invitesendbill").generateEmptyDynamicObject();
        onbrdInviteObj.set("org", onbrdbillDyn.get("org"));
        onbrdInviteObj.set("onbrd", (Object)onbrdbillDyn);
        onbrdInviteObj.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
        onbrdInviteObj.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
        onbrdInviteObj.set("sendmode", (Object)SendModeEnum.MANUAL_SEND.getValue());
        onbrdInviteObj.set("loginstatus", (Object)LoginStatusEnum.NO_LOGIN.getValue());
        Object welcomelettertpl = this.onbrdToRuleEngineResult(onbrdbillDyn, RuleEngineSceneNumberEnum.WELCOME_LETTER_TPL);
        onbrdInviteObj.set("welcomelettertpl", ObjectUtils.isEmpty((Object)welcomelettertpl) ? Long.valueOf(0L) : welcomelettertpl);
        Object guidetpl = this.onbrdToRuleEngineResult(onbrdbillDyn, RuleEngineSceneNumberEnum.GUIDANCE_SCHEME);
        onbrdInviteObj.set("guidetpl", ObjectUtils.isEmpty((Object)guidetpl) ? Long.valueOf(0L) : guidetpl);
        long onbrdbillId = onbrdbillDyn.getLong("id");
        Map<Long, Long> onbrdLoginConfigIdMap = IOnbrdCommonAppService.getInstance().getOnbrdLoginConfigIdMap((Collection<Long>)ImmutableSet.of((Object)onbrdbillId));
        IOnbrdCommonAppService.getInstance().saveOnbrdLoginConfig(onbrdbillId, onbrdLoginConfigIdMap);
        onbrdInviteObj.set("loginscheme", (Object)onbrdLoginConfigIdMap.getOrDefault(onbrdbillDyn.getLong("id"), 0L));
        Object sendInviteMessageTpl = this.onbrdToRuleEngineResult(onbrdbillDyn, RuleEngineSceneNumberEnum.HOMSCE_WELCOME_MESSAGE);
        if (sendInviteMessageTpl instanceof String) {
            DynamicObject dynamicObject = HomCommonRepository.queryDynamicObject("msg_template", "id", new QFilter("number", "=", sendInviteMessageTpl));
            onbrdInviteObj.set("sendinvitemessagetpl", (Object)(StringUtils.isBlank((Object)sendInviteMessageTpl) || dynamicObject == null ? 0L : dynamicObject.getLong("id")));
        } else if (sendInviteMessageTpl instanceof Long) {
            onbrdInviteObj.set("sendinvitemessagetpl", sendInviteMessageTpl);
        }
        Object loginRemindMessageTpl = this.onbrdToRuleEngineResult(onbrdbillDyn, RuleEngineSceneNumberEnum.LOGIN_REMIND_MESSAGE);
        if (loginRemindMessageTpl instanceof String) {
            DynamicObject dynamicObject = HomCommonRepository.queryDynamicObject("msg_template", "id", new QFilter("number", "=", loginRemindMessageTpl));
            onbrdInviteObj.set("loginremindmessagetpl", (Object)(StringUtils.isBlank((Object)sendInviteMessageTpl) || dynamicObject == null ? 0L : dynamicObject.getLong("id")));
        } else if (loginRemindMessageTpl instanceof Long) {
            onbrdInviteObj.set("loginremindmessagetpl", loginRemindMessageTpl);
        }
        onbrdInviteObj.set("invitemessagesendstatus", (Object)InviteMessageSendStatusEnum.WAIT_SEND.getValue());
        return onbrdInviteObj;
    }

    private Object onbrdToRuleEngineResult(DynamicObject onbrdbillDyn, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        LOG.info(MessageFormat.format("onbrdToRuleEngineResult-start onbrd is {0}", onbrdbillDyn.getLong("id")));
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("onbrdbill", onbrdbillDyn);
        Map<String, Object> resultResp = service.callRuleEngineResult(ruleEngineSceneNumberEnum.getSceneNumber(), onbrdbillDyn.getString("org.number"), map);
        Object result = "";
        if (!HRObjectUtils.isEmpty(resultResp)) {
            result = resultResp.get("result");
        }
        LOG.info(MessageFormat.format("onbrdToRuleEngineResult-end result is {0}", result));
        return result;
    }

    @Override
    public void triggerAppointmentManageActivity(DynamicObject onbrdbillDyn, Long instanceId) {
        onbrdbillDyn.set("preenrollstatus", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue());
        onbrdbillDyn.set("preins", (Object)instanceId);
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(onbrdbillDyn);
    }

    @Override
    public void triggerCheckInActivity(DynamicObject onbrdbillDyn, Long instanceId) {
        onbrdbillDyn.set("checkinins", (Object)instanceId);
        onbrdbillDyn.set("checkinstatus", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue());
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfo(onbrdbillDyn);
    }
}

