/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.base;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.base.IBdInfoGroupService;

public class BdInfoGroupServiceImpl
implements IBdInfoGroupService {
    private static final Log LOGGER = LogFactory.getLog(BdInfoGroupServiceImpl.class);

    @Override
    public void syncNumberToHomConfig(DynamicObject infoGroup) {
        boolean isMulEntity = infoGroup.getBoolean("multipleentity");
        DynamicObjectCollection infogroupfieldList = infoGroup.getDynamicObjectCollection("infogroupfield");
        if (Boolean.FALSE.equals(isMulEntity) || HRCollUtil.isEmpty((Collection)infogroupfieldList)) {
            LOGGER.info("###BdInfoGroupServiceImpl.syncNumberToHomConfig, isMulEntity:{}, infogroupfieldList size:{}", (Object)isMulEntity, (Object)infogroupfieldList.size());
            return;
        }
        LOGGER.info("###BdInfoGroupServiceImpl.syncNumberToHomConfig start");
        QFilter qFilter = new QFilter("businesskey", "=", (Object)"hcf_multipagelist");
        String selectFields = "businesskey,businessvalue";
        DynamicObject config = HomCommonRepository.queryDynamicObject("hom_config", selectFields, qFilter);
        if (HRObjectUtils.isEmpty((Object)config)) {
            return;
        }
        String businessValue = config.getString("businessvalue");
        StringBuilder businessvalueCopy = new StringBuilder(businessValue);
        for (DynamicObject infogroupfield : infogroupfieldList) {
            String pageId = infogroupfield.getString("pageid");
            String businessvalueCopyStr = businessvalueCopy.toString();
            List<String> pageIds = Arrays.asList(businessvalueCopyStr.split(","));
            if (HRStringUtils.isBlank((CharSequence)pageId) || pageIds.contains(pageId)) continue;
            if (HRStringUtils.isBlank((CharSequence)businessvalueCopyStr)) {
                businessvalueCopy.append(pageId);
                continue;
            }
            businessvalueCopy.append(",").append(pageId);
        }
        if (!businessValue.equals(businessvalueCopy.toString())) {
            config.set("businessvalue", (Object)businessvalueCopy.toString());
            HomCommonRepository.updateDynamicObject("hom_config", config);
        }
    }
}

