/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.base;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;

public class HomConfigDomainServiceImpl
implements IHomConfigDomainService {
    @Override
    public String getConfig(String configKey) {
        return HomConfigRepository.queryValueByBusinessKey(configKey);
    }

    @Override
    public String getConfig(IFormView formView, String cacheKey, String configKey) {
        String value = formView.getPageCache().get(cacheKey);
        if (HRStringUtils.isEmpty((String)value)) {
            value = HomConfigRepository.queryValueByBusinessKey(configKey);
            formView.getPageCache().put(cacheKey, value);
        }
        return value;
    }

    @Override
    public Set<String> getConfigSet(IFormView formView, String cacheKey, String configKey) {
        String configStr = "";
        configStr = formView != null ? this.getConfig(formView, cacheKey, configKey) : this.getConfig(configKey);
        if (HRStringUtils.isEmpty((String)configStr)) {
            return new HashSet<String>();
        }
        return Arrays.stream(configStr.split(",")).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getConfigOfSet(String configKey) {
        String configStr = this.getConfig(configKey);
        if (HRStringUtils.isEmpty((String)configStr)) {
            return new HashSet<String>();
        }
        return Arrays.stream(configStr.split(",")).collect(Collectors.toSet());
    }
}

