/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.AcceptManageRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.IAcceptManageService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.entity.AcceptManageEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class AcceptManageServiceImpl
implements IAcceptManageService {
    private static final Log logger = LogFactory.getLog(AcceptManageServiceImpl.class);
    private static final String HCF_PROPERTIES = "id, degreeid, graduateschool,educationid,schoolrecord";
    private static final String GRADUATESCHOOL = "graduateschool";
    private static final Map<String, Long> EDU_CERTIFICATE_MAP = ImmutableMap.builder().put((Object)"1249297648691749896", (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1010).put((Object)"1249297648691749894", (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1020).put((Object)"1408187915879632900", (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1030).put((Object)"1408187915879632901", (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1040).put((Object)"1408187915879632899", (Object)BaseDataIdConstants.HBSS_EDUCERTTYPE_1050).build();
    private static final Map<String, LocaleString> TIP_INFO = ImmutableMap.builder().put((Object)"1371742664319348736", (Object)ResManager.getLocaleString((String)"\u79bb\u804c\u8bc1\u660e", (String)"AcceptManageServiceImpl_0", (String)"hr-hom-business")).put((Object)"1371743378382828544", (Object)ResManager.getLocaleString((String)"\u8bc1\u4e66\u9644\u4ef6", (String)"AcceptManageServiceImpl_1", (String)"hr-hom-business")).put((Object)"1371743948917223424", (Object)ResManager.getLocaleString((String)"\u8bc1\u4e66\u9644\u4ef6", (String)"AcceptManageServiceImpl_1", (String)"hr-hom-business")).build();

    @Override
    public Object[] save(DynamicObjectCollection collection) {
        return AcceptManageRepository.save(collection);
    }

    @Override
    public void showMutexMsg(IFormView formView, List<Long> failLockIds, String msg) {
        QFilter qFilter = new QFilter("id", "in", failLockIds);
        Object[] dyos = HomCommonRepository.queryDynamicObjects("hom_collect", "onboard.name", qFilter);
        if (HRArrayUtils.isEmpty((Object[])dyos)) {
            return;
        }
        StringBuilder nameStr = new StringBuilder();
        Stream.of(dyos).forEach(dyo -> nameStr.append(dyo.getLocaleString("onboard.name").getLocaleValue()).append(','));
        String name = nameStr.substring(0, nameStr.length() - 1);
        formView.showErrorNotification(MessageFormat.format(ResManager.loadKDString((String)"%1$s\u7684\u4fe1\u606f\u6b63\u5728\u88ab\u7f16\u8f91\uff0c\u65e0\u6cd5\u6267\u884c\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"AcceptManageServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]), name, msg));
    }

    @Override
    public DynamicObject[] queryByCollectByOnbrd(String selectProperties, Object onbrdId, String oderBy) {
        QFilter filter = new QFilter("onboard", "=", onbrdId);
        return AcceptManageRepository.query(selectProperties, new QFilter[]{filter}, oderBy);
    }

    @Override
    public List<AcceptManageEntity> getImgAndAttachList(InfoGroupConfigEntity infoConfig, long onbrdId, long canidateId, long collectConfigHisId, String isPass) {
        ArrayList<AcceptManageEntity> acceptlist = new ArrayList<AcceptManageEntity>(50);
        for (InfoGroupEntity infoGroup : infoConfig.getInfoGroupEntityList()) {
            logger.info("===getImgAndAttachList infoGroup.getInfoGroupNumber: {}===", (Object)infoGroup.getInfoGroupNumber());
            for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroup.getInfoGroupFieldList()) {
                logger.info("===infoGroupField.getFieldKey:{}  infoGroupField.getFieldName:{} infoGroupField.getPageKey:{} infoGroupField.isFieldRecheck:{}===", new Object[]{infoGroupField.getFieldKey(), infoGroupField.getFieldName(), infoGroupField.getPageKey(), infoGroupField.isFieldRecheck()});
                if (infoGroupField.isFieldRecheck()) {
                    logger.info("=== entry infoGroupField.getFieldKey:{}  infoGroupField.getFieldName:{} infoGroupField.getPageKey:{} infoGroupField.isFieldRecheck:{}===", new Object[]{infoGroupField.getFieldKey(), infoGroupField.getFieldName(), infoGroupField.getPageKey(), infoGroupField.isFieldRecheck()});
                    String fieldName = infoGroupField.getFieldName();
                    String fieldKey = String.valueOf(infoGroupField.getFieldId());
                    int fieldCount = infoGroupField.getFieldCount();
                    int fieldType = infoGroupField.getFieldType();
                    String fieldRecheckStand = infoGroupField.getFieldRecheckStand();
                    String entityKey = infoGroupField.getFieldKey();
                    String pageKey = infoGroupField.getPageKey();
                    this.queryImgAndAttach(onbrdId, canidateId, collectConfigHisId, isPass, acceptlist, fieldName, fieldKey, fieldCount, fieldType, fieldRecheckStand, null, entityKey, pageKey);
                    continue;
                }
                logger.info("===noentry infoGroupField.getFieldKey:{}  infoGroupField.getFieldName:{} infoGroupField.getPageKey:{} infoGroupField.isFieldRecheck:{}===", new Object[]{infoGroupField.getFieldKey(), infoGroupField.getFieldName(), infoGroupField.getPageKey(), infoGroupField.isFieldRecheck()});
            }
        }
        return acceptlist;
    }

    @Override
    public void queryImgAndAttach(long onbrdId, long canidateId, long collectConfigHisId, String isPass, List<AcceptManageEntity> acceptlist, String fieldName, String fieldKey, int fieldCount, int fieldType, String fieldRecheckStand, Long eduId, String entityKey, String pageKey) {
        switch (fieldKey) {
            case "1249297648691749896": 
            case "1249297648691749894": 
            case "1408187915879632900": 
            case "1408187915879632901": 
            case "1408187915879632899": {
                this.queryEduCertificate(onbrdId, canidateId, collectConfigHisId, fieldName, fieldKey, fieldCount, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                break;
            }
            case "1249296820501257236": 
            case "1249296820501257237": 
            case "1410112593770628096": 
            case "1410112593770628097": 
            case "1410112593770628098": {
                this.queryCancreImg(onbrdId, canidateId, collectConfigHisId, fieldName, fieldKey, "hcf_cancre", fieldCount, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                break;
            }
            case "1255756328329169921": {
                this.queryByOnbrdAttach(onbrdId, collectConfigHisId, fieldName, fieldKey, "hom_onbrdbillbase", fieldCount, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                break;
            }
            case "1333291938488558593": {
                this.queryOnbrdImg(onbrdId, collectConfigHisId, fieldName, fieldKey, "hom_onbrdbillbase", fieldCount, fieldType, fieldRecheckStand, acceptlist, isPass, entityKey);
                break;
            }
            case "1383497238491310080": {
                this.queryByBankCard(onbrdId, canidateId, collectConfigHisId, fieldName, fieldKey, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                break;
            }
            case "1371742664319348736": 
            case "1371743378382828544": 
            case "1371743948917223424": {
                this.queryCommonInfo(onbrdId, canidateId, collectConfigHisId, fieldName, pageKey, fieldKey, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                break;
            }
            default: {
                this.queryOtherFile(onbrdId, canidateId, collectConfigHisId, fieldName, pageKey, fieldKey, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
            }
        }
    }

    private void queryCommonInfo(long onbrdId, long canidateId, long collectConfigHisId, String fieldName, String pageKey, String fieldKey, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        DynamicObject[] dyos;
        if (eduId != null) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
            return;
        }
        QFilter filter = new QFilter("candidate", "=", (Object)canidateId);
        String properties = "";
        switch (fieldKey) {
            case "1371742664319348736": {
                properties = "unitname";
                break;
            }
            case "1371743378382828544": {
                properties = "language.name";
                break;
            }
            case "1371743948917223424": {
                properties = "patentname";
                break;
            }
        }
        for (DynamicObject dyo : dyos = IHcfDataDomainService.getInstance().queryHcfAttachedData(pageKey, properties, new QFilter[]{filter})) {
            long id = dyo.getLong("id");
            StringBuilder tmpFieldName = new StringBuilder();
            tmpFieldName.append(dyo.getString(properties)).append(TIP_INFO.getOrDefault(fieldKey, new LocaleString()).getLocaleValue());
            AcceptManageEntity acceptEntity = new AcceptManageEntity(tmpFieldName.toString(), fieldKey, pageKey, 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(id), "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
        }
    }

    private void queryOtherFile(long onbrdId, long canidateId, long collectConfigHisId, String fieldName, String pageKey, String fieldKey, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        if (eduId != null) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
            return;
        }
        if (pageKey.contains("hom")) {
            DynamicObject onbrdInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById(entityKey, onbrdId);
            if (!Objects.isNull(onbrdInfo)) {
                AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(onbrdId), "", fieldRecheckStand, "", entityKey);
                acceptlist.add(acceptEntity);
            }
        } else if (pageKey.contains("hcf")) {
            DynamicObject[] dyos;
            if ("hcf_cancre".equals(pageKey)) {
                this.queryCancreImg(onbrdId, canidateId, collectConfigHisId, fieldName, fieldKey, "hcf_cancre", 0, fieldType, fieldRecheckStand, acceptlist, isPass, eduId, entityKey);
                return;
            }
            QFilter filter = new QFilter("candidate", "=", (Object)canidateId);
            for (DynamicObject dyo : dyos = IHcfDataDomainService.getInstance().queryHcfAttachedData(pageKey, entityKey, new QFilter[]{filter})) {
                long id = dyo.getLong("id");
                AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(id), "", fieldRecheckStand, "", entityKey);
                acceptlist.add(acceptEntity);
            }
        }
    }

    private void queryByBankCard(long onbrdId, long canidateId, long collectConfigHisId, String fieldName, String fieldKey, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        DynamicObject[] dyos;
        String properties = "cardface";
        if (eduId != null) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, "hcf_canbankcard", 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
            return;
        }
        QFilter filter = new QFilter("candidate", "=", (Object)canidateId);
        for (DynamicObject dyo : dyos = IHcfDataDomainService.getInstance().queryHcfAttachedData("hcf_canbankcard", properties, new QFilter[]{filter})) {
            long id = dyo.getLong("id");
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, "hcf_canbankcard", 0, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(id), "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
        }
    }

    private void queryOnbrdImg(long onbrdId, long collectConfigHisId, String fieldName, String fieldKey, String pageKey, int fieldCount, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, String entityKey) {
        DynamicObject onbrdInfo = IOnbrdBillDomainService.getInstance().findOnbrdBillById("picturefield", onbrdId);
        if (!Objects.isNull(onbrdInfo)) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(onbrdId), "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
        }
    }

    private void queryEduCertificate(long onbrdId, long canidateId, long collectConfigHisId, String fieldName, String fieldKey, int fieldCount, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        DynamicObject[] dyos;
        if (eduId != null) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, "hcf_educertificate", fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
            return;
        }
        Long educationattach = EDU_CERTIFICATE_MAP.getOrDefault(fieldKey, 0L);
        logger.info("=== queryByCandidateAttach onbrdId:{} canidateId:{} collectConfigHisId:{} fieldKey:{} fieldType:{} fieldRecheckStand:{} educationattach:{} ===", new Object[]{onbrdId, canidateId, collectConfigHisId, fieldKey, fieldType, fieldRecheckStand, educationattach});
        QFilter filter = new QFilter("candidate", "=", (Object)canidateId);
        IHcfDataDomainService hcfService = IHcfDataDomainService.getInstance();
        for (DynamicObject dyo : dyos = hcfService.queryHcfAttachedData("hcf_caneduexp", HCF_PROPERTIES, new QFilter[]{filter})) {
            StringBuilder tmpStr = new StringBuilder().append(fieldName);
            String school = dyo.getDynamicObject(GRADUATESCHOOL) != null ? (!BaseDataIdConstants.HBSS_COLLEGE_OTHER_SCHOOL.equals(dyo.getLong("graduateschool.id")) ? dyo.getString("graduateschool.name") : dyo.getString("schoolrecord")) : dyo.getString("schoolrecord");
            if (!HRStringUtils.isEmpty((String)school)) {
                tmpStr.append('-').append(school);
            }
            String tmpName = tmpStr.toString();
            long id = dyo.getLong("id");
            QFilter cerFilter = new QFilter("edu.id", "=", (Object)id).and("certtype.id", "=", (Object)educationattach);
            DynamicObject[] dys = hcfService.queryHcfAttachedData("hcf_educertificate", "id", new QFilter[]{cerFilter});
            if (dys == null || dys.length <= 0) continue;
            AcceptManageEntity acceptEntity = new AcceptManageEntity(tmpName, fieldKey, "hcf_educertificate", fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(id), "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
        }
    }

    private void queryByOnbrdAttach(long onbrdId, long collectConfigHisId, String fieldName, String fieldKey, String pageKey, int fieldCount, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        if (eduId != null) {
            AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, "", fieldRecheckStand, "", entityKey);
            acceptlist.add(acceptEntity);
            return;
        }
        AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, fieldKey, pageKey, fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(onbrdId), "", fieldRecheckStand, "", entityKey);
        acceptlist.add(acceptEntity);
    }

    private void queryCancreImg(long onbrdId, long canidateId, long collectConfigHisId, String fieldName, String fieldKey, String pageKey, int fieldCount, int fieldType, String fieldRecheckStand, List<AcceptManageEntity> acceptlist, String isPass, Long eduId, String entityKey) {
        DynamicObject[] dyos2;
        String properties = "reverseimage" + "," + "faceimage" + "," + "credentialstype";
        if (eduId != null) {
            QFilter filter = new QFilter("id", "=", (Object)eduId);
            DynamicObject[] dyos2 = IHcfDataDomainService.getInstance().queryHcfAttachedData(pageKey, properties, new QFilter[]{filter});
            if (dyos2 != null && dyos2.length > 0) {
                DynamicObject creDent = dyos2[0].getDynamicObject("credentialstype");
                Long creDentId = creDent.getLong("id");
                String creDentNum = creDent.getString("number");
                String creDentName = creDent.getLocaleString("name").getLocaleValue();
                if ((fieldKey.equals("1410112593770628096") || fieldKey.equals("1410112593770628097")) && !creDentId.equals(BaseDataIdConstants.HBSS_CREDENTIALSTYPE_1010)) {
                    return;
                }
                if (fieldKey.equals("1410112593770628098") && !creDentId.equals(BaseDataIdConstants.HBSS_CREDENTIALSTYPE_1020)) {
                    return;
                }
                AcceptManageEntity acceptEntity = new AcceptManageEntity(fieldName, (String)fieldKey, pageKey, fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), eduId, creDentNum, fieldRecheckStand, creDentName, entityKey);
                acceptlist.add(acceptEntity);
            }
            return;
        }
        QFilter filter = new QFilter("candidate", "=", (Object)canidateId);
        switch (fieldKey) {
            case "1410112593770628096": 
            case "1410112593770628097": {
                filter = filter.and("credentialstype.id", "=", (Object)BaseDataIdConstants.HBSS_CREDENTIALSTYPE_1010);
                break;
            }
            case "1410112593770628098": {
                filter = filter.and("credentialstype.id", "=", (Object)BaseDataIdConstants.HBSS_CREDENTIALSTYPE_1020);
                break;
            }
            case "1249296820501257237": {
                Set<Long> configIdSet = this.getConfigIdSet("cardtype_has_rever");
                filter = filter.and("credentialstype.id", "in", configIdSet);
                break;
            }
            case "1249296820501257236": {
                Set<Long> configIdSet = this.getConfigIdSet("cardtype_has_face");
                filter = filter.and("credentialstype.id", "in", configIdSet);
                break;
            }
            default: {
                Set<Long> configIdSet = this.getConfigIdSet("cardtype_img");
                filter = filter.and("credentialstype.id", "not in", configIdSet);
                break;
            }
        }
        for (DynamicObject dyo : dyos2 = IHcfDataDomainService.getInstance().queryHcfAttachedData(pageKey, properties, new QFilter[]{filter})) {
            long id = dyo.getLong("id");
            DynamicObject creDent = dyo.getDynamicObject("credentialstype");
            String creDentNum = creDent.getString("number");
            String creDentName = creDent.getLocaleString("name").getLocaleValue();
            StringBuilder tmpFieldNames = new StringBuilder();
            String tmpFieldName = HRStringUtils.isEmpty((String)creDentName) ? fieldName : tmpFieldNames.append(creDentName).append('_').append(fieldName).toString();
            AcceptManageEntity acceptEntity = new AcceptManageEntity(tmpFieldName, (String)fieldKey, pageKey, fieldCount, fieldType, isPass, Long.valueOf(onbrdId), Long.valueOf(collectConfigHisId), Long.valueOf(id), creDentNum, fieldRecheckStand, creDentName, entityKey);
            acceptlist.add(acceptEntity);
        }
    }

    private Set<Long> getConfigIdSet(String configKey) {
        Set<String> configSet = ServiceFactory.getService(IHomConfigDomainService.class).getConfigSet(null, configKey, configKey);
        return configSet.stream().map(Long::parseLong).collect(Collectors.toSet());
    }
}

