/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectFieldVerifyService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.constant.StrRunnable;
import kd.sdk.hr.hom.common.InfoGroupEntity;
import org.apache.commons.lang3.math.NumberUtils;

public class CollectFieldVerifyServiceImpl
implements ICollectFieldVerifyService {
    private static final Log LOGGER = LogFactory.getLog(CollectFieldVerifyServiceImpl.class);
    private static final Map<Long, BiFunction<InfoGroupEntity.InfoGroupField, IDataModel, String>> fieldStrategyMap = Maps.newHashMapWithExpectedSize((int)10);
    private static final Map<Long, LocaleString> fieldVerifyDescMap = ImmutableMap.builder().put((Object)InfoGroupFieldConstants.BASE_PINYIN, (Object)ResManager.getLocaleString((String)"\u5b57\u6bb5\u201c{0}\u201d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\u3002", (String)"CollectFieldVerifyServiceImpl_0", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.BASE_ENGLISH, (Object)ResManager.getLocaleString((String)"\u5b57\u6bb5\u201c{0}\u201d\u53ea\u80fd\u7531\u82f1\u6587\u5b57\u6bcd\u7ec4\u6210\uff0c\u4e14\u5355\u8bcd\u9996\u5b57\u6bcd\u9700\u4e3a\u5927\u5199\u3002", (String)"CollectFieldVerifyServiceImpl_1", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.BASE_BIRTHDAY, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CollectFieldVerifyServiceImpl_2", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_ISSUEDATE, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_3", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_EXPIRATIONDATE, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u665a\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_4", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_BIR, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CollectFieldVerifyServiceImpl_5", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.EDU_STARTTIME, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_6", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.EDU_ENDTIME, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u665a\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_7", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.LANG_SIGNTIME, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CollectFieldVerifyServiceImpl_8", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.WORK_EXITDATE, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u665a\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_10", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.WORK_ENDDATE, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u665a\u4e8e{1}\u3002", (String)"CollectFieldVerifyServiceImpl_10", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.EXAM_TIME, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CollectFieldVerifyServiceImpl_11", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.RSMPATINV_APPLYTIME, (Object)ResManager.getLocaleString((String)"{0}\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"CollectFieldVerifyServiceImpl_12", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.BANK_ACCOUNT, (Object)ResManager.getLocaleString((String)"\u5b57\u6bb5\u201c{0}\u201d\u5e94\u4e3a13~19\u4f4d\u6570\u5b57\u3002", (String)"CollectFieldVerifyServiceImpl_3CollectFieldVerifyServiceImpl_13", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_FIRSTNAME_EN, (Object)ResManager.getLocaleString((String)"\u201c\u59d3\uff08\u62fc\u97f3/\u82f1\u6587\uff09\u201d\u4ec5\u652f\u6301\u8f93\u5165\u82f1\u6587\u3002", (String)"CollectFieldVerifyServiceImpl_14", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_SECONDNAME_EN, (Object)ResManager.getLocaleString((String)"\u201c\u540d\uff08\u62fc\u97f3/\u82f1\u6587\uff09\u201d\u4ec5\u652f\u6301\u8f93\u5165\u82f1\u6587\u3002", (String)"CollectFieldVerifyServiceImpl_17", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_FIRSTNAME_ZH, (Object)ResManager.getLocaleString((String)"\u201c\u59d3\uff08\u4e2d\u6587\uff09\u201d\u4ec5\u652f\u6301\u8f93\u5165\u4e2d\u6587\u3002", (String)"CollectFieldVerifyServiceImpl_18", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CERT_SECONDNAME_ZH, (Object)ResManager.getLocaleString((String)"\u201c\u540d\uff08\u4e2d\u6587\uff09\u201d\u4ec5\u652f\u6301\u8f93\u5165\u4e2d\u6587\u3002", (String)"CollectFieldVerifyServiceImpl_19", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CONTACT_PHONE, (Object)ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u768411\u4f4d\u6570\u5b57\u624b\u673a\u53f7\u7801\u3002", (String)"CollectFieldVerifyServiceImpl_15", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CONTACT_PEREMAIL, (Object)ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684{0}\uff0c\u683c\u5f0f\u5982\uff1aXXXXX@xx.xxx\u3002", (String)"CollectFieldVerifyServiceImpl_16", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CANFAMILY_PHONE, (Object)ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u768411\u4f4d\u6570\u5b57\u624b\u673a\u53f7\u7801\u3002", (String)"CollectFieldVerifyServiceImpl_15", (String)"hr-hom-business")).put((Object)InfoGroupFieldConstants.CANCONTACT_PHONE, (Object)ResManager.getLocaleString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u768411\u4f4d\u6570\u5b57\u624b\u673a\u53f7\u7801\u3002", (String)"CollectFieldVerifyServiceImpl_15", (String)"hr-hom-business")).build();

    public CollectFieldVerifyServiceImpl() {
        fieldStrategyMap.put(InfoGroupFieldConstants.BASE_BIRTHDAY, this::timeBeforeCurrent);
        fieldStrategyMap.put(InfoGroupFieldConstants.BASE_PINYIN, this::validateEngName);
        fieldStrategyMap.put(InfoGroupFieldConstants.BASE_ENGLISH, this::validateEngName);
        fieldStrategyMap.put(InfoGroupFieldConstants.CONTACT_PEREMAIL, this::emailValidate);
        fieldStrategyMap.put(InfoGroupFieldConstants.CONTACT_PHONE, this::phoneValidate);
        fieldStrategyMap.put(InfoGroupFieldConstants.CANCONTACT_PHONE, this::phoneValidate);
        fieldStrategyMap.put(InfoGroupFieldConstants.CANFAMILY_PHONE, this::phoneValidate);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_BIR, this::timeBeforeCurrent);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_FIRSTNAME_EN, this::validateEngName);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_SECONDNAME_EN, this::validateEngName);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_FIRSTNAME_ZH, this::validateZhName);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_SECONDNAME_ZH, this::validateZhName);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_ISSUEDATE, this::certTimeRange);
        fieldStrategyMap.put(InfoGroupFieldConstants.CERT_EXPIRATIONDATE, this::certTimeRange);
        fieldStrategyMap.put(InfoGroupFieldConstants.EDU_STARTTIME, this::eduTimeRange);
        fieldStrategyMap.put(InfoGroupFieldConstants.EDU_ENDTIME, this::eduTimeRange);
        fieldStrategyMap.put(InfoGroupFieldConstants.WORK_ENDDATE, this::workEndDate);
        fieldStrategyMap.put(InfoGroupFieldConstants.WORK_EXITDATE, this::workExitDate);
        fieldStrategyMap.put(InfoGroupFieldConstants.LANG_SIGNTIME, this::timeBeforeAndEqualCurrent);
        fieldStrategyMap.put(InfoGroupFieldConstants.BANK_ACCOUNT, this::bankValidate);
        fieldStrategyMap.put(InfoGroupFieldConstants.RSMPATINV_APPLYTIME, this::timeBeforeAndEqualCurrent);
    }

    @Override
    public String fieldVerify(InfoGroupEntity.InfoGroupField field, IFormView formView, List<InfoGroupEntity.InfoGroupField> infoGroupFieldList) {
        String descStr = fieldStrategyMap.getOrDefault(field.getFieldId(), this::defaultVerify).apply(field, formView.getModel());
        HashMap<Long, StrRunnable> map = new HashMap<Long, StrRunnable>();
        ICollectService collectService = ServiceFactory.getService(ICollectService.class);
        map.put(InfoGroupFieldConstants.CERT_ISSUEDATE, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        map.put(InfoGroupFieldConstants.CERT_EXPIRATIONDATE, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.CERT_ISSUEDATE);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        map.put(InfoGroupFieldConstants.EDU_STARTTIME, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.EDU_ENDTIME);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        map.put(InfoGroupFieldConstants.CERT_FIRSTNAME_EN, () -> descStr);
        map.put(InfoGroupFieldConstants.CERT_SECONDNAME_EN, () -> descStr);
        map.put(InfoGroupFieldConstants.CERT_FIRSTNAME_ZH, () -> descStr);
        map.put(InfoGroupFieldConstants.CERT_SECONDNAME_ZH, () -> descStr);
        map.put(InfoGroupFieldConstants.EDU_ENDTIME, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.EDU_STARTTIME);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        map.put(InfoGroupFieldConstants.WORK_EXITDATE, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.WORK_STARTDATE);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        map.put(InfoGroupFieldConstants.WORK_ENDDATE, () -> {
            InfoGroupEntity.InfoGroupField infoGroupField = collectService.findInfoGroupFieldById(infoGroupFieldList, InfoGroupFieldConstants.WORK_STARTDATE);
            if (infoGroupField == null) {
                return null;
            }
            return MessageFormat.format(descStr, field.getFieldName(), infoGroupField.getFieldName());
        });
        return map.getOrDefault(field.getFieldId(), () -> MessageFormat.format(descStr, field.getFieldName())).run();
    }

    private String bankValidate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        String bankAccount = dataModel.getDataEntity().getString("field" + field.getFieldId());
        if (HRStringUtils.isEmpty((String)bankAccount)) {
            return "";
        }
        String trim = bankAccount.replaceAll(" ", "");
        dataModel.getDataEntity().set("field" + field.getFieldId(), (Object)trim);
        int length = trim.length();
        return length >= 13 && length <= 19 && NumberUtils.isDigits((String)trim) ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String workExitDate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        Date workStartDate;
        Date workExitDate = dataModel.getDataEntity().getDate("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)workExitDate)) {
            return "";
        }
        if (!HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.WORK_STARTDATE)) && !HRObjectUtils.isEmpty((Object)(workStartDate = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.WORK_STARTDATE)))) {
            return workExitDate.compareTo(workStartDate) > 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
        }
        return "";
    }

    private String workEndDate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        Date workStartDate;
        Date workEndDate = dataModel.getDataEntity().getDate("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)workEndDate)) {
            return "";
        }
        if (!HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.WORK_STARTDATE)) && !HRObjectUtils.isEmpty((Object)(workStartDate = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.WORK_STARTDATE)))) {
            return workEndDate.compareTo(workStartDate) >= 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
        }
        return "";
    }

    private String workStartDate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        Date workEndDate;
        Date workStartDate = dataModel.getDataEntity().getDate("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)workStartDate)) {
            return "";
        }
        if (!HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.WORK_ENDDATE)) && !HRObjectUtils.isEmpty((Object)(workEndDate = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.WORK_ENDDATE))) && workEndDate.compareTo(workStartDate) <= 0) {
            return fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
        }
        return "";
    }

    private String emailValidate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        String email = dataModel.getDataEntity().getString("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)email)) {
            return "";
        }
        if (email.length() > 100) {
            String msg = ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u90ae\u7bb1\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0\uff0c100]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdCommonAppServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]);
            return msg;
        }
        return StringUtils.isEmail((String)email) ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String phoneValidate(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        String phone = dataModel.getDataEntity().getString("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)phone)) {
            return "";
        }
        Optional<String> validateResult = IOnbrdCommonAppService.getInstance().validatePhone(phone, field.getFieldName());
        return validateResult.orElse("");
    }

    private String certTimeRange(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.CERT_ISSUEDATE)) || HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE))) {
            return "";
        }
        Date eduStartTime = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.CERT_ISSUEDATE);
        Date eduEndTime = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
        if (HRObjectUtils.isEmpty((Object)eduStartTime) || HRObjectUtils.isEmpty((Object)eduEndTime)) {
            return "";
        }
        return eduStartTime.compareTo(eduEndTime) <= 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String eduTimeRange(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.EDU_STARTTIME)) || HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.EDU_ENDTIME))) {
            return "";
        }
        Date eduStartTime = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.EDU_STARTTIME);
        Date eduEndTime = dataModel.getDataEntity().getDate("field" + InfoGroupFieldConstants.EDU_ENDTIME);
        if (HRObjectUtils.isEmpty((Object)eduStartTime) || HRObjectUtils.isEmpty((Object)eduEndTime)) {
            return "";
        }
        return eduStartTime.compareTo(eduEndTime) < 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String validateEngName(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        String engName = dataModel.getDataEntity().getString("field" + field.getFieldId());
        if (HRStringUtils.isEmpty((String)engName)) {
            return "";
        }
        String regStr = "^[a-zA-Z\\s.]*$";
        Pattern pattern = Pattern.compile(regStr);
        return pattern.matcher(engName).matches() ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String validateZhName(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        String zhName = dataModel.getDataEntity().getString("field" + field.getFieldId());
        if (HRStringUtils.isEmpty((String)zhName)) {
            return "";
        }
        String regStr = "^[\\u4e00-\\u9fa5]+";
        Pattern pattern = Pattern.compile(regStr);
        return pattern.matcher(zhName).matches() ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String timeBeforeCurrent(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        Date fieldValue = dataModel.getDataEntity().getDate("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)fieldValue)) {
            return "";
        }
        return new Date().compareTo(fieldValue) > 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String timeBeforeAndEqualCurrent(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        Date fieldValue = dataModel.getDataEntity().getDate("field" + field.getFieldId());
        if (HRObjectUtils.isEmpty((Object)fieldValue)) {
            return "";
        }
        return new Date().compareTo(fieldValue) >= 0 ? "" : fieldVerifyDescMap.getOrDefault(field.getFieldId(), new LocaleString()).getLocaleValue();
    }

    private String defaultVerify(InfoGroupEntity.InfoGroupField field, IDataModel dataModel) {
        return "";
    }

    @Override
    public boolean fieldIsEmpty(InfoGroupEntity.InfoGroupField field, IFormView formView) {
        long baseDataId;
        IDataModel dataModel = formView.getModel();
        IDataEntityProperty property = dataModel.getProperty("field" + field.getFieldId());
        if (field.getFieldType() == 2) {
            boolean empty = false;
            String attachStr = formView.getPageCache().get("field" + field.getFieldId());
            LOGGER.info("attach verify cache:{}", (Object)attachStr);
            if (HRStringUtils.isEmpty((String)attachStr)) {
                empty = true;
            } else {
                List attachList = (List)SerializationUtils.fromJsonString((String)attachStr, List.class);
                if (CollectionUtils.isEmpty((Collection)attachList)) {
                    empty = true;
                }
            }
            return empty;
        }
        if (HRObjectUtils.isEmpty((Object)dataModel.getDataEntityType().getProperties().get((Object)("field" + field.getFieldId())))) {
            return false;
        }
        Object fieldValue = property instanceof BasedataProp ? ((baseDataId = dataModel.getDataEntity().getLong("field" + field.getFieldId() + "_id")) == 0L ? null : Long.valueOf(baseDataId)) : dataModel.getValue("field" + field.getFieldId());
        if (field.getFieldId().equals(InfoGroupFieldConstants.RSM_PTDATA)) {
            return HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + field.getFieldId() + "_ptstartdate")) || HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + field.getFieldId() + "_ptendingdate"));
        }
        return fieldValue == null || HRStringUtils.isEmpty((String)fieldValue.toString());
    }

    @Override
    public boolean fieldVerifyMustInput(InfoGroupEntity.InfoGroupField field, IFormView formView) {
        return field.isFieldMustInput() && this.fieldIsEmpty(field, formView);
    }
}

