/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectMatchTemplateService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class CollectMatchTemplateServiceImpl
implements ICollectMatchTemplateService {
    private static final Log LOGGER = LogFactory.getLog(CollectMatchTemplateServiceImpl.class);

    @Override
    public boolean matchCollectTemplate(Long onboardId, Long activityId) {
        DynamicObject onbrdbillDyn = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "", onboardId);
        DynamicObject activityDynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_collect", "", activityId);
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("onbrdbill", onbrdbillDyn);
        try {
            DynamicObject dynamicObject;
            Map<String, Object> resultResp = service.callRuleEngineResult(RuleEngineSceneNumberEnum.RULE_COLLECT_TEMPLATE.getSceneNumber(), onbrdbillDyn.getString("org.number"), map);
            if (HRObjectUtils.isEmpty(resultResp)) {
                return false;
            }
            Object result = resultResp.get("result");
            if (!HRObjectUtils.isEmpty((Object)result) && result instanceof DynamicObject) {
                dynamicObject = (DynamicObject)result;
                dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hom_infocollectconfig", "", dynamicObject.getLong("id"));
            } else {
                dynamicObject = HomCommonRepository.queryDynamicObjectByNumber("hom_infocollectconfig", "", result);
            }
            if (!"1".equals(dynamicObject.getString("enable"))) {
                LOGGER.warn(result + "template is not enable");
                return false;
            }
            this.setCollectTemplate(activityDynamicObject, dynamicObject);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("invoke rule engine error", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setCollectTemplate(DynamicObject collectActivity, Long templateId) {
        DynamicObject templateDy = HomCommonRepository.queryDynamicObjectByPk("hom_infocollectconfig", "", templateId);
        this.setCollectTemplate(collectActivity, templateDy);
    }

    private void setCollectTemplate(DynamicObject collectActivity, DynamicObject templateDy) {
        long onbrdId = collectActivity.getLong("onboard.id");
        collectActivity.set("collectconfig", (Object)templateDy.getLong("id"));
        collectActivity.set("collectconfighis", (Object)templateDy.getLong("vid"));
        collectActivity.set("templateresult", (Object)"1");
        HomCommonRepository.updateDynamicObject("hom_collect", collectActivity);
        InfoGroupConfigEntity infoGroupConfigEntity = ServiceFactory.getService(ICollectService.class).transferDynToEntity(templateDy);
        collectActivity.set("submitpro", (Object)ServiceFactory.getService(ICollectService.class).getSubmitPro(infoGroupConfigEntity, onbrdId));
        HomCommonRepository.updateDynamicObject("hom_collect", collectActivity);
        ServiceFactory.getService(ICollectGroupStatusService.class).saveCollectGroupStatus(collectActivity);
    }
}

