/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.page.EduPageServiceImpl;
import kd.hr.hom.business.application.page.ICertificatePageService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.collect.ICollectValidateService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.enums.InfoGroupCertTypeEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class CollectValidateServiceImpl
implements ICollectValidateService {
    private static final int CERT_VALIDATE = 0;
    private static final int CERT_TYPE_ERROR = 1;
    private static final int CERT_VALUE_ERROR = 2;
    private static final int CERT_FORMAT_ERROR = 3;
    private static final int CERT_PERSON_VALUE_ERROR = 4;

    @Override
    public void dealEduInfoGroup(IDataModel dataModel, IFormView formView) {
        formView.setVisible(Boolean.FALSE, new String[]{"fieldboard" + InfoGroupFieldConstants.OTHER_SCHOOL});
        if (HRObjectUtils.isEmpty((Object)dataModel.getDataEntity().getDynamicObjectType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME))) || HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME))) {
            return;
        }
        Long eduSchoolNameId = dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME + ".id");
        if (InfoGroupFieldConstants.OTHER_SCHOOL_ID.equals(eduSchoolNameId)) {
            formView.setVisible(Boolean.TRUE, new String[]{"fieldboard" + InfoGroupFieldConstants.OTHER_SCHOOL});
        }
    }

    @Override
    public void dealLanguageInfoGroup(IDataModel dataModel, IFormView formView) {
        DataEntityPropertyCollection properties = dataModel.getDataEntityType().getProperties();
        formView.setVisible(Boolean.FALSE, new String[]{"fieldboard" + InfoGroupFieldConstants.LANG_OTHER_CERT});
        if (HRObjectUtils.isEmpty((Object)properties.get((Object)("field" + InfoGroupFieldConstants.LANG_CERT)))) {
            return;
        }
        String langOtherCertFieldName = "field" + InfoGroupFieldConstants.LANG_OTHER_CERT;
        if (HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + InfoGroupFieldConstants.LANG_CERT)) && !HRObjectUtils.isEmpty((Object)properties.get((Object)langOtherCertFieldName))) {
            dataModel.setValue(langOtherCertFieldName, null);
            return;
        }
        long langCertId = dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.LANG_CERT + "_id");
        if (InfoGroupFieldConstants.OTHER_LANGCERT_ID.equals(langCertId)) {
            formView.setVisible(Boolean.TRUE, new String[]{"fieldboard" + InfoGroupFieldConstants.LANG_OTHER_CERT});
        }
    }

    @Override
    public void dealEduLevel(IDataModel dataModel, IFormView formView) {
        String[] fieldList = InfoGroupFieldConstants.EDU_FIELD_SET.stream().map(field -> "fieldboard" + field).collect(Collectors.toList()).toArray(new String[0]);
        formView.setVisible(Boolean.TRUE, fieldList);
        if (HRObjectUtils.isEmpty((Object)dataModel.getDataEntity().getDynamicObjectType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDUCATIONID))) || HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + InfoGroupFieldConstants.EDUCATIONID))) {
            return;
        }
        String educationNumber = dataModel.getDataEntity().getString("field" + InfoGroupFieldConstants.EDUCATIONID + ".number");
        EduPageServiceImpl service = new EduPageServiceImpl();
        String educationId = service.educationNumberToId(educationNumber);
        Set<String> configSet = ServiceFactory.getService(IHomConfigDomainService.class).getConfigSet(formView, "lower_edu_id", "lower_edu_id");
        if (configSet.contains(educationId)) {
            if (!HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME))) {
                dataModel.setValue("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME, (Object)InfoGroupFieldConstants.OTHER_SCHOOL_ID);
            }
            formView.setVisible(Boolean.FALSE, fieldList);
        }
    }

    @Override
    public void getEduVisibleField(List<String> result, IDataModel dataModel) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME)) || 0L == dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME + "_id")) {
            return;
        }
        dataModel.setValue("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME, (Object)dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME + "_id"));
        Long eduSchoolNameId = dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.EDU_SCHOOLNAME + ".id");
        if (eduSchoolNameId == 0L) {
            return;
        }
        if (!InfoGroupFieldConstants.OTHER_SCHOOL_ID.equals(eduSchoolNameId)) {
            result.add("field" + InfoGroupFieldConstants.OTHER_SCHOOL);
        } else {
            result.remove("field" + InfoGroupFieldConstants.OTHER_SCHOOL);
        }
    }

    @Override
    public void getEduLevel(List<String> result, IDataModel dataModel, IFormView formView) {
        List fieldList = InfoGroupFieldConstants.EDU_FIELD_SET.stream().map(field -> "field" + field).collect(Collectors.toList());
        if (HRObjectUtils.isEmpty((Object)dataModel.getDataEntity().getDynamicObjectType().getProperties().get((Object)("field" + InfoGroupFieldConstants.EDUCATIONID))) || HRObjectUtils.isEmpty((Object)dataModel.getValue("field" + InfoGroupFieldConstants.EDUCATIONID))) {
            return;
        }
        String educationNumber = dataModel.getDataEntity().getString("field" + InfoGroupFieldConstants.EDUCATIONID + ".number");
        EduPageServiceImpl service = new EduPageServiceImpl();
        String educationId = service.educationNumberToId(educationNumber);
        Set<String> configSet = ServiceFactory.getService(IHomConfigDomainService.class).getConfigSet(formView, "lower_edu_id", "lower_edu_id");
        if (configSet.contains(educationId)) {
            result.addAll(fieldList);
        }
    }

    @Override
    public void getLangVisibleField(List<String> result, IDataModel dataModel) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("field" + InfoGroupFieldConstants.LANGUAGE_TYPE)) || 0L == dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.LANGUAGE_TYPE + "_id")) {
            result.add("field" + InfoGroupFieldConstants.LANG_OTHER_CERT);
            return;
        }
        dataModel.beginInit();
        long otherCertTypeId = dataModel.getDataEntity().getLong("field" + InfoGroupFieldConstants.LANGUAGE_TYPE + "_id");
        dataModel.setValue("field" + InfoGroupFieldConstants.LANGUAGE_TYPE, (Object)otherCertTypeId);
        dataModel.endInit();
        if (!InfoGroupFieldConstants.OTHER_LANGCERT_ID.equals(otherCertTypeId)) {
            result.add("field" + InfoGroupFieldConstants.LANG_OTHER_CERT);
        } else {
            result.remove("field" + InfoGroupFieldConstants.LANG_OTHER_CERT);
        }
    }

    @Override
    public void getCertVisibleField(List<String> result, IDataModel dataModel, IFormView formView) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("fieldcerttype")) || HRObjectUtils.isEmpty((Object)dataModel.getValue("fieldcerttype"))) {
            return;
        }
        Map infoGroupConfigFieldCertMap = (Map)JSON.parseObject((String)formView.getPageCache().get("certConfigMap"), Map.class);
        Collection values = infoGroupConfigFieldCertMap.values();
        ArrayList allFieldList = new ArrayList();
        values.forEach(allFieldList::addAll);
        String fieldCertType = dataModel.getValue("fieldcerttype").toString();
        ArrayList showFiledList = (ArrayList)infoGroupConfigFieldCertMap.getOrDefault(fieldCertType, infoGroupConfigFieldCertMap.get("9999"));
        if (CollectionUtils.isEmpty((Collection)showFiledList)) {
            showFiledList = new ArrayList();
        }
        if (dataModel.getDataEntity().containsProperty("field" + InfoGroupFieldConstants.CERT_ISPERMANENT) && dataModel.getDataEntity().getBoolean("field" + InfoGroupFieldConstants.CERT_ISPERMANENT)) {
            showFiledList.remove("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
        }
        allFieldList.removeAll(showFiledList);
        if (!CollectionUtils.isEmpty(allFieldList)) {
            result.addAll(allFieldList);
        }
    }

    @Override
    public boolean validateEngName(IDataModel dataModel) {
        String engName = (String)dataModel.getValue("field" + InfoGroupFieldConstants.BASE_ENGLISH);
        if (HRStringUtils.isEmpty((String)engName)) {
            return false;
        }
        String regStr = "^[a-zA-Z\\s.]*$";
        Pattern pattern = Pattern.compile(regStr);
        if (pattern.matcher(engName).matches()) {
            String engNameStr = engName.trim().replaceAll("\\s+", " ");
            String[] engNames = engNameStr.split(" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (String name : engNames) {
                String first = name.substring(0, 1).toUpperCase(Locale.ROOT);
                stringBuilder.append(first);
                if (StringUtils.isNotBlank((CharSequence)name.substring(1))) {
                    String after = name.substring(1).toLowerCase(Locale.ROOT);
                    stringBuilder.append(after);
                }
                stringBuilder.append(' ');
            }
            dataModel.setValue("field" + InfoGroupFieldConstants.BASE_ENGLISH, (Object)stringBuilder.toString().trim());
            return false;
        }
        return true;
    }

    @Override
    public void dealCertField(IDataModel dataModel, IFormView formView) {
        if (HRObjectUtils.isEmpty((Object)dataModel.getProperty("fieldcerttype")) || HRObjectUtils.isEmpty((Object)dataModel.getValue("fieldcerttype"))) {
            return;
        }
        String fieldCertType = dataModel.getValue("fieldcerttype").toString();
        Map infoGroupConfigFieldCertMap = (Map)JSON.parseObject((String)formView.getPageCache().get("certConfigMap"), Map.class);
        Collection values = infoGroupConfigFieldCertMap.values();
        ArrayList allFieldList = new ArrayList();
        values.forEach(allFieldList::addAll);
        List<String> allFieldIdList = allFieldList.stream().map(fieldKey -> fieldKey.replace("field", "fieldboard")).collect(Collectors.toList());
        formView.setVisible(Boolean.FALSE, allFieldIdList.toArray(new String[0]));
        List showFieldList = (List)infoGroupConfigFieldCertMap.getOrDefault(fieldCertType, infoGroupConfigFieldCertMap.get("9999"));
        if (CollectionUtils.isEmpty((Collection)showFieldList)) {
            return;
        }
        List<String> showList = showFieldList.stream().map(fieldKey -> fieldKey.replace("field", "fieldboard")).collect(Collectors.toList());
        if (dataModel.getDataEntity().containsProperty("field" + InfoGroupFieldConstants.CERT_ISPERMANENT) && dataModel.getDataEntity().getBoolean("field" + InfoGroupFieldConstants.CERT_ISPERMANENT)) {
            showList.remove("fieldboard" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
        }
        formView.setVisible(Boolean.TRUE, showList.toArray(new String[0]));
    }

    @Override
    public int certValidate(IDataModel dataModel, IFormView formView, boolean isAdd, String originCertType, String originCertValue, List<Object> certTypeSet, List<Object> certValueSet, Long onboardId) {
        String fieldcerttype = dataModel.getValue("fieldcerttype").toString();
        String fieldcertvalue = dataModel.getValue("field" + InfoGroupFieldConstants.CERT_NUMBER).toString();
        if (certTypeSet.contains(fieldcerttype) && !InfoGroupCertTypeEnum.PASSPORT.getId().toString().equalsIgnoreCase(fieldcerttype)) {
            return 1;
        }
        if (InfoGroupCertTypeEnum.PASSPORT.getId().toString().equalsIgnoreCase(fieldcerttype) && certValueSet.contains(fieldcertvalue)) {
            return 3;
        }
        DynamicObject dynamicObjectPage = dataModel.getDataEntity();
        dataModel.setValue("field" + InfoGroupFieldConstants.CERT_TYPE, dynamicObjectPage.get("field" + InfoGroupFieldConstants.CERT_TYPE + "_id"));
        DynamicObject credentialsType = dynamicObjectPage.getDynamicObject("field" + InfoGroupFieldConstants.CERT_TYPE);
        String credentialsNumber = dynamicObjectPage.getString("field" + InfoGroupFieldConstants.CERT_NUMBER);
        boolean flag = ServiceFactory.getService(ICertificatePageService.class).validateCreNumber(credentialsType, credentialsNumber);
        if (!flag) {
            return 3;
        }
        if (isAdd || !fieldcerttype.equals(originCertType) || !fieldcertvalue.equals(originCertValue)) {
            return IOnbrdBillDomainService.getInstance().certInfoUniqCheck(fieldcerttype, fieldcertvalue, onboardId, formView);
        }
        return 0;
    }

    @Override
    public boolean certNumberValidate(int certResult, IFormView formView, BeforeClickEvent evt, InfoGroupEntity infoGroupEntity) {
        boolean result = false;
        if (1 == certResult) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8bc1\u4ef6\u7c7b\u578b\u5df2\u6dfb\u52a0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CollectActivityAddPlugin_1", (String)"hr-hom-business", (Object[])new Object[0]));
            evt.setCancel(true);
            result = true;
        } else if (2 == certResult) {
            evt.setCancel(true);
            result = true;
        } else if (3 == certResult) {
            InfoGroupEntity.InfoGroupField certField = ServiceFactory.getService(ICollectService.class).findInfoGroupFieldById(infoGroupEntity.getInfoGroupFieldList(), InfoGroupFieldConstants.CERT_NUMBER);
            formView.showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CollectActivityAddPlugin_10", (String)"hr-hom-business", (Object[])new Object[0]), certField.getFieldName()));
            evt.setCancel(true);
            result = true;
        } else if (4 == certResult) {
            evt.setCancel(true);
            result = true;
        }
        return result;
    }
}

