/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.collect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.LogPrivacyUtil;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectFieldVerifyService;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ISyncCollectToHcf;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.entity.InfoGroupAttachEntity;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class SyncCollectToHcfImpl
implements ISyncCollectToHcf {
    private static final Log LOGGER = LogFactory.getLog(SyncCollectToHcfImpl.class);
    private static final Set<String> IGNORE_FIELD = Sets.newHashSet((Object[])new String[]{"id", "sourcevid"});

    @Override
    public void saveCollectToHcf(InfoGroupConfigEntity infoGroupConfig, IFormView formView, DynamicObject dataEntity) {
        infoGroupConfig.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            ServiceFactory.getService(ICollectGroupStatusService.class).completeCollectGroup(Collections.singletonList(infoGroupEntity.getInfoGroupId()), dataEntity.getLong("id"));
            if (infoGroupEntity.isMultipleEntity()) {
                return;
            }
            this.saveCollectToHcfByInfoGroup(infoGroupConfig, formView, dataEntity.getLong("onboard.id"), infoGroupEntity.getInfoGroupNumber(), new AtomicBoolean(false));
        });
    }

    @Override
    public void saveAddress(String pageKey, Long candidateId, IDataModel childModel, String addressType, DynamicObjectCollection hisMultiRowEntity, Map<String, List<DynamicObject>> collect) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
        List<DynamicObject> oldDys = collect.get(addressType);
        if (!CollectionUtils.isEmpty(oldDys)) {
            dyn = HOMObjectUtils.copyHcfHisDynamicObject((String)pageKey, (DynamicObject)oldDys.get(0));
        }
        dyn.set("boid", null);
        dyn.set("candidate", (Object)candidateId);
        dyn.set("addresstype", (Object)IHcfDataDomainService.getInstance().getAddressTypeById(Long.parseLong(addressType)));
        String confVal = ServiceFactory.getService(IHomConfigService.class).getConfVal("ADDRESS_ID_MAP", "");
        if (HRStringUtils.isNotEmpty((String)confVal)) {
            Map map = (Map)JSONObject.parseObject((String)confVal, Map.class);
            InfoGroupFieldConstants.ADDRESS_ID_MAP.putAll(map);
        }
        boolean isSave = false;
        for (Map.Entry stringLongEntry : InfoGroupFieldConstants.ADDRESS_ID_MAP.entrySet()) {
            if (!((String)stringLongEntry.getKey()).startsWith(addressType)) continue;
            Long infoFieldId = (Long)stringLongEntry.getValue();
            IDataEntityProperty infoDataEntityProperty = (IDataEntityProperty)childModel.getDataEntityType().getProperties().get((Object)("field" + infoFieldId));
            if (HRObjectUtils.isEmpty((Object)infoDataEntityProperty)) {
                if (CollectionUtils.isEmpty(oldDys)) continue;
                isSave = true;
                continue;
            }
            String replaceKey = ((String)stringLongEntry.getKey()).replace(addressType + "_", "");
            if (HRObjectUtils.isEmpty((Object)childModel.getDataEntityType().getProperties().get((Object)("field" + infoFieldId + "_id")))) {
                dyn.set(replaceKey, childModel.getDataEntity().get("field" + infoFieldId));
                if (!HRStringUtils.isNotEmpty((String)childModel.getDataEntity().getString("field" + infoFieldId))) continue;
                isSave = true;
                continue;
            }
            long basedataId = childModel.getDataEntity().getLong("field" + infoFieldId + "_id");
            dyn.set(replaceKey, (Object)basedataId);
            if (dyn.getDataEntityType().getProperties().get((Object)(replaceKey + "_id")) != null) {
                dyn.set(replaceKey + "_id", (Object)basedataId);
            }
            if (0L == basedataId) continue;
            isSave = true;
        }
        if (isSave) {
            hisMultiRowEntity.add((Object)dyn);
        }
    }

    @Override
    public void fillEntityMap(Map<String, List<InfoGroupEntity.InfoGroupField>> entityMap, InfoGroupEntity.InfoGroupField field, String pageKey) {
        List<InfoGroupEntity.InfoGroupField> fieldEntityList = entityMap.get(pageKey);
        if (fieldEntityList == null || fieldEntityList.size() == 0) {
            fieldEntityList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        }
        fieldEntityList.add(field);
        entityMap.put(pageKey, fieldEntityList);
    }

    @Override
    public long saveMultiEntityByInfoGroup(InfoGroupEntity infoGroupEntity, IFormView formView, Long candidateId, List<String> visibleFiledList) {
        IDataModel model = formView.getModel();
        HashMap hcfMultiMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap keyIndexMap = Maps.newHashMapWithExpectedSize((int)3);
        infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
            String pageKey = field.getPageKey();
            if (pageKey.contains("hcf_")) {
                this.fillEntityMap(hcfMultiMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            }
        });
        List finalVisibleFiledList = visibleFiledList.stream().map(visibleField -> visibleField.replaceAll("entry", "").replaceAll("field", "")).collect(Collectors.toList());
        List cacheAttach = JSONArray.parseArray((String)formView.getPageCache().get("cacheAttach"), InfoGroupAttachEntity.class);
        Map<String, List> cacheAttachMap = cacheAttach.stream().collect(Collectors.toMap(InfoGroupAttachEntity::getKey, InfoGroupAttachEntity::getAttachments));
        LOGGER.info("InfoGroupDynViewPlugin saveMultiEntityByInfoGroup attach json : {}", (Object)SerializationUtils.toJsonString(cacheAttachMap));
        AtomicReference<Long> addId = new AtomicReference<Long>(0L);
        Set<String> noHisTable = ServiceFactory.getService(IHomConfigDomainService.class).getConfigOfSet("no_his_table");
        for (Map.Entry stringListEntry : hcfMultiMap.entrySet()) {
            Map<String, Object> eduMap;
            String pageKey = (String)stringListEntry.getKey();
            if ("hcf_educertificate".equals(pageKey)) continue;
            DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
            List fieldList = (List)stringListEntry.getValue();
            HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
            DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
            DynamicObjectCollection multiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
            HashMap dynamicObjectMap = new HashMap();
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                if (noHisTable.contains(pageKey)) {
                    multiRowEntity.forEach(row -> IHomToHcfAppService.getInstance().deleteByIdNoHis(row.getLong("id"), pageKey));
                } else {
                    IHomToHcfAppService.getInstance().deleteRowEntity(pageKey, new ArrayList<Long>(Collections.singleton(candidateId)));
                }
                if (!"hcf_caneduexp".equals(pageKey)) continue;
                HashSet deleteIdSet = Sets.newHashSet();
                multiRowEntity.forEach(dynamicObject -> deleteIdSet.add(dynamicObject.getLong("id")));
                QFilter qFilter = new QFilter("edu", "in", (Object)deleteIdSet);
                DynamicObjectCollection eduCertificate = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_educertificate", new QFilter[]{qFilter});
                eduCertificate.forEach(dynamicObject -> {
                    IHomToHcfAppService.getInstance().deleteById(dynamicObject.getLong("id"), "hcf_educertificate");
                    AttachmentServiceHelper.remove((String)"hcf_educertificate", (Object)dynamicObject.getLong("id"));
                });
                continue;
            }
            List entryIdList = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong("entryid")).collect(Collectors.toList());
            HashSet deleteIdSet = Sets.newHashSet();
            multiRowEntity.forEach(dynamicObject -> {
                if (entryIdList.contains(dynamicObject.getLong("id"))) {
                    dynamicObjectMap.put(dynamicObject.getLong("id"), dynamicObject);
                    return;
                }
                deleteIdSet.add(dynamicObject.getLong("id"));
                IHomToHcfAppService.getInstance().deleteById(dynamicObject.getLong("id"), pageKey);
            });
            if (!CollectionUtils.isEmpty((Collection)deleteIdSet) && "hcf_caneduexp".equals(pageKey)) {
                QFilter qFilter = new QFilter("edu", "in", (Object)deleteIdSet);
                DynamicObjectCollection eduCertificate = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_educertificate", new QFilter[]{qFilter});
                eduCertificate.forEach(dynamicObject -> {
                    IHomToHcfAppService.getInstance().deleteById(dynamicObject.getLong("id"), "hcf_educertificate");
                    AttachmentServiceHelper.remove((String)"hcf_educertificate", (Object)dynamicObject.getLong("id"));
                });
            }
            AtomicInteger index = new AtomicInteger();
            dynamicObjectCollection.forEach(dyObject -> this.saveInfoGroupData(formView, candidateId, keyIndexMap, finalVisibleFiledList, (Map<String, List<Map<String, Object>>>)cacheAttachMap, addId, pageKey, hisMultiRowEntity, fieldList, dynamicObjectMap, index, (DynamicObject)dyObject));
            map.put(candidateId, hisMultiRowEntity);
            if (noHisTable.contains(pageKey)) {
                IHomToHcfAppService.getInstance().saveMultiRowEntity(map, pageKey);
                continue;
            }
            HashMap<String, DynamicObjectCollection> mapParam = new HashMap<String, DynamicObjectCollection>(2);
            mapParam.put(pageKey, hisMultiRowEntity);
            ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>(1);
            list.add(mapParam);
            try {
                LOGGER.info("kd.hr.hom.business.domain.service.impl.collect.SyncCollectToHcfImpl - saveMultiEntityByInfoGroup 296" + LogPrivacyUtil.filterPrivacyProp(mapParam));
            }
            catch (Exception e) {
                LOGGER.warn((Throwable)e);
            }
            if (((Boolean)(eduMap = IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list)).get("success")).booleanValue()) continue;
            LOGGER.info("save eduCert fail {}");
        }
        if (hcfMultiMap.containsKey("hcf_educertificate")) {
            String pageKey = "hcf_educertificate";
            DynamicObjectCollection hisMultiRowEntity = new DynamicObjectCollection();
            List fieldList = (List)hcfMultiMap.get(pageKey);
            HashMap<Long, DynamicObjectCollection> map = new HashMap<Long, DynamicObjectCollection>();
            DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                IHomToHcfAppService.getInstance().deleteRowEntity(pageKey, new ArrayList<Long>(Collections.singleton(candidateId)));
                return 0L;
            }
            AtomicInteger index = new AtomicInteger();
            dynamicObjectCollection.forEach(dynamicObject -> {
                Long eduId = dynamicObject.getLong("entryid") == 0L ? (Long)addId.get() : Long.valueOf(dynamicObject.getLong("entryid"));
                Map<String, List<InfoGroupEntity.InfoGroupField>> collect = fieldList.stream().collect(Collectors.groupingBy(field -> (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(field.getFieldId())));
                QFilter qFilter = new QFilter("edu", "in", (Object)eduId);
                DynamicObjectCollection eduCertificate = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, "hcf_educertificate", new QFilter[]{qFilter});
                Map<String, List<DynamicObject>> certMap = eduCertificate.stream().filter(dy -> !HRObjectUtils.isEmpty((Object)dy.get("certtype"))).collect(Collectors.groupingBy(dy -> dy.getString("certtype.id")));
                for (Map.Entry<String, List<InfoGroupEntity.InfoGroupField>> longListEntry : collect.entrySet()) {
                    this.saveEducertificateInfoGroupData(formView, (Map<String, List<Map<String, Object>>>)cacheAttachMap, pageKey, hisMultiRowEntity, (DynamicObject)dynamicObject, eduId, eduCertificate, certMap, longListEntry);
                }
                index.getAndIncrement();
            });
            map.put(candidateId, hisMultiRowEntity);
            IHomToHcfAppService.getInstance().saveMultiRowEntity(map, pageKey);
        }
        formView.getPageCache().put("removeUid", "");
        return addId.get();
    }

    /*
     * WARNING - void declaration
     */
    private void saveInfoGroupData(IFormView formView, Long candidateId, Map<Integer, Long> keyIndexMap, List<String> finalVisibleFiledList, Map<String, List<Map<String, Object>>> cacheAttachMap, AtomicReference<Long> addId, String pageKey, DynamicObjectCollection hisMultiRowEntity, List<InfoGroupEntity.InfoGroupField> fieldList, Map<Long, DynamicObject> dynamicObjectMap, AtomicInteger index, DynamicObject dyObject) {
        Set<String> noHisTable;
        long bizId;
        HashMap<String, void> objectObjectHashMap = new HashMap<String, void>(2);
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
        DynamicObject originDyn = dynamicObjectMap.get(dyObject.getLong("entryid"));
        if (!HRObjectUtils.isEmpty((Object)originDyn)) {
            HRDynamicObjectUtils.copy((DynamicObject)originDyn, (DynamicObject)dyn, IGNORE_FIELD);
        }
        long id = 0L;
        if (HRObjectUtils.isEmpty((Object)originDyn)) {
            id = ORM.create().genLongId(pageKey);
            dyn.set("id", (Object)id);
            addId.set(id);
            bizId = id;
        } else {
            noHisTable = ServiceFactory.getService(IHomConfigDomainService.class).getConfigOfSet("no_his_table");
            if (!noHisTable.contains(pageKey)) {
                dyn.set("boid", originDyn.get("boid"));
                dyn.set("id", (Object)0L);
                bizId = originDyn.getLong("boid");
            } else {
                dyn.set("id", originDyn.get("id"));
                bizId = originDyn.getLong("id");
            }
        }
        noHisTable = fieldList.iterator();
        while (noHisTable.hasNext()) {
            InfoGroupEntity.InfoGroupField infoGroupField = (InfoGroupEntity.InfoGroupField)noHisTable.next();
            if (finalVisibleFiledList.contains(infoGroupField.getFieldId().toString() + index) && !InfoGroupFieldConstants.CERT_TYPE.equals(infoGroupField.getFieldId())) continue;
            if (infoGroupField.getFieldType() == 2) {
                void var23_24;
                List<Map<String, Object>> list;
                String suffix = bizId + "";
                if (addId.get() != 0L) {
                    suffix = "-1";
                }
                if (CollectionUtils.isEmpty(list = cacheAttachMap.get("field" + infoGroupField.getFieldId() + "_" + suffix))) {
                    ArrayList arrayList = new ArrayList();
                }
                var23_24.forEach(atatchMap -> atatchMap.put("size", Long.parseLong(atatchMap.get("size").toString())));
                objectObjectHashMap.put(infoGroupField.getFieldKey(), var23_24);
                continue;
            }
            if (InfoGroupFieldConstants.RSM_PTDATA.equals(infoGroupField.getFieldId())) {
                dyn.set("ptstartdate", dyObject.get("entryfield" + infoGroupField.getFieldId() + "_ptstartdate"));
                dyn.set("ptendingdate", dyObject.get("entryfield" + infoGroupField.getFieldId() + "_ptendingdate"));
                continue;
            }
            if (dyObject.getDataEntityType().getProperties().get((Object)("entryfield" + infoGroupField.getFieldId())) instanceof MulBasedataProp) {
                MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = (MulBasedataDynamicObjectCollection)dyObject.get("entryfield" + infoGroupField.getFieldId());
                MulBasedataProp mulBasedataProp = (MulBasedataProp)dyObject.getDataEntityType().getProperties().get((Object)("entryfield" + infoGroupField.getFieldId()));
                MulBasedataDynamicObjectCollection newMul = (MulBasedataDynamicObjectCollection)dyn.get(infoGroupField.getFieldKey());
                newMul.clear();
                mulBasedataDynamicObjectCollection.forEach(dynamicObject -> {
                    long fbasedataid_id = dynamicObject.getLong("fbasedataid_id");
                    DynamicObject dynamicObject1 = newMul.addNew();
                    dynamicObject1.set("fbasedataid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)fbasedataid_id, (String)iDataEntityProperty.getBaseEntityId()));
                    dynamicObject1.set("fbasedataid_id", (Object)fbasedataid_id);
                });
                continue;
            }
            if (dyObject.getDataEntityType().getProperties().get((Object)("entryfield" + infoGroupField.getFieldId())) instanceof BasedataProp && dyObject.getLong("entryfield" + infoGroupField.getFieldId() + "_id") != 0L) {
                dyn.set(infoGroupField.getFieldKey(), dyObject.get("entryfield" + infoGroupField.getFieldId() + "_id"));
                continue;
            }
            dyn.set(infoGroupField.getFieldKey(), dyObject.get("entryfield" + infoGroupField.getFieldId()));
        }
        if (!objectObjectHashMap.isEmpty()) {
            if (!HRObjectUtils.isEmpty((Object)originDyn)) {
                id = originDyn.getLong("id");
            }
            Set removeUidSet = new HashSet();
            String removeUid = formView.getPageCache().get("removeUid");
            if (!HRStringUtils.isEmpty((String)removeUid)) {
                removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUid, Set.class);
            }
            for (String string : removeUidSet) {
                AttachmentServiceHelper.remove((String)pageKey, (Object)id, (Object)string);
            }
            for (Map.Entry entry : objectObjectHashMap.entrySet()) {
                List value = (List)entry.getValue();
                HashMap attachmentDataMap = new HashMap(2);
                attachmentDataMap.put(entry.getKey(), value);
                AttachmentServiceHelper.saveTempAttachments((String)pageKey, (Object)id, (String)"hcf", attachmentDataMap);
                value.forEach(attach -> {
                    Object description = attach.get("description");
                    QFilter[] filters = new QFilter[]{new QFilter("fnumber", "=", (Object)attach.get("uid").toString())};
                    DynamicObject[] dynColl = HomCommonRepository.queryDynamicObjects("bos_attachment", "", filters);
                    Arrays.stream(dynColl).forEach(dynamicObject -> dynamicObject.set("fdescription", description));
                    SaveServiceHelper.save((DynamicObject[])dynColl);
                });
            }
        }
        if (!(noHisTable = ServiceFactory.getService(IHomConfigDomainService.class).getConfigOfSet("no_his_table")).contains(pageKey) && 0L != dyn.getLong("boid")) {
            keyIndexMap.put(index.get(), dyn.getLong("boid"));
        } else {
            keyIndexMap.put(index.get(), dyn.getLong("id"));
        }
        dyn.set("candidate", (Object)candidateId);
        hisMultiRowEntity.add((Object)dyn);
        index.getAndIncrement();
    }

    /*
     * WARNING - void declaration
     */
    private void saveEducertificateInfoGroupData(IFormView formView, Map<String, List<Map<String, Object>>> cacheAttachMap, String pageKey, DynamicObjectCollection hisMultiRowEntity, DynamicObject dynamicObject, Long eduId, DynamicObjectCollection eduCertificate, Map<String, List<DynamicObject>> certMap, Map.Entry<String, List<InfoGroupEntity.InfoGroupField>> longListEntry) {
        DynamicObject dyn;
        HashMap<String, void> objectObjectHashMap = new HashMap<String, void>(2);
        if (CollectionUtils.isEmpty((Collection)eduCertificate) || CollectionUtils.isEmpty((Collection)certMap.get(longListEntry.getKey()))) {
            dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
            dyn.set("id", (Object)ORM.create().genLongId(pageKey));
        } else {
            List<DynamicObject> dynamicObjects = certMap.get(longListEntry.getKey());
            dyn = dynamicObjects.get(dynamicObjects.size() - 1);
        }
        hisMultiRowEntity.add((Object)dyn);
        dyn.set("edu", (Object)eduId);
        dyn.set("certtype", (Object)HomCommonRepository.queryDynamicObjectByPk("hbss_educerttype", "", Long.parseLong(longListEntry.getKey())));
        for (InfoGroupEntity.InfoGroupField infoGroupField : longListEntry.getValue()) {
            if (infoGroupField.getFieldType() == 2) {
                void var15_15;
                List<Map<String, Object>> list;
                String suffix = dynamicObject.getString("entryid");
                if (dynamicObject.getLong("entryid") == 0L) {
                    suffix = "-1";
                }
                if (CollectionUtils.isEmpty(list = cacheAttachMap.get("field" + infoGroupField.getFieldId() + "_" + suffix))) {
                    ArrayList arrayList = new ArrayList();
                }
                var15_15.forEach(atatchMap -> atatchMap.put("size", Long.parseLong(atatchMap.get("size").toString())));
                objectObjectHashMap.put(infoGroupField.getFieldKey(), var15_15);
                continue;
            }
            dyn.set(infoGroupField.getFieldKey(), dynamicObject.get("entryfield" + infoGroupField.getFieldId()));
        }
        if (!objectObjectHashMap.isEmpty()) {
            LOGGER.info("kd.hr.hom.formplugin.mobile.collect.InfoGroupDynViewMobilePlugin - saveMultiEntityByInfoGroup 351" + SerializationUtils.toJsonString(objectObjectHashMap));
            Set removeUidSet = new HashSet();
            String removeUid = formView.getPageCache().get("removeUid");
            if (!HRStringUtils.isEmpty((String)removeUid)) {
                removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUid, Set.class);
            }
            for (String string : removeUidSet) {
                LOGGER.info("kd.hr.hom.formplugin.mobile.collect.InfoGroupDynViewMobilePlugin - saveMultiEntityByInfoGroup 59" + SerializationUtils.toJsonString(removeUidSet));
                AttachmentServiceHelper.remove((String)pageKey, (Object)dyn.getLong("id"), (Object)string);
            }
            for (Map.Entry entry : objectObjectHashMap.entrySet()) {
                List value = (List)entry.getValue();
                HashMap attachmentDataMap = new HashMap(2);
                attachmentDataMap.put(entry.getKey(), value);
                LOGGER.info("kd.hr.hom.formplugin.mobile.collect.InfoGroupDynViewMobilePlugin - saveMultiEntityByInfoGroup 366" + SerializationUtils.toJsonString(attachmentDataMap));
                AttachmentServiceHelper.saveTempAttachments((String)pageKey, (Object)dyn.getLong("id"), (String)"hcf", attachmentDataMap);
                value.forEach(attach -> {
                    Object description = attach.get("description");
                    QFilter[] filters = new QFilter[]{new QFilter("fnumber", "=", (Object)attach.get("uid").toString())};
                    DynamicObject[] dynColl = HomCommonRepository.queryDynamicObjects("bos_attachment", "", filters);
                    Arrays.stream(dynColl).forEach(dy -> dy.set("fdescription", description));
                    SaveServiceHelper.save((DynamicObject[])dynColl);
                });
            }
        }
    }

    @Override
    public String saveCollectToHcfByInfoGroup(InfoGroupConfigEntity infoGroupConfigData, IFormView formView, Long onboardId, String infogroupnumber, AtomicBoolean allEmpty) {
        String pageKey;
        HashMap hcfSingleMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap homEntityMap = Maps.newHashMapWithExpectedSize((int)3);
        List infoGroupEntityList = infoGroupConfigData.getInfoGroupEntityList();
        InfoGroupEntity infoGroupEntity = infoGroupEntityList.stream().filter(infoGroup -> infoGroup.getInfoGroupNumber().equalsIgnoreCase(infogroupnumber)).findFirst().get();
        ArrayList fieldStatusVerifyList = new ArrayList();
        HashMap<InfoGroupEntity.InfoGroupField, String> fieldStatusVerifyDescMap = new HashMap<InfoGroupEntity.InfoGroupField, String>();
        infoGroupEntity.getInfoGroupFieldList().forEach(field -> {
            String pageKey;
            ICollectFieldVerifyService collectService = ServiceFactory.getService(ICollectFieldVerifyService.class);
            if (!collectService.fieldIsEmpty((InfoGroupEntity.InfoGroupField)field, formView)) {
                allEmpty.set(false);
            }
            if (collectService.fieldVerifyMustInput((InfoGroupEntity.InfoGroupField)field, formView)) {
                fieldStatusVerifyList.add(field);
            }
            if (HRStringUtils.isNotEmpty((String)collectService.fieldVerify((InfoGroupEntity.InfoGroupField)field, formView, infoGroupEntity.getInfoGroupFieldList()))) {
                fieldStatusVerifyDescMap.put((InfoGroupEntity.InfoGroupField)field, collectService.fieldVerify((InfoGroupEntity.InfoGroupField)field, formView, infoGroupEntity.getInfoGroupFieldList()));
            }
            if ("hom_standardfield".equals(pageKey = field.getPageKey())) {
                return;
            }
            if (pageKey.contains("hcf_")) {
                this.fillEntityMap(hcfSingleMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            } else {
                this.fillEntityMap(homEntityMap, (InfoGroupEntity.InfoGroupField)field, pageKey);
            }
        });
        if (!CollectionUtils.isEmpty(fieldStatusVerifyList)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u4e3a\u5fc5\u586b\uff0c\u8bf7\u586b\u5199\uff1a%s", (String)"AbstractCollectDynViewPlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]), fieldStatusVerifyList.stream().map(InfoGroupEntity.InfoGroupField::getFieldName).collect(Collectors.joining("\u3001"))));
            formView.showTipNotification(stringBuilder.toString());
            return "1";
        }
        if (!fieldStatusVerifyDescMap.isEmpty()) {
            fieldStatusVerifyDescMap.forEach((infoGroupField, desc) -> formView.showTipNotification(desc));
            return "1";
        }
        if (allEmpty.get() && !infoGroupEntity.getInfoGroupNumber().equalsIgnoreCase(InfoGroupEnum.JOB_CARD_INFO.getNumber())) {
            return "2";
        }
        Long candidateId = formView.getParentView().getModel().getDataEntity().getLong("onboard.candidate.id");
        for (Map.Entry stringListEntry : hcfSingleMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            this.saveHcfSingleData(formView, pageKey, candidateId, (List)stringListEntry.getValue());
        }
        for (Map.Entry stringListEntry : homEntityMap.entrySet()) {
            pageKey = (String)stringListEntry.getKey();
            this.saveHcfHomData(formView, pageKey, onboardId, (List)stringListEntry.getValue());
        }
        return "0";
    }

    @Override
    public void saveHcfHomData(IFormView iFormView, String pageKey, Long onboardId, List<InfoGroupEntity.InfoGroupField> fieldList) {
        DynamicObject homEntity = HomCommonRepository.queryDynamicObjectByPk(pageKey, "", iFormView.getParentView().getModel().getDataEntity().getLong("onboard.id"));
        for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
            if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)iFormView.getControl("field" + infoGroupField.getFieldId());
                List attachmentData = attachmentPanel.getAttachmentData();
                attachmentData.forEach(atatchMap -> atatchMap.put("size", Long.parseLong(atatchMap.get("size").toString())));
                HashMap<String, List> objectObjectHashMap = new HashMap<String, List>(2);
                objectObjectHashMap.put(infoGroupField.getFieldKey(), attachmentData);
                LOGGER.info("kd.hr.hom.business.domain.service.impl.collect.SyncCollectToHcfImpl - saveHcfHomData" + SerializationUtils.toJsonString(objectObjectHashMap));
                AttachmentServiceHelper.saveTempAttachments((String)infoGroupField.getPageKey(), (Object)onboardId, (String)"hom", objectObjectHashMap);
                Set removeUidSet = Sets.newHashSetWithExpectedSize((int)3);
                String removeUid = iFormView.getPageCache().get("removeUid");
                if (!HRStringUtils.isEmpty((String)removeUid)) {
                    removeUidSet = (Set)SerializationUtils.fromJsonString((String)removeUid, Set.class);
                }
                for (String s : removeUidSet) {
                    AttachmentServiceHelper.remove((String)pageKey, (Object)onboardId, (Object)s);
                }
                iFormView.getPageCache().put("removeUid", "");
                continue;
            }
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)homEntity.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
            if (iDataEntityProperty instanceof BasedataProp && HRObjectUtils.isEmpty((Object)iFormView.getModel().getValue("field" + infoGroupField.getFieldId()))) {
                homEntity.set(infoGroupField.getFieldKey(), iFormView.getModel().getDataEntity().get("field" + infoGroupField.getFieldId() + "_id"));
                continue;
            }
            homEntity.set(infoGroupField.getFieldKey(), iFormView.getModel().getValue("field" + infoGroupField.getFieldId()));
        }
        HomCommonRepository.updateDynamicObject(pageKey, homEntity);
    }

    @Override
    public void saveHcfSingleData(IFormView iFormView, String pageKey, Long candidateId, List<InfoGroupEntity.InfoGroupField> fieldList) {
        if ("hcf_canaddress".equals(pageKey)) {
            DynamicObjectCollection hisMultiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(candidateId, pageKey);
            if (HRObjectUtils.isEmpty((Object)hisMultiRowEntity)) {
                hisMultiRowEntity = new DynamicObjectCollection();
            }
            IHomToHcfAppService.getInstance().deleteRowEntity(pageKey, new ArrayList<Long>(Collections.singleton(candidateId)));
            DynamicObjectCollection multiRowEntity = new DynamicObjectCollection();
            HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
            Map<String, List<DynamicObject>> collect = hisMultiRowEntity.stream().filter(dynamicObject -> !HRObjectUtils.isEmpty((Object)dynamicObject.get("addresstype"))).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("addresstype.id")));
            String confVal = ServiceFactory.getService(IHomConfigService.class).getConfVal("address_type_str", InfoGroupFieldConstants.ADDRESS_TYPE_DEFAULT_STR);
            for (String addressType : confVal.split(",")) {
                this.saveAddress(pageKey, candidateId, iFormView.getModel(), addressType, multiRowEntity, collect);
            }
            map.put(pageKey, multiRowEntity);
            ArrayList<Map<String, DynamicObjectCollection>> list = new ArrayList<Map<String, DynamicObjectCollection>>();
            list.add(map);
            IHomToHcfAppService.getInstance().saveOrUpdateCandidates(list);
        } else {
            DynamicObject singleRowEntity = IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, pageKey);
            DynamicObject personBaseDyNew = null;
            personBaseDyNew = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
            if (!HRObjectUtils.isEmpty((Object)singleRowEntity)) {
                HRDynamicObjectUtils.copy((DynamicObject)singleRowEntity, (DynamicObject)personBaseDyNew, IGNORE_FIELD);
            } else {
                singleRowEntity = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pageKey));
            }
            personBaseDyNew.set("boid", HRObjectUtils.isEmpty((Object)singleRowEntity) ? null : Long.valueOf(singleRowEntity.getLong("boid")));
            personBaseDyNew.set("candidate", HRObjectUtils.isEmpty((Object)singleRowEntity) ? candidateId : singleRowEntity.get("candidate"));
            HashMap<String, List> attach = new HashMap<String, List>();
            for (InfoGroupEntity.InfoGroupField infoGroupField : fieldList) {
                if (infoGroupField.getFieldType() == Integer.parseInt(InfoGroupFieldTypeEnum.ATTACH.getFieldType())) {
                    AttachmentPanel attachmentPanel = (AttachmentPanel)iFormView.getControl("field" + infoGroupField.getFieldId());
                    attach.put(infoGroupField.getFieldKey(), attachmentPanel.getAttachmentData());
                    continue;
                }
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)personBaseDyNew.getDataEntityType().getProperties().get((Object)infoGroupField.getFieldKey());
                if (iDataEntityProperty instanceof BasedataProp && HRObjectUtils.isEmpty((Object)iFormView.getModel().getValue("field" + infoGroupField.getFieldId()))) {
                    personBaseDyNew.set(infoGroupField.getFieldKey() + "_id", iFormView.getModel().getDataEntity().get("field" + infoGroupField.getFieldId() + "_id"));
                    continue;
                }
                personBaseDyNew.set(infoGroupField.getFieldKey(), iFormView.getModel().getValue("field" + infoGroupField.getFieldId()));
            }
            HashMap<Long, DynamicObject> personMap = new HashMap<Long, DynamicObject>(2);
            personMap.put(candidateId, personBaseDyNew);
            Map<String, Object> result = IHomToHcfAppService.getInstance().saveHisSingleRowEntity(personMap, pageKey);
            if (!((Boolean)result.get("success")).booleanValue()) {
                LOGGER.error("candidate Info Save Fail, ", (Object)result.get("message").toString());
                return;
            }
            AttachmentServiceHelper.saveTempAttachments((String)pageKey, (Object)IHomToHcfAppService.getInstance().getSingleRowEntity(candidateId, pageKey).getLong("id"), (String)"hcf", attach);
        }
    }
}

