/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.BaseDataRepository;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.handler.HPFSTemplatePropertyHandler;
import kd.hr.hom.common.util.HOMObjectUtils;

public class BaseDataDomainServiceImpl
implements IBaseDataDomainService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataDomainServiceImpl.class);

    @Override
    public DynamicObject[] getOnboardTypes(String selectProperties, Set<String> numberSet) {
        return BaseDataRepository.getOnboardTypes(selectProperties, numberSet);
    }

    @Override
    public boolean isExists(HRBaseServiceHelper helper, QFilter filter) {
        return helper.isExists(filter);
    }

    @Override
    public String getPermItemNameById(String permItemId) {
        QFilter filter = new QFilter("id", "=", (Object)permItemId);
        Object[] permItems = BaseDataRepository.getPermitems("name", new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])permItems)) {
            return null;
        }
        return permItems[0].getLocaleString("name").getLocaleValue();
    }

    @Override
    public DynamicObject getHpfsChgactionByNumber(String number, String selectProperties) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        filter.and("enable", "=", (Object)"1");
        Object[] hpfsChgactions = BaseDataRepository.getHpfsChgaction(selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])hpfsChgactions)) {
            return null;
        }
        return hpfsChgactions[0];
    }

    @Override
    public DynamicObject getHpfsChgActionById(Long id, String selectProperties) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        filter.and("enable", "=", (Object)"1");
        Object[] hpfsChgactions = BaseDataRepository.getHpfsChgaction(selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])hpfsChgactions)) {
            return null;
        }
        return hpfsChgactions[0];
    }

    @Override
    public DynamicObject getHpfsChgactionDefault(String selectProperties) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        Object[] hpfsChgactions = BaseDataRepository.getHpfsChgaction(selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])hpfsChgactions)) {
            return null;
        }
        return hpfsChgactions[0];
    }

    @Override
    public DynamicObject getBaseDataInfoByNumber(String entityNum, String number, String selectProperties) {
        if (number == null) {
            return null;
        }
        Map<String, DynamicObject> result = this.getBaseDataInfoByNumber(entityNum, (Collection<String>)ImmutableList.of((Object)number), selectProperties);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(number);
    }

    @Override
    public DynamicObject getBaseDataInfoById(String entityNum, Long id, String selectProperties) {
        if (id == null || id == 0L) {
            return null;
        }
        Map<Long, DynamicObject> result = this.getBaseDataInfoByIds(entityNum, (Collection<Long>)ImmutableList.of((Object)id), selectProperties);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return result.get(id);
    }

    @Override
    public Map<String, DynamicObject> getBaseDataInfoByNumber(String entityNum, Collection<String> numberSet, String selectProperties) {
        QFilter filter = new QFilter("number", "in", numberSet);
        Object[] baseDataInfos = BaseDataRepository.getBaseDataInfoByNumber(entityNum, selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])baseDataInfos)) {
            return new HashMap<String, DynamicObject>();
        }
        return Stream.of(baseDataInfos).collect(Collectors.toMap(baseDataInfo -> baseDataInfo.getString("number"), baseDataInfo -> baseDataInfo, (oldValue, newValue) -> newValue));
    }

    @Override
    public Map<Long, DynamicObject> getBaseDataInfoByIds(String entityNum, Collection<Long> idSet, String selectProperties) {
        QFilter filter = new QFilter("id", "in", idSet);
        Object[] baseDataInfos = BaseDataRepository.getBaseDataInfoByNumber(entityNum, selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])baseDataInfos)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Stream.of(baseDataInfos).collect(Collectors.toMap(baseDataInfo -> baseDataInfo.getLong("id"), baseDataInfo -> baseDataInfo, (oldValue, newValue) -> newValue));
    }

    @Override
    public DynamicObject getSexInfo(String sexName, String selectProperties) {
        Object[] sexInfos;
        QFilter filter = new QFilter("name", "=", (Object)sexName);
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id,number,name";
        }
        if (HRArrayUtils.isEmpty((Object[])(sexInfos = BaseDataRepository.getSexInfo(selectProperties, new QFilter[]{filter})))) {
            return null;
        }
        return sexInfos[0];
    }

    @Override
    public Map<Long, DynamicObject> getLoginConfigById(Collection<Long> loginConfigIds, String selectProperties) {
        QFilter filter = new QFilter("id", "in", loginConfigIds);
        Object[] loginConfigs = BaseDataRepository.getLoginConfigs(selectProperties, new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])loginConfigs)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Stream.of(loginConfigs).collect(Collectors.toMap(loginConfig -> loginConfig.getLong("id"), loginConfigInfo -> loginConfigInfo, (oldValue, newValue) -> newValue));
    }

    @Override
    public DynamicObject[] getJobFamilyScmInfosByJobScmIdsAndJobFamilyIds(List<Long> jobScmIds, List<Long> jobFamilyIds) {
        return (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds", (Object[])new Object[]{jobScmIds, jobFamilyIds});
    }

    @Override
    public Map<Long, Map<String, Object>> getJobRelationInfosByJobIds(List<Long> jobIds) {
        LOGGER.info("getJobRelationInfosByJobIds size:" + jobIds.size());
        Map queryResultRpc = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)"selectJobHisinfo", (Object[])new Object[]{jobIds, new Date()});
        String code = queryResultRpc.get("code").toString();
        if (HRStringUtils.equals((String)"200", (String)code)) {
            Object data = queryResultRpc.get("data");
            if (data == null) {
                LOGGER.info("getJobRelationInfosByJobIds cannot find any data !");
                return null;
            }
            List reslist = (List)data;
            return reslist.stream().collect(Collectors.toMap(jobRelationInfoMap -> Long.parseLong(jobRelationInfoMap.get("boid").toString()), jobRelationInfoMap -> jobRelationInfoMap, (oldValue, newValue) -> newValue));
        }
        LOGGER.info("getJobRelationInfosByJobIds fail:" + JSONObject.toJSONString((Object)queryResultRpc));
        return null;
    }

    @Override
    public Map<Long, Map<String, List<DynamicObject>>> getJobLevelGradesByJobIds(List<Long> jobBoids) {
        LOGGER.info("getJobLevelGradesByJobIds size:" + jobBoids.size());
        Map queryResultRpc = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobLevelGradeRangeInfo", (Object[])new Object[]{jobBoids});
        String code = queryResultRpc.get("code").toString();
        if (HRStringUtils.equals((String)"200", (String)code)) {
            Object data = queryResultRpc.get("data");
            if (data == null) {
                LOGGER.info("getJobLevelGradesByJobIds cannot find any data !");
                return null;
            }
            Map resdataMap = (Map)data;
            return resdataMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.parseLong((String)entry.getKey()), Map.Entry::getValue, (oldValue, newValue) -> newValue));
        }
        LOGGER.info("getJobLevelGradesByJobIds fail:" + JSONObject.toJSONString((Object)queryResultRpc));
        return null;
    }

    @Override
    public Map<String, Map<String, Object>> queryAdminOrgInfos(List<Long> orgIdList) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{orgIdList, new Date()});
    }

    @Override
    public Map<Long, Long> getCompanyMapWithAdminorgByRPC(List<Long> adminOrgIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)adminOrgIds.size());
        Map<String, Map<String, Object>> queryResultRpc = this.queryAdminOrgInfos(adminOrgIds);
        LOGGER.info("getCompanyMapWithAdminorgByRPC queryResultRpc:" + JSONObject.toJSONString(queryResultRpc));
        for (Long adminOrgId : adminOrgIds) {
            Map<String, Object> adminOrgInfoMap = queryResultRpc.get(adminOrgId.toString());
            if (CollectionUtils.isEmpty(adminOrgInfoMap)) continue;
            Long companyId = (Long)adminOrgInfoMap.getOrDefault("belongcompany", 0L);
            resultMap.put(adminOrgId, companyId);
        }
        LOGGER.info("getCompanyMapWithAdminorgByRPC resultMap:" + JSONObject.toJSONString((Object)resultMap));
        return resultMap;
    }

    @Override
    public List<Long> getChgeventKeys() {
        QFilter qFilter = new QFilter("chgevent.number", "=", (Object)"1010_S");
        Object[] hpfsChgcategorys = BaseDataRepository.getHpfsChgcategory("id", new QFilter[]{qFilter});
        if (HRArrayUtils.isEmpty((Object[])hpfsChgcategorys)) {
            return new ArrayList<Long>();
        }
        List<Long> reList = Arrays.stream(hpfsChgcategorys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        return reList;
    }

    @Override
    public Tuple<List<Long>, String> getHpfsChgactionInfo() {
        List<Long> chgeventKeys = this.getChgActionIdsByHomMetadata();
        if (CollectionUtils.isEmpty(chgeventKeys)) {
            LOGGER.info("getHpfsChgactionInfo_null");
            return new Tuple(new ArrayList(0), null);
        }
        QFilter qFilter = new QFilter("id", "in", chgeventKeys);
        QFilter enableQFilter = new QFilter("enable", "in", (Object)"1");
        Object[] hpfsChgactions = BaseDataRepository.getHpfsChgaction("name", new QFilter[]{qFilter, enableQFilter});
        if (HRArrayUtils.isEmpty((Object[])hpfsChgactions)) {
            LOGGER.info("getHpfsChgactionInfo_hpfsChgactions_null");
            return new Tuple(new ArrayList(0), null);
        }
        ArrayList keys = new ArrayList(hpfsChgactions.length);
        StringBuilder stringBuilder = new StringBuilder();
        Arrays.stream(hpfsChgactions).forEach(dy -> {
            stringBuilder.append(dy.getString("name")).append(',');
            keys.add(dy.getLong("id"));
        });
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return new Tuple(keys, (Object)stringBuilder.toString());
    }

    @Override
    public Map<String, Map<String, Object>> getJobLevelInfoByScmId(List<Map<String, Object>> levelScmInfos) {
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobLevelRangeByScmId", (Object[])new Object[]{levelScmInfos, RequestContext.getOrCreate().getLang().name()});
        if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
            LOGGER.error("getJobLevelInfoByScmId fail! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return new HashMap<String, Map<String, Object>>();
        }
        List dataList = (List)responseMap.get("data");
        if (dataList == null || dataList.isEmpty()) {
            LOGGER.error("getJobLevelInfoByScmId data is empty! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return new HashMap<String, Map<String, Object>>();
        }
        return dataList.stream().collect(Collectors.toMap(dataInfo -> dataInfo.get("scmId") + "-" + dataInfo.get("joblevelName"), dataInfo -> dataInfo, (oldValue, newValue) -> newValue));
    }

    @Override
    public Map<String, Map<String, Object>> getJobGradeInfoByScmId(List<Map<String, Object>> gradeScmInfos) {
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobGradeRangeByScmId", (Object[])new Object[]{gradeScmInfos, RequestContext.getOrCreate().getLang().name()});
        if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
            LOGGER.error("getJobGradeInfoByScmId fail! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return new HashMap<String, Map<String, Object>>();
        }
        List dataList = (List)responseMap.get("data");
        if (dataList == null || dataList.size() == 0) {
            LOGGER.error("getJobGradeInfoByScmId data is empty! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return new HashMap<String, Map<String, Object>>();
        }
        return dataList.stream().collect(Collectors.toMap(dataInfo -> dataInfo.get("scmId") + "-" + dataInfo.get("jobgradeName"), dataInfo -> dataInfo, (oldValue, newValue) -> newValue));
    }

    @Override
    public Map<Long, Map<String, Object>> getJobLevelGradeRangeInfoByJobIds(List<Long> jobBoids) {
        if (CollectionUtils.isEmpty(jobBoids)) {
            return new HashMap<Long, Map<String, Object>>();
        }
        LOGGER.info("jobBoids.size():{}", (Object)jobBoids.size());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)jobBoids.size());
        int partitionLenght = 500;
        List jobIdParts = new ArrayList<List<Long>>(16);
        if (jobBoids.size() > partitionLenght) {
            jobIdParts = Lists.partition(jobBoids, (int)partitionLenght);
        } else {
            jobIdParts.add(jobBoids);
        }
        for (List jobIds : jobIdParts) {
            Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getAllJobLevelGradeRangeInfoByJobId", (Object[])new Object[]{jobIds});
            if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
                LOGGER.error("getJobLevelGradeRangeInfoByJobIds fail! {}", (Object)JSONObject.toJSONString((Object)responseMap));
                continue;
            }
            List dataList = (List)responseMap.get("data");
            if (dataList == null || dataList.size() == 0) {
                LOGGER.error("getJobLevelGradeRangeInfoByJobIds data is empty! {}", (Object)JSONObject.toJSONString((Object)responseMap));
                continue;
            }
            for (Map data : dataList) {
                if (!Boolean.parseBoolean(data.get("success").toString()) || !Boolean.parseBoolean(data.get("exist").toString())) {
                    LOGGER.error("cannot find data: {}", (Object)JSONObject.toJSONString((Object)data));
                    continue;
                }
                HashMap jobinfoMap = Maps.newHashMapWithExpectedSize((int)12);
                jobinfoMap.put("jobNumber", data.get("jobNumber"));
                jobinfoMap.put("jobName", data.get("jobName"));
                jobinfoMap.put("createOrg", data.get("createOrg"));
                jobinfoMap.put("jobscm", data.get("jobscm"));
                jobinfoMap.put("jobseq", data.get("jobseq"));
                jobinfoMap.put("jobfamily", data.get("jobfamily"));
                jobinfoMap.put("jobclass", data.get("jobclass"));
                long jobId = Long.parseLong(data.get("jobId").toString());
                LOGGER.info("jobId:{}, simple jobinfoMap:{}", (Object)jobId, (Object)HOMObjectUtils.toJSONString((Object)jobinfoMap));
                this.putJoblevelgradeRangesAndScmToMap(data, jobinfoMap);
                resultMap.put(jobId, jobinfoMap);
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> getJobLevelGradeRangeInfoByJobId(Long jobBoid) {
        Map<Long, Map<String, Object>> resultMap = this.getJobLevelGradeRangeInfoByJobIds((List<Long>)ImmutableList.of((Object)jobBoid));
        return resultMap.get(jobBoid);
    }

    @Override
    public List<Long> getChgActionIdsByHomMetadata() {
        Object actionIds;
        Map response;
        boolean businessValue = HPFSTemplatePropertyHandler.isNewChgAction("hom_onbrd_hpfs_new");
        if (businessValue) {
            response = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getActionResByBillSource", (Object[])new Object[]{"hom_onbrdinfo"});
            List maps = (List)response.get("data");
            actionIds = maps.stream().map(m -> m.get("id")).collect(Collectors.toList());
        } else {
            response = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getActionResByBill", (Object[])new Object[]{"hom_onbrdinfo"});
            actionIds = response.get("data");
        }
        if (response == null || response.isEmpty()) {
            return new ArrayList<Long>();
        }
        LOGGER.info("response:{}", (Object)JSONObject.toJSONString((Object)response));
        if (actionIds == null) {
            return new ArrayList<Long>();
        }
        return (List)actionIds;
    }

    @Override
    public Map<Long, List<DynamicObject>> queryStdPositionByOrg(List<Long> orgIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPositionByOrg", (Object[])new Object[]{orgIds});
        if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
            LOGGER.error("queryStdPositionByOrg fail! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return resultMap;
        }
        List dataList = (List)responseMap.get("data");
        if (dataList == null || dataList.size() == 0) {
            LOGGER.error("queryStdPositionByOrg data is empty! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return resultMap;
        }
        for (Map data : dataList) {
            if (!Boolean.parseBoolean(data.get("exist").toString())) {
                LOGGER.error("cannot find data: {}", (Object)HOMObjectUtils.toJSONString((Object)data));
                continue;
            }
            Long orgId = HOMObjectUtils.getLongValOfCustomParam(data.get("orgId"));
            List standardPositions = (List)data.get("standardPositions");
            resultMap.put(orgId, standardPositions);
        }
        return resultMap;
    }

    @Override
    public Map<String, Boolean> valideStdPositionAndOrg(List<Map<String, Long>> orgStdPositions) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)orgStdPositions.size());
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"valideStandardPositionAndOrg", (Object[])new Object[]{orgStdPositions});
        if (!HRStringUtils.equals((String)"200", (String)responseMap.get("code").toString())) {
            LOGGER.error("valideStdPositionAndOrg fail! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return resultMap;
        }
        List dataList = (List)responseMap.get("data");
        if (dataList == null || dataList.size() == 0) {
            LOGGER.error("valideStdPositionAndOrg data is empty! {}", (Object)HOMObjectUtils.toJSONString((Object)responseMap));
            return resultMap;
        }
        for (Map data : dataList) {
            Long orgId = HOMObjectUtils.getLongValOfCustomParam(data.get("orgId"));
            long standardPositionId = HOMObjectUtils.getLongValOfCustomParam(data.get("standardPositionId"));
            Boolean ifPassed = Boolean.parseBoolean(data.get("valide").toString());
            resultMap.put(orgId + "-" + standardPositionId, ifPassed);
        }
        LOGGER.info("resultMap:{}", (Object)HOMObjectUtils.toJSONString((Object)resultMap));
        return resultMap;
    }

    private void putJoblevelgradeRangesAndScmToMap(Map<String, Object> rpcQueryDataMap, Map<String, Object> jobinfoMap) {
        Long joblevelScmid = 0L;
        Map job_joblevel = (Map)rpcQueryDataMap.get("job_joblevel");
        Map jobfamily_joblevel = (Map)rpcQueryDataMap.get("jobfamily_joblevel");
        Map jobclass_joblevel = (Map)rpcQueryDataMap.get("jobclass_joblevel");
        Map jobscm_joblevel = (Map)rpcQueryDataMap.get("jobscm_joblevel");
        if (job_joblevel != null && (Long)job_joblevel.get("id") != 0L) {
            joblevelScmid = job_joblevel.get("id");
        } else if (jobclass_joblevel != null && (Long)jobclass_joblevel.get("id") != 0L) {
            joblevelScmid = jobclass_joblevel.get("id");
        } else if (jobfamily_joblevel != null && (Long)jobfamily_joblevel.get("id") != 0L) {
            joblevelScmid = jobfamily_joblevel.get("id");
        } else if (jobscm_joblevel != null && (Long)jobscm_joblevel.get("id") != 0L) {
            joblevelScmid = jobscm_joblevel.get("id");
        }
        jobinfoMap.put("joblevelScmid", joblevelScmid);
        List joblevelRanges = new ArrayList();
        if (job_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)job_joblevel.get("ranges")))) {
            joblevelRanges = (List)job_joblevel.get("ranges");
            LOGGER.info("job_joblevel ranges:{}", (Object)HOMObjectUtils.toJSONString(joblevelRanges));
        } else if (jobclass_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobclass_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobclass_joblevel.get("ranges");
            LOGGER.info("jobclass_joblevel ranges:{}", (Object)HOMObjectUtils.toJSONString(joblevelRanges));
        } else if (jobfamily_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobfamily_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobfamily_joblevel.get("ranges");
            LOGGER.info("jobfamily_joblevel ranges:{}", (Object)HOMObjectUtils.toJSONString(joblevelRanges));
        } else if (jobscm_joblevel != null && !CollectionUtils.isEmpty((Collection)((List)jobscm_joblevel.get("ranges")))) {
            joblevelRanges = (List)jobscm_joblevel.get("ranges");
            LOGGER.info("jobscm_joblevel ranges:{}", (Object)HOMObjectUtils.toJSONString(joblevelRanges));
        }
        jobinfoMap.put("joblevelRanges", joblevelRanges);
        Long jobgradeScmid = 0L;
        Map job_jobgrade = (Map)rpcQueryDataMap.get("job_jobgrade");
        Map jobfamily_jobgrade = (Map)rpcQueryDataMap.get("jobfamily_jobgrade");
        Map jobclass_jobgrade = (Map)rpcQueryDataMap.get("jobclass_jobgrade");
        Map jobscm_jobgrade = (Map)rpcQueryDataMap.get("jobscm_jobgrade");
        if (job_jobgrade != null && (Long)job_jobgrade.get("id") != 0L) {
            jobgradeScmid = job_jobgrade.get("id");
        } else if (jobclass_jobgrade != null && (Long)jobclass_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobclass_jobgrade.get("id");
        } else if (jobfamily_jobgrade != null && (Long)jobfamily_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobfamily_jobgrade.get("id");
        } else if (jobscm_jobgrade != null && (Long)jobscm_jobgrade.get("id") != 0L) {
            jobgradeScmid = jobscm_jobgrade.get("id");
        }
        jobinfoMap.put("jobgradeScmid", jobgradeScmid);
        List jobgradeRanges = new ArrayList();
        if (job_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)job_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)job_jobgrade.get("ranges");
            LOGGER.info("job_jobgrade ranges:{}", (Object)HOMObjectUtils.toJSONString(jobgradeRanges));
        } else if (jobclass_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobclass_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobclass_jobgrade.get("ranges");
            LOGGER.info("jobclass_jobgrade ranges:{}", (Object)HOMObjectUtils.toJSONString(jobgradeRanges));
        } else if (jobfamily_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobfamily_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobfamily_jobgrade.get("ranges");
            LOGGER.info("jobfamily_jobgrade ranges:{}", (Object)HOMObjectUtils.toJSONString(jobgradeRanges));
        } else if (jobscm_jobgrade != null && !CollectionUtils.isEmpty((Collection)((List)jobscm_jobgrade.get("ranges")))) {
            jobgradeRanges = (List)jobscm_jobgrade.get("ranges");
            LOGGER.info("jobscm_jobgrade ranges:{}", (Object)HOMObjectUtils.toJSONString(jobgradeRanges));
        }
        jobinfoMap.put("jobgradeRanges", jobgradeRanges);
    }
}

