/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.common.IHomConfigService;

public class HomConfigServiceImpl
implements IHomConfigService {
    private static final String KEY_CONFIG = "hom:config";

    @Override
    public String getConfVal(String businessKey) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)KEY_CONFIG);
        String str = (String)ihrAppCache.get(businessKey, String.class);
        return str == null ? "" : str;
    }

    @Override
    public String getConfVal(String businessKey, String defaultVal) {
        IHRAppCache ihrAppCache = HRAppCache.get((String)KEY_CONFIG);
        String val = (String)ihrAppCache.get(businessKey, String.class);
        if (HRStringUtils.isEmpty((String)val)) {
            val = HomConfigRepository.queryValueByBusinessKey(businessKey);
            if (HRStringUtils.isEmpty((String)val)) {
                val = defaultVal;
            }
            ihrAppCache.put(businessKey, (Object)val);
        }
        return val;
    }

    @Override
    public List<String> getConfValList(String businessKey, String defaultVal) {
        String confVal = this.getConfVal(businessKey, defaultVal);
        if (HRStringUtils.isEmpty((String)confVal)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(confVal.split(","));
    }
}

