/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.common.util.SceneResultUtil;

public class HomRuleEngineServiceImpl
implements IHomRuleEngineService {
    @Override
    public Map<String, Object> callRuleEngine(String sceneNumber, String buNumber, Map<String, Object> inputParams) {
        return this.callRuleEngine("hom", sceneNumber, buNumber, null, inputParams);
    }

    @Override
    public Map<String, Object> callRuleEngineResult(String sceneNumber, String buNumber, Map<String, Object> inputParams) {
        Map<String, Object> ruleEngineResult = this.callRuleEngine(sceneNumber, buNumber, inputParams);
        return SceneResultUtil.getRespResult((SceneResult)RuleEngineResponseUtils.transferToSceneResult(ruleEngineResult));
    }

    @Override
    public List<Map<String, Object>> callRuleEngineResultList(String sceneNumber, String buNumber, Map<String, Object> inputParams) {
        Map<String, Object> ruleEngineResult = this.callRuleEngine(sceneNumber, buNumber, inputParams);
        return SceneResultUtil.getRespResultList((SceneResult)RuleEngineResponseUtils.transferToSceneResult(ruleEngineResult));
    }

    @Override
    public Map<String, Object> callRuleEngine(String bizApp, String sceneNumber, String buNumber, List<Long> executePolicyIds, Map<String, Object> inputParams) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)5);
        requestMap.put("bizApp", bizApp);
        requestMap.put("sceneNumber", sceneNumber);
        requestMap.put("buNumber", buNumber);
        if (!CollectionUtils.isEmpty(executePolicyIds)) {
            requestMap.put("executePolicyIds", executePolicyIds);
        }
        if (!CollectionUtils.isEmpty(inputParams)) {
            requestMap.put("inputParams", inputParams);
        }
        return (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
    }

    @Override
    public List<Map<String, Object>> batchCallRuleEngine(String sceneNumber, String buNumber, List<Map<String, Object>> inputParamsMapList) {
        return this.batchCallRuleEngine("hom", sceneNumber, buNumber, inputParamsMapList);
    }

    @Override
    public List<Map<String, Object>> batchCallRuleEngine(String bizApp, String sceneNumber, String buNumber, List<Map<String, Object>> inputParamsMapList) {
        HashMap baseRequestMap = Maps.newHashMapWithExpectedSize((int)3);
        baseRequestMap.put("bizApp", bizApp);
        baseRequestMap.put("sceneNumber", sceneNumber);
        baseRequestMap.put("buNumber", buNumber);
        return (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngine", (Object[])new Object[]{baseRequestMap, inputParamsMapList});
    }
}

