/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.util.PluginUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.util.HomUrlUtils;

public class MessageTemplateParser {
    private static final Log LOG = LogFactory.getLog(MessageTemplateParser.class);

    public static String getMessageContext(String templateNumber, Long businessId, Map<String, String> paramMap) {
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return "";
        }
        String format = MessageTemplateParser.parserMessageTpl(templateNumber, businessId, paramMap, dynamicObject);
        return format;
    }

    public static String parserMessageTpl(String templateNumber, Long businessId, Map<String, String> paramMap, DynamicObject dynamicObject) {
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = HomCommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        if ("hom_onbrdbilltpl".equals(businessDynamicObject.getDynamicObjectType().getName())) {
            String url = HomUrlUtils.dealUrl(businessDynamicObject.getString("url"));
            String candidateId = businessDynamicObject.getString("candidate.id");
            String safeLoginUrl = IOnbrdCommonAppService.getInstance().transToSafeLoginUrl(url, "1060_S", candidateId);
            if (StringUtils.isNotBlank((CharSequence)(safeLoginUrl = HomUrlUtils.dealUrl(safeLoginUrl))) && safeLoginUrl.contains("http")) {
                businessDynamicObject.set("url", (Object)safeLoginUrl);
            }
        }
        LocaleString title = new LocaleString();
        LocaleString content = new LocaleString();
        JSONObject mObject = JSONObject.parseObject((String)msgTemplate);
        Iterator iterator = mObject.entrySet().iterator();
        String contentStr = "";
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object value = entry.getValue();
            if (PluginUtil.isJSONObject(value)) {
                JSONObject con = JSONObject.parseObject((String)value.toString());
                if (null == con) continue;
                contentStr = StringUtils.isNotBlank((CharSequence)con.getString("emailContent")) ? con.getString("emailContent") : con.getString("content");
                String titleStr = StringUtils.isNotBlank((CharSequence)con.getString("emailTitle")) ? con.getString("emailTitle") : con.getString("title");
                content.setItem((String)entry.getKey(), (Object)contentStr);
                title.setItem((String)entry.getKey(), (Object)titleStr);
                continue;
            }
            content.setItem((String)entry.getKey(), (Object)String.valueOf(value));
            contentStr = String.valueOf(value);
        }
        return MessageTemplateParser.transferStr(contentStr, businessDynamicObject, paramMap);
    }

    @Deprecated
    public static Map<String, String> parserMessageTplNew(String templateNumber, Long businessId, Map<String, String> paramMap, DynamicObject dynamicObject) {
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = HomCommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        if ("hom_onbrdbilltpl".equals(businessDynamicObject.getDynamicObjectType().getName())) {
            String url = HomUrlUtils.dealUrl(businessDynamicObject.getString("url"));
            String candidateId = businessDynamicObject.getString("candidate.id");
            String safeLoginUrl = IOnbrdCommonAppService.getInstance().transToSafeLoginUrl(url, "1060_S", candidateId);
            if (StringUtils.isNotBlank((CharSequence)(safeLoginUrl = HomUrlUtils.dealUrl(safeLoginUrl))) && safeLoginUrl.contains("http")) {
                businessDynamicObject.set("url", (Object)safeLoginUrl);
            }
        }
        JSONObject mObject = JSONObject.parseObject((String)msgTemplate);
        Iterator iterator = mObject.entrySet().iterator();
        HashMap<String, String> result = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object value = entry.getValue();
            if (PluginUtil.isJSONObject(value)) {
                JSONObject con = JSONObject.parseObject((String)value.toString());
                if (null == con) continue;
                for (Map.Entry stringObjectEntry : con.entrySet()) {
                    result.put((String)stringObjectEntry.getKey(), MessageTemplateParser.transferStr(stringObjectEntry.getValue().toString(), businessDynamicObject, paramMap));
                }
                continue;
            }
            result.put(entry.getKey().toString(), MessageTemplateParser.transferStr(value.toString(), businessDynamicObject, paramMap));
        }
        return result;
    }

    public static Map<String, String> parserMessageEntity(String templateNumber, Long businessId, Map<String, Object> paramMap, DynamicObject dynamicObject) {
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = HomCommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        HashMap<String, String> result = new HashMap<String, String>();
        if (HRStringUtils.isEmpty((String)dentityid) || HRObjectUtils.isEmpty((Object)businessDynamicObject)) {
            return result;
        }
        if ("hom_onbrdbilltpl".equals(businessDynamicObject.getDynamicObjectType().getName())) {
            String url = HomUrlUtils.dealUrl(businessDynamicObject.getString("url"));
            String candidateId = businessDynamicObject.getString("candidate.id");
            String safeLoginUrl = IOnbrdCommonAppService.getInstance().transToSafeLoginUrl(url, "1060_S", candidateId);
            if (StringUtils.isNotBlank((CharSequence)(safeLoginUrl = HomUrlUtils.dealUrl(safeLoginUrl))) && safeLoginUrl.contains("http")) {
                businessDynamicObject.set("url", (Object)safeLoginUrl);
                paramMap.put("mc_url", safeLoginUrl);
            }
        }
        JSONObject mObject = JSONObject.parseObject((String)msgTemplate);
        for (Map.Entry entry : mObject.entrySet()) {
            Object value = entry.getValue();
            if (PluginUtil.isJSONObject(value)) {
                JSONObject con = JSONObject.parseObject((String)value.toString());
                if (null == con) continue;
                for (Map.Entry stringObjectEntry : con.entrySet()) {
                    result.put((String)stringObjectEntry.getKey(), MessageTemplateParser.transferStrNew(stringObjectEntry.getValue().toString(), businessDynamicObject, paramMap));
                }
                continue;
            }
            result.put(entry.getKey().toString(), MessageTemplateParser.transferStrNew(value.toString(), businessDynamicObject, paramMap));
        }
        return result;
    }

    public static Map<String, Object> parserMessageTplParam(String templateNumber, Long businessId, Map<String, Object> paramMap, DynamicObject dynamicObject) {
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = HomCommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        if ("hom_onbrdbilltpl".equals(businessDynamicObject.getDynamicObjectType().getName())) {
            String url = HomUrlUtils.dealUrl(businessDynamicObject.getString("url"));
            String candidateId = businessDynamicObject.getString("candidate.id");
            String safeLoginUrl = IOnbrdCommonAppService.getInstance().transToSafeLoginUrl(url, "1060_S", candidateId);
            if (StringUtils.isNotBlank((CharSequence)(safeLoginUrl = HomUrlUtils.dealUrl(safeLoginUrl))) && safeLoginUrl.contains("http")) {
                result.put("url", safeLoginUrl);
                result.put("mc_url", safeLoginUrl);
            }
        }
        result.putAll(paramMap);
        JSONObject mObject = JSONObject.parseObject((String)msgTemplate);
        for (Map.Entry entry : mObject.entrySet()) {
            Object value = entry.getValue();
            if (PluginUtil.isJSONObject(value)) {
                JSONObject con = JSONObject.parseObject((String)value.toString());
                if (null == con) continue;
                for (Map.Entry stringObjectEntry : con.entrySet()) {
                    MessageTemplateParser.transferStrParam(stringObjectEntry.getValue().toString(), businessDynamicObject, result);
                }
                continue;
            }
            MessageTemplateParser.transferStrParam(value.toString(), businessDynamicObject, result);
        }
        return result;
    }

    @Deprecated
    private static String transferStr(String contentStr, DynamicObject businessDynamicObject, Map<String, String> paramMap) {
        ArrayList<String> params = new ArrayList<String>();
        String str = MessageTemplateParser.parseMsgTemplate(contentStr, params);
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = "";
            string = object.getDataEntityType().getProperties().containsKey((Object)strId) ? (object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)"yyyy-MM-dd") : object.getString(strId)) : HRStringUtils.cnulls((String)paramMap.get(strId), (String)"");
            result.add(string);
        }
        return MessageFormat.format(str, result.toArray());
    }

    private static String transferStrNew(String contentStr, DynamicObject businessDynamicObject, Map<String, Object> paramMap) {
        ArrayList<String> params = new ArrayList<String>();
        String str = MessageTemplateParser.parseMsgTemplate(contentStr, params);
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = "";
            string = object.getDataEntityType().getProperties().containsKey((Object)strId) ? (object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)"yyyy-MM-dd") : object.getString(strId)) : HRStringUtils.cnulls((Object)paramMap.get(strId), (String)"");
            result.add(string);
        }
        return MessageFormat.format(str, result.toArray());
    }

    private static void transferStrParam(String contentStr, DynamicObject businessDynamicObject, Map<String, Object> result) {
        ArrayList<String> params = new ArrayList<String>();
        MessageTemplateParser.parseMsgTemplate(contentStr, params);
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.put(param, strId);
                continue;
            }
            String string = "";
            if (object.getDataEntityType().getProperties().containsKey((Object)strId)) {
                string = object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)"yyyy-MM-dd") : object.getString(strId);
            }
            if (!HRStringUtils.isNotEmpty((String)string)) continue;
            result.put(param, string);
        }
    }

    public static String getMessageContext(String templateNumber, Long businessId) {
        return MessageTemplateParser.getMessageContext(templateNumber, businessId, new HashMap<String, String>());
    }

    private static DynamicObject getDynamicObject(String[] split, DynamicObject dynamicObject, int index) {
        if (index < split.length - 1) {
            DynamicObject dynamicObject1 = dynamicObject.getDynamicObject(split[index]);
            return MessageTemplateParser.getDynamicObject(split, dynamicObject1, index + 1);
        }
        return dynamicObject;
    }

    private static String parseMsgTemplate(String msgTemplate, List<String> params) {
        if (HRStringUtils.isEmpty((String)msgTemplate)) {
            return "";
        }
        String result = msgTemplate;
        String[] split = msgTemplate.split("\\{");
        if (split.length <= 1) {
            return result;
        }
        for (int i = 1; i < split.length; ++i) {
            String param = split[i];
            params.add(param.substring(0, param.indexOf(125)));
            result = result.replace('{' + param.substring(0, param.indexOf(125)) + "}", "{" + (i - 1) + "}");
        }
        return result;
    }

    public static Tuple<String, String> getMessageContextTuple(String templateNumber, Long businessId) {
        DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return Tuple.create((Object)"", (Object)"");
        }
        String msgTemplate = dynamicObject.getLocaleString("msgtemplate").getLocaleValue_zh_CN();
        LOG.info(MessageFormat.format("msgTemplate is: {0},templateNumber is {1},applybill is {2}", msgTemplate, templateNumber, businessId));
        DynamicObject msgEntity = dynamicObject.getDynamicObject("msgentity");
        String dentityid = msgEntity.getString("id");
        DynamicObject businessDynamicObject = HomCommonRepository.queryDynamicObjectByPk(dentityid, "", businessId);
        Map<String, String> result = MessageTemplateParser.parserMessageTplNew(templateNumber, businessId, new HashMap<String, String>(), dynamicObject);
        String title = MessageTemplateParser.setParams(msgTemplate, businessDynamicObject, "title");
        String content = MessageTemplateParser.setParams(msgTemplate, businessDynamicObject, "content");
        for (Map.Entry<String, String> stringStringEntry : result.entrySet()) {
            if (stringStringEntry.getKey().toLowerCase().contains("title")) {
                title = stringStringEntry.getValue();
                continue;
            }
            if (!stringStringEntry.getKey().toLowerCase().contains("content")) continue;
            content = stringStringEntry.getValue();
        }
        return Tuple.create((Object)title, (Object)content);
    }

    private static String setParams(String msgTemplate, DynamicObject businessDynamicObject, String content) {
        ArrayList<String> params = new ArrayList<String>();
        JSONObject templateObject = JSONObject.parseObject((String)msgTemplate);
        String str = MessageTemplateParser.parseMsgTemplate(templateObject.getString(content), params);
        ArrayList<String> result = new ArrayList<String>();
        for (String param : params) {
            String[] split = param.split("\\.");
            DynamicObject object = MessageTemplateParser.getDynamicObject(split, businessDynamicObject, 1);
            String strId = split[split.length - 1];
            if (Objects.isNull(object)) {
                result.add(strId);
                continue;
            }
            String string = object.get(strId) != null && Timestamp.class.equals(object.get(strId).getClass()) ? HRDateTimeUtils.format((Date)object.getDate(strId), (String)"yyyy-MM-dd") : object.getString(strId);
            result.add(string);
        }
        return MessageFormat.format(str, result.toArray());
    }
}

