/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.IMessageService;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.IHomConfigService;
import kd.hr.hom.business.domain.service.common.IHomRuleEngineService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.impl.common.MessageTemplateParser;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.MessageDTO;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.sdk.hr.hom.business.msg.IMsgParamService;

public class SendMessageServiceImpl
implements ISendMessageService {
    private static final Log logger = LogFactory.getLog(SendMessageServiceImpl.class);
    private final Map<RuleEngineSceneNumberEnum, String> RULE_ENGINE_SCENE_NUMBER_MAP = new ImmutableMap.Builder().put((Object)RuleEngineSceneNumberEnum.COLLECT_NOTICE_MESSAGE, (Object)"OBD005").put((Object)RuleEngineSceneNumberEnum.COLLECT_TASK_NOTICE_MESSAGE, (Object)"OBD014").put((Object)RuleEngineSceneNumberEnum.COLLECT_APPROVE_PASS, (Object)"OBD006").put((Object)RuleEngineSceneNumberEnum.COLLECT_APPROVE_FAIL, (Object)"OBD007").put((Object)RuleEngineSceneNumberEnum.COLLECT_APPROVE_REJECT, (Object)"OBD008").put((Object)RuleEngineSceneNumberEnum.NOTICE_APPOINTMENT, (Object)"OBD009").put((Object)RuleEngineSceneNumberEnum.MANAGE_NOTICE_TRANSFER, (Object)"OBD016").put((Object)RuleEngineSceneNumberEnum.DO_NOTICE_TRANSFER, (Object)"OBD015").put((Object)RuleEngineSceneNumberEnum.UNDO_NOTICE, (Object)"OBD017").put((Object)RuleEngineSceneNumberEnum.HOMSCE_CHECK_PASS_MESSAGE, (Object)"OBD018").put((Object)RuleEngineSceneNumberEnum.HOMSCE_CHECK_FAIL_MESSAGE, (Object)"OBD019").build();

    @Override
    public String getTextMessageTemplateNumber(String buNumber, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, DynamicObject onbrdBill) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        DynamicObject dbOnbrdBill = this.getOnbrdBillById(onbrdBill.getLong("id"));
        map.put("onbrdbill", dbOnbrdBill);
        return this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, map);
    }

    @Override
    public String getTextMessageTemplateNumber(String buNumber, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, Map<String, Object> map) {
        String messageNumber = this.RULE_ENGINE_SCENE_NUMBER_MAP.get(ruleEngineSceneNumberEnum);
        if (HRStringUtils.isNotEmpty((String)messageNumber)) {
            return messageNumber;
        }
        IHomRuleEngineService service = ServiceFactory.getService(IHomRuleEngineService.class);
        try {
            Map<String, Object> resultResp = service.callRuleEngineResult(ruleEngineSceneNumberEnum.getSceneNumber(), buNumber, map);
            if (!HRObjectUtils.isEmpty(resultResp)) {
                Object result = resultResp.get("result");
                return result.toString();
            }
            logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u77ed\u4fe1\u6d88\u606f\u6a21\u677f\u5931\u8d25");
        }
        catch (Exception exception) {
            logger.error("\u89c4\u5219\u5f15\u64ce\u83b7\u53d6\u77ed\u4fe1\u6d88\u606f\u6a21\u677f\u5931\u8d25", (Throwable)exception);
        }
        return "";
    }

    @Override
    public boolean sendTextMessageWithOnbrdBill(String buNumber, DynamicObject onbrdBill, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, Map<String, List<String>> concatMap) {
        String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill);
        if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
            return false;
        }
        long bizId = onbrdBill.getLong("id");
        String billNo = onbrdBill.getString("billno");
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
        IMsgParamService msgchannel = ServiceFactory.getImplService(IMsgParamService.class, templateDyn.getString("msgchannel"));
        if (HRObjectUtils.isEmpty((Object)msgchannel)) {
            MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO((Long)bizId, textMessageTemplateNumber, null, billNo, "");
            messageDto.setEmailsToParams(concatMap.get("email"));
            messageDto.setPhonesToParams(concatMap.get("phone"));
            return SendMessageUtil.sendMessage(messageDto);
        }
        return msgchannel.sendMessage(concatMap, templateDyn, onbrdBill, new HashMap());
    }

    @Override
    public boolean sendTextMessage(String buNumber, Long bizId, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, Map<String, List<String>> concatMap, Map<String, String> paramMap) {
        QFilter qFilter = new QFilter("id", "=", (Object)bizId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("", new QFilter[]{qFilter});
        String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill);
        if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
            return false;
        }
        return this.sendTextMessageWithOnbrdBill(buNumber, onbrdBill, ruleEngineSceneNumberEnum, concatMap);
    }

    @Override
    public boolean sendTextByTemplate(String buNumber, Long bizId, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, List<Long> userIds, Map<String, String> paramMap) {
        QFilter qFilter = new QFilter("id", "=", (Object)bizId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("", new QFilter[]{qFilter});
        String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill);
        if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
            return false;
        }
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
        try {
            Map<String, String> messageTextMap = MessageTemplateParser.parserMessageTplNew(templateDyn.getString("number"), bizId, paramMap, templateDyn);
            messageTextMap.put("billno", onbrdBill.getString("billno"));
            SendMessageUtil.sendMessageByTemplate(bizId, messageTextMap, "", userIds, templateDyn, paramMap);
        }
        catch (Exception e) {
            logger.error("###SendMessageServiceImpl.sendTextByTemplate error:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Map<Long, Boolean> batchSendTextMessage(Map<String, Map<Long, Map<String, List<String>>>> listMap, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        if (listMap.isEmpty()) {
            return new HashMap<Long, Boolean>();
        }
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        HashSet onbrdIds = new HashSet(listMap.size());
        listMap.values().forEach(onbrdMap -> onbrdIds.addAll(onbrdMap.keySet()));
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("", new QFilter[]{qFilter});
        Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        for (Map.Entry<String, Map<Long, Map<String, List<String>>>> stringMapEntry : listMap.entrySet()) {
            String buNumber = stringMapEntry.getKey();
            Map<Long, Map<String, List<String>>> value = stringMapEntry.getValue();
            for (Map.Entry<Long, Map<String, List<String>>> longListEntry : value.entrySet()) {
                Long onbrdId = longListEntry.getKey();
                DynamicObject onbrdBill2 = onbrdBillMap.get(onbrdId);
                String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill2);
                if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
                    result.put(onbrdId, Boolean.FALSE);
                    logger.info("###SendMessageServiceImpl.batchSendTextMessage textMessageTemplateNumber is empty! onbrdId:{}, ruleEngineSceneNumberEnum:{}", (Object)onbrdId, (Object)ruleEngineSceneNumberEnum.getSceneNumber());
                    continue;
                }
                String billNo = onbrdBill2.getString("billno");
                MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(onbrdId, textMessageTemplateNumber, null, billNo, "");
                List emailList = longListEntry.getValue().getOrDefault("email", new ArrayList());
                List phoneList = longListEntry.getValue().getOrDefault("phone", new ArrayList());
                messageDto.setEmailsToParams(emailList);
                messageDto.setPhonesToParams(phoneList);
                DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
                IMsgParamService msgchannel = ServiceFactory.getImplService(IMsgParamService.class, templateDyn.getString("msgchannel"));
                if (HRObjectUtils.isEmpty((Object)msgchannel)) {
                    result.put(longListEntry.getKey(), SendMessageUtil.sendMessage(messageDto));
                    continue;
                }
                result.put(longListEntry.getKey(), msgchannel.sendMessage(longListEntry.getValue(), templateDyn, onbrdBill2, new HashMap()));
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> sendShortInfo(String buNumber, Long bizId, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, List<String> phoneList) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        DynamicObject onbrdBill = this.getOnbrdBillById(bizId);
        map.put("onbrdbill", onbrdBill);
        String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, map);
        if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u5339\u914d\u6d88\u606f\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SendMessageServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
            return resultMap;
        }
        String messageContext = "";
        try {
            messageContext = MessageTemplateParser.getMessageContext(textMessageTemplateNumber, bizId);
        }
        catch (Exception exception) {
            logger.error("sendShortInfo error", (Throwable)exception);
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u6d88\u606f\u6a21\u677f\u5185\u5bb9\u89e3\u6790\u62a5\u9519\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SendMessageServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]));
            return resultMap;
        }
        String billNo = onbrdBill.getString("billno");
        MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(bizId, textMessageTemplateNumber, null, billNo, "");
        messageDto.setContent(messageContext);
        messageDto.setPhonesToParams(phoneList);
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
        IMsgParamService msgchannel = ServiceFactory.getImplService(IMsgParamService.class, templateDyn.getString("msgchannel"));
        if (HRObjectUtils.isEmpty((Object)msgchannel)) {
            if (SendMessageUtil.sendMessage(messageDto)) {
                resultMap.put("success", Boolean.TRUE);
                resultMap.put("message", null);
            }
        } else if (this.sendTextMessageService(messageContext, phoneList)) {
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("message", null);
        }
        return resultMap;
    }

    private DynamicObject getOnbrdBillById(Long bizId) {
        return HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "", bizId);
    }

    @Override
    public Map<String, Object> batchSendShortInfo(Map<String, List<DynamicObject>> paramMap, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, List<Long> ids) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        logger.info("batchSendShortInfo-start");
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : paramMap.entrySet()) {
            String buNumber = stringListEntry.getKey();
            List<DynamicObject> value = stringListEntry.getValue();
            for (DynamicObject dynamicObject : value) {
                DynamicObject onbrdObj = dynamicObject.getDynamicObject("onbrd");
                DynamicObject dbOnbrdBill = this.getOnbrdBillById(onbrdObj.getLong("id"));
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("onbrdbill", dbOnbrdBill);
                String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, map);
                if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
                    HashMap<String, Object> successHashMap = new HashMap<String, Object>(3);
                    String id = dynamicObject.getString("id");
                    successHashMap.put("success", Boolean.FALSE);
                    successHashMap.put("message", ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u5f15\u64ce\u5931\u8d25;", (String)"SendMessageServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]));
                    resultMap.put(id, successHashMap);
                    continue;
                }
                String phone = onbrdObj.getString("phone");
                String email = onbrdObj.getString("peremail");
                long bizId = dbOnbrdBill.getLong("id");
                String billNo = dbOnbrdBill.getString("billno");
                HashMap<String, List<String>> concatMap = new HashMap<String, List<String>>();
                concatMap.put("phone", Collections.singletonList(phone));
                concatMap.put("email", Collections.singletonList(email));
                DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", textMessageTemplateNumber);
                IMsgParamService msgchannel = ServiceFactory.getImplService(IMsgParamService.class, templateDyn.getString("msgchannel"));
                if (!HRObjectUtils.isEmpty((Object)msgchannel)) {
                    msgchannel.sendMessage(concatMap, templateDyn, onbrdObj, new HashMap());
                } else {
                    MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO((Long)bizId, textMessageTemplateNumber, null, billNo, "");
                    messageDto.setEmailsToParams(Collections.singletonList(email));
                    messageDto.setPhonesToParams(Collections.singletonList(phone));
                    SendMessageUtil.sendMessage(messageDto);
                }
                String id = dynamicObject.getString("id");
                HashMap<String, Boolean> successHashMap = new HashMap<String, Boolean>(3);
                successHashMap.put("success", Boolean.TRUE);
                successHashMap.put("message", null);
                resultMap.put(id, successHashMap);
            }
        }
        logger.info("batchSendShortInfo-end");
        return resultMap;
    }

    @Override
    public void batchSendShortInfo(Map<Long, Long> bizIdAndMessageTplIdMap, Map<Long, List<String>> bizIdAndPhoneListMap, Map<Long, Long> bizIdAndOnbrdIdMap) {
        logger.info("batchSendShortInfo-start");
        DynamicObject[] templateObjs = HomCommonRepository.queryDynamicObjectByPks("msg_template", "", bizIdAndMessageTplIdMap.values().toArray(new Object[0]));
        if (templateObjs == null || templateObjs.length == 0) {
            return;
        }
        Map<Long, DynamicObject> templateObjsMap = Arrays.stream(templateObjs).collect(Collectors.toMap(templateObj -> templateObj.getLong("id"), templateObj -> templateObj));
        for (Map.Entry<Long, List<String>> longListEntry : bizIdAndPhoneListMap.entrySet()) {
            DynamicObject dynamicObject = templateObjsMap.get(bizIdAndMessageTplIdMap.get(longListEntry.getKey()));
            if (Objects.isNull(dynamicObject)) continue;
            String templateNumber = dynamicObject.getString("number");
            Long businessId = bizIdAndOnbrdIdMap.get(longListEntry.getKey());
            DynamicObject onbrdObj = HomCommonRepository.queryDynamicObjectByPk("hom_onbrdbilltpl", "", businessId);
            String billNo = onbrdObj.getString("billno");
            MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(businessId, templateNumber, null, billNo, "");
            String phone = onbrdObj.getString("phone");
            String email = onbrdObj.getString("peremail");
            HashMap<String, List<String>> concatMap = new HashMap<String, List<String>>();
            concatMap.put("phone", Collections.singletonList(phone));
            concatMap.put("email", Collections.singletonList(email));
            DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
            IMsgParamService msgchannel = ServiceFactory.getImplService(IMsgParamService.class, templateDyn.getString("msgchannel"));
            if (!HRObjectUtils.isEmpty((Object)msgchannel)) {
                msgchannel.sendMessage(concatMap, templateDyn, onbrdObj, new HashMap());
                continue;
            }
            messageDto.setEmailsToParams(Collections.singletonList(email));
            messageDto.setPhonesToParams(Collections.singletonList(phone));
            SendMessageUtil.sendMessage(messageDto);
        }
        logger.info("batchSendShortInfo-end");
    }

    @Override
    public boolean sendmail(String buNumber, Long bizId, Map<String, Object> emailInfoMap, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        logger.info(MessageFormat.format("sendmail-start-bizId is {1}", bizId));
        return this.sendMailInfo(emailInfoMap);
    }

    private boolean sendMailInfo(Map<String, Object> emailInfoMap) {
        try {
            Object attachmentNames;
            if (CollectionUtils.isEmpty(emailInfoMap)) {
                return false;
            }
            EmailInfo emailInfo = new EmailInfo();
            emailInfo.setTitle((String)emailInfoMap.get("title"));
            Object receiver = emailInfoMap.get("receiver");
            if (receiver instanceof List) {
                List receiverList = (List)receiver;
                emailInfo.setReceiver(receiverList);
            }
            emailInfo.setContentMimeType("HTML");
            emailInfo.setContent((String)emailInfoMap.get("content"));
            Object attachments = emailInfoMap.get("attachments");
            if (attachments instanceof List) {
                List attachmentsList = (List)attachments;
                emailInfo.setAttachments(attachmentsList);
            }
            if ((attachmentNames = emailInfoMap.get("attachmentnames")) instanceof List) {
                emailInfo.setAttachmentNames((List)attachmentNames);
            }
            ServiceFactory.getService(IMessageService.class).sendEmail(emailInfo);
            logger.info("sendmail-end-resultMap success");
            return true;
        }
        catch (Exception exception) {
            logger.error("###sendMailInfo exception:", (Throwable)exception);
            return false;
        }
    }

    @Override
    public void batchSendmail(Map<Long, Map<String, Object>> params) {
        logger.info("batchSendmail-satrt");
        for (Map.Entry<Long, Map<String, Object>> mapEntry : params.entrySet()) {
            this.sendMailInfo(mapEntry.getValue());
        }
        logger.info("batchSendmail-end");
    }

    private boolean sendTextMessageService(String messageContext, List<String> phoneList) {
        try {
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setMessage(messageContext);
            Tuple<String, String> sysWhiteListConfig = this.smsWhiteList();
            phoneList = phoneList.stream().filter(phone -> !HRStringUtils.equals((String)((String)sysWhiteListConfig.item1), (String)"1") || ((String)sysWhiteListConfig.item2).contains((CharSequence)phone)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(phoneList)) {
                return true;
            }
            shortMessageInfo.setPhone(phoneList);
            ServiceFactory.getService(IMessageService.class).sendShortMessage(shortMessageInfo);
            return true;
        }
        catch (Exception exception) {
            logger.error("sendTextMessageService exception", (Throwable)exception);
            return false;
        }
    }

    private Tuple<String, String> smsWhiteList() {
        String smsWhiteListEnable = ServiceFactory.getService(IHomConfigService.class).getConfVal("sms_whitelist_enable", "0");
        if ("1".equals(smsWhiteListEnable)) {
            String smsWhiteListStr = ServiceFactory.getService(IHomConfigService.class).getConfVal("sms_whitelist_str", "");
            return Tuple.create((Object)"1", (Object)smsWhiteListStr);
        }
        return Tuple.create((Object)"0", (Object)"");
    }

    @Override
    public boolean sendMessageNew(DynamicObject dynamicObject, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        String buNumber = dynamicObject.getString("onboard.org.number");
        Long bizId = dynamicObject.getLong("onboard.id");
        QFilter qFilter = new QFilter("id", "=", (Object)bizId);
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBill("", new QFilter[]{qFilter});
        String templateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill);
        String billNo = onbrdBill.getString("billno");
        String phone = dynamicObject.getString("onboard.phone");
        DynamicObject templateDyn = HomCommonRepository.queryDynamicObjectByNumber("msg_template", "", templateNumber);
        String email = dynamicObject.getString("onboard.peremail");
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)templateNumber)) {
            return false;
        }
        String msgchannel = templateDyn.getString("msgchannel");
        IMsgParamService service = ServiceFactory.getImplService(IMsgParamService.class, msgchannel);
        if (HRObjectUtils.isEmpty((Object)service)) {
            MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(bizId, templateNumber, null, billNo, "");
            messageDto.setEmailsToParams(Collections.singletonList(email));
            messageDto.setPhonesToParams(Collections.singletonList(phone));
            return SendMessageUtil.sendMessage(messageDto);
        }
        ArrayList<String> phoneList = new ArrayList<String>();
        phoneList.add(phone);
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(email);
        HashMap<String, ArrayList<String>> targetMap = new HashMap<String, ArrayList<String>>();
        targetMap.put("phone", phoneList);
        targetMap.put("email", emailList);
        return service.sendMessage(targetMap, templateDyn, onbrdBill, new HashMap());
    }

    @Override
    public Map<Long, Boolean> sendMessage(Map<Long, List<Map<Long, Map<String, String>>>> onbrdIdAndPhone, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        QFilter filter = new QFilter("id", "in", onbrdIdAndPhone.keySet());
        DynamicObject[] onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("", new QFilter[]{filter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)onbrdIdAndPhone.size());
        for (DynamicObject onbrdBill : onbrdBills) {
            this.sendLeaderAndTeacherMsg(onbrdIdAndPhone, ruleEngineSceneNumberEnum, result, onbrdBill);
        }
        return result;
    }

    private void sendLeaderAndTeacherMsg(Map<Long, List<Map<Long, Map<String, String>>>> onbrdIdAndPhone, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, Map<Long, Boolean> result, DynamicObject onbrdBill) {
        String buNumber = onbrdBill.getString("org.number");
        Long bizId = onbrdBill.getLong("id");
        List<Map<Long, Map<String, String>>> onbrdIdAndPhoneList = onbrdIdAndPhone.get(bizId);
        if (!CollectionUtils.isEmpty(onbrdIdAndPhoneList)) {
            for (Map<Long, Map<String, String>> phoneAndPerson : onbrdIdAndPhoneList) {
                for (Map.Entry<Long, Map<String, String>> entry : phoneAndPerson.entrySet()) {
                    String positionName;
                    String positionMsg;
                    Map<String, String> concat = entry.getValue();
                    String personName = concat.get("name");
                    HashMap<String, String> params = new HashMap<String, String>(3);
                    String positionType = onbrdBill.getString("apositiontype");
                    if ("1".equals(positionType)) {
                        positionMsg = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"SendMessageServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]);
                        positionName = onbrdBill.getString("aposition") != null ? onbrdBill.getString("aposition.name") : "";
                        params.put("positiontype", positionMsg);
                        params.put("positionname", positionName);
                    }
                    if ("0".equals(positionType)) {
                        positionMsg = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"SendMessageServiceImpl_5", (String)"hr-hom-business", (Object[])new Object[0]);
                        positionName = onbrdBill.getString("stdposition") != null ? onbrdBill.getString("stdposition.name") : "";
                        params.put("positiontype", positionMsg);
                        params.put("positionname", positionName);
                    }
                    if ("2".equals(positionType)) {
                        positionMsg = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"SendMessageServiceImpl_6", (String)"hr-hom-business", (Object[])new Object[0]);
                        positionName = Optional.ofNullable(onbrdBill.getString("ajob.name")).orElse("");
                        params.put("positiontype", positionMsg);
                        params.put("positionname", positionName);
                    }
                    params.put("personname", personName);
                    ImmutableList userIds = ImmutableList.of((Object)entry.getKey());
                    result.put(bizId, this.sendTextByTemplate(buNumber, bizId, ruleEngineSceneNumberEnum, (List<Long>)userIds, params));
                }
            }
        }
    }

    @Override
    public boolean sendMessage(String phone, String messageContext) {
        try {
            ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
            shortMessageInfo.setMessage(messageContext);
            shortMessageInfo.setPhone((List)ImmutableList.of((Object)phone));
            Tuple<String, String> sysWhiteListConfig = this.smsWhiteList();
            if (HRStringUtils.equals((String)((String)sysWhiteListConfig.item1), (String)"1") && !((String)sysWhiteListConfig.item2).contains(phone)) {
                return true;
            }
            ServiceFactory.getService(IMessageService.class).sendShortMessage(shortMessageInfo);
            return true;
        }
        catch (Exception exception) {
            logger.error("sendTextMessageService exception", (Throwable)exception);
            return false;
        }
    }

    @Override
    public Map<Long, Boolean> sendMessage(Collection<Long> onbrdIds, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        DynamicObject[] onbrdBills;
        HashMap result = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        for (DynamicObject onbrdBill : onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("", new QFilter[]{qFilter})) {
            String buNumber = onbrdBill.getString("org.number");
            Long bizId = onbrdBill.getLong("id");
            ImmutableList phoneList = ImmutableList.of((Object)onbrdBill.getString("phone"));
            ImmutableList emailList = ImmutableList.of((Object)onbrdBill.getString("peremail"));
            HashMap<String, List<String>> concatMap = new HashMap<String, List<String>>();
            concatMap.put("phone", (List<String>)phoneList);
            concatMap.put("email", (List<String>)emailList);
            result.put(bizId, this.sendTextMessageWithOnbrdBill(buNumber, onbrdBill, ruleEngineSceneNumberEnum, concatMap));
        }
        return result;
    }

    @Override
    public Map<Long, Boolean> sendEmails(Collection<Long> onbrdIds, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, String mailTile) {
        DynamicObject[] onbrdBills;
        HashMap result = Maps.newHashMapWithExpectedSize((int)onbrdIds.size());
        QFilter qFilter = new QFilter("id", "in", onbrdIds);
        for (DynamicObject onbrdBill : onbrdBills = IOnbrdBillDomainService.getInstance().findOnbrdBills("", new QFilter[]{qFilter})) {
            String buNumber = onbrdBill.getString("org.number");
            Long bizId = onbrdBill.getLong("id");
            String email = onbrdBill.getString("peremail");
            result.put(bizId, this.sendEmailMessage(buNumber, onbrdBill, ruleEngineSceneNumberEnum, email, mailTile));
        }
        return result;
    }

    @Override
    public boolean sendEmailMessage(String buNumber, DynamicObject onbrdBill, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum, String email, String mailTile) {
        String textMessageTemplateNumber = this.getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdBill);
        if (StringUtils.isEmpty((Object)textMessageTemplateNumber)) {
            return false;
        }
        String messageContext = "";
        Long bizId = onbrdBill.getLong("id");
        try {
            messageContext = MessageTemplateParser.getMessageContext(textMessageTemplateNumber, bizId);
        }
        catch (Exception exception) {
            logger.error("\u89e3\u6790\u6d88\u606f\u5185\u5bb9\u62a5\u9519", (Throwable)exception);
            return false;
        }
        ImmutableList receiverList = ImmutableList.of((Object)email);
        HashMap<String, Object> emailInfoMap = new HashMap<String, Object>(16);
        emailInfoMap.put("title", mailTile);
        emailInfoMap.put("receiver", receiverList);
        emailInfoMap.put("copyreceiver", receiverList);
        emailInfoMap.put("secretreceiver", receiverList);
        emailInfoMap.put("content", messageContext);
        return this.transferEmailToMsgTemplate(emailInfoMap, bizId, textMessageTemplateNumber, onbrdBill);
    }

    private boolean transferEmailToMsgTemplate(Map<String, Object> emailInfoMap, Long bizId, String templateNumber, DynamicObject onbrdBill) {
        String billNo = onbrdBill.getString("billno");
        String email = onbrdBill.getString("peremail");
        String phone = onbrdBill.getString("phone");
        String title = (String)emailInfoMap.get("title");
        String content = (String)emailInfoMap.get("content");
        MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO(bizId, templateNumber, null, billNo, "");
        messageDto.setContent(content);
        messageDto.setTitle(title);
        messageDto.setEmailsToParams(Collections.singletonList(email));
        messageDto.setPhonesToParams(Collections.singletonList(phone));
        return SendMessageUtil.sendMessage(messageDto);
    }

    @Override
    @Deprecated
    public Map<Long, Long> sendMessage(DynamicObject[] dys, List<Long> personIds, Map<String, String> params) {
        String templateNumber = "OBD020";
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (DynamicObject dy : dys) {
            if (HRStringUtils.isEmpty((String)templateNumber)) {
                map.put((Long)dy.getPkValue(), 0L);
            }
            Tuple<String, String> messageContext = MessageTemplateParser.getMessageContextTuple(templateNumber, dy.getLong("id"));
            MessageInfo message = new MessageInfo();
            message.setMessageType("message");
            message.setMessageContent((ILocaleString)new LocaleString((String)messageContext.item2));
            message.setMessageTitle((ILocaleString)new LocaleString((String)messageContext.item1));
            List<Long> filterIds = SendMessageUtil.getFilterIds(personIds);
            if (HRCollUtil.isEmpty(filterIds)) continue;
            message.setUserIds(filterIds);
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u5165\u804c\u534f\u4f5c", (String)"SendMessageUtil_2", (String)"hr-hom-business"));
            message.setContentUrl(SendMessageUtil.buildURL(dy, params));
            MessageCenterServiceHelper.batchSendMessages(Collections.singletonList(message));
            map.put((Long)dy.getPkValue(), message.getId());
        }
        return map;
    }

    @Override
    public void sendMessageByTemplateNumber(MessageDTO messageDto) {
        SendMessageUtil.sendMessage(messageDto);
    }
}

