/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.hbpm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.domain.repository.HbpmRepository;
import kd.hr.hom.business.domain.service.hbpm.IHbpmDataDomainService;
import kd.hr.hom.common.util.HOMObjectUtils;

public class HbpmDataDomainService
implements IHbpmDataDomainService {
    private static final Log LOG = LogFactory.getLog(HbpmDataDomainService.class);
    private static final String DATA = "data";

    @Override
    public Map<String, Object> getHrBuScmJob(List<Long> ids) {
        try {
            Map<String, Object> result = HbpmRepository.getHrIposition(ids);
            ArrayList list = (ArrayList)result.get(DATA);
            return (Map)list.get(0);
        }
        catch (Exception e) {
            LOG.error("invoke getHrIposition failed!", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public Map<String, Object> getStandardBuScmJob(List<Long> ids) {
        try {
            Map<String, Object> result = HbpmRepository.getStandardIposition(ids);
            ArrayList list = (ArrayList)result.get(DATA);
            return (Map)list.get(0);
        }
        catch (Exception e) {
            LOG.error("invoke getStandardIposition failed!", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public Map<Long, Map<String, Object>> getBatchHrBuScmJob(List<Long> ids) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        try {
            Map<String, Object> result = HbpmRepository.getHrIposition(ids);
            ArrayList list = (ArrayList)result.get(DATA);
            if (!HRObjectUtils.isEmpty((Object)list)) {
                for (Map data : list) {
                    resultMap.put((Long)data.get("id"), data);
                }
            } else {
                LOG.error(String.valueOf(ids));
            }
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke getHrIposition failed!", (Throwable)e);
            return resultMap;
        }
    }

    @Override
    public Map<Long, Map<String, Object>> getBatchStandardBuScmJob(List<Long> ids) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        try {
            LOG.info("ids:" + HOMObjectUtils.toJSONString(ids));
            Map<String, Object> result = HbpmRepository.getStandardIposition(ids);
            ArrayList list = (ArrayList)result.get(DATA);
            if (!HRObjectUtils.isEmpty((Object)list)) {
                LOG.info(HOMObjectUtils.toJSONString((Object)list));
                for (Map data : list) {
                    resultMap.put((Long)data.get("boid"), data);
                }
            } else {
                LOG.error(String.valueOf(ids));
            }
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke getStandardIposition failed!", (Throwable)e);
            return resultMap;
        }
    }

    @Override
    public Map<Long, Object> queryJobLevelAndJobGradeByStdPositionIds(List<Long> ids) {
        HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
        try {
            Map<String, Object> result = HbpmRepository.queryJobLevelAndJobGradeByStdPositionIds(ids);
            if (!HRObjectUtils.isEmpty(result)) {
                LOG.info("invoke queryJobLevelAndJobGradeByStdPositionIds");
                LOG.info(result.toString());
                if (HRObjectUtils.isEmpty((Object)result.get(DATA))) {
                    return resultMap;
                }
                return (HashMap)result.get(DATA);
            }
            LOG.error(String.valueOf(ids));
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke queryJobLevelAndJobGradeByStdPositionIds failed!", (Throwable)e);
            return resultMap;
        }
    }

    @Override
    public Map<Long, Object> queryJobLevelAndJobGradeByPositionIds(List<Long> ids) {
        HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
        try {
            Map<String, Object> result = HbpmRepository.queryJobLevelAndJobGradeByPositionIds(ids);
            if (!HRObjectUtils.isEmpty(result)) {
                LOG.info("invoke queryJobLevelAndJobGradeByPositionIds");
                LOG.info(result.toString());
                if (HRObjectUtils.isEmpty((Object)result.get(DATA))) {
                    return resultMap;
                }
                return (HashMap)result.get(DATA);
            }
            LOG.error(String.valueOf(ids));
            return resultMap;
        }
        catch (Exception e) {
            LOG.error("invoke queryJobLevelAndJobGradeByPositionIds failed!", (Throwable)e);
            return resultMap;
        }
    }
}

