/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.hpfs;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.hpfs.IHpfsDataDomainService;
import kd.hr.hom.business.mq.action.MessagePublisher;
import kd.hr.hom.common.constant.ActionMessageConstants;

public class HpfsDataDomainService
implements IHpfsDataDomainService {
    private static final Log LOGGER = LogFactory.getLog(HpfsDataDomainService.class);
    private static final String APP_ID_HPFS = "hpfs";
    private static final String IHPFS_ROLLBACK_SERVICE = "IHPFSRollbackService";
    private static final String DATA_ROLLBACK = "dataRollback";
    private static final String BILL_ID = "billId";
    private static final String CHG_ACTION_ID = "chgaction";
    private static final String BILL_NO = "billNo";

    @Override
    public String dataRollback(Long billId, Long chgActionId, String billNo) {
        Map result;
        LOGGER.info("invoke dataRollback onBrdBillId:{},chgActionId:{},billNo:{}", new Object[]{billId, chgActionId, billNo});
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put(BILL_ID, billId);
        params.put(CHG_ACTION_ID, chgActionId);
        params.put(BILL_NO, billNo);
        DynamicObject onBrd = OnbrdBillRepository.findOnbrdBillById(String.join((CharSequence)",", "name", "discardevent"), billId);
        if (!HRObjectUtils.isEmpty((Object)onBrd)) {
            long discardEvent = onBrd.getLong("discardevent");
            LOGGER.info("discardEvent:{}", (Object)discardEvent);
            params.put("eventId", discardEvent);
        }
        if ((result = (Map)HRMServiceHelper.invokeHRService((String)APP_ID_HPFS, (String)IHPFS_ROLLBACK_SERVICE, (String)DATA_ROLLBACK, (Object[])new Object[]{params})) == null) {
            LOGGER.error("invoke dataRollback return null");
            return ResManager.loadKDString((String)"\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u64a4\u56de\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HpfsDataDomainService_0", (String)"hr-hom-business", (Object[])new Object[0]);
        }
        LOGGER.info("invoke dataRollback result:{}", (Object)result);
        String code = Optional.ofNullable(result.get("code")).map(Object::toString).orElse(null);
        String msg = Optional.ofNullable(result.get("msg")).map(Object::toString).orElse(null);
        this.sendOnBrdRollbackActionMessage(onBrd, result);
        return HRStringUtils.equals((String)code, (String)"200") ? null : msg;
    }

    private void sendOnBrdRollbackActionMessage(DynamicObject onBrd, Map<String, Object> body) {
        String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5165\u804c\u5355\u636e\u64a4\u56de", (String)"RepealOnbrdConfirmEdit_5", (String)"hr-hom-business", (Object[])new Object[0]), onBrd.getString("name"));
        String msgNumber = String.format("%s_%s", onBrd.getString("id"), System.currentTimeMillis());
        MessagePublisher.sendActionMessage(msgNumber, "MP20230703001091", title, ActionMessageConstants.ACTION_ID_ON_BRD_ROLLBACK, body);
    }
}

