/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.integrate;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hom.business.application.impl.onbrd.OnbrdConfirmAppServiceImpl;
import kd.hr.hom.business.domain.repository.IntegrateRepository;
import kd.hr.hom.business.domain.service.integrate.IIntegrateService;
import kd.hr.hom.common.entity.SyncPersonEntity;
import kd.hr.hom.common.enums.IntegrateEnum;

public class IntegrateService
implements IIntegrateService {
    private static final String PROPERTIES_SHOWPAGE = "id,modifytime,sendstatus,consumestatus,onbrd,feedbacktext_tag";

    @Override
    public Object[] saveIntegrateLogs(DynamicObject[] dyos) {
        return IntegrateRepository.saveIntegrateLogs(dyos);
    }

    @Override
    public Object saveIntegrateLog(DynamicObject dyo) {
        return IntegrateRepository.saveIntegrateLog(dyo);
    }

    @Override
    public DynamicObject[] findIntegrateLogs(String selectProperties, QFilter[] filters) {
        return IntegrateRepository.findIntegrateLogs(selectProperties, filters);
    }

    @Override
    public DynamicObject findIntegrateLog(String selectProperties, QFilter[] filters) {
        Object[] integrateLogs = this.findIntegrateLogs(selectProperties, filters);
        if (HRArrayUtils.isEmpty((Object[])integrateLogs)) {
            return null;
        }
        return integrateLogs[0];
    }

    @Override
    public void saveOrUpdIntegraLog(Map<Long, SyncPersonEntity> logMaps) {
        if (!CollectionUtils.isEmpty(logMaps)) {
            DynamicObject[] integrateLogs;
            QFilter filter = new QFilter("onbrd.id", "in", logMaps.keySet()).and("integratemethod", "=", (Object)IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
            for (DynamicObject logDy : integrateLogs = this.findIntegrateLogs(PROPERTIES_SHOWPAGE, new QFilter[]{filter})) {
                SyncPersonEntity entity = logMaps.get(logDy.getLong("onbrd.id"));
                if (HRObjectUtils.isEmpty((Object)entity)) continue;
                logDy.set("consumestatus", (Object)entity.getConsumeStatus());
                logDy.set("feedbacktext_tag", (Object)entity.getConsumeText());
                logDy.set("modifytime", (Object)new Date());
            }
            this.saveIntegrateLogs(integrateLogs);
        }
    }

    @Override
    public void saveOrUpdIntegraLog(Map<Long, SyncPersonEntity> logMaps, String integrate) {
        if (!CollectionUtils.isEmpty(logMaps)) {
            DynamicObject[] integrateLogs;
            QFilter filter = new QFilter("onbrd.id", "in", logMaps.keySet()).and("integratespot", "=", (Object)integrate).and("integratemethod", "=", (Object)IntegrateEnum.INTEGRATE_SPOT_PERSON.getValue());
            for (DynamicObject logDy : integrateLogs = this.findIntegrateLogs(PROPERTIES_SHOWPAGE, new QFilter[]{filter})) {
                SyncPersonEntity entity = logMaps.get(logDy.getLong("onbrd.id"));
                if (HRObjectUtils.isEmpty((Object)entity)) continue;
                logDy.set("consumestatus", (Object)entity.getConsumeStatus());
                logDy.set("feedbacktext_tag", (Object)entity.getConsumeText());
                logDy.set("modifytime", (Object)new Date());
            }
            this.saveIntegrateLogs(integrateLogs);
        }
    }

    @Override
    public void syncHpfs(Long[] onbrdIdArray) {
        Long userId = RequestContext.get().getCurrUserId();
        Set<Long> ids = Arrays.stream(onbrdIdArray).collect(Collectors.toSet());
        DynamicObject[] onbrdBillDetailInfoList = new OnbrdConfirmAppServiceImpl().getOnbrdBillInfoForDealing(ids);
        List<DynamicObject> canConfirmSimpleList = Arrays.stream(onbrdBillDetailInfoList).collect(Collectors.toList());
        new OnbrdConfirmAppServiceImpl().retryHpfs(userId, canConfirmSimpleList);
    }
}

