/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.invite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.impl.onbrd.OnbrdWorkTableServiceImpl;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdWorkTableService;
import kd.hr.hom.business.application.utils.SendMessageUtil;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.invite.IOnbrdInviteDomainService;
import kd.hr.hom.business.domain.service.util.HomUrlUtils;
import kd.hr.hom.common.entity.MessageDTO;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.util.FileServiceUtils;
import kd.sdk.hr.hom.business.onbrd.IOnbrdInviteSupportAttachmentService;

public class OnbrdInviteDomainService
implements IOnbrdInviteDomainService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInviteDomainService.class);
    private static final List<String> MSG_CHANNEL_TYPES = ImmutableList.of((Object)"sms", (Object)"email");
    private static final IOnbrdWorkTableService WORK_TABLE_SERVICE = new OnbrdWorkTableServiceImpl();
    private static final String LOGIN_TYPE = "logintype";
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)OnbrdInviteDomainService.class.getName(), (int)5, (int)1000);
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";

    @Override
    public Integer workTableInviteCountNum(String enrollstatus, String sendstatus, String loginstatus, List<Long> adminorgids, List<Long> hrbuids) {
        List<Long> onboardId = this.workTableInviteOnbIds(enrollstatus, sendstatus, loginstatus, adminorgids, hrbuids);
        if (onboardId == null) {
            return 0;
        }
        return onboardId.size();
    }

    private DynamicObject[] workTableInviteCollection(String enrollstatus, String sendstatus, String loginstatus, List<Long> adminorgids, List<Long> hrbuids) {
        List<Long> onbrdIds = ServiceFactory.getService(IActivityDomainService.class).findWorkTableOnbrd(enrollstatus, adminorgids, hrbuids);
        QFilter sendQFilter = new QFilter("sendstatus", "=", (Object)sendstatus);
        QFilter loginQFilter = new QFilter("loginstatus", "=", (Object)loginstatus);
        QFilter conFilter = new QFilter("onbrd", "in", onbrdIds);
        return HomCommonRepository.queryDynamicObjects("hom_onbrdinvite", "onbrd", sendQFilter, conFilter, loginQFilter);
    }

    @Override
    public List<Long> workTableInviteOnbIds(String enrollstatus, String sendstatus, String loginstatus, List<Long> adminorgids, List<Long> hrbuids) {
        DynamicObject[] inviteDyns = this.workTableInviteCollection(enrollstatus, sendstatus, loginstatus, adminorgids, hrbuids);
        if (inviteDyns == null || inviteDyns.length == 0) {
            return new ArrayList<Long>();
        }
        List onboardId = Arrays.stream(inviteDyns).map(dy -> dy.getLong("onbrd.id")).collect(Collectors.toList());
        QFilter status = new QFilter("activityins.taskstatus", "!=", (Object)ActivityStatusEnum.TOASSIGN.getValue());
        QFilter onbFilter = new QFilter("onbrdid", "in", onboardId);
        QFilter activityTypeFilter = new QFilter("activity.id", "=", (Object)ActivityNumberEnum.INDUCTIONINVITATION.getId());
        QFilter activity = new QFilter("activityins", "!=", (Object)0L);
        QFilter perQFilter = WORK_TABLE_SERVICE.getPermQFilter("hom_collaborationalllist", "QXX0001");
        if (!HRObjectUtils.isEmpty((Object)perQFilter)) {
            onbFilter = onbFilter.and(perQFilter);
        }
        DynamicObject[] activityDyns = HomCommonRepository.queryDynamicObjects("hom_activeinfobody", "onbrdid", status, onbFilter, activityTypeFilter, activity);
        return Arrays.stream(activityDyns).map(dy -> dy.getLong("onbrdid.id")).collect(Collectors.toList());
    }

    @Override
    public void workTableInviteSendNotice(String enrollstatus, String sendstatus, String loginstatus, List<Long> adminorgids, List<Long> hrbuids, Boolean isall) {
        Object[] inviteDyns;
        List<Long> onbrdIds = this.workTableInviteOnbIds(enrollstatus, sendstatus, loginstatus, adminorgids, hrbuids);
        QFilter sendQFilter = new QFilter("sendstatus", "=", (Object)sendstatus);
        QFilter loginQFilter = new QFilter("loginstatus", "=", (Object)loginstatus);
        QFilter conFilter = new QFilter("onbrd", "in", onbrdIds);
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        list.add(conFilter);
        list.add(loginQFilter);
        list.add(sendQFilter);
        if (isall.booleanValue()) {
            QFilter isAllQFilter = new QFilter("remindnum", "=", (Object)0);
            list.add(isAllQFilter);
        }
        if (HRArrayUtils.isEmpty((Object[])(inviteDyns = HomCommonRepository.queryDynamicObjects("hom_onbrdinvite", "", list.toArray(new QFilter[0]))))) {
            return;
        }
        this.sendNotice((DynamicObject[])inviteDyns);
    }

    private void sendNotice(DynamicObject[] inviteDyns) {
        Map<String, List<DynamicObject>> paramMap = Arrays.stream(inviteDyns).collect(Collectors.groupingBy(onbrdObj -> onbrdObj.getString("org.number")));
        List<Long> ids = Arrays.stream(inviteDyns).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Map<String, Object> resultMap = ServiceFactory.getService(ISendMessageService.class).batchSendShortInfo(paramMap, RuleEngineSceneNumberEnum.LOGIN_REMIND_MESSAGE, ids);
        int successOpCount = 0;
        int failOpCount = 0;
        ArrayList<Long> successIds = new ArrayList<Long>(ids.size());
        for (Map.Entry<String, Object> stringObjectEntry : resultMap.entrySet()) {
            Map value = (Map)stringObjectEntry.getValue();
            if (Boolean.TRUE.equals(value.get("success"))) {
                ++successOpCount;
                successIds.add(Long.valueOf(stringObjectEntry.getKey()));
                continue;
            }
            ++failOpCount;
        }
        ArrayList<DynamicObject> remindInfoObjs = new ArrayList<DynamicObject>(successIds.size());
        DynamicObject[] inviteSendBillObjSuccessIds = this.getInviteSendBillObjs(successIds.toArray(new Object[0]));
        for (Long successId : successIds) {
            DynamicObject remindInfoObj = new HRBaseServiceHelper("hom_remindinfo").generateEmptyDynamicObject();
            remindInfoObj.set("inductioninvite", (Object)successId);
            remindInfoObj.set("reminddate", (Object)new Date());
            remindInfoObj.set("operator", (Object)RequestContext.get().getCurrUserId());
            remindInfoObjs.add(remindInfoObj);
        }
        HomCommonRepository.updateDynamicObjects("hom_remindinfo", remindInfoObjs.toArray(new DynamicObject[remindInfoObjs.size()]));
        for (DynamicObject inviteSendBillObj : inviteSendBillObjSuccessIds) {
            inviteSendBillObj.set("remindnum", (Object)(inviteSendBillObj.getInt("remindnum") + 1));
        }
        HomCommonRepository.updateDynamicObjects("hom_invitesendbill", inviteSendBillObjSuccessIds);
    }

    @Override
    public DynamicObject[] getInviteSendBillObjs(Object[] ids) {
        return HomCommonRepository.queryDynamicObjectByPks("hom_invitesendbill", "sendstatus,loginstatus,onbrd.id,onbrd.name,onbrd.candidate.number,onbrd.employeeno,onbrd.effectdate,onbrd.enrollstatus,sendtime,phone,org.number,welcomelettertpl.mailtitle,welcomelettertpl.welcomecontent_tag,remindnum,sendinvitemessagetpl,guidetpl,loginscheme,loginremindmessagetpl,welcomelettersendstatus,invitemessagesendstatus,onbrd.phone", ids);
    }

    @Override
    public Map<String, Object> getEmailInfoMap(DynamicObject inviteSendBillObj, DynamicObject onbrdObj) {
        String peremail = onbrdObj.getString("peremail");
        DynamicObject welcomeLetterTplObj = inviteSendBillObj.getDynamicObject("welcomelettertpl");
        if (Objects.isNull(welcomeLetterTplObj)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> emailInfoMap = new HashMap<String, Object>(16);
        ArrayList<String> receiverList = new ArrayList<String>(1);
        receiverList.add(peremail);
        QFilter qFilter = new QFilter("id", "=", (Object)welcomeLetterTplObj.getLong("id"));
        DynamicObject welcomeLetterObj = HomCommonRepository.queryDynamicObject("hom_welcomeletter", "mailtitle,welcomecontent_tag,selectcustompicture", qFilter);
        String mailTile = welcomeLetterObj.getString("mailtitle");
        String welcomeContent = welcomeLetterObj.getString("welcomecontent_tag");
        String str = welcomeContent.replace("{url}", "{0}");
        if (str.contains("{0}")) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            String url = HomUrlUtils.dealUrl(onbrdObj.getString("url"));
            String candidateId = onbrdObj.getString("candidate.id");
            Map<Long, Map<String, Object>> longMapMap = IOnbrdCommonAppService.getInstance().onbrdToRuleEngineResult(new DynamicObject[]{onbrdObj}, RuleEngineSceneNumberEnum.HOMSCE_LOGIN_CONGIF);
            Map<String, Object> ruleEngineMap = longMapMap.get(onbrdObj.getLong("id"));
            String logintype = "";
            if (!HRMapUtils.isEmpty(ruleEngineMap)) {
                LOGGER.warn("getEmailInfoMap.onbrdToRuleEngineResult, match ruleEngineMap success");
                logintype = Optional.ofNullable(ruleEngineMap.get(LOGIN_TYPE)).orElseGet(() -> "").toString();
                DynamicObject languageDy = (DynamicObject)ruleEngineMap.get("language");
                if (!HRObjectUtils.isEmpty((Object)languageDy)) {
                    DynamicObject dbLanguageDy = BusinessDataServiceHelper.loadSingle((Object)languageDy.getPkValue(), (String)languageDy.getDataEntityType().getName(), (String)"number");
                    params.put("language", dbLanguageDy.getString("number"));
                }
            }
            DynamicObject[] loginConfig = inviteSendBillObj.getDynamicObject("loginscheme");
            String configLoginTypeStr = Arrays.stream(Optional.ofNullable(loginConfig.getString(LOGIN_TYPE)).orElseGet(() -> "").split(",")).filter(i -> !HRStringUtils.isBlank((CharSequence)i)).collect(Collectors.joining(","));
            logintype = HRStringUtils.isEmpty((String)logintype) ? configLoginTypeStr : logintype + "," + configLoginTypeStr;
            params.put("loginType", logintype);
            String safeLoginUrl = HomUrlUtils.dealUrl(IOnbrdCommonAppService.getInstance().transToSafeLoginUrl(url, "1060_S", candidateId, params));
            welcomeContent = MessageFormat.format(str, safeLoginUrl);
        }
        String selectcustompicture = welcomeLetterObj.getString("selectcustompicture");
        String imageData = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)selectcustompicture)) {
                if (selectcustompicture.startsWith("http")) {
                    imageData = FileServiceUtils.imageToBase64ByOnline((String)selectcustompicture);
                } else {
                    imageData = selectcustompicture;
                    imageData = FileServiceUtils.imageToBase64ByOnline((String)imageData);
                }
            }
        }
        catch (IOException exception) {
            LOGGER.error("FileServiceUtils.imageToBase64ByOnline error");
        }
        if (StringUtils.isNotBlank(imageData)) {
            String image;
            welcomeContent = image = "<p style=\"margin-bottom: 12.0pt; text-align: center;\" align=\"center\"><img src=\"" + "data:image/png;base64," + imageData + "\" style=\"width: 100%; height: 180px; max-width: 500px;\"></p>" + welcomeContent;
        }
        LOGGER.info(MessageFormat.format("FileServiceUtils.imageToBase64ByOnline {0}", welcomeContent));
        emailInfoMap.put("title", mailTile);
        emailInfoMap.put("receiver", receiverList);
        emailInfoMap.put("copyreceiver", receiverList);
        emailInfoMap.put("secretreceiver", receiverList);
        emailInfoMap.put("content", welcomeContent);
        QFilter filter = new QFilter("finterid", "in", (Object)welcomeLetterObj.getString("id")).and(new QFilter("fbilltype", "=", (Object)"hom_welcomeletter").and(new QFilter("fattachmentpanel", "=", (Object)ATTACHMENTPANELAP)));
        DynamicObject[] attachmentData = HomCommonRepository.queryDynamicObjects("bos_attachment", "ffileid,fattachmentname", filter);
        ArrayList<byte[]> attachments = new ArrayList<byte[]>(attachmentData.length);
        ArrayList<String> attachmentNames = new ArrayList<String>(attachmentData.length);
        for (DynamicObject attachmentDatum : attachmentData) {
            String url = attachmentDatum.getString("ffileid");
            attachments.add(FileServiceUtils.urlToByte((String)url));
            attachmentNames.add(attachmentDatum.getString("fattachmentname"));
        }
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IOnbrdInviteSupportAttachmentService.class, (String)"kd.sdk.hr.hom.business.onbrd.IOnbrdInviteSupportAttachmentService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.addAttachment(onbrdObj.getString("id"), attachments, attachmentNames);
            return null;
        });
        emailInfoMap.put("attachments", attachments);
        emailInfoMap.put("attachmentnames", attachmentNames);
        return emailInfoMap;
    }

    @Override
    public Map<String, Object> sendShortInfo(DynamicObject onbrdObj, RuleEngineSceneNumberEnum ruleEngineSceneNumberEnum) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        String buNumber = onbrdObj.getString("org.number");
        String textMessageTemplateNumber = ServiceFactory.getService(ISendMessageService.class).getTextMessageTemplateNumber(buNumber, ruleEngineSceneNumberEnum, onbrdObj);
        if (HRStringUtils.isEmpty((String)textMessageTemplateNumber)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u89c4\u5219\u5f15\u64ce\u5339\u914d\u6d88\u606f\u6a21\u677f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OnbrdInviteDomainService_20", (String)"hr-hom-business", (Object[])new Object[0]));
            return resultMap;
        }
        String phone = onbrdObj.getString("phone");
        String email = onbrdObj.getString("peremail");
        long bizId = onbrdObj.getLong("id");
        String billNo = onbrdObj.getString("billno");
        MessageDTO messageDto = SendMessageUtil.buildBaseMessageDTO((Long)bizId, textMessageTemplateNumber, null, billNo, "");
        messageDto.setPhonesToParams(Collections.singletonList(phone));
        messageDto.setEmailsToParams(Collections.singletonList(email));
        resultMap.put("success", SendMessageUtil.sendMessage(messageDto));
        resultMap.put("message", null);
        return resultMap;
    }

    @Override
    public boolean sendMail(DynamicObject inviteSendBillObj) {
        DynamicObject onbrdObj = inviteSendBillObj.getDynamicObject("onbrd");
        String buNumber = onbrdObj.getString("org.number");
        Long bizId = inviteSendBillObj.getLong("id");
        Map<String, Object> emailInfoMap = ServiceFactory.getService(IOnbrdInviteDomainService.class).getEmailInfoMap(inviteSendBillObj, onbrdObj);
        return ServiceFactory.getService(ISendMessageService.class).sendmail(buNumber, bizId, emailInfoMap, null);
    }

    @Override
    public void updateRemindInfo(DynamicObject inviteSendBillObj, IFormView view) {
        DynamicObject remindInfoObj = new HRBaseServiceHelper("hom_remindinfo").generateEmptyDynamicObject();
        remindInfoObj.set("inductioninvite", (Object)inviteSendBillObj.getLong("id"));
        remindInfoObj.set("reminddate", (Object)new Date());
        remindInfoObj.set("operator", (Object)RequestContext.get().getCurrUserId());
        HomCommonRepository.updateDynamicObject("hom_remindinfo", remindInfoObj);
        inviteSendBillObj.set("remindnum", (Object)(inviteSendBillObj.getInt("remindnum") + 1));
        HomCommonRepository.updateDynamicObject("hom_invitesendbill", inviteSendBillObj);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u9192\u767b\u5f55\u6210\u529f", (String)"OnbrdInviteOperateListPlugin_18", (String)"hr-hom-formplugin", (Object[])new Object[0]));
    }

    @Override
    public boolean validSms(StringBuilder message) {
        QFilter sms = new QFilter("number", "=", (Object)"sms");
        DynamicObject smsObj = HomCommonRepository.queryDynamicObject("msg_channel", "", sms);
        if (smsObj == null) {
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0-\u6d88\u606f\u6e20\u9053\uff1a\u8bf7\u914d\u7f6e\u77ed\u4fe1\u4fe1\u606f\uff1b", (String)"OnbrdInviteDomainService_0", (String)"hr-hom-business", (Object[])new Object[0]));
            return false;
        }
        StringBuilder tmpMessage = new StringBuilder();
        if (!smsObj.getBoolean("enable")) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u7528\u6e20\u9053\uff1b", (String)"OnbrdInviteDomainService_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)smsObj.getString("smsapiurl"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u77ed\u4fe1\u63a5\u53e3\uff1b", (String)"OnbrdInviteDomainService_2", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)smsObj.getString("smscode"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u77ed\u4fe1\u6a21\u677f\uff1b", (String)"OnbrdInviteDomainService_3", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)smsObj.getString("clientid"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5ba2\u6237ID\uff1b", (String)"OnbrdInviteDomainService_4", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)smsObj.getString("clientsecret"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5ba2\u6237\u5bc6\u94a5\uff1b", (String)"OnbrdInviteDomainService_5", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)tmpMessage)) {
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0-\u6d88\u606f\u6e20\u9053-\u77ed\u4fe1\uff1a", (String)"OnbrdInviteDomainService_6", (String)"hr-hom-business", (Object[])new Object[0])).append((CharSequence)tmpMessage);
            return false;
        }
        return true;
    }

    @Override
    public boolean validEmail(StringBuilder message) {
        QFilter email = new QFilter("number", "=", (Object)"email");
        DynamicObject emailObj = HomCommonRepository.queryDynamicObject("msg_channel", "", email);
        if (emailObj == null) {
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0-\u6d88\u606f\u6e20\u9053\uff1a\u8bf7\u914d\u7f6e\u90ae\u4ef6\u4fe1\u606f\uff1b", (String)"OnbrdInviteDomainService_7", (String)"hr-hom-business", (Object[])new Object[0]));
            return false;
        }
        StringBuilder tmpMessage = new StringBuilder();
        if (!emailObj.getBoolean("enable")) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u542f\u7528\u6e20\u9053\uff1b", (String)"OnbrdInviteDomainService_1", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)emailObj.getString("smtphost"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u4ef6\u670d\u52a1\u5730\u5740\uff1b", (String)"OnbrdInviteDomainService_8", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)emailObj.getString("smtpport"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u90ae\u4ef6\u670d\u52a1\u7aef\u53e3\uff1b", (String)"OnbrdInviteDomainService_9", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)emailObj.getString("username"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\uff1b", (String)"OnbrdInviteDomainService_10", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)emailObj.getString("password"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5bc6\u7801\uff1b", (String)"OnbrdInviteDomainService_11", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)emailObj.getString("fromaccount"))) {
            tmpMessage.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d1\u4ef6\u4eba\u8d26\u53f7\uff1b", (String)"OnbrdInviteDomainService_12", (String)"hr-hom-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)tmpMessage)) {
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0-\u6d88\u606f\u6e20\u9053-\u90ae\u4ef6\uff1a", (String)"OnbrdInviteDomainService_14", (String)"hr-hom-business", (Object[])new Object[0])).append((CharSequence)tmpMessage);
            return false;
        }
        return true;
    }

    @Override
    public boolean validMessageConfig(Map<Long, String> messageTypeMap, DynamicObject inviteSendBillObj, boolean validSms, boolean validEmail) {
        String messageType = messageTypeMap.getOrDefault(inviteSendBillObj.getLong("id"), "");
        LOGGER.info("###validMessageConfig messageType={},validSms={},validEmail={}", new Object[]{messageType, validSms, validEmail});
        if ("sms".equalsIgnoreCase(messageType) && validSms) {
            return true;
        }
        return "email".equalsIgnoreCase(messageType) && validEmail;
    }

    @Override
    public List<DynamicObject> notFitData(List<DynamicObject> notEnrolledInfos, Map<Long, String> messageMap) {
        boolean validSms = this.validSms(new StringBuilder());
        boolean validEmail = this.validEmail(new StringBuilder());
        Map<Long, String> messageTypeMap = notEnrolledInfos.stream().collect(Collectors.toMap(info -> info.getLong("id"), info -> Optional.ofNullable(info.getString("sendinvitemessagetpl.msgchannel")).orElse("")));
        ArrayList notFits = Lists.newArrayListWithCapacity((int)notEnrolledInfos.size());
        for (DynamicObject inviteSendBillObj : notEnrolledInfos) {
            boolean validEmailIsSuccess2;
            if (inviteSendBillObj.getLong("loginscheme.id") == 0L) {
                String message = ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u672a\u5339\u914d\u5230\u767b\u5f55\u65b9\u6848\uff0c\u5165\u804c\u4eba\u5458\u5c06\u4e0d\u80fd\u6b63\u5e38\u767b\u5f55\uff0c\u8bf7\u9009\u62e9\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_15", (String)"hr-hom-business", (Object[])new Object[0]);
                this.recordRows(messageMap, notFits, inviteSendBillObj, message);
                continue;
            }
            long welcomeLetterTplId = inviteSendBillObj.getLong("welcomelettertpl.id");
            long sendInviteMessageTplId = inviteSendBillObj.getLong("sendinvitemessagetpl.id");
            if (sendInviteMessageTplId == 0L && welcomeLetterTplId == 0L) {
                String message = ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u672a\u5339\u914d\u5230\u6b22\u8fce\u4fe1\u6a21\u677f\u53ca\u9080\u7ea6\u4fe1\u606f\u6a21\u677f\uff0c\u8bf7\u4efb\u9009\u5176\u4e00\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_16", (String)"hr-hom-business", (Object[])new Object[0]);
                this.recordRows(messageMap, notFits, inviteSendBillObj, message);
                continue;
            }
            String messageType = messageTypeMap.getOrDefault(inviteSendBillObj.getLong("id"), "");
            if (!MSG_CHANNEL_TYPES.contains(messageType)) continue;
            boolean validMessageConfig = this.validMessageConfig(messageTypeMap, inviteSendBillObj, validSms, validEmail);
            if (!validMessageConfig && !validEmail) {
                if ("sms".equalsIgnoreCase(messageType)) {
                    String message = ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u4ef6\u3001\u77ed\u4fe1\u6e20\u9053\u5747\u672a\u6b63\u5e38\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_17", (String)"hr-hom-business", (Object[])new Object[0]);
                    this.recordRows(messageMap, notFits, inviteSendBillObj, message);
                    continue;
                }
                String message = ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u4ef6\u6e20\u9053\u672a\u6b63\u5e38\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_19", (String)"hr-hom-business", (Object[])new Object[0]);
                this.recordRows(messageMap, notFits, inviteSendBillObj, message);
                continue;
            }
            boolean emailValue = this.validEmailValue(inviteSendBillObj);
            boolean validEmailIsSuccess = welcomeLetterTplId != 0L && validEmail && emailValue;
            boolean validSmsIsSuccess = sendInviteMessageTplId != 0L && validSms;
            boolean validMessageIsSuccess = this.validMessageConfig(messageTypeMap, inviteSendBillObj, validSmsIsSuccess, validEmailIsSuccess2 = sendInviteMessageTplId != 0L && validEmail && emailValue);
            if (validMessageIsSuccess || validEmailIsSuccess) continue;
            String message = welcomeLetterTplId != 0L ? (!emailValue ? ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u7bb1\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_18", (String)"hr-hom-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u4ef6\u6e20\u9053\u672a\u6b63\u5e38\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_19", (String)"hr-hom-business", (Object[])new Object[0])) : ("sms".equalsIgnoreCase(messageType) ? ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u77ed\u4fe1\u6e20\u9053\u672a\u6b63\u5e38\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_13", (String)"hr-hom-business", (Object[])new Object[0]) : (!emailValue ? ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u7bb1\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_18", (String)"hr-hom-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d1\u9001\u5931\u8d25\u3002\u90ae\u4ef6\u6e20\u9053\u672a\u6b63\u5e38\u914d\u7f6e\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u65b0\u53d1\u9001\u3002", (String)"OnbrdInviteDomainService_19", (String)"hr-hom-business", (Object[])new Object[0])));
            this.recordRows(messageMap, notFits, inviteSendBillObj, message);
        }
        return notFits;
    }

    private void recordRows(Map<Long, String> messageMap, List<DynamicObject> notFits, DynamicObject inviteSendBillObj, String message) {
        messageMap.put(inviteSendBillObj.getLong("id"), message);
        notFits.add(inviteSendBillObj);
    }

    private boolean validEmailValue(DynamicObject inviteSendBillObj) {
        DynamicObject onbrd = inviteSendBillObj.getDynamicObject("onbrd");
        String peremail = onbrd.getString("peremail");
        return StringUtils.isNotBlank((CharSequence)peremail);
    }

    @Override
    public boolean isEndOnbrd(DynamicObject inviteSendBillObj) {
        String enrollStatus = inviteSendBillObj.getString("onbrd.enrollstatus");
        return HRStringUtils.equals((String)OnbrdStatusEnum.HAS_ONBRD.toString(), (String)enrollStatus) || HRStringUtils.equals((String)OnbrdStatusEnum.BREAK_UP.toString(), (String)enrollStatus);
    }

    @Override
    public boolean validSmsIsSuccess(DynamicObject dynamicObject, StringBuilder smsInfo) {
        boolean sms = IOnbrdInviteDomainService.getInstance().validSms(smsInfo);
        long sendInviteMessageTplId = dynamicObject.getLong("sendinvitemessagetpl.id");
        return sms && sendInviteMessageTplId != 0L;
    }

    @Override
    public boolean validEmailIsSuccess(DynamicObject dynamicObject, StringBuilder emailInfo) {
        boolean email = IOnbrdInviteDomainService.getInstance().validEmail(emailInfo);
        long welcomeLetterTplId = dynamicObject.getLong("welcomelettertpl.id");
        return email && welcomeLetterTplId != 0L && this.validEmailValue(dynamicObject);
    }

    @Override
    public boolean validSmsIsSuccessNew(DynamicObject dynamicObject, boolean smsConfig) {
        long sendInviteMessageTplId = dynamicObject.getLong("sendinvitemessagetpl.id");
        return smsConfig && sendInviteMessageTplId != 0L;
    }

    @Override
    public boolean validEmailIsSuccessNew(DynamicObject dynamicObject, boolean emailConfig) {
        long welcomeLetterTplId = dynamicObject.getLong("welcomelettertpl.id");
        return emailConfig && welcomeLetterTplId != 0L && this.validEmailValue(dynamicObject);
    }

    @Override
    public boolean sendInvite(DynamicObject onBrdObj, DynamicObject inviteSendBillObj) {
        String message = this.validateInvite(inviteSendBillObj);
        if (HRStringUtils.isNotEmpty((String)message)) {
            LOGGER.error("validateInvite message:{}", (Object)message);
            return false;
        }
        this.sendShortAndEmail(inviteSendBillObj);
        threadPool.execute(() -> IActivityDomainService.getInstance().autoConsentTask(onBrdObj.getLong("id"), inviteSendBillObj.getLong("inviteins.id"), ActivityNumberEnum.INDUCTIONINVITATION), RequestContext.get());
        return true;
    }

    @Override
    public Optional<String> sendShortAndEmail(DynamicObject inviteSendBillObj) {
        String traceId = RequestContext.get().getTraceId();
        threadPool.execute(() -> {
            DynamicObject onbrdBill = inviteSendBillObj.getDynamicObject("onbrd");
            String perEmail = onbrdBill.getString("peremail");
            String billNo = onbrdBill.getString("billno");
            LOGGER.info(MessageFormat.format("sendSEmail start traceId: {0}, billNo:{1}", traceId, billNo));
            Tuple<String, String> sysWhiteListConfig = SendMessageUtil.smsWhiteList();
            if ("0".equals(sysWhiteListConfig.item1) || ((String)sysWhiteListConfig.item2).contains(perEmail)) {
                boolean success = IOnbrdInviteDomainService.getInstance().sendMail(inviteSendBillObj);
                LOGGER.info("sendSEmail end traceId: {} success:{}", (Object)traceId, (Object)success);
            }
        }, RequestContext.get());
        threadPool.execute(() -> {
            LOGGER.info(MessageFormat.format("sendShort start traceId: {0}", traceId));
            HashMap bizIdAndMessageTplIdMap = Maps.newHashMapWithExpectedSize((int)1);
            long bizId = inviteSendBillObj.getLong("id");
            bizIdAndMessageTplIdMap.put(bizId, inviteSendBillObj.getLong("sendinvitemessagetpl.id"));
            HashMap bizIdAndPhoneListMap = Maps.newHashMapWithExpectedSize((int)1);
            bizIdAndPhoneListMap.put(bizId, ImmutableList.of((Object)inviteSendBillObj.getString("onbrd.phone")));
            HashMap bizIdAndOnbrdIdMap = Maps.newHashMapWithExpectedSize((int)1);
            bizIdAndOnbrdIdMap.put(bizId, inviteSendBillObj.getLong("onbrd.id"));
            ServiceFactory.getService(ISendMessageService.class).batchSendShortInfo(bizIdAndMessageTplIdMap, bizIdAndPhoneListMap, bizIdAndOnbrdIdMap);
            LOGGER.info(MessageFormat.format("sendShort end traceId: {0}", traceId));
        }, RequestContext.get());
        return Optional.empty();
    }

    @Override
    public DynamicObject getInviteSendBillById(long id, String selectProperties) {
        return HomCommonRepository.queryDynamicObjectByPk("hom_onbrdinvite", selectProperties, id);
    }

    private String validateInvite(DynamicObject inviteSendBillObj) {
        if (IOnbrdInviteDomainService.getInstance().isEndOnbrd(inviteSendBillObj)) {
            return ResManager.loadKDString((String)"\u6b64\u5f85\u5165\u804c\u4eba\u5458\u5df2\u5165\u804c/\u5df2\u7ec8\u6b62\u5165\u804c\uff0c\u4e0d\u53ef\u53d1\u9001\u5165\u804c\u9080\u7ea6\u3002", (String)"OnbrdInviteOperateListPlugin_11", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        }
        HashMap messageMap = Maps.newHashMapWithExpectedSize((int)1);
        IOnbrdInviteDomainService.getInstance().notFitData((List<DynamicObject>)ImmutableList.of((Object)inviteSendBillObj), messageMap);
        return (String)messageMap.get(inviteSendBillObj.getLong("id"));
    }
}

