/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.Service;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdConfirmAppService;
import kd.hr.hom.business.application.rule.IOnbrdConfirmValidatorService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillExecuteService;
import kd.hr.hom.common.util.HOMObjectUtils;

@Service(value="confirm")
public class ConfirmOnbrdBillExecuteServiceImpl
implements IOnbrdBillExecuteService {
    private static final Log LOGGER = LogFactory.getLog(ConfirmOnbrdBillExecuteServiceImpl.class);

    @Override
    public Tuple<Boolean, String> validateOnbrdBill(DynamicObject onbrdBill) {
        return this.checkConfirm(onbrdBill);
    }

    @Override
    public Tuple<Boolean, String> executeOnbrdBill(DynamicObject onbrdBill, String remark) {
        ArrayList<Map<String, Object>> operationResultList = new ArrayList<Map<String, Object>>();
        Long userId = RequestContext.get().getCurrUserId();
        ServiceFactory.getService(IOnbrdConfirmAppService.class).doSomethinsForOnboarding(userId, Collections.singletonList(onbrdBill), operationResultList, null);
        Iterator iterator = operationResultList.iterator();
        if (iterator.hasNext()) {
            Map operationResult = (Map)iterator.next();
            if (Boolean.parseBoolean(operationResult.get("isSuccess").toString())) {
                return Tuple.create((Object)Boolean.TRUE, (Object)"");
            }
            String failOperation = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"OnbrdConfirmPlugin_15", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)failOperation);
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    private Tuple<Boolean, String> checkConfirm(DynamicObject onbrdBill) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)1);
        LOGGER.info("HRCertCommonHelper.verifyCertCount: {}", (Object)HOMObjectUtils.toJSONString((Object)verifyResult));
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        String verifyCertMessage = (String)verifyResult.get("message");
        Map<String, Object> resultMap = ServiceFactory.getService(IOnbrdConfirmAppService.class).getPersonInfoFeedbackMap(onbrdBill);
        resultMap.put("isSuccess", Boolean.TRUE);
        resultMap.put("failReason", "");
        if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) {
            resultMap.put("failReason", verifyCertMessage);
            resultMap.put("isSuccess", Boolean.FALSE);
        }
        Map<Long, String> baseCheckResultMap = IOnbrdConfirmValidatorService.getInstance().checkEnableForDoComfirm(new DynamicObject[]{onbrdBill}, null);
        baseCheckResultMap.forEach((onbrdId, errMsg) -> {
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                resultMap.put("failReason", errMsg);
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        Map<Long, String> checkPersonResult = IOnbrdCommonAppService.getInstance().checkPersonIfExisted(new DynamicObject[]{onbrdBill});
        checkPersonResult.forEach((onbrdId, fieldNames) -> {
            if (StringUtils.isNotEmpty((String)fieldNames)) {
                if (HRStringUtils.equals((String)ResManager.loadKDString((String)"\u4eba\u5458\u63a5\u53e3\u672a\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c\u3002", (String)"OnbrdConfirmAppServiceImpl_7", (String)"hr-hom-business", (Object[])new Object[0]), (String)fieldNames)) {
                    resultMap.put("failReason", ResManager.loadKDString((String)"\u63a5\u53e3\u670d\u52a1\u5f02\u5e38\uff0c\u65e0\u6cd5\u6821\u9a8c\u4eba\u5458\u552f\u4e00\u6027\u3002", (String)"OnbrdConfirmAppServiceImpl_8", (String)"hr-hom-business", (Object[])new Object[0]));
                } else {
                    resultMap.put("failReason", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u6570\u636e\u7684\u201c%s\u201d\u4e0e\u5728\u804c\u5458\u5de5\u5b58\u5728\u4fe1\u606f\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OnbrdConfirmAppServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]), fieldNames));
                }
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        Map<Long, Optional<String>> validateStaffUseMap = IStaffUseService.getInstance().validateStaffUse(Collections.singletonList(onbrdBill.getLong("id")), "UPDATE");
        validateStaffUseMap.forEach((onbrdId, validateStaffUseResult) -> {
            if (RequestContext.getOrCreate().getCurrUserId() != -1L && Optional.ofNullable(validateStaffUseResult).isPresent() && validateStaffUseResult.isPresent()) {
                resultMap.put("failReason", validateStaffUseResult.get());
                resultMap.put("isSuccess", Boolean.FALSE);
            }
        });
        String errorMsg = HRObjectUtils.isEmpty((Object)resultMap.get("failReason")) ? "" : resultMap.get("failReason").toString();
        return Tuple.create((Object)((Boolean)resultMap.get("isSuccess")), (Object)errorMsg);
    }
}

