/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.utils.RuleCodeUtils;
import kd.hr.hom.business.domain.service.rulecode.CodeServiceFactory;
import kd.hr.hom.business.domain.service.rulecode.IRuleCodeBusinessCheckService;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.UpdateControlUtil;
import kd.sdk.hr.hom.service.IOnbrdInfoService;

public class OnbrdInfoServiceImpl
implements IOnbrdInfoService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInfoServiceImpl.class);

    public Optional<String> validateFieldMandatory(IFormView view) {
        Set mustInputFields = UpdateControlUtil.getViewMustInputFields((IFormView)view);
        if (CollectionUtils.isEmpty((Collection)mustInputFields)) {
            return Optional.empty();
        }
        DynamicObject dynamicObjectPage = view.getModel().getDataEntity();
        DataEntityPropertyCollection properties = dynamicObjectPage.getDataEntityType().getProperties();
        StringBuilder emptyFields = new StringBuilder();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            Object object = dynamicObjectPage.get(propertyName);
            if (property instanceof BasedataProp && object instanceof Long) {
                object = (Long)object == 0L ? null : object;
                LOGGER.info("This BasedataProp value is long:{}", (Object)property.getName());
            }
            if (!mustInputFields.contains(propertyName) || !HOMObjectUtils.isEmpty((Object)object)) continue;
            emptyFields.append(property.getDisplayName().getLocaleValue()).append('\u3001');
        }
        String emptyFieldStr = emptyFields.toString();
        if (HRStringUtils.isNotEmpty((String)emptyFieldStr)) {
            emptyFieldStr = emptyFieldStr.substring(0, emptyFieldStr.lastIndexOf(12289));
        }
        if (HRStringUtils.isNotEmpty((String)emptyFieldStr)) {
            LOGGER.info("emptyFieldStr:{}", (Object)emptyFieldStr);
            return Optional.of(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d \u3002", (String)"OnbrdInfoEdit_10", (String)"hr-hom-business", (Object[])new Object[0]), emptyFieldStr));
        }
        return Optional.empty();
    }

    public void createCodeRuleHandler(DynamicObject dy, List<String> numberList, int count, int expectNum) {
        if (numberList == null) {
            return;
        }
        String entityId = dy.getDataEntityType().getName();
        List<String> code = RuleCodeUtils.getCodeNo(entityId, dy, count);
        if (CollectionUtil.isEmpty(code)) {
            return;
        }
        IRuleCodeBusinessCheckService service = CodeServiceFactory.getService(entityId);
        code = service.checkNumber(code);
        if (CollectionUtil.isNotEmpty(code)) {
            numberList.addAll(code);
        }
        if (numberList.size() == expectNum) {
            return;
        }
        this.createCodeRuleHandler(dy, numberList, expectNum - numberList.size(), expectNum);
    }
}

