/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hbpm.IHrmpExternalService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.tsc.IOnbrdBillService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillExecuteService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdService;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.sdk.hr.common.entity.ValidResult;
import kd.sdk.hr.common.enums.TipTypeEnum;

public class OnbrdServiceImpl
implements IOnbrdService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdServiceImpl.class);

    @Override
    public DynamicObject getOnbrdBillByCandidateId(Long candidateId) {
        return IOnbrdBillService.getInstance().getOnbrdBillByCandidateId(candidateId);
    }

    @Override
    public DynamicObject getOnbrdBillById(String selectProperties, Long onbrdId) {
        return IOnbrdBillDomainService.getInstance().findOnbrdBillById(selectProperties, onbrdId);
    }

    @Override
    public DynamicObject getOnbrdBillByBillNo(String billNo) {
        return IOnbrdBillService.getInstance().getOnbrdBillByBillNo(billNo);
    }

    @Override
    public Map<String, Object> createOnboardBill(Map<String, Object> requestMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Tuple<Boolean, String> result = this.createHandle(requestMap);
            if (((Boolean)result.item1).booleanValue()) {
                resultMap.put("result", "success");
                resultMap.put("desc", ResManager.loadKDString((String)"\u5165\u804c\u5355\u521b\u5efa\u6210\u529f\u3002", (String)"OnbrdServiceImpl_3", (String)"hr-hom-business", (Object[])new Object[0]));
                resultMap.put("data", result.item2);
            } else {
                resultMap.put("result", "fail");
                resultMap.put("desc", result.item2);
            }
        }
        catch (Exception e) {
            resultMap.put("result", "fail");
            resultMap.put("desc", ResManager.loadKDString((String)"\u5165\u804c\u5355\u521b\u5efa\u5931\u8d25\u3002", (String)"OnbrdServiceImpl_4", (String)"hr-hom-business", (Object[])new Object[0]));
            LOGGER.error("createOnboardBill error -> ", (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> updateOnboardBillStatus(Long onbrdId, String status, String remark) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject onbrdBill = IOnbrdBillDomainService.getInstance().findOnbrdBillById("", onbrdId);
        if (HRObjectUtils.isEmpty((Object)onbrdBill)) {
            result.put("result", "fail");
            result.put("desc", ResManager.loadKDString((String)"\u5165\u804c\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762", (String)"OnbrdServiceImpl_0", (String)"hr-hom-business", (Object[])new Object[0]));
            return result;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(OnbrdStatusEnum.HAS_ONBRD.getValue(), "confirm");
        map.put(OnbrdStatusEnum.BREAK_UP.getValue(), "breakup");
        String operateKey = map.getOrDefault(status, "default");
        IOnbrdBillExecuteService onbrdBillExecuteService = ServiceFactory.getImplService(IOnbrdBillExecuteService.class, operateKey);
        Tuple<Boolean, String> validateOnbrdBill = onbrdBillExecuteService.validateOnbrdBill(onbrdBill);
        if (!((Boolean)validateOnbrdBill.item1).booleanValue()) {
            result.put("result", "fail");
            result.put("desc", validateOnbrdBill.item2);
            return result;
        }
        Tuple<Boolean, String> executeOnbrdBill = onbrdBillExecuteService.executeOnbrdBill(onbrdBill, remark);
        result.put("result", (Boolean)executeOnbrdBill.item1 != false ? "success" : "fail");
        result.put("desc", executeOnbrdBill.item2);
        return result;
    }

    @Override
    public Map<Long, ValidResult> validAgainOnboards(List<Long> employeeIds) {
        LOGGER.info("###validAgainOnboards-params {}", employeeIds);
        ArrayList validResults = Lists.newArrayListWithExpectedSize((int)employeeIds.size());
        QFilter qFilter = new QFilter("personfield", "in", employeeIds);
        qFilter.and("enrollstatus", "in", (Object)ImmutableList.of((Object)OnbrdStatusEnum.WAIT_ONBRD.getValue(), (Object)OnbrdStatusEnum.HAS_ONBRD.getValue(), (Object)OnbrdStatusEnum.WAIT_START.getValue()));
        DynamicObject[] dynamicObjects = HomCommonRepository.queryDynamicObjects("hom_onbrdbilltpl", "createtime,enrollstatus,personfield.id", qFilter);
        List personfieldList = Arrays.stream(dynamicObjects).sorted(Comparator.comparing(dy -> dy.getDate("createtime"), Comparator.reverseOrder())).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> personfieldMap = personfieldList.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("personfield.id")));
        for (Long employeeId : employeeIds) {
            ValidResult validResult2;
            List<DynamicObject> onbrdDys = personfieldMap.get(employeeId);
            if (CollectionUtils.isEmpty(onbrdDys)) {
                ValidResult validResult3 = new ValidResult(employeeId, "", "");
                validResults.add(validResult3);
                continue;
            }
            DynamicObject dynamicObject2 = onbrdDys.get(0);
            String enrollStatus = dynamicObject2.getString("enrollstatus");
            if (OnbrdStatusEnum.WAIT_START.getValue().equals(enrollStatus)) {
                validResult2 = new ValidResult(employeeId, TipTypeEnum.ERROR.getName(), ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5df2\u6709\u5728\u9014\u7684\u5165\u804c\u5355\u636e\uff0c\u8bf7\u5148\u7ec8\u6b62\u5355\u636e\u540e\u518d\u8fdb\u884c\u64a4\u56de\u79bb\u804c\u64cd\u4f5c\u3002", (String)"OnbrdServiceImpl_1", (String)"hr-hom-business", (Object[])new Object[0]), false);
                validResults.add(validResult2);
                continue;
            }
            validResult2 = new ValidResult(employeeId, TipTypeEnum.ERROR.getName(), ResManager.loadKDString((String)"\u4eba\u5458\u5df2\u518d\u5165\u804c\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de\u79bb\u804c\u3002", (String)"OnbrdServiceImpl_2", (String)"hr-hom-business", (Object[])new Object[0]), false);
            validResults.add(validResult2);
        }
        Map<Long, ValidResult> validResultMap = validResults.stream().collect(Collectors.toMap(ValidResult::getId, validResult -> validResult, (oldValue, newValue) -> newValue));
        LOGGER.info("###validAgainOnboards-result {}", validResultMap);
        return validResultMap;
    }

    private Tuple<Boolean, String> createHandle(Map<String, Object> requestMap) {
        Tuple result = Tuple.create((Object)Boolean.TRUE, (Object)"");
        Long candidateId = HRObjectUtils.isEmpty((Object)requestMap.get("candidate_id")) ? null : (Long)requestMap.get("candidate_id");
        DynamicObject onbrdBill = IOnbrdBillService.getInstance().getOnbrdBillByCandidateId(candidateId);
        if (Objects.isNull(onbrdBill) || OnbrdStatusEnum.BREAK_UP.getValue().equals(onbrdBill.getString("enrollstatus")) || OnbrdStatusEnum.HAS_ONBRD.getValue().equals(onbrdBill.getString("enrollstatus"))) {
            onbrdBill = IOnbrdBillService.getInstance().generateOnbrdBill(requestMap);
            long certificateTypeId = onbrdBill.getLong("certificatetype_id");
            if (certificateTypeId != 0L && !HRObjectUtils.isEmpty((Object)onbrdBill.get("certificatetype"))) {
                DynamicObject dynamicObject = HomCommonRepository.queryDynamicObjectByPk("hbss_credentialstype", null, certificateTypeId);
                onbrdBill.set("certificatetype", (Object)dynamicObject);
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u5165\u804c\u5355\u3002", (String)"CreateOnbrdBillService_0", (String)"hr-hom-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        result = this.validateHandle(onbrdBill);
        if (((Boolean)result.item1).booleanValue()) {
            result = this.validateRepeat(onbrdBill, requestMap);
            if (((Boolean)result.item1).booleanValue()) {
                result = this.validateVerifyCertHandle();
            }
        }
        if (((Boolean)result.item1).booleanValue()) {
            try (TXHandle txHandle = TX.required();){
                IOnbrdBillService.getInstance().createOnbrdBill(onbrdBill);
                Object candidate = onbrdBill.get("candidate");
                Long candidatePkId = candidate instanceof DynamicObject ? Long.valueOf(((DynamicObject)candidate).getLong("id")) : Long.valueOf(onbrdBill.getLong("candidate"));
                DynamicObject createOnbrdBill = IOnbrdBillService.getInstance().getOnbrdBillByCandidateId(candidatePkId);
                LOGGER.info("OnbrdServiceImpl.createHandle.createOnbrdBill:{}", (Object)HOMObjectUtils.toJSONString((Object)createOnbrdBill));
                IOnbrdBillService.getInstance().initRoleAndJobInfoHandle(createOnbrdBill);
                IOnbrdBillService.getInstance().updateOnbrdBill(createOnbrdBill);
                result = Tuple.create((Object)Boolean.TRUE, (Object)createOnbrdBill.getString("id"));
            }
        }
        return result;
    }

    private Tuple<Boolean, String> validateVerifyCertHandle() {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)1);
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) {
            String errorMsg = ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreateOnbrdBillService_1", (String)"hr-hom-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    private Tuple<Boolean, String> validateRepeat(DynamicObject onbrdBill, Map<String, Object> requestMap) {
        ArrayList<HomCommonWrapper> rowDataWrapperList = new ArrayList<HomCommonWrapper>();
        HomCommonWrapper homCommonWrapper = new HomCommonWrapper(onbrdBill);
        rowDataWrapperList.add(homCommonWrapper);
        ArrayList<String> validateList = new ArrayList<String>();
        if (!HRObjectUtils.isEmpty((Object)requestMap.get("phone"))) {
            validateList.add("phone");
        }
        if (!HRObjectUtils.isEmpty((Object)requestMap.get("peremail"))) {
            validateList.add("peremail");
        }
        if (null != onbrdBill.getDynamicObject("certificatetype") && HRStringUtils.isNotEmpty((String)onbrdBill.getString("certificatenumber"))) {
            validateList.add("certificatetype.id");
            validateList.add("certificatenumber");
        }
        IOnbrdCommonValidator.getInstance().judgeDuplicateByHrpiRpc(rowDataWrapperList, validateList);
        LOGGER.info("CreateOnbrdBillService.validateRepeat.judgeDuplicateByHrpiRpc -> {}", rowDataWrapperList.get(0));
        if (!CollectionUtils.isEmpty(rowDataWrapperList) && null != rowDataWrapperList.get(0) && 0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u4e3a\u5728\u804c\u5458\u5de5", (String)"CreateOnbrdBillService_2", (String)"hr-hom-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        if (null != onbrdBill.get("certificatetype") && !HRObjectUtils.isEmpty((Object)requestMap.get("certificatenumber"))) {
            IOnbrdCommonValidator.getInstance().judgeCertificateIfDuplicate(rowDataWrapperList);
        }
        if (!HRObjectUtils.isEmpty((Object)requestMap.get("phone"))) {
            IOnbrdCommonValidator.getInstance().judgePhoneIfDuplicate(rowDataWrapperList);
        }
        if (!HRObjectUtils.isEmpty((Object)requestMap.get("peremail"))) {
            IOnbrdCommonValidator.getInstance().judgeEmailIfDuplicate(rowDataWrapperList);
        }
        IOnbrdCommonValidator.getInstance().validPreOnbrd(rowDataWrapperList);
        IOnbrdCommonValidator.getInstance().validateVirtuallyOrg(rowDataWrapperList);
        IOnbrdCommonValidator.getInstance().validateDepartPerson(rowDataWrapperList);
        LOGGER.info("CreateOnbrdBillService.validateRepeat.judgeCertificatePhoneEmail -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (!CollectionUtils.isEmpty(rowDataWrapperList) && null != rowDataWrapperList.get(0) && 0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u5165\u804c\u5355\u3002", (String)"CreateOnbrdBillService_0", (String)"hr-hom-business", (Object[])new Object[0]);
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    private Tuple<Boolean, String> validateHandle(DynamicObject onbrdBill) {
        Optional<String> emailResult;
        Optional<String> phoneResult;
        Optional<String> certificateResult;
        String phone = onbrdBill.getString("phone");
        String email = onbrdBill.getString("peremail");
        DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
        String certificateNumber = onbrdBill.getString("certificatenumber");
        if (null != certificateType && HRStringUtils.isNotEmpty((String)certificateNumber) && (certificateResult = IOnbrdCommonAppService.getInstance().validateCertificateNum(certificateType, certificateNumber)).isPresent()) {
            return Tuple.create((Object)Boolean.FALSE, (Object)certificateResult.get());
        }
        if (HRStringUtils.isNotEmpty((String)phone) && (phoneResult = IOnbrdCommonAppService.getInstance().validatePhone(phone)).isPresent()) {
            return Tuple.create((Object)Boolean.FALSE, (Object)phoneResult.get());
        }
        if (HRStringUtils.isNotEmpty((String)email) && (emailResult = IOnbrdCommonAppService.getInstance().validateEmail(email)).isPresent()) {
            return Tuple.create((Object)Boolean.FALSE, (Object)emailResult.get());
        }
        return Tuple.create((Object)Boolean.TRUE, (Object)"");
    }

    @Override
    public Map<String, Boolean> validateVirtuallyOrg(List<Long> adminOrgIds, Date effectDate) {
        IHrmpExternalService hrmpService = IHrmpExternalService.getInstance();
        Map<String, Map<String, Object>> adminOrgMap = hrmpService.invokeAdminOrgInfoQuery(adminOrgIds, effectDate);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, Map<String, Object>> stringMapEntry : adminOrgMap.entrySet()) {
            Object isvirtualorg = stringMapEntry.getValue().get("isvirtualorg");
            result.put(stringMapEntry.getKey(), !HRObjectUtils.isEmpty((Object)isvirtualorg) && Boolean.parseBoolean(isvirtualorg.toString()));
        }
        return result;
    }
}

