/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.common.ReentryRuleService;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.mobile.IMobCommonAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.onbrd.OnbrdAgainRuleUtils;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdStartUpProcessService;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.enums.AgainCheckResultsEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.enums.WorkflowSchemeStatusEnum;
import kd.hr.hom.common.util.SceneResultUtil;

public class OnbrdStartUpProcessService
implements IOnbrdStartUpProcessService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdStartUpProcessService.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"OnbrdStartUpProcessService", (int)5, (int)1000);

    @Override
    public Map<Long, Optional<String>> validateData(DynamicObject[] onbrdBills) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        Map<Long, Optional<String>> validateMustInput = IOnbrdCommonAppService.getInstance().startOnBrdValidateMustInputField(onbrdBills);
        Map<Long, Optional<String>> validateCertificate = this.validateCertificateIsUnique(onbrdBills);
        resultMap.putAll(validateCertificate);
        Map<Long, String> validateEffectDateMap = IOnbrdCommonAppService.getInstance().validateEffectDateWithOrgField(onbrdBills);
        Stream.of(onbrdBills).forEach(onbrdBill -> {
            long onbrdBillId = onbrdBill.getLong("id");
            String validateResult = (String)validateEffectDateMap.get(onbrdBillId);
            if (HRStringUtils.isNotEmpty((String)validateResult)) {
                resultMap.put(onbrdBillId, Optional.of(validateResult));
            }
        });
        Map<Long, Optional<String>> validateAgainOnbrdAdapter = this.batchValidateAgainOnbrdAdapter(onbrdBills, resultMap);
        resultMap.putAll(validateAgainOnbrdAdapter);
        Map<Long, Optional<String>> validateAgainOnbrd = this.validateAgainOnbrd(onbrdBills);
        resultMap.putAll(validateAgainOnbrd);
        IOnbrdCommonValidator onbrdCommonValidator = IOnbrdCommonValidator.getInstance();
        AtomicInteger num = new AtomicInteger();
        List<HomCommonWrapper> rowDataWrapperList = Arrays.stream(onbrdBills).map(entity -> new HomCommonWrapper(entity, entity, num.getAndIncrement(), (Object)this, null)).collect(Collectors.toList());
        onbrdCommonValidator.judgeEmployeenoIfDuplicate(rowDataWrapperList);
        onbrdCommonValidator.judgeDuplicateByHrpiRpc(rowDataWrapperList, (List<String>)ImmutableList.of((Object)"employeeno"));
        onbrdCommonValidator.validNumber(rowDataWrapperList);
        onbrdCommonValidator.validateVirtuallyOrg(rowDataWrapperList);
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(rowDataWrapperList);
        Map<Long, Optional> validNumberMap = rowDataWrapperList.stream().filter(rowData -> rowData.getErrorMsgNum() > 0).collect(Collectors.toMap(row -> row.getBizData().getLong("id"), row -> Optional.of(row.getErrorMsgs().element().toString())));
        resultMap.putAll(validNumberMap);
        resultMap.putAll(validateMustInput);
        Set<Long> idSet = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toSet());
        Map<Long, Optional<String>> validateStaffUseMap = IStaffUseService.getInstance().validateStaffUse(idSet, "NEW");
        resultMap.putAll(validateStaffUseMap);
        return resultMap;
    }

    private Map<Long, Optional<String>> batchValidateAgainOnbrdAdapter(DynamicObject[] onbrdBills, Map<Long, Optional<String>> paramsResult) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return resultMap;
        }
        HashSet againOnbrdIds = new HashSet(onbrdBills.length);
        List againOnbrds = Arrays.stream(onbrdBills).filter(dy -> paramsResult.containsKey(dy.getLong("id")) && ViewTypeEnum.AGAIN.getCode().equals(dy.getString("viewtype"))).peek(bill -> againOnbrdIds.add(bill.getLong("id"))).collect(Collectors.toList());
        if (againOnbrds == null || againOnbrds.isEmpty()) {
            return resultMap;
        }
        DynamicObject[] againOnbrdArray = HomCommonRepository.queryDynamicObjectByPks("hom_onbrdbilltpl", "", againOnbrdIds.toArray());
        List<Map<String, Object>> inputParamList = ReentryRuleService.getInstance().batchGetInputParams(againOnbrdArray);
        Map<Long, Optional<String>> againCheckMap = this.batchAagainCheck(inputParamList);
        resultMap.putAll(againCheckMap);
        List<Map<String, Object>> nextCheckInputParams = inputParamList.stream().filter(map -> !againCheckMap.containsKey(((DynamicObject)map.get("reboard")).getLong("id"))).collect(Collectors.toList());
        if (nextCheckInputParams.isEmpty()) {
            return resultMap;
        }
        Map<Long, Optional<String>> connectionMap = this.batchAgainConnection(nextCheckInputParams);
        resultMap.putAll(connectionMap);
        return resultMap;
    }

    private Map<Long, Optional<String>> againConnection(DynamicObject onbrdBill, Map<String, Object> inputParams) {
        String acSwitch;
        String scSwitch;
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)1);
        List<Map<String, Object>> ruleResult = OnbrdAgainRuleUtils.getRuleResult(inputParams, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_SUCCEED.getSceneNumber(), onbrdBill);
        LOGGER.info("connection rule=={}", ruleResult);
        if (CollectionUtils.isEmpty(ruleResult)) {
            return resultMap;
        }
        String ecSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("employeeno_connection_switch");
        boolean isSame = OnbrdAgainRuleUtils.isIdentical(ruleResult, ecSwitch, scSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("seniority_connection_switch"));
        if (!isSame) {
            return resultMap;
        }
        Map<String, Object> rule = ruleResult.get(0);
        if (rule != null && !OnbrdAgainRuleUtils.checkResultBeforeStart(rule, onbrdBill, ecSwitch, scSwitch, acSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("automaticinfo_switch"))) {
            String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652272369278017536L, null);
            resultMap.put(onbrdBill.getLong("id"), Optional.of(tipByHRCS));
            return resultMap;
        }
        return resultMap;
    }

    private Map<Long, Optional<String>> batchAgainConnection(List<Map<String, Object>> inputParams) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)inputParams.size());
        Map<String, List<Map<String, Object>>> inputParamMap = ReentryRuleService.getInstance().groupByBuNumber(inputParams);
        String ecSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("employeeno_connection_switch");
        String scSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("seniority_connection_switch");
        inputParamMap.forEach((buNumber, inputParamList) -> {
            List<Map<String, Object>> ruleResults = OnbrdAgainRuleUtils.bacthGetRuleResult(inputParamList, buNumber, RuleEngineSceneNumberEnum.HOMSCE_REBOARD_SUCCEED.getSceneNumber());
            LOGGER.info("ruleResults = {}", ruleResults);
            for (int i = 0; i < ruleResults.size(); ++i) {
                String acSwitch;
                Map rule;
                SceneResult sceneResult = RuleEngineResponseUtils.transferToSceneResult(ruleResults.get(i));
                List respResultList = SceneResultUtil.getRespResultList((SceneResult)sceneResult);
                LOGGER.info("respResultList = {}", (Object)respResultList);
                if (CollectionUtils.isEmpty((Collection)respResultList)) continue;
                DynamicObject reboard = (DynamicObject)((Map)inputParamList.get(i)).get("reboard");
                boolean isSame = OnbrdAgainRuleUtils.isIdentical(respResultList, ecSwitch, scSwitch);
                if (!isSame || (rule = (Map)respResultList.get(0)) == null || OnbrdAgainRuleUtils.checkResultBeforeStart(rule, reboard, ecSwitch, scSwitch, acSwitch = ServiceFactory.getService(IHomConfigDomainService.class).getConfig("automaticinfo_switch"))) continue;
                LOGGER.info("rule = {},ecSwitch ={},  scSwitch={}", new Object[]{rule, ecSwitch, acSwitch});
                String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652272369278017536L, null);
                LOGGER.info("tipByHRCS = {}", (Object)tipByHRCS);
                resultMap.put(reboard.getLong("id"), Optional.of(tipByHRCS));
            }
        });
        return resultMap;
    }

    private Map<Long, Optional<String>> batchAagainCheck(List<Map<String, Object>> inputParamList) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)inputParamList.size());
        Map<String, List<Map<String, Object>>> inputParamMap = ReentryRuleService.getInstance().groupByBuNumber(inputParamList);
        inputParamMap.forEach((buNumber, inputParams) -> {
            Map<Long, String> newCheckResultMap = OnbrdAgainRuleUtils.batchGetReentryCheckResult(inputParams, buNumber);
            LOGGER.info("newCheckResultMap={}", newCheckResultMap);
            if (newCheckResultMap.isEmpty()) {
                return;
            }
            inputParams.forEach(inputParam -> {
                DynamicObject onbrdBill = (DynamicObject)inputParam.get("reboard");
                long billId = onbrdBill.getLong("id");
                String newCheckResult = (String)newCheckResultMap.get(billId);
                String pageCheckResult = onbrdBill.getString("againcheckresults");
                if (newCheckResult == null) {
                    return;
                }
                if (HRStringUtils.equals((String)newCheckResult, (String)AgainCheckResultsEnum.PROHIBIT.getCode())) {
                    String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652272708706263040L, null);
                    resultMap.put(onbrdBill.getLong("id"), Optional.of(tipByHRCS));
                    return;
                }
                if (!HRStringUtils.equals((String)newCheckResult, (String)pageCheckResult)) {
                    String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652272369278017536L, null);
                    resultMap.put(onbrdBill.getLong("id"), Optional.of(tipByHRCS));
                }
            });
        });
        return resultMap;
    }

    private Map<Long, Optional<String>> validateAgainOnbrd(DynamicObject[] onbrdBills) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        if (HRArrayUtils.isEmpty((Object[])onbrdBills)) {
            return resultMap;
        }
        for (DynamicObject onbrdBill : onbrdBills) {
            String againCheckResult = onbrdBill.getString("againcheckresults");
            String viewType = onbrdBill.getString("viewtype");
            if (!ViewTypeEnum.AGAIN.getCode().equals(viewType)) continue;
            if (HRStringUtils.isEmpty((String)againCheckResult)) {
                resultMap.put(onbrdBill.getLong("id"), Optional.of(IMobCommonAppService.getInstance().getTipByHRCS(null, 1652272101429764096L, null)));
                continue;
            }
            if (!AgainCheckResultsEnum.PROHIBIT.getCode().equals(againCheckResult)) continue;
            String tipByHRCS = IMobCommonAppService.getInstance().getTipByHRCS(null, 1652270228404592640L, null);
            resultMap.put(onbrdBill.getLong("id"), Optional.of(tipByHRCS));
        }
        return resultMap;
    }

    private Map<Long, Optional<String>> validateCertificateIsUnique(DynamicObject[] onbrdBills) {
        LOGGER.info("start validateCertificateIsUnique");
        Set idSet = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toSet());
        Set certificateTypeSet = Stream.of(onbrdBills).map(onbrdBill -> onbrdBill.getLong("certificatetype.id")).collect(Collectors.toSet());
        QFilter certificateFilter = new QFilter("certificatetype", "in", certificateTypeSet);
        HashSet<String> enrollStatusSet = new HashSet<String>();
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_START.toString());
        enrollStatusSet.add(OnbrdStatusEnum.WAIT_ONBRD.toString());
        QFilter enrollStatusFilter = new QFilter("enrollstatus", "in", enrollStatusSet);
        String properties = "id,certificatetype,certificatenumber,enrollstatus,candidate";
        DynamicObject[] onbrdBillsFromDB = IOnbrdBillDomainService.getInstance().findOnbrdBills(properties, new QFilter[]{certificateFilter, enrollStatusFilter});
        Map<String, DynamicObject> certificateMap = Stream.of(onbrdBillsFromDB).filter(onbrdBill -> !idSet.contains(onbrdBill.getLong("id")) && HRStringUtils.isNotEmpty((String)onbrdBill.getString("certificatenumber"))).collect(Collectors.toMap(onbrdBill -> this.getCerUniqueKey((DynamicObject)onbrdBill), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        for (DynamicObject onbrdBill2 : onbrdBills) {
            String key = this.getCerUniqueKey(onbrdBill2);
            DynamicObject dynamicObject = certificateMap.get(key);
            if (dynamicObject != null) {
                String tips = ResManager.loadKDString((String)"\u4e0e\u5176\u4ed6\u4eba\u5458\u7684\u8bc1\u4ef6\u53f7\u7801\u91cd\u590d,\u5019\u9009\u4eba\u7f16\u53f7:", (String)"OnbrdStartUpProcessService_1", (String)"hr-hom-business", (Object[])new Object[0]) + dynamicObject.getString("candidate.number");
                resultMap.put(onbrdBill2.getLong("id"), Optional.of(tips));
                continue;
            }
            resultMap.put(onbrdBill2.getLong("id"), Optional.empty());
            certificateMap.put(key, onbrdBill2);
        }
        LOGGER.info("end validateCertificateIsUnique");
        return resultMap;
    }

    private String getCerUniqueKey(DynamicObject onbrdBill) {
        DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
        String certificateTypeNumber = HRObjectUtils.isEmpty((Object)certificateType) ? "" : certificateType.getString("number");
        return certificateTypeNumber + ":" + onbrdBill.getString("certificatenumber");
    }

    @Override
    public Map<Long, Optional<String>> matchOnbrdActivityPlan(DynamicObject[] onbrdBills) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBills.length);
        for (DynamicObject onbrdBill : onbrdBills) {
            resultMap.put(onbrdBill.getLong("id"), Optional.empty());
        }
        return resultMap;
    }

    @Override
    public Map<Long, String> sendOnbrdActivityPlanIdToWorkflow(List<Long> onbrdBillIds) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)onbrdBillIds.size());
        LOGGER.info(MessageFormat.format("sendOnbrdActivityPlanIdToWorkflow-start onbrdBillIds is {0}", String.valueOf(onbrdBillIds)));
        DynamicObject[] onbrdBills = HomCommonRepository.queryDynamicObjectByPks("hom_onbrdinfo", "", onbrdBillIds.toArray(new Object[0]));
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<Long> successId = new ArrayList<Long>(onbrdBillIds.size());
        ArrayList<Long> ids = new ArrayList<Long>(onbrdBillIds.size());
        try (TXHandle txHandle = TX.required();){
            try {
                HashMap<Long, DynamicObjectCollection> actSchemeEntryDysMap = new HashMap<Long, DynamicObjectCollection>(onbrdBills.length);
                HashMap<Long, Long> activitySchemeMap = new HashMap<Long, Long>(onbrdBills.length);
                HashMap<Long, String> workflowStatusSchemeMap = new HashMap<Long, String>(onbrdBills.length);
                for (DynamicObject onbrdBill : onbrdBills) {
                    Long bill = onbrdBill.getLong("id");
                    ids.add(bill);
                    Map<String, Object> activitySchemeFromWorkflow = IHomToHrcsAppService.getInstance().getActivitySchemeFromWorkflow(onbrdBill, "actschemeentry.activity,actschemeentry.paramname,actschemeentry.paramnumber,actschemeentry.paramvalue");
                    boolean success = (Boolean)activitySchemeFromWorkflow.get("success");
                    if (!success) {
                        resultMap.put(bill, (String)activitySchemeFromWorkflow.get("errorMsg"));
                        workflowStatusSchemeMap.put(bill, WorkflowSchemeStatusEnum.MATCH_FAIL.getValue());
                        continue;
                    }
                    Object data = activitySchemeFromWorkflow.get("data");
                    DynamicObject activitySchemeObj = null;
                    if (data instanceof DynamicObject) {
                        activitySchemeObj = (DynamicObject)data;
                    }
                    if (activitySchemeObj == null) {
                        resultMap.put(bill, ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6d3b\u52a8\u65b9\u6848\u3002", (String)"OnbrdStartUpProcessService_2", (String)"hr-hom-business", (Object[])new Object[0]));
                        workflowStatusSchemeMap.put(bill, WorkflowSchemeStatusEnum.MATCH_FAIL.getValue());
                        continue;
                    }
                    DynamicObjectCollection actSchemeEntryDys = activitySchemeObj.getDynamicObjectCollection("actschemeentry");
                    actSchemeEntryDysMap.put(onbrdBill.getLong("id"), actSchemeEntryDys);
                    long activityScheme = activitySchemeObj.getLong("id");
                    activitySchemeMap.put(onbrdBill.getLong("id"), activityScheme);
                    successId.add(bill);
                }
                if (!CollectionUtils.isEmpty(successId)) {
                    IHomToHrcsAppService.getInstance().initActivityInfo(successId, activitySchemeMap, actSchemeEntryDysMap, workflowStatusSchemeMap);
                }
            }
            catch (Exception exp) {
                flag.set(false);
                txHandle.markRollback();
                LOGGER.error(MessageFormat.format("sendOnbrdActivityPlanIdToWorkflow-exp is {0}", exp));
            }
        }
        LOGGER.info(MessageFormat.format("End sendOnbrdActivityPlanIdToWorkflow-start onbrdBillIds is {0}", String.valueOf(onbrdBillIds)));
        if (flag.get()) {
            threadPool.execute(() -> {
                LOGGER.info(MessageFormat.format("tryTriggerProcess-start fitIds is {0}", String.valueOf(ids)));
                for (Long onbrdBillId : ids) {
                    WorkflowServiceHelper.tryTriggerProcess((String)String.valueOf(onbrdBillId), (String)"submit", (String)"hom_onbrdinfo", new HashMap(1));
                }
                LOGGER.info(MessageFormat.format("tryTriggerProcess-end fitIds is {0}", String.valueOf(ids)));
            }, RequestContext.get());
        }
        threadPool.execute(() -> {
            LOGGER.info("sendOnbrdActivityPlanIdToWorkflow Start to syncCandidateInfo");
            for (DynamicObject dynamicObject : onbrdBills) {
                IHomToHcfAppService.getInstance().syncPersonInfo(dynamicObject);
                IHomToHcfAppService.getInstance().syncCandidateInfo(dynamicObject);
            }
            LOGGER.info("sendOnbrdActivityPlanIdToWorkflow syncCandidateInfo success");
        }, RequestContext.get());
        return resultMap;
    }

    @Override
    public List<DynamicObject> validateStartUpData(DynamicObject[] onbrdBills, List<Tuple<DynamicObject, String>> errorBillList) {
        ArrayList<DynamicObject> successBillList = new ArrayList<DynamicObject>(onbrdBills.length);
        Map<Long, DynamicObject> onbrdBillMap = Stream.of(onbrdBills).collect(Collectors.toMap(onbrdBill -> onbrdBill.getLong("id"), onbrdBill -> onbrdBill, (oldValue, newValue) -> newValue));
        OnbrdStartUpProcessService onbrdStartUpProcessService = new OnbrdStartUpProcessService();
        Map<Long, Optional<String>> validateDataResult = onbrdStartUpProcessService.validateData(onbrdBills);
        ArrayList valiDataPassedList = new ArrayList(onbrdBills.length);
        validateDataResult.forEach((key, value) -> {
            DynamicObject onbrdBill = (DynamicObject)onbrdBillMap.get(key);
            if (value.isPresent()) {
                errorBillList.add(Tuple.create((Object)onbrdBill, value.get()));
            } else {
                valiDataPassedList.add(onbrdBill);
            }
        });
        Map<Long, Optional<String>> matchActivityPlanResult = onbrdStartUpProcessService.matchOnbrdActivityPlan(valiDataPassedList.toArray(new DynamicObject[valiDataPassedList.size()]));
        matchActivityPlanResult.entrySet().stream().forEach(entry -> {
            DynamicObject onbrdBill = (DynamicObject)onbrdBillMap.get(entry.getKey());
            String enrollStatus = onbrdBill.getString("enrollstatus");
            if (!HRStringUtils.equals((String)OnbrdStatusEnum.WAIT_START.getValue(), (String)enrollStatus)) {
                errorBillList.add(Tuple.create((Object)onbrdBill, (Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u64cd\u4f5c\uff1b", (String)"OnbrdStartUpAppServiceImpl_14", (String)"hr-hom-business", (Object[])new Object[0])));
            } else if (((Optional)entry.getValue()).isPresent()) {
                errorBillList.add(Tuple.create((Object)onbrdBill, ((Optional)entry.getValue()).get()));
            } else {
                successBillList.add(onbrdBill);
            }
        });
        return successBillList;
    }
}

