/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.reservation;

import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;

public class ReservationService {
    private static final Log LOGGER = LogFactory.getLog(ReservationService.class);
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"ReservationService#&&==", (int)5, (int)100);

    public static void reservationConfirm(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        QFilter idLongsFilter = new QFilter("id", "in", idList);
        Object[] reservationObjs = IOnbrdBillDomainService.getInstance().findOnbrdBills("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", new QFilter[]{idLongsFilter});
        if (HRArrayUtils.isEmpty((Object[])reservationObjs)) {
            return;
        }
        Arrays.stream(reservationObjs).forEach(dy -> dy.set("preenrollstatus", (Object)PreEnrollStatusEnum.HAS_RESERVATION.getValue()));
        try {
            IOnbrdBillDomainService.getInstance().setWaitCheckin((DynamicObject[])reservationObjs);
            IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos((DynamicObject[])reservationObjs);
            threadPool.execute(() -> IActivityDomainService.getInstance().batchConsentTask(idList, ActivityNumberEnum.APPOINTMENT), RequestContext.get());
            threadPool.execute(() -> ServiceFactory.getService(ISendMessageService.class).sendMessage(idList, RuleEngineSceneNumberEnum.NOTICE_APPOINTMENT), RequestContext.get());
        }
        catch (Exception exception) {
            LOGGER.error("ReservationService_reservationConfirm:", (Throwable)exception);
        }
    }

    public static void reservationCancel(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        QFilter idLongsFilter = new QFilter("id", "in", idList);
        Object[] reservationObjs = IOnbrdBillDomainService.getInstance().findOnbrdBills("preenrollstatus,preeneffectdate,preenonbrdtcity,effectdate,onbrdtcity,checkintype,nocheckintimes,ischeckinexception,exceptioncause,checkinstatus,preenonbrdtcity.id,enrollstatus", new QFilter[]{idLongsFilter});
        if (HRArrayUtils.isEmpty((Object[])reservationObjs)) {
            return;
        }
        Arrays.stream(reservationObjs).forEach(dy -> {
            dy.set("preenrollstatus", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue());
            dy.set("effectdate", null);
            dy.set("onbrdtcity", null);
            dy.set("preeneffectdate", null);
            dy.set("preenonbrdtcity", null);
        });
        IOnbrdBillDomainService.getInstance().saveOnbrdBillInfos((DynamicObject[])reservationObjs);
    }
}

