/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.tsc;

import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.service.tsc.IBreakupOnbrdBillDomainService;
import kd.hr.hom.common.entity.tsc.OnbrdRespVal;
import kd.hr.hom.common.entity.tsc.ResponseDTO;
import kd.hr.hom.common.enums.OnbrdDataSourceEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakupOnbrdBillDomainServiceImpl
implements IBreakupOnbrdBillDomainService {
    private static final Logger logger = LoggerFactory.getLogger(BreakupOnbrdBillDomainServiceImpl.class);
    private static final String BREAKUP_ONBRD_QUEUE = "kd.hr.service.message.tsc.tspr.breakuponbrd_queue";

    @Override
    public void sendBreakupOnbrdMsg(List<DynamicObject> onbrdBillList) {
        logger.info("BreakupOnbrdBillDomainServiceImpl.sendBreakupOnbrdMsg.start");
        MessagePublisher mqServer = MQFactory.get().createSimplePublisher("tsc", BREAKUP_ONBRD_QUEUE);
        for (DynamicObject onbrdBill : onbrdBillList) {
            logger.info("BreakupOnbrdBillDomainServiceImpl.onbrdBill.[{}]", (Object)onbrdBill);
            String dataSource = onbrdBill.getString("datasource");
            if (!OnbrdDataSourceEnum.TSC.getValue().equals(dataSource)) continue;
            Long appFileId = onbrdBill.getDynamicObject("candidate").getLong("appfileid");
            Long breakupTypeDy = onbrdBill.getLong("breakuptype");
            Long breakupReasonDy = onbrdBill.getLong("breakupreason");
            String breakupRemarks = onbrdBill.getString("breakupremarks");
            OnbrdRespVal onbrdRespVal = new OnbrdRespVal();
            onbrdRespVal.setAppFileId(appFileId);
            onbrdRespVal.setBreakupTypeId(breakupTypeDy);
            onbrdRespVal.setBreakupReasonId(breakupReasonDy);
            onbrdRespVal.setBreakupRemarks(breakupRemarks);
            onbrdRespVal.setOfferNumber(onbrdBill.getString("offernumber"));
            onbrdRespVal.setOnbrdOfferId(Long.valueOf(onbrdBill.getLong("offerid")));
            ResponseDTO responseDTO = new ResponseDTO();
            responseDTO.setOnboardType("C");
            responseDTO.setResult((Object)onbrdRespVal);
            responseDTO.setSuccess(Boolean.TRUE);
            logger.info("send breakup onbrd message body : {}", (Object)responseDTO);
            try {
                mqServer.publish(SerializationUtils.toJsonString((Object)responseDTO));
            }
            catch (Exception ex) {
                logger.error("send breakup onbrd message error :", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
            finally {
                if (mqServer == null) continue;
                mqServer.close();
            }
        }
    }

    @Override
    public void handleBreakupOnbrdMsg(OnbrdRespVal onbrdRespVal) {
        logger.info("BreakupOnbrdBillDomainServiceImpl.handleBreakupOnbrdMsg.start");
        Long appFileId = onbrdRespVal.getAppFileId();
        QFilter qFilter = new QFilter("enrollstatus", "in", (Object)ImmutableList.of((Object)"1", (Object)"2"));
        qFilter.and("candidate.appfileid", "=", (Object)appFileId);
        DynamicObject[] onbrdBillDys = OnbrdBillRepository.findOnbrdBills("enrollstatus, breakuptype, breakupreason, breakupremarks, breakupdate", new QFilter[]{qFilter});
        if (ObjectUtils.isNotEmpty((Object)onbrdBillDys)) {
            DynamicObject onbrdBillDy = onbrdBillDys[0];
            onbrdBillDy.set("enrollstatus", (Object)"4");
            onbrdBillDy.set("breakuptype", (Object)onbrdRespVal.getBreakupTypeId());
            onbrdBillDy.set("breakupreason", (Object)onbrdRespVal.getBreakupReasonId());
            onbrdBillDy.set("breakupremarks", (Object)onbrdRespVal.getBreakupRemarks());
            onbrdBillDy.set("breakupdate", (Object)new Date());
            OnbrdBillRepository.saveOnbrdBillInfo(onbrdBillDy);
        }
    }
}

