/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.collect.approve;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.opplugin.validate.approve.SubmitValidator;

public class SubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(SubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("templateresult");
        args.getFieldKeys().add("onboard");
        args.getFieldKeys().add("sendtext");
        args.getFieldKeys().add("approvestatus");
        args.getFieldKeys().add("collectstatus");
        args.getFieldKeys().add("collectconfighis");
        args.getFieldKeys().add("submitpro");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SubmitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        String entityId = dataEntity.getDataEntityType().getName();
        long onbrdId = dataEntity.getLong("onboard.id");
        boolean isApprove = "hom_collectapprovereject".equals(entityId);
        LOGGER.info("###SubmitOp.beginOperationTransaction, approvePassCollectLog,isApprove\uff1a{}", (Object)isApprove);
        if (isApprove) {
            dataEntity.set("approvestatus", (Object)CollectApproveStatusEnum.APPROVING.getStatus());
        } else {
            dataEntity.set("collectstatus", (Object)CollectManageStatusEnum.FINISH.getStatus());
        }
        long collectConfigHisId = dataEntity.getLong("collectconfighis.id");
        DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
        String submitPro = ((ICollectService)ServiceFactory.getService(ICollectService.class)).getSubmitPro(infoGroupConfigEntity, Long.valueOf(onbrdId));
        dataEntity.set("submitpro", (Object)submitPro);
        IHcfDataDomainService.getInstance().syncDataFormHcfToHom(Long.valueOf(onbrdId));
        HomCommonRepository.updateDynamicObject((String)"hom_collect", (DynamicObject)dataEntity);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        String entityId = dataEntity.getDataEntityType().getName();
        boolean isApprove = "hom_collectapprovereject".equals(entityId);
        if (!isApprove) {
            long onbrdId = dataEntity.getLong("onboard.id");
            LOGGER.info("###SubmitOp.beginOperationTransaction, batchConsentTask,id\uff1a{}", (Object)onbrdId);
            OperationResult operationResult = IActivityDomainService.getInstance().batchConsentTask(Collections.singletonList(onbrdId), ActivityNumberEnum.INFOCOLLECTION);
            LOGGER.info("###SubmitOp.beginOperationTransaction, batchConsentTask result:{}", (Object)operationResult.isSuccess());
        }
    }
}

