/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.collect.collectmanage;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.common.ISendMessageService;
import kd.hr.hom.common.enums.RuleEngineSceneNumberEnum;
import kd.hr.hom.opplugin.validate.collectmanage.OneClickNoticeValidator;

public class OneClickNoticeOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(kd.hr.hom.opplugin.collect.approve.OneClickNoticeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("onboard");
        args.getFieldKeys().add("sendtext");
        args.getFieldKeys().add("collectstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new OneClickNoticeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Map sendResultMap;
        int dataLength = args.getDataEntities().length;
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> onbrdIds = new ArrayList<Long>(dataLength);
        HashMap onbrdCollectMap = Maps.newHashMapWithExpectedSize((int)dataLength);
        for (DynamicObject dynamicObject : dataEntities) {
            long onbrdId = dynamicObject.getLong("onboard.id");
            onbrdCollectMap.put(onbrdId, dynamicObject);
            onbrdIds.add(onbrdId);
        }
        LOGGER.info("###OneClickNoticeOp.beforeExecuteOperationTransaction sendMessage param:{}", onbrdIds);
        TXHandle ignored = TX.notSupported();
        Object object = null;
        try {
            sendResultMap = ((ISendMessageService)ServiceFactory.getService(ISendMessageService.class)).sendMessage(onbrdIds, RuleEngineSceneNumberEnum.COLLECT_NOTICE_MESSAGE);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (object != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(dataLength);
        LOGGER.info("###OneClickNoticeOp, sendMessage result:{}", (Object)JSON.toJSONString((Object)sendResultMap));
        for (Map.Entry entry : sendResultMap.entrySet()) {
            if (!Boolean.TRUE.equals(entry.getValue())) continue;
            DynamicObject collectManage = (DynamicObject)onbrdCollectMap.get(entry.getKey());
            collectManage.set("sendtext", (Object)"1");
            successList.add(collectManage);
        }
        HomCommonRepository.updateDynamicObjects((String)"hom_collect", (DynamicObject[])successList.toArray(new DynamicObject[0]));
    }
}

