/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.domain.service.common.IHomDataMutexService;
import kd.hr.hom.business.domain.service.impl.hcf.HcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.constant.MultiEntityImportConstants;
import kd.hr.hom.opplugin.validate.OnbrdBillDeleteValidator;

public class OnbrdInfoDeleteOp
extends HRDataBaseOp
implements Serializable {
    private static final Log logger = LogFactory.getLog(OnbrdInfoDeleteOp.class);
    private static final long serialVersionUID = -3260416921672107502L;

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        List fieldKeys = evt.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("candidate");
        fieldKeys.add("name");
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new OnbrdBillDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] onbrdBills = args.getDataEntities();
        Set candidateIds = Arrays.stream(onbrdBills).filter(onbrdBill -> {
            DynamicObject candidate = onbrdBill.getDynamicObject("candidate");
            if (HRObjectUtils.isEmpty((Object)candidate)) {
                return false;
            }
            return candidate.getLong("appfileid") == 0L;
        }).map(onbrdBill -> onbrdBill.getLong("candidate.id")).collect(Collectors.toSet());
        logger.info("candidateIds.size:" + candidateIds.size() + ", " + candidateIds);
        HcfDataDomainService hcfDataDomainService = new HcfDataDomainService();
        List candidateIdList = candidateIds.stream().collect(Collectors.toList());
        for (String entityName : MultiEntityImportConstants.CANDIDATE_ATTACH_ENTITY) {
            logger.info("entityName:" + entityName + ", before delete:" + candidateIdList.size());
            hcfDataDomainService.deleteHcfAttachedData(entityName, candidateIdList);
            logger.info("entityName:" + entityName + ", after delete:" + candidateIdList.size());
        }
        hcfDataDomainService.deleteByIds(candidateIds, "hcf_candidate");
        logger.info("entityName:" + "hcf_candidate" + ", after delete:" + candidateIds.size());
        Set onbrdBillIds = Arrays.stream(onbrdBills).map(onbrdBill -> onbrdBill.getLong("id")).collect(Collectors.toSet());
        logger.info("onbrdBillIds.size:" + onbrdBillIds.size() + ", " + onbrdBillIds);
        IOnbrdBillDomainService.getInstance().deleteByPkIds(onbrdBillIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        Set onbrdIdSet = this.getOperationResult().getSuccessPkIds().stream().map(pkId -> Long.parseLong(pkId.toString())).collect(Collectors.toSet());
        IHomDataMutexService.getInstance().batchRelease(onbrdIdSet, "hom_onbrdinfo", "delete");
    }
}

