/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.opplugin.onbrd;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hom.business.application.hrcs.IHomToHrcsAppService;
import kd.hr.hom.business.application.staff.IStaffUseService;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.enums.AuditStatusEnum;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.common.util.HOMObjectUtils;

public class UnSubmitOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(UnSubmitOp.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"UnSubmitOp", (int)5, (int)1000);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("enrollstatus");
        fieldKeys.add("billstatus");
        fieldKeys.add("auditstatus");
        fieldKeys.add("processstatus");
        fieldKeys.add("preenrollstatus");
        fieldKeys.add("checkinstatus");
        fieldKeys.add("preins");
        fieldKeys.add("checkinins");
        fieldKeys.add("name");
        fieldKeys.add("employeeno");
        fieldKeys.add("billno");
        fieldKeys.add("candidate");
        fieldKeys.add("aadminorg");
        fieldKeys.add("apositiontype");
        fieldKeys.add("aposition");
        fieldKeys.add("stdposition");
        fieldKeys.add("ajob");
        fieldKeys.add("ajoblevel");
        fieldKeys.add("laborreltype");
        fieldKeys.add("effectdate");
        fieldKeys.add("starttime");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        this.batchRevocation();
        List successPkIds = this.getOperationResult().getSuccessPkIds().stream().map(HOMObjectUtils::getLongValOfCustomParam).collect(Collectors.toList());
        if (successPkIds.isEmpty()) {
            LOGGER.info("successPkIds is empty");
        } else {
            LOGGER.info("successPkIds:{}", successPkIds);
            THREAD_POOL.execute(() -> IStaffUseService.getInstance().sendMsgForOnbrdBreakUp(successPkIds), RequestContext.get());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        LOGGER.info("UnSubmitOp-beginOperationTransaction start");
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            dataEntity.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
            dataEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
            dataEntity.set("auditstatus", (Object)AuditStatusEnum.SAVE.getCode());
            dataEntity.set("processstatus", (Object)ProcessStatusEnum.WAIT_PROCESS.getValue());
            dataEntity.set("preenrollstatus", (Object)" ");
            dataEntity.set("preins", (Object)0L);
            dataEntity.set("checkinstatus", (Object)" ");
            dataEntity.set("checkinins", (Object)0L);
            dataEntity.set("starttime", null);
        }
        Set billIds = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        HomCommonRepository.deleteByFilter((String)"hom_invitesendbill", (QFilter[])new QFilter[]{new QFilter("onbrd", "in", billIds)});
        HomCommonRepository.deleteByFilter((String)"hom_collect", (QFilter[])new QFilter[]{new QFilter("onboard", "in", billIds)});
        HomCommonRepository.deleteByFilter((String)"hom_acceptmanagedetail", (QFilter[])new QFilter[]{new QFilter("onboard", "in", billIds)});
        HomCommonRepository.deleteByFilter((String)"hom_activityoverview", (QFilter[])new QFilter[]{new QFilter("onbrd", "in", billIds)});
        LOGGER.info("UnSubmitOp-beginOperationTransaction end");
    }

    private OperationResult batchRevocation() {
        LOGGER.info("UnSubmitOp_batchRevocation_start");
        List idlist = this.getOperationResult().getSuccessPkIds().stream().map(Object::toString).collect(Collectors.toList());
        return IHomToHrcsAppService.getInstance().batchRevocation(idlist, Long.valueOf(RequestContext.get().getCurrUserId()));
    }
}

