/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.tsc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.message.IHRMsgTplService;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.api.tsc.ICreateOnbrdBillService;
import kd.hr.hom.business.application.impl.rule.OnbrdCommonValidator;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.application.onbrd.IValidEntryDateService;
import kd.hr.hom.business.application.rule.IOnbrdCommonValidator;
import kd.hr.hom.business.application.tsc.IOnbrdBillService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.business.domain.service.tsc.ICreateOnbrdBillDomainService;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.entity.tsc.OnboardReqDTO;
import kd.hr.hom.common.entity.tsc.OnbrdRespVal;
import kd.hr.hom.common.entity.tsc.ResponseDTO;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;

public class CreateOnbrdBillService
implements ICreateOnbrdBillService,
IHRMsgTplService {
    private static final Log log = LogFactory.getLog(CreateOnbrdBillService.class);
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"CreateOnbrdBillService", (int)5, (int)1000);

    public HRMServiceResult consumerSaveMsg(DynamicObject dynamicObject) {
        String content = dynamicObject.getString("msgcontent");
        Map contentMap = (Map)SerializationUtils.deSerializeFromBase64((String)content);
        String reqDTOStr = (String)contentMap.get("onboard_req");
        OnboardReqDTO reqDTO = (OnboardReqDTO)JSON.parseObject((String)reqDTOStr, OnboardReqDTO.class);
        log.info("CreateOnbrdBillService.consumerSaveMsg -> {}", (Object)JSONObject.toJSONString((Object)content));
        try {
            this.createHandle(reqDTO);
            return HRMServiceResult.success();
        }
        catch (Exception e) {
            log.error("CreateOnbrdBillService.consumerSaveMsg error -> ", (Throwable)e);
            return HRMServiceResult.fail((String)e.getMessage());
        }
    }

    private void createHandle(OnboardReqDTO reqDTO) {
        Long candidateId = reqDTO.getCandidateId();
        log.info("CreateOnbrdBillService.java_createHandle.candidateId:{}", (Object)candidateId);
        DynamicObject onbrdBill = IOnbrdBillService.getInstance().getOnbrdBillByCandidateId(candidateId);
        if (!(Objects.isNull(onbrdBill) || OnbrdStatusEnum.BREAK_UP.getValue().equals(onbrdBill.getString("enrollstatus")) || OnbrdStatusEnum.HAS_ONBRD.getValue().equals(onbrdBill.getString("enrollstatus")))) {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u5165\u804c\u5355\u3002", (String)"CreateOnbrdBillService_0", (String)"hr-hom-business", (Object[])new Object[0]);
            DynamicObject finalOnbrdBill = onbrdBill;
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, finalOnbrdBill.getString("offernumber"), errorMsg, Boolean.FALSE));
            return;
        }
        onbrdBill = IOnbrdBillService.getInstance().generateOnbrdBill(reqDTO);
        if (this.validateHandle(onbrdBill, reqDTO).booleanValue() && this.validateRepeat(onbrdBill, reqDTO).booleanValue() && this.validateVerifyCertHandle(reqDTO).booleanValue()) {
            try (TXHandle txHandle = TX.required();){
                IOnbrdBillService.getInstance().createOnbrdBill(onbrdBill);
                DynamicObject createOnbrdBill = IOnbrdBillService.getInstance().getOnbrdBillByCandidateId(Long.valueOf(onbrdBill.getLong("candidate")));
                this.initRoleAndJobInfoHandle(createOnbrdBill);
                IOnbrdBillService.getInstance().updateOnbrdBill(createOnbrdBill);
                threadPool.execute(() -> this.sendSuccessMsgHandle(reqDTO));
            }
        }
    }

    private Boolean validateVerifyCertHandle(OnboardReqDTO reqDTO) {
        Map verifyResult = HRCertCommonHelper.verifyCertCount((String)"1WXB5G9/BL46", (String)"hom_onbrdpersonlist", (int)1);
        String verifyCertInfoType = (String)verifyResult.get("infoType");
        if (HRStringUtils.equals((String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName(), (String)verifyCertInfoType)) {
            String errorMsg = ResManager.loadKDString((String)"\u8d85\u8fc7\u53ef\u7528\u8bb8\u53ef\u6570\u91cf\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreateOnbrdBillService_1", (String)"hr-hom-business", (Object[])new Object[0]);
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, errorMsg, Boolean.TRUE));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void initRoleAndJobInfoHandle(DynamicObject onbrdBill) {
        ArrayList<HomCommonWrapper> rowDataWrapperList = new ArrayList<HomCommonWrapper>();
        HomCommonWrapper homCommonWrapper = new HomCommonWrapper(onbrdBill);
        rowDataWrapperList.add(homCommonWrapper);
        OnbrdCommonValidator validator = new OnbrdCommonValidator();
        validator.initRoleByAposition(rowDataWrapperList);
        log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initRoleByAposition -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (!"2".equals(onbrdBill.getString("apositiontype"))) {
            IOnbrdCommonValidator.getInstance().initAndCheckJobInfo(rowDataWrapperList);
            log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initAndCheckJobInfo -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        }
        IOnbrdInfoInitService.getInstance().initFieldValue(rowDataWrapperList, InitTypeEnum.ONBRD_NEW_INTEGERATE_TSC.getValue());
        IValidEntryDateService.getInstance().validEntryDateOfQuitDateByMultiEntity(rowDataWrapperList);
        log.info("CreateOnbrdBillService.initRoleAndJobInfoHandle.initFieldValue -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            throw new RuntimeException("initRoleByAposition or initJobInfos error!");
        }
    }

    private void sendSuccessMsgHandle(OnboardReqDTO reqDTO) {
        ResponseDTO<OnbrdRespVal> respDTO = this.convertMsgHandle(reqDTO);
        String msgTitle = String.format(ResManager.loadKDString((String)"%s\u521b\u5efa\u5165\u804c\u5355\u6210\u529f", (String)"CreateOnbrdBillService_4", (String)"hr-hom-business", (Object[])new Object[0]), reqDTO.getAppFileNumber());
        ICreateOnbrdBillDomainService.getInstance().sendOnbrdMsg(respDTO, msgTitle);
    }

    private ResponseDTO<OnbrdRespVal> convertMsgHandle(OnboardReqDTO reqDTO) {
        ResponseDTO respDTO = new ResponseDTO();
        OnbrdRespVal val = new OnbrdRespVal();
        val.setAppFileId(reqDTO.getAppFileId());
        val.setAppFileNumber(reqDTO.getAppFileNumber());
        val.setCandidateId(reqDTO.getCandidateId());
        val.setOfferNumber(reqDTO.getOfferNumber());
        respDTO.setSuccess(Boolean.TRUE);
        respDTO.setOnboardType("A");
        respDTO.setResult((Object)val);
        return respDTO;
    }

    private void sendErrorMsgHandle(OnboardReqDTO reqDTO, String onbrdOfferNumber, String errorMsg, Boolean isCanRetry) {
        ResponseDTO<OnbrdRespVal> respDTO = this.convertMsgHandle(reqDTO, onbrdOfferNumber, errorMsg, isCanRetry);
        String msgTitle = String.format(ResManager.loadKDString((String)"%s\u521b\u5efa\u5165\u804c\u5355\u5931\u8d25", (String)"CreateOnbrdBillService_3", (String)"hr-hom-business", (Object[])new Object[0]), reqDTO.getAppFileNumber());
        ICreateOnbrdBillDomainService.getInstance().sendOnbrdMsg(respDTO, msgTitle);
    }

    private Boolean validateRepeat(DynamicObject onbrdBill, OnboardReqDTO reqDTO) {
        ArrayList<HomCommonWrapper> rowDataWrapperList = new ArrayList<HomCommonWrapper>();
        HomCommonWrapper homCommonWrapper = new HomCommonWrapper(onbrdBill);
        rowDataWrapperList.add(homCommonWrapper);
        ArrayList<String> validateList = new ArrayList<String>();
        if (HRStringUtils.isNotEmpty((String)reqDTO.getPhone())) {
            validateList.add("phone");
        }
        if (HRStringUtils.isNotEmpty((String)reqDTO.getEmail())) {
            validateList.add("peremail");
        }
        if (null != onbrdBill.getDynamicObject("certificatetype") && HRStringUtils.isNotEmpty((String)onbrdBill.getString("certificatenumber"))) {
            validateList.add("certificatetype.id");
            validateList.add("certificatenumber");
        }
        IOnbrdCommonValidator.getInstance().judgeDuplicateByHrpiRpc(rowDataWrapperList, validateList);
        log.info("CreateOnbrdBillService.validateRepeat.judgeDuplicateByHrpiRpc -> {}", rowDataWrapperList.get(0));
        if (!CollectionUtils.isEmpty(rowDataWrapperList) && null != rowDataWrapperList.get(0) && 0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u4e3a\u5728\u804c\u5458\u5de5", (String)"CreateOnbrdBillService_2", (String)"hr-hom-business", (Object[])new Object[0]);
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, errorMsg, Boolean.FALSE));
            return Boolean.FALSE;
        }
        if (null != reqDTO.getCertificateType() && 0L != reqDTO.getCertificateType() && HRStringUtils.isNotEmpty((String)reqDTO.getCertificateNumber())) {
            IOnbrdCommonValidator.getInstance().judgeCertificateIfDuplicate(rowDataWrapperList);
        }
        if (HRStringUtils.isNotEmpty((String)reqDTO.getPhone())) {
            IOnbrdCommonValidator.getInstance().judgePhoneIfDuplicate(rowDataWrapperList);
        }
        if (HRStringUtils.isNotEmpty((String)reqDTO.getEmail())) {
            IOnbrdCommonValidator.getInstance().judgeEmailIfDuplicate(rowDataWrapperList);
        }
        log.info("CreateOnbrdBillService.validateRepeat.judgeCertificatePhoneEmail -> {}", (Object)((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgs());
        if (!CollectionUtils.isEmpty(rowDataWrapperList) && null != rowDataWrapperList.get(0) && 0 != ((HomCommonWrapper)rowDataWrapperList.get(0)).getErrorMsgNum()) {
            String errorMsg = ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5b58\u5728\u6709\u6548\u5165\u804c\u5355\u3002", (String)"CreateOnbrdBillService_0", (String)"hr-hom-business", (Object[])new Object[0]);
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, errorMsg, Boolean.FALSE));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean validateHandle(DynamicObject onbrdBill, OnboardReqDTO reqDTO) {
        Optional emailResult;
        Optional phoneResult;
        Optional certificateResult;
        String phone = onbrdBill.getString("phone");
        String email = onbrdBill.getString("peremail");
        DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
        String certificateNumber = onbrdBill.getString("certificatenumber");
        if (null != certificateType && HRStringUtils.isNotEmpty((String)certificateNumber) && (certificateResult = IOnbrdCommonAppService.getInstance().validateCertificateNum(certificateType, certificateNumber)).isPresent()) {
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, (String)certificateResult.get(), Boolean.TRUE));
            return Boolean.FALSE;
        }
        if (HRStringUtils.isNotEmpty((String)phone) && (phoneResult = IOnbrdCommonAppService.getInstance().validatePhone(phone)).isPresent()) {
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, (String)phoneResult.get(), Boolean.TRUE));
            return Boolean.FALSE;
        }
        if (HRStringUtils.isNotEmpty((String)email) && (emailResult = IOnbrdCommonAppService.getInstance().validateEmail(email)).isPresent()) {
            threadPool.execute(() -> this.sendErrorMsgHandle(reqDTO, null, (String)emailResult.get(), Boolean.TRUE));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private ResponseDTO<OnbrdRespVal> convertMsgHandle(OnboardReqDTO reqDTO, String onbrdOfferNumber, String errorMsg, Boolean isCanRetry) {
        ResponseDTO respDTO = new ResponseDTO();
        OnbrdRespVal val = new OnbrdRespVal();
        val.setAppFileId(reqDTO.getAppFileId());
        val.setAppFileNumber(reqDTO.getAppFileNumber());
        val.setCandidateId(reqDTO.getCandidateId());
        val.setOfferNumber(reqDTO.getOfferNumber());
        val.setOnbrdOfferNumber(onbrdOfferNumber);
        val.setEnrollStatus(isCanRetry != false ? "1" : "2");
        respDTO.setSuccess(Boolean.FALSE);
        respDTO.setMessage(errorMsg);
        respDTO.setOnboardType("A");
        respDTO.setResult((Object)val);
        return respDTO;
    }
}

