/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.Locale;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class HomConfigDataUpdateService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(HomConfigDataUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            LOGGER.info("==HomConfigDataUpdateService hom config begin==");
            int row = this.doUpgrade(ver, iteration, dbKey, sqlFileName);
            result.setLog(String.format("HomConfigDataUpdateService hom config oristatus upgrade success: %s", row));
            result.setSuccess(true);
            result.setEl("warning");
            LOGGER.info("==HomConfigDataUpdateService hom config success==");
            return result;
        }
        catch (Exception exception) {
            LOGGER.error("==HomConfigDataUpdateService hom config success==", (Throwable)exception);
            result.setErrorInfo(exception.getMessage());
            result.setSuccess(false);
            throw new KDException((Throwable)exception, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", exception.getMessage())});
        }
    }

    private int doUpgrade(String ver, String iteration, String dbKey, String sqlFileName) {
        if (!this.isExistsOnbrdbill(dbKey)) {
            String newBusinessValue = "{\"1010\":\"201010\", \"1020\":\"201030\", \"default\":\"201010\"}";
            return this.updateDevConfigByBusinessKey(dbKey, newBusinessValue);
        }
        return 0;
    }

    private boolean isExistsOnbrdbill(String dbKey) {
        String sql = "select count(1) from t_hom_onbrdbill;";
        long num = (Long)DB.query((DBRoute)new DBRoute(dbKey), (String)sql, null, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        return num > 0L;
    }

    private int updateDevConfigByBusinessKey(String dbKey, String newBusinessValue) {
        String sql = "update t_hom_config set fbusinessvalue = ? where fbusinesskey =?";
        return DB.update((DBRoute)new DBRoute(dbKey), (String)sql, (Object[])new Object[]{newBusinessValue, "onbrdtype_relation_chgactionconfigid"});
    }
}

