/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.common.enums.OnbrdDataSourceEnum;

public class HomDatasourceUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(HomDatasourceUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        LOGGER.info("Start Updating Datasource of OnbrdBill ");
        boolean flag = true;
        DataSet onbrdBillDataSet = this.getOnbrdBillData();
        try (TXHandle required = TX.required();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            while (onbrdBillDataSet.hasNext()) {
                Row row = onbrdBillDataSet.next();
                Long fid = row.getLong("fid");
                String candidateNumber = row.getString("fcandidatenumber");
                if (HRStringUtils.isEmpty((String)candidateNumber) || !candidateNumber.startsWith("SR")) {
                    paramsList.add(new Object[]{OnbrdDataSourceEnum.HOM.getValue(), fid});
                    continue;
                }
                paramsList.add(new Object[]{OnbrdDataSourceEnum.TSC.getValue(), fid});
            }
            if (!paramsList.isEmpty()) {
                LOGGER.info("paramsList.size():{}", (Object)paramsList.size());
                DBRoute dbRoute = new DBRoute("hrb.hom");
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)this.updateSql(), paramsList);
            }
        }
        LOGGER.info("End Updating Datasource of OnbrdBill ");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("Updating Datasource of OnbrdBill Success");
        } else {
            result.setLog("Updating Datasource of OnbrdBill Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private DataSet getOnbrdBillData() {
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select t.fid, t.fcandidatenumber, a.fdatasource \nfrom t_hom_onbrdbill t \njoin t_hom_onbrdbill_a a on t.fid = a.fid and a.fdatasource = ' ' ";
        return HRDBUtil.queryDataSet((String)"HomDatasourceUpgradeService", (DBRoute)dbRoute, (String)sql, null);
    }

    private String updateSql() {
        return "update t_hom_onbrdbill_a set fdatasource = ? where fid = ? ";
    }
}

