/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDBUtil;

public class PolicyResultDatasUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PolicyResultDatasUpgradeService.class);
    private static final IHRAppCache CACHE = HRAppCache.get((String)"bree");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("Start Updating PolicyResultDataUpgradeService==");
        boolean flag = true;
        try (TXHandle required = TX.required();
             DataSet policyResultDataSet = this.getPolicyResultData();
             DataSet drlFilterResultDataSet = this.getDrlFilterResultData();){
            this.dealPolicyResultData(policyResultDataSet);
            this.dealDrlResultData(drlFilterResultDataSet);
        }
        logger.info("End Updating PolicyResultDataUpgradeService of OnbrdBill HRDBUtil");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("Updating PolicyResultDataUpgradeService of OnbrdBill Success");
        } else {
            result.setLog("Updating PolicyResultDataUpgradeService of OnbrdBill Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private void dealPolicyResultData(DataSet policyResultDataSet) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (policyResultDataSet.hasNext()) {
            Row row = policyResultDataSet.next();
            long fid = row.getLong("fid");
            String results = row.getString("fresults");
            String newResult = this.getResult(results);
            Object[] paramArr = new Object[]{newResult, fid};
            paramsList.add(paramArr);
        }
        if (!paramsList.isEmpty()) {
            DBRoute dbRoute = new DBRoute("hmp");
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)this.updateSql(), paramsList);
        }
    }

    private String getResult(String results) {
        return results.replaceAll(ResManager.loadKDString((String)"\u4f7f\u7528\u65b0\u5de5\u53f7", (String)"PolicyResultDataUpgradeService_0", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"PolicyResultDataUpgradeService_1", (String)"hr-hom-mservice", (Object[])new Object[0])).replaceAll(ResManager.loadKDString((String)"\u4f7f\u7528\u539f\u5de5\u53f7", (String)"PolicyResultDataUpgradeService_2", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f", (String)"PolicyResultDataUpgradeService_3", (String)"hr-hom-mservice", (Object[])new Object[0])).replaceAll(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u53f8\u9f84", (String)"PolicyResultDataUpgradeService_4", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5426", (String)"PolicyResultDataUpgradeService_1", (String)"hr-hom-mservice", (Object[])new Object[0])).replaceAll(ResManager.loadKDString((String)"\u5ef6\u7eed\u8ba1\u7b97\u53f8\u9f84", (String)"PolicyResultDataUpgradeService_5", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f", (String)"PolicyResultDataUpgradeService_3", (String)"hr-hom-mservice", (Object[])new Object[0])).replaceAll(ResManager.loadKDString((String)"\u53f8\u9f84\u63a5\u7eed\u65b9\u6848", (String)"PolicyResultDataUpgradeService_6", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u5ef6\u7eed\u53f8\u9f84", (String)"PolicyResultDataUpgradeService_7", (String)"hr-hom-mservice", (Object[])new Object[0])).replaceAll(ResManager.loadKDString((String)"\u5de5\u53f7\u63a5\u7eed\u65b9\u6848", (String)"PolicyResultDataUpgradeService_8", (String)"hr-hom-mservice", (Object[])new Object[0]), ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u627f\u5de5\u53f7", (String)"PolicyResultDataUpgradeService_9", (String)"hr-hom-mservice", (Object[])new Object[0]));
    }

    private void dealDrlResultData(DataSet drlFilterResultDataSet) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (drlFilterResultDataSet.hasNext()) {
            Row row = drlFilterResultDataSet.next();
            long fid = row.getLong("fentryid");
            String results = row.getString("fresults");
            String newResult = this.getResult(results);
            Object[] paramArr = new Object[]{newResult, fid};
            paramsList.add(paramArr);
        }
        if (!paramsList.isEmpty()) {
            DBRoute dbRoute = new DBRoute("hmp");
            HRDBUtil.executeBatch((DBRoute)dbRoute, (String)this.updateDrlFilterSql(), paramsList);
        }
    }

    private DataSet getPolicyResultData() {
        DBRoute dbRoute = new DBRoute("hmp");
        String sql = "select fresults,fid from t_brm_policy where fsceneid =1594222338948363264";
        return HRDBUtil.queryDataSet((String)"getPolicyResultData", (DBRoute)dbRoute, (String)sql, null);
    }

    private String updateSql() {
        return "update t_brm_policy set fresults = ? where fid = ? ";
    }

    private String updateDrlFilterSql() {
        return "update t_brm_drlfilter set fresults = ? where fentryid = ? ";
    }

    private DataSet getDrlFilterResultData() {
        DBRoute dbRoute = new DBRoute("hmp");
        String sql = "select fentryid,fresults from t_brm_drlfilter where fsceneid =1594222338948363264";
        return HRDBUtil.queryDataSet((String)"getDrlFilterResultData", (DBRoute)dbRoute, (String)sql, null);
    }
}

