/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRObjectUtils;

public class PreStartDateUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PreStartDateUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("Start Updating preservestartdate of OnbrdBill HRDBUtil");
        boolean flag = true;
        DataSet homDataSet = this.getHomBaseinfoData();
        try (TXHandle required = TX.required();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
            while (homDataSet.hasNext()) {
                Row row = homDataSet.next();
                Long candidateId = row.getLong("fcandidateid");
                Object breakupdate = row.get("fbreakupdate");
                if (HRObjectUtils.isEmpty((Object)candidateId) || HRObjectUtils.isEmpty((Object)breakupdate)) continue;
                Object[] paramArr = new Object[]{breakupdate, candidateId};
                paramsList.add(paramArr);
            }
            if (!paramsList.isEmpty()) {
                DBRoute dbRoute = new DBRoute("hcf");
                HRDBUtil.executeBatch((DBRoute)dbRoute, (String)this.updateSql(), paramsList);
            }
        }
        logger.info("End Updating preservestartdate of OnbrdBill HRDBUtil");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("Updating preservestartdate of OnbrdBill Success");
        } else {
            result.setLog("Updating preservestartdate of OnbrdBill Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private DataSet getHomBaseinfoData() {
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select fid, fcandidateid, fenrollstatus, fbreakupdate FROM t_hom_onbrdbill where fenrollstatus = '4' ";
        return HRDBUtil.queryDataSet((String)"PreStartDateUpgradeService", (DBRoute)dbRoute, (String)sql, null);
    }

    private String updateSql() {
        return "update t_hcf_candidate set fpreservestartdate = ? where fid = ? ";
    }
}

