/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.mservice.upgrade;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.common.enums.ActivityStatusEnum;
import kd.hr.hom.common.enums.CheckinStatusEnum;
import kd.hr.hom.common.enums.PreEnrollStatusEnum;

public class StatusUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(StatusUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("Start StatusUpgradeService");
        boolean flag = true;
        try (TXHandle required = TX.required();
             DataSet homDataSet = this.getHomBaseinfoData();){
            if (!homDataSet.isEmpty()) {
                logger.info("StatusUpgradeService.updateStatusToEmpty");
                this.updateStatusToEmpty();
                logger.info("StatusUpgradeService.updatePreStatus");
                this.updatePreStatus();
                logger.info("StatusUpgradeService.updateCheckinStatus");
                this.updateCheckinStatus();
            }
        }
        logger.info("End Start StatusUpgradeService");
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        if (flag) {
            result.setLog("StatusUpgradeService Success");
        } else {
            result.setLog("StatusUpgradeService Fail");
        }
        result.setSuccess(flag);
        return result;
    }

    private void updateStatusToEmpty() {
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "update t_hom_onbrdbill_a set fcheckinstatus = ' ', fpreenrollstatus = ' ' where 1=1";
        HRDBUtil.execute((DBRoute)dbRoute, (String)sql, null);
    }

    private void updatePreStatus() {
        QFilter activity = new QFilter("activity", "=", (Object)1296911737613900800L);
        QFilter onbrd = new QFilter("onbrdid", "<>", (Object)0L);
        activity.and(onbrd);
        logger.info("StatusUpgradeService.updatePreStatus. query hom_activeinfobody start");
        DynamicObject[] reservationActivityObjs = HomCommonRepository.queryDynamicObjects((String)"hom_activeinfobody", (String)"activityins.taskstatus,onbrdid", (QFilter[])new QFilter[]{activity});
        logger.info("StatusUpgradeService.updatePreStatus. query hom_activeinfobody end");
        Set<Object> onbrds = Arrays.stream(reservationActivityObjs).map(dynamicObject -> dynamicObject.getLong("onbrdid.id")).collect(Collectors.toSet());
        DynamicObject[] reservationOnbrdObjs = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdbilltpl", (String)"preenrollstatus", (Object[])onbrds.toArray(new Object[0]));
        block0: for (DynamicObject reservationActivityObj : reservationActivityObjs) {
            String taskstatus = reservationActivityObj.getString("activityins.taskstatus");
            for (DynamicObject reservationOnbrdObj : reservationOnbrdObjs) {
                long onbrdId = reservationActivityObj.getLong("onbrdid.id");
                if (onbrdId != reservationOnbrdObj.getLong("id")) continue;
                if (ActivityStatusEnum.PROCESSING.getValue().equals(taskstatus) || ActivityStatusEnum.TERMINATED.getValue().equals(taskstatus)) {
                    reservationOnbrdObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.WAIT_RESERVATION.getValue());
                    continue block0;
                }
                if (!ActivityStatusEnum.COMPLETED.getValue().equals(taskstatus)) continue block0;
                reservationOnbrdObj.set("preenrollstatus", (Object)PreEnrollStatusEnum.HAS_RESERVATION.getValue());
                continue block0;
            }
        }
        logger.info("StatusUpgradeService.updatePreStatus. updateDynamicObjects hom_onbrdbilltpl");
        HomCommonRepository.updateDynamicObjects((String)"hom_onbrdbilltpl", (DynamicObject[])reservationOnbrdObjs);
    }

    private void updateCheckinStatus() {
        QFilter activity = new QFilter("activity", "=", (Object)1296914540574989312L);
        QFilter onbrd = new QFilter("onbrdid", "<>", (Object)0L);
        activity.and(onbrd);
        logger.info("StatusUpgradeService.updateCheckinStatus. query hom_activeinfobody start");
        DynamicObject[] reservationActivityObjs = HomCommonRepository.queryDynamicObjects((String)"hom_activeinfobody", (String)"activityins.taskstatus,onbrdid", (QFilter[])new QFilter[]{activity});
        logger.info("StatusUpgradeService.updateCheckinStatus. query hom_activeinfobody end");
        Set<Object> onbrds = Arrays.stream(reservationActivityObjs).map(dynamicObject -> dynamicObject.getLong("onbrdid.id")).collect(Collectors.toSet());
        DynamicObject[] reservationOnbrdObjs = HomCommonRepository.queryDynamicObjectByPks((String)"hom_onbrdbilltpl", (String)"checkinstatus,preeneffectdate", (Object[])onbrds.toArray(new Object[0]));
        block0: for (DynamicObject reservationActivityObj : reservationActivityObjs) {
            String taskstatus = reservationActivityObj.getString("activityins.taskstatus");
            for (DynamicObject reservationOnbrdObj : reservationOnbrdObjs) {
                long onbrdId = reservationActivityObj.getLong("onbrdid.id");
                if (onbrdId != reservationOnbrdObj.getLong("id")) continue;
                if (ActivityStatusEnum.PROCESSING.getValue().equals(taskstatus) || ActivityStatusEnum.TERMINATED.getValue().equals(taskstatus)) {
                    Date date = HRDateTimeUtils.truncateDate((Date)new Date());
                    Date preeneffectdate = reservationOnbrdObj.getDate("preeneffectdate");
                    if (preeneffectdate != null && HRDateTimeUtils.dayAfter((Date)date, (Date)preeneffectdate)) {
                        reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.CHECKIN_EXCEPTION.getValue());
                        continue block0;
                    }
                    reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.WAIT_CHECKIN.getValue());
                    continue block0;
                }
                if (!ActivityStatusEnum.COMPLETED.getValue().equals(taskstatus)) continue block0;
                reservationOnbrdObj.set("checkinstatus", (Object)CheckinStatusEnum.HAS_CHECKIN.getValue());
                continue block0;
            }
        }
        logger.info("StatusUpgradeService.updateCheckinStatus. updateDynamicObjects hom_onbrdbilltpl");
        HomCommonRepository.updateDynamicObjects((String)"hom_onbrdbilltpl", (DynamicObject[])reservationOnbrdObjs);
    }

    private DataSet getHomBaseinfoData() {
        DBRoute dbRoute = new DBRoute("hrb.hom");
        String sql = "select fid FROM t_hom_onbrdbill";
        return HRDBUtil.queryDataSet((String)"PreStartDateUpgradeService", (DBRoute)dbRoute, (String)sql, null);
    }
}

