/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.EduPageServiceImpl;
import kd.hr.hom.business.domain.repository.OnbrdBillRepository;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.base.IHomConfigDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectFieldVerifyService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.common.constant.HcfCandidateConstants;
import kd.hr.hom.common.constant.InfoGroupFieldConstants;
import kd.hr.hom.common.enums.InfoGroupEnum;
import kd.hr.hom.common.enums.InfoGroupFieldTypeEnum;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class CustomStyleUtils {
    private static final Log LOGGER = LogFactory.getLog(CustomStyleUtils.class);
    private static final String ENTITY_NUMBER_HOM = "hom_";
    private static final String ENTITY_NUMBER_HCF = "hcf_";

    public static String getStyleToBase64(String customCss) {
        JSONObject customStyleMap = new JSONObject();
        customStyleMap.put("type", (Object)"0");
        customStyleMap.put("content", (Object)customCss);
        return Base64.getEncoder().encodeToString(customStyleMap.toJSONString().getBytes());
    }

    public static void nothingInputConfirm(IFormView view, String title, ConfirmCallBackListener listener, String customParam) {
        String confirm = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u586b\u5199\u4efb\u4f55\u4fe1\u606f\uff0c\u7cfb\u7edf\u4f1a\u6e05\u7a7a\u8fd9\u6761\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CustomStyleUtils_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InfoGroupDynViewMobilePlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InfoGroupDynViewMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]));
        view.showConfirm(title, confirm, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener, btnNameMaps, customParam);
    }

    public static List<InfoGroupEntity.InfoGroupField> checkFieldList(List<String> visibleFiledList, List<InfoGroupEntity.InfoGroupField> infoGroupFields, IFormView view, AtomicBoolean allEmpty) {
        ArrayList<InfoGroupEntity.InfoGroupField> fieldStatusVerifyList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        ICollectFieldVerifyService collectService = (ICollectFieldVerifyService)ServiceFactory.getService(ICollectFieldVerifyService.class);
        infoGroupFields.forEach(field -> {
            if (visibleFiledList.contains("field" + field.getFieldId())) {
                return;
            }
            if (!collectService.fieldIsEmpty(field, view)) {
                allEmpty.set(false);
            }
            if (collectService.fieldVerifyMustInput(field, view)) {
                fieldStatusVerifyList.add((InfoGroupEntity.InfoGroupField)field);
            }
        });
        return fieldStatusVerifyList;
    }

    @Deprecated
    public static List<String> checkFieldDescList(List<String> visibleFiledList, List<InfoGroupEntity.InfoGroupField> infoGroupFields, IFormView view, AtomicBoolean allEmpty) {
        ArrayList<String> fieldStatusVerifyDescList = new ArrayList<String>();
        ICollectFieldVerifyService collectService = (ICollectFieldVerifyService)ServiceFactory.getService(ICollectFieldVerifyService.class);
        infoGroupFields.forEach(field -> {
            if (visibleFiledList.contains("field" + field.getFieldId())) {
                return;
            }
            if (!collectService.fieldIsEmpty(field, view)) {
                allEmpty.set(false);
            }
            String fieldVerify = collectService.fieldVerify(field, view, infoGroupFields);
            if (!collectService.fieldVerifyMustInput(field, view) && HRStringUtils.isNotEmpty((String)fieldVerify)) {
                fieldStatusVerifyDescList.add(fieldVerify);
            }
        });
        return fieldStatusVerifyDescList;
    }

    public static StringBuilder getErrorMessage(List<InfoGroupEntity.InfoGroupField> fieldStatusVerifyList, IFormView view) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a%s\u3002", (String)"AbstractCollectDynViewPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]), fieldStatusVerifyList.stream().map(InfoGroupEntity.InfoGroupField::getFieldName).collect(Collectors.joining("\u3001"))));
        return stringBuilder;
    }

    public static String getFormatStr(Collection<String> coll, String errorItemFormat, String errorSeparator) {
        return coll.stream().collect(Collectors.joining(errorSeparator));
    }

    @Deprecated
    public static String getGroupInputErrorInfo(Map<String, String> mustInputMap, Long collectId) {
        String errorSeparator;
        String errorItemFormat;
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject((String)"hom_collectgroupstatus", (String)"infogroupentry.infogroupstatus,infogroupentry.infogroup", (QFilter[])new QFilter[]{new QFilter("collectactivity", "=", (Object)collectId)});
        List<String> errorFieldNameList = collectGroupDyn.getDynamicObjectCollection("infogroupentry").stream().filter(dy -> HRStringUtils.equals((String)"0", (String)dy.getString("infogroupstatus"))).map(dy -> "mustinput" + dy.getLong("infogroup.id")).filter(mustInputMap::containsKey).map(mustInputMap::get).collect(Collectors.toList());
        String errorGroup = CustomStyleUtils.getFormatStr(errorFieldNameList, errorItemFormat = "", errorSeparator = "\u3001");
        if (HRStringUtils.isNotEmpty((String)errorGroup)) {
            String errorPrefix = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5fc5\u586b\u4fe1\u606f\u7ec4\uff1a%s", (String)"CollectActivityPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return String.format(Locale.ROOT, errorPrefix, errorGroup);
        }
        return "";
    }

    @Deprecated
    public static String getGroupInputCheckInfo(List<InfoGroupEntity> infoGroupEntityList, DynamicObject onboardBill) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        infoGroupEntityList.stream().filter(InfoGroupEntity::getMustInput).filter(infoGroupEntity -> HRCollUtil.isNotEmpty((Collection)infoGroupEntity.getInfoGroupFieldList())).forEach(infoGroupEntity -> {
            DynamicObject onboard;
            String infoGroupName = infoGroupEntity.getInfoGroupName();
            String pageKey = ((InfoGroupEntity.InfoGroupField)infoGroupEntity.getInfoGroupFieldList().get(0)).getPageKey();
            if (pageKey.contains(ENTITY_NUMBER_HOM) && (onboard = OnbrdBillRepository.findOnbrdBillById(null, (Object)onboardBill.getPkValue())) == null) {
                groupNameList.add(infoGroupName);
            }
            if (pageKey.contains(ENTITY_NUMBER_HCF)) {
                long candidateId = onboardBill.getLong("candidate_id");
                if (infoGroupEntity.isMultipleEntity()) {
                    DynamicObjectCollection hisMultiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(candidateId), pageKey);
                    if (hisMultiRowEntity == null || hisMultiRowEntity.isEmpty()) {
                        groupNameList.add(infoGroupName);
                    }
                } else {
                    DynamicObject singleRowEntity = IHomToHcfAppService.getInstance().getSingleRowEntity(Long.valueOf(candidateId), pageKey);
                    if (HRObjectUtils.isEmpty((Object)singleRowEntity)) {
                        groupNameList.add(infoGroupName);
                    }
                }
            }
        });
        String errorItemFormat = "";
        String errorSeparator = "\u3001";
        String errorGroup = CustomStyleUtils.getFormatStr(groupNameList, errorItemFormat, errorSeparator);
        if (HRStringUtils.isNotEmpty((String)errorGroup)) {
            String errorPrefix = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u7ec4\u5185\u5b58\u5728\u5fc5\u586b\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\uff1a%s", (String)"CollectActivityPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return String.format(Locale.ROOT, errorPrefix, errorGroup);
        }
        return "";
    }

    public static String checkFieldList(List<InfoGroupEntity> infoGroupEntityList, IFormView view, DynamicObject onboard) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (InfoGroupEntity infoGroupEntity : infoGroupEntityList) {
            String errorGroupName = infoGroupEntity.isMultipleEntity() ? CustomStyleUtils.getErrorGroupNameMultiple(infoGroupEntity, view, onboard) : CustomStyleUtils.getErrorGroupNameSingle(infoGroupEntity, view, onboard);
            if (!HRStringUtils.isNotEmpty((String)errorGroupName)) continue;
            groupNameList.add(errorGroupName);
        }
        String errorItemFormat = "";
        String errorSeparator = "\u3001";
        String errorGroup = CustomStyleUtils.getFormatStr(groupNameList, errorItemFormat, errorSeparator);
        if (HRStringUtils.isNotEmpty((String)errorGroup)) {
            String errorPrefix = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u7ec4\u5185\u5b58\u5728\u5fc5\u586b\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\uff1a%s", (String)"CollectActivityPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return String.format(Locale.ROOT, errorPrefix, errorGroup);
        }
        return "";
    }

    private static String getErrorGroupNameSingle(InfoGroupEntity infoGroupEntity, IFormView view, DynamicObject onboard) {
        int size = infoGroupEntity.getInfoGroupFieldList().size();
        ArrayList<String> mustInputList = new ArrayList<String>(size);
        ArrayList<String> notEmptyList = new ArrayList<String>(size);
        boolean existRecord = false;
        ArrayList<InfoGroupEntity.InfoGroupField> mustAttachList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
            DynamicObject dataEntity = view.getModel().getDataEntity();
            Object obj = null;
            if (dataEntity.containsProperty("field" + infoGroupField.getFieldId())) {
                obj = dataEntity.get("field" + infoGroupField.getFieldId());
                if (!existRecord && !HRObjectUtils.isEmpty((Object)obj)) {
                    existRecord = true;
                }
            }
            if (!infoGroupField.isFieldMustInput()) continue;
            if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(String.valueOf(infoGroupField.getFieldType()))) {
                mustAttachList.add(infoGroupField);
                continue;
            }
            mustInputList.add(infoGroupField.getFieldName());
            if (HRObjectUtils.isEmpty((Object)obj)) continue;
            notEmptyList.add(infoGroupField.getFieldName());
        }
        if (infoGroupEntity.getMustInput().booleanValue()) {
            if (mustInputList.size() != notEmptyList.size()) {
                LOGGER.info(" mustinput checksingle fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
                return infoGroupEntity.getInfoGroupName();
            }
        } else if (existRecord && mustInputList.size() != notEmptyList.size()) {
            LOGGER.info(" not mustinput checksingle fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
            return infoGroupEntity.getInfoGroupName();
        }
        return CustomStyleUtils.getAttachmentResult(existRecord, infoGroupEntity, onboard, mustAttachList);
    }

    private static String getAttachmentResult(boolean existRecord, InfoGroupEntity infoGroupEntity, DynamicObject onboard, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        boolean success = CustomStyleUtils.checkAttachment(infoGroupEntity, onboard, mustAttachList);
        if (!success) {
            if (infoGroupEntity.getMustInput().booleanValue()) {
                return infoGroupEntity.getInfoGroupName();
            }
            return existRecord ? infoGroupEntity.getInfoGroupName() : "";
        }
        return "";
    }

    private static String getErrorGroupNameMultiple(InfoGroupEntity infoGroupEntity, IFormView view, DynamicObject onboard) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        if (infoGroupEntity.isMultipleEntity()) {
            dynamicObjectCollection = view.getModel().getDataEntity(true).getDynamicObjectCollection("entryap" + infoGroupEntity.getInfoGroupNumber().toLowerCase());
            if (infoGroupEntity.getMustInput().booleanValue() && (dynamicObjectCollection == null || dynamicObjectCollection.size() < 1)) {
                return infoGroupEntity.getInfoGroupName();
            }
        }
        boolean existRecord = false;
        ArrayList<InfoGroupEntity.InfoGroupField> mustAttachList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        int size = infoGroupEntity.getInfoGroupFieldList().size();
        ArrayList<String> mustInputList = new ArrayList<String>(size);
        ArrayList<String> notEmptyList = new ArrayList<String>(size);
        for (DynamicObject dy : dynamicObjectCollection) {
            List<String> invisibleFieldList = CustomStyleUtils.invisibleField(infoGroupEntity.getInfoGroupNumber(), view, dy);
            for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
                long count = invisibleFieldList.stream().filter(invisibleField -> invisibleField.contains(String.valueOf(infoGroupField.getFieldId()))).count();
                if (count > 0L) continue;
                Object obj = null;
                if (dy.containsProperty("entryfield" + infoGroupField.getFieldId())) {
                    obj = dy.get("entryfield" + infoGroupField.getFieldId());
                    if (!existRecord && !HRObjectUtils.isEmpty((Object)obj)) {
                        existRecord = true;
                    }
                }
                if (!infoGroupField.isFieldMustInput()) continue;
                if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(String.valueOf(infoGroupField.getFieldType()))) {
                    mustAttachList.add(infoGroupField);
                    continue;
                }
                mustInputList.add(infoGroupField.getFieldName());
                if (infoGroupField.getFieldId().equals(InfoGroupFieldConstants.RSM_PTDATA)) {
                    Object startDate = dy.get("entryfield" + infoGroupField.getFieldId() + "_ptstartdate");
                    Object pendingDate = dy.get("entryfield" + infoGroupField.getFieldId() + "_ptendingdate");
                    if (HRObjectUtils.isEmpty((Object)startDate) || HRObjectUtils.isEmpty((Object)pendingDate)) continue;
                    notEmptyList.add(infoGroupField.getFieldName());
                    continue;
                }
                if (HRObjectUtils.isEmpty((Object)obj)) continue;
                notEmptyList.add(infoGroupField.getFieldName());
            }
        }
        if (infoGroupEntity.getMustInput().booleanValue()) {
            if (mustInputList.size() != notEmptyList.size()) {
                LOGGER.info(" mustinput checkmultiple fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
                return infoGroupEntity.getInfoGroupName();
            }
        } else if (existRecord && mustInputList.size() != notEmptyList.size()) {
            LOGGER.info("not mustinput checkmultiple fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
            return infoGroupEntity.getInfoGroupName();
        }
        return CustomStyleUtils.getAttachmentResult(existRecord, infoGroupEntity, onboard, mustAttachList);
    }

    private static boolean checkAttachment(InfoGroupEntity infoGroupEntity, DynamicObject onboard, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        long candidateId = onboard.getLong("candidate_id");
        long onboardId = onboard.getLong("id");
        switch (infoGroupEntity.getInfoGroupNumber()) {
            case "S003": {
                return CustomStyleUtils.checkAttachmentCert(candidateId, mustAttachList);
            }
            case "S004": {
                return CustomStyleUtils.checkAttachmentEdu(candidateId, mustAttachList);
            }
            case "S007": {
                return CustomStyleUtils.checkAttachmentLang(candidateId, mustAttachList);
            }
            case "S008": {
                return CustomStyleUtils.checkAttachmentPreWorkExp(candidateId, mustAttachList);
            }
            case "S009": {
                return CustomStyleUtils.checkAttachmentPhysical(onboardId, mustAttachList);
            }
            case "S010": {
                return CustomStyleUtils.checkAttachmentRsmpatinv(candidateId, mustAttachList);
            }
        }
        return true;
    }

    private static boolean checkAttachmentRsmpatinv(long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        return CustomStyleUtils.checkAttachmentCandidateMultiple("hcf_rsmpatinv", candidateId, mustAttachList);
    }

    private static boolean checkAttachmentPreWorkExp(long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        return CustomStyleUtils.checkAttachmentCandidateMultiple("hcf_canprework", candidateId, mustAttachList);
    }

    private static boolean checkAttachmentLang(long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        return CustomStyleUtils.checkAttachmentCandidateMultiple("hcf_canlgability", candidateId, mustAttachList);
    }

    private static boolean checkAttachmentCert(long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        return CustomStyleUtils.checkAttachmentCandidateMultiple("hcf_cancre", candidateId, mustAttachList);
    }

    private static boolean checkAttachmentPhysical(long onboardId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        return CustomStyleUtils.checkAttachmentByOnboard(onboardId, mustAttachList);
    }

    private static boolean checkAttachmentByOnboard(long onboardId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        if (HRCollUtil.isEmpty(mustAttachList)) {
            return true;
        }
        Map attachmentMap = AttachmentServiceHelper.getAttachments((String)mustAttachList.get(0).getPageKey(), (Object[])new Object[]{onboardId}, (String)mustAttachList.get(0).getFieldKey(), (boolean)true);
        if (attachmentMap.isEmpty()) {
            return false;
        }
        return mustAttachList.size() == attachmentMap.size();
    }

    private static boolean checkAttachmentCandidateMultiple(String entityNum, long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        if (HRCollUtil.isEmpty(mustAttachList)) {
            return true;
        }
        DynamicObjectCollection hisMultiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(candidateId), entityNum);
        Object[] ids = hisMultiRowEntity.stream().map(DataEntityBase::getPkValue).toArray();
        if (ids.length == 0) {
            return false;
        }
        Map attachmentMap = AttachmentServiceHelper.getAttachments((String)mustAttachList.get(0).getPageKey(), (Object[])ids, (String)mustAttachList.get(0).getFieldKey(), (boolean)true);
        if (attachmentMap.isEmpty()) {
            return false;
        }
        return mustAttachList.size() == attachmentMap.size();
    }

    private static boolean checkAttachmentEdu(long candidateId, List<InfoGroupEntity.InfoGroupField> mustAttachList) {
        if (HRCollUtil.isEmpty(mustAttachList)) {
            return true;
        }
        DynamicObjectCollection hisMultiRowEntity = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(candidateId), "hcf_caneduexp");
        List eduIds = hisMultiRowEntity.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (HRCollUtil.isEmpty(eduIds)) {
            return false;
        }
        QFilter cerFilter = new QFilter("edu.id", "in", eduIds);
        DynamicObject[] dys = IHcfDataDomainService.getInstance().queryHcfAttachedData("hcf_educertificate", "id,edu,certtype", new QFilter[]{cerFilter});
        if (dys == null || dys.length < 1) {
            return false;
        }
        Object[] certificateIds = new Object[dys.length];
        HashMap certificateMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (int i = 0; i < dys.length; ++i) {
            DynamicObject certificate = dys[i];
            certificateIds[i] = certificate.getPkValue();
            certificateMap.put(certificate.getString("id"), certificate);
        }
        Map attachmentMap = AttachmentServiceHelper.getAttachments((String)mustAttachList.get(0).getPageKey(), (Object[])certificateIds, (String)mustAttachList.get(0).getFieldKey(), (boolean)true);
        if (attachmentMap.isEmpty()) {
            return false;
        }
        HashMap certTypeMap = new HashMap();
        attachmentMap.forEach((certificateId, attachment) -> {
            DynamicObject certificate = (DynamicObject)certificateMap.get(certificateId);
            if (certificate != null) {
                int count = certTypeMap.computeIfAbsent(certificate.getString("certtype.id"), val -> 0);
                certTypeMap.put(certificate.getString("certtype.id"), ++count);
            }
        });
        for (InfoGroupEntity.InfoGroupField infoGroupField : mustAttachList) {
            String certType = (String)InfoGroupFieldConstants.EDU_CERTIFICATE_MAP.get(infoGroupField.getFieldId());
            Integer count = (Integer)certTypeMap.get(certType);
            if (count != null && count.intValue() == eduIds.size()) continue;
            return false;
        }
        return true;
    }

    public static List<String> checkFieldDescList(List<InfoGroupEntity> infoGroupEntityList, IFormView view) {
        ICollectFieldVerifyService collectService = (ICollectFieldVerifyService)ServiceFactory.getService(ICollectFieldVerifyService.class);
        ArrayList<String> fieldStatusVerifyDescList = new ArrayList<String>();
        infoGroupEntityList.forEach(infoGroupEntity -> {
            if (infoGroupEntity.isMultipleEntity()) {
                return;
            }
            List infoGroupFieldList = infoGroupEntity.getInfoGroupFieldList();
            infoGroupFieldList.forEach(infoGroupField -> {
                if (!view.getModel().getDataEntity().containsProperty("field" + infoGroupField.getFieldId())) {
                    return;
                }
                Object obj = view.getModel().getDataEntity().get("field" + infoGroupField.getFieldId());
                if (HRObjectUtils.isEmpty((Object)obj)) {
                    return;
                }
                String fieldVerify = collectService.fieldVerify(infoGroupField, view, infoGroupFieldList);
                if (HRStringUtils.isNotEmpty((String)fieldVerify)) {
                    fieldStatusVerifyDescList.add(fieldVerify);
                }
            });
        });
        return fieldStatusVerifyDescList;
    }

    private static List<String> invisibleField(String infoGroupNumber, IFormView view, DynamicObject dy) {
        switch (infoGroupNumber) {
            case "S003": {
                return CustomStyleUtils.getCertInvisibleField(view, dy);
            }
            case "S004": {
                return CustomStyleUtils.getEduInvisibleField(view, dy);
            }
            case "S007": {
                return CustomStyleUtils.getLangInvisibleField(dy);
            }
        }
        return new ArrayList<String>();
    }

    private static List<String> getCertInvisibleField(IFormView view, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        if (!dy.containsProperty("entryfieldcert") || HRObjectUtils.isEmpty((Object)dy.getString("entryfieldcert"))) {
            return invisibleFieldList;
        }
        Map infoGroupConfigFieldCertMap = (Map)JSON.parseObject((String)view.getPageCache().get("certConfigMap"), Map.class);
        Collection values = infoGroupConfigFieldCertMap.values();
        values.forEach(invisibleFieldList::addAll);
        String fieldCertType = dy.getString("entryfieldcert");
        List showFiledList = (List)infoGroupConfigFieldCertMap.getOrDefault(fieldCertType, infoGroupConfigFieldCertMap.get("9999"));
        if (!CollectionUtils.isEmpty((Collection)showFiledList)) {
            if (dy.containsProperty("entryfield" + InfoGroupFieldConstants.CERT_ISPERMANENT) && dy.getBoolean("entryfield" + InfoGroupFieldConstants.CERT_ISPERMANENT)) {
                showFiledList.remove("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
            }
            invisibleFieldList.removeAll(showFiledList);
        }
        return invisibleFieldList;
    }

    private static List<String> getEduInvisibleField(IFormView view, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        if (!dy.containsProperty("entryfield" + InfoGroupFieldConstants.EDU_SCHOOLNAME) || 0L == dy.getLong("entryfield" + InfoGroupFieldConstants.EDU_SCHOOLNAME + "_id")) {
            return invisibleFieldList;
        }
        long eduSchoolNameId = dy.getLong("entryfield" + InfoGroupFieldConstants.EDU_SCHOOLNAME + "_id");
        if (!InfoGroupFieldConstants.OTHER_SCHOOL_ID.equals(eduSchoolNameId)) {
            invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.OTHER_SCHOOL);
        }
        List<String> eduLevelInvisibleFields = CustomStyleUtils.getEduLevelInvisibleField(view, dy);
        invisibleFieldList.addAll(eduLevelInvisibleFields);
        return invisibleFieldList;
    }

    public static List<String> getLangInvisibleField(DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        if (!dy.containsProperty("entryfield" + InfoGroupFieldConstants.LANGUAGE_TYPE) || 0L == dy.getLong("entryfield" + InfoGroupFieldConstants.LANGUAGE_TYPE + "_id")) {
            invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.LANG_OTHER_CERT);
            return invisibleFieldList;
        }
        long otherCertTypeId = dy.getLong("entryfield" + InfoGroupFieldConstants.LANGUAGE_TYPE + "_id");
        if (!InfoGroupFieldConstants.OTHER_LANGCERT_ID.equals(otherCertTypeId)) {
            invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.LANG_OTHER_CERT);
        }
        return invisibleFieldList;
    }

    public static List<String> getEduLevelInvisibleField(IFormView formView, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        if (!dy.containsProperty("entryfield" + InfoGroupFieldConstants.EDUCATIONID) || 0L == dy.getLong("entryfield" + InfoGroupFieldConstants.EDUCATIONID + "_id")) {
            return invisibleFieldList;
        }
        List fieldList = InfoGroupFieldConstants.EDU_FIELD_SET.stream().map(field -> "entryfield" + field).collect(Collectors.toList());
        String educationNumber = dy.getString("entryfield" + InfoGroupFieldConstants.EDUCATIONID + ".number");
        EduPageServiceImpl service = new EduPageServiceImpl();
        String educationId = service.educationNumberToId(educationNumber);
        Set configSet = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfigSet(formView, "lower_edu_id", "lower_edu_id");
        if (configSet.contains(educationId)) {
            invisibleFieldList.addAll(fieldList);
        }
        return invisibleFieldList;
    }

    public static String checkFieldListMob(List<InfoGroupEntity> infoGroupEntityList, DynamicObject onboard) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        for (InfoGroupEntity infoGroupEntity : infoGroupEntityList) {
            String errorGroupName = infoGroupEntity.isMultipleEntity() ? CustomStyleUtils.getErrorGroupNameMultipleMob(infoGroupEntity, onboard) : CustomStyleUtils.getErrorGroupNameSingleMob(infoGroupEntity, onboard);
            if (!HRStringUtils.isNotEmpty((String)errorGroupName)) continue;
            groupNameList.add(errorGroupName);
        }
        String errorItemFormat = "";
        String errorSeparator = "\u3001";
        String errorGroup = CustomStyleUtils.getFormatStr(groupNameList, errorItemFormat, errorSeparator);
        if (HRStringUtils.isNotEmpty((String)errorGroup)) {
            String errorPrefix = ResManager.loadKDString((String)"\u4ee5\u4e0b\u4fe1\u606f\u7ec4\u5185\u5b58\u5728\u5fc5\u586b\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5145\uff1a%s", (String)"CollectActivityPlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
            return String.format(Locale.ROOT, errorPrefix, errorGroup);
        }
        return "";
    }

    private static Map<String, DynamicObject> getDataByPageKeySingle(InfoGroupEntity infoGroupEntity, DynamicObject onboard) {
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)infoGroupEntity.getInfoGroupFieldList().size());
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
            if (!infoGroupField.isFieldMustInput()) continue;
            String pageKey = infoGroupField.getPageKey();
            DynamicObject dy = null;
            if (dyMap.get(pageKey) != null) continue;
            if (pageKey.contains(ENTITY_NUMBER_HOM)) {
                dy = OnbrdBillRepository.findOnbrdBillById(null, (Object)onboard.getPkValue());
            }
            if (pageKey.contains(ENTITY_NUMBER_HCF)) {
                dy = IHomToHcfAppService.getInstance().getSingleRowEntity(Long.valueOf(onboard.getLong("candidate_id")), pageKey);
            }
            if (dy == null) continue;
            dyMap.put(pageKey, dy);
        }
        return dyMap;
    }

    private static DynamicObject getHcfAddress(DynamicObject dy, InfoGroupEntity infoGroupEntity, InfoGroupEntity.InfoGroupField infoGroupField) {
        try {
            if (HRObjectUtils.isEmpty((Object)dy)) {
                return dy;
            }
            if (!InfoGroupEnum.CONTACT_INFO.getNumber().equals(infoGroupEntity.getInfoGroupNumber()) || !"hcf_canaddress".equals(infoGroupField.getPageKey())) {
                return dy;
            }
            long addresstypeId = 0L;
            if (InfoGroupFieldConstants.ADDRESSTYPE_COMMU_CONYNTRY.equals(infoGroupField.getFieldId()) || InfoGroupFieldConstants.ADDRESSTYPE_COMMU_INFO.equals(infoGroupField.getFieldId())) {
                addresstypeId = HcfCandidateConstants.ADDRESSTYPE_CN_COMMUID;
            }
            if (InfoGroupFieldConstants.ADDRESSTYPE_HUKOU_CONYNTRY.equals(infoGroupField.getFieldId()) || InfoGroupFieldConstants.ADDRESSTYPE_HUKOU_INFO.equals(infoGroupField.getFieldId())) {
                addresstypeId = HcfCandidateConstants.ADDRESSTYPE_CN_HUKOUID;
            }
            if (InfoGroupFieldConstants.ADDRESSTYPE_PERSON_CONYNTRY.equals(infoGroupField.getFieldId()) || InfoGroupFieldConstants.ADDRESSTYPE_PERSON_INFO.equals(infoGroupField.getFieldId())) {
                addresstypeId = HcfCandidateConstants.ADDRESSTYPE_CN_PERSONID;
            }
            if (dy.containsProperty("addresstype") && addresstypeId == dy.getLong("addresstype.id")) {
                return dy;
            }
            LOGGER.info(" get IHomToHcfAppService hcf_canaddress param:{},{}", (Object)addresstypeId, (Object)dy.getLong("candidate.id"));
            QFilter qFilter = new QFilter("addresstype", "=", (Object)addresstypeId);
            DynamicObjectCollection entities = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(dy.getLong("candidate.id")), "hcf_canaddress", new QFilter[]{qFilter});
            if (entities == null || entities.size() < 1) {
                return null;
            }
            return (DynamicObject)entities.get(0);
        }
        catch (Exception e) {
            LOGGER.error("get IHomToHcfAppService hcf_canaddress error", (Throwable)e);
            return dy;
        }
    }

    private static String getErrorGroupNameSingleMob(InfoGroupEntity infoGroupEntity, DynamicObject onboard) {
        Map<String, DynamicObject> dyMap = CustomStyleUtils.getDataByPageKeySingle(infoGroupEntity, onboard);
        int size = infoGroupEntity.getInfoGroupFieldList().size();
        ArrayList<String> mustInputList = new ArrayList<String>(size);
        ArrayList<String> notEmptyList = new ArrayList<String>(size);
        ArrayList<InfoGroupEntity.InfoGroupField> mustAttachList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        boolean existRecord = false;
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
            DynamicObject dy = dyMap.get(infoGroupField.getPageKey());
            dy = CustomStyleUtils.getHcfAddress(dy, infoGroupEntity, infoGroupField);
            if (!existRecord && dy != null && dy.containsProperty(infoGroupField.getFieldKey()) && !HRObjectUtils.isEmpty((Object)dy.get(infoGroupField.getFieldKey()))) {
                existRecord = true;
            }
            if (!infoGroupField.isFieldMustInput()) continue;
            if (dy == null && infoGroupEntity.getMustInput().booleanValue()) {
                return infoGroupEntity.getInfoGroupName();
            }
            if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(String.valueOf(infoGroupField.getFieldType()))) {
                mustAttachList.add(infoGroupField);
                continue;
            }
            mustInputList.add(infoGroupField.getFieldName());
            if (dy == null || !dy.containsProperty(infoGroupField.getFieldKey()) || HRObjectUtils.isEmpty((Object)dy.get(infoGroupField.getFieldKey()))) continue;
            notEmptyList.add(infoGroupField.getFieldName());
        }
        if (infoGroupEntity.getMustInput().booleanValue()) {
            if (mustInputList.size() != notEmptyList.size()) {
                LOGGER.info(" mustinput checksinglemob fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
                return infoGroupEntity.getInfoGroupName();
            }
        } else if (existRecord && mustInputList.size() != notEmptyList.size()) {
            LOGGER.info(" not mustinput checksinglemob fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
            return infoGroupEntity.getInfoGroupName();
        }
        return CustomStyleUtils.getAttachmentResult(existRecord, infoGroupEntity, onboard, mustAttachList);
    }

    private static Map<String, DynamicObjectCollection> getDataByPageKeyMultiple(InfoGroupEntity infoGroupEntity, DynamicObject onboard) {
        HashMap dyMap = Maps.newHashMapWithExpectedSize((int)infoGroupEntity.getInfoGroupFieldList().size());
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
            DynamicObjectCollection dys;
            String pageKey;
            if (!infoGroupField.isFieldMustInput() || dyMap.get(pageKey = infoGroupField.getPageKey()) != null || !pageKey.contains(ENTITY_NUMBER_HCF) || (dys = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(onboard.getLong("candidate_id")), pageKey)) == null || dys.size() <= 0) continue;
            dyMap.put(pageKey, dys);
        }
        return dyMap;
    }

    private static String getErrorGroupNameMultipleMob(InfoGroupEntity infoGroupEntity, DynamicObject onboard) {
        Map<String, DynamicObjectCollection> dysMap = CustomStyleUtils.getDataByPageKeyMultiple(infoGroupEntity, onboard);
        if (infoGroupEntity.getMustInput().booleanValue()) {
            for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
                DynamicObjectCollection dys;
                if (!infoGroupField.isFieldMustInput() || (dys = dysMap.get(infoGroupField.getPageKey())) != null && dys.size() != 0) continue;
                return infoGroupEntity.getInfoGroupName();
            }
        }
        ArrayList<InfoGroupEntity.InfoGroupField> mustAttachList = new ArrayList<InfoGroupEntity.InfoGroupField>();
        int size = infoGroupEntity.getInfoGroupFieldList().size();
        ArrayList<String> mustInputList = new ArrayList<String>(size);
        ArrayList<String> notEmptyList = new ArrayList<String>(size);
        boolean existRecord = false;
        for (Map.Entry<String, DynamicObjectCollection> entry : dysMap.entrySet()) {
            DynamicObjectCollection dys = entry.getValue();
            if (dys == null || dys.size() == 0) continue;
            String pageKey = entry.getKey();
            for (DynamicObject dy : dys) {
                List<String> invisibleFieldList = CustomStyleUtils.invisibleFieldMob(infoGroupEntity, dy);
                for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupEntity.getInfoGroupFieldList()) {
                    long count;
                    if (!infoGroupField.getPageKey().equals(pageKey) || (count = invisibleFieldList.stream().filter(invisibleField -> invisibleField.contains(String.valueOf(infoGroupField.getFieldId()))).count()) > 0L) continue;
                    Object fieldValue = null;
                    if (dy.containsProperty(infoGroupField.getFieldKey())) {
                        fieldValue = dy.get(infoGroupField.getFieldKey());
                        if (!existRecord && !HRObjectUtils.isEmpty((Object)fieldValue)) {
                            existRecord = true;
                        }
                    }
                    if (!infoGroupField.isFieldMustInput() || !CustomStyleUtils.isMatchEduCert(dy, infoGroupField)) continue;
                    if (InfoGroupFieldTypeEnum.ATTACH.getFieldType().equals(String.valueOf(infoGroupField.getFieldType()))) {
                        mustAttachList.add(infoGroupField);
                        continue;
                    }
                    mustInputList.add(infoGroupField.getFieldName());
                    if (HRObjectUtils.isEmpty((Object)fieldValue)) continue;
                    notEmptyList.add(infoGroupField.getFieldName());
                }
            }
        }
        if (infoGroupEntity.getMustInput().booleanValue()) {
            if (mustInputList.size() != notEmptyList.size()) {
                LOGGER.info(" mustinput checkmultiplemob fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
                return infoGroupEntity.getInfoGroupName();
            }
        } else if (existRecord && mustInputList.size() != notEmptyList.size()) {
            LOGGER.info(" not mustinput checkmultiplemob fail,{},{},{}", new Object[]{infoGroupEntity.getInfoGroupName(), mustInputList, notEmptyList});
            return infoGroupEntity.getInfoGroupName();
        }
        return CustomStyleUtils.getAttachmentResult(existRecord, infoGroupEntity, onboard, mustAttachList);
    }

    private static boolean isMatchEduCert(DynamicObject dy, InfoGroupEntity.InfoGroupField infoGroupField) {
        if (!"hcf_educertificate".equals(infoGroupField.getPageKey())) {
            return true;
        }
        Long fieldId = infoGroupField.getFieldId();
        String certTypeId = dy.getString("certtype.id");
        if (InfoGroupFieldConstants.EDU_REGISTER_ELECTRONIC_NUMBER.equals(fieldId) && "1040".equals(certTypeId)) {
            return true;
        }
        if (InfoGroupFieldConstants.EDU_NUMBER.equals(fieldId) && "1050".equals(certTypeId)) {
            return true;
        }
        if (InfoGroupFieldConstants.FOREIGN_EDU_NUMBER.equals(fieldId) && "1030".equals(certTypeId)) {
            return true;
        }
        if (InfoGroupFieldConstants.EDU_GRA_NUMBER.equals(fieldId) && "1010".equals(certTypeId)) {
            return true;
        }
        if (InfoGroupFieldConstants.EDU_DEGREE_NUMBER.equals(fieldId) && "1020".equals(certTypeId)) {
            return true;
        }
        return InfoGroupFieldConstants.EDU_CERT_CODE.equals(fieldId) && "1040".equals(certTypeId);
    }

    private static List<String> invisibleFieldMob(InfoGroupEntity infoGroupEntity, DynamicObject dy) {
        switch (infoGroupEntity.getInfoGroupNumber()) {
            case "S003": {
                return CustomStyleUtils.getCertInvisibleFieldMob(infoGroupEntity.getInfoGroupFieldList(), dy);
            }
            case "S004": {
                return CustomStyleUtils.getEduInvisibleFieldMob(infoGroupEntity.getInfoGroupFieldList(), dy);
            }
            case "S007": {
                return CustomStyleUtils.getLangInvisibleFieldMob(infoGroupEntity.getInfoGroupFieldList(), dy);
            }
        }
        return new ArrayList<String>();
    }

    private static List<String> getCertInvisibleFieldMob(List<InfoGroupEntity.InfoGroupField> infoGroupFieldList, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        DynamicObjectCollection infoGroupConfigFieldCert = HomConfigRepository.queryConfigEntityByBusinessKey((String)"info_group_config_fieldCert");
        if (CollectionUtils.isEmpty((Collection)infoGroupConfigFieldCert)) {
            return invisibleFieldList;
        }
        HashMap certConfigMap = new HashMap();
        infoGroupConfigFieldCert.forEach(config -> {
            String entityValue = config.getString("entityvalue");
            LinkedList list = new LinkedList(CollectionUtils.arrayToList((Object)entityValue.split(",")));
            String entityKey = config.getString("entitykey");
            certConfigMap.put(entityKey, list);
        });
        for (InfoGroupEntity.InfoGroupField infoGroupField : infoGroupFieldList) {
            List showFiledList;
            if (!InfoGroupFieldConstants.CERT_TYPE.equals(infoGroupField.getFieldId()) || !dy.containsProperty("credentialstype")) continue;
            Collection values = certConfigMap.values();
            values.forEach(invisibleFieldList::addAll);
            String certType = dy.getString(infoGroupField.getFieldKey() + "_id");
            if (!HRStringUtils.isNotEmpty((String)certType) || CollectionUtils.isEmpty((Collection)(showFiledList = (List)certConfigMap.getOrDefault(certType, certConfigMap.get("9999"))))) continue;
            if (dy.containsProperty("ispermanent") && dy.getBoolean("ispermanent")) {
                showFiledList.remove("field" + InfoGroupFieldConstants.CERT_EXPIRATIONDATE);
            }
            invisibleFieldList.removeAll(showFiledList);
        }
        return invisibleFieldList;
    }

    private static List<String> getEduInvisibleFieldMob(List<InfoGroupEntity.InfoGroupField> infoGroupFieldList, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        infoGroupFieldList.stream().filter(infoGroupField -> InfoGroupFieldConstants.EDU_SCHOOLNAME.equals(infoGroupField.getFieldId())).forEach(infoGroupField -> {
            if (dy.containsProperty(infoGroupField.getFieldKey()) && 0L != dy.getLong(infoGroupField.getFieldKey() + "_id")) {
                long eduSchoolNameId = dy.getLong(infoGroupField.getFieldKey() + "_id");
                if (!InfoGroupFieldConstants.OTHER_SCHOOL_ID.equals(eduSchoolNameId)) {
                    invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.OTHER_SCHOOL);
                }
                List<String> eduLevelInvisibleFields = CustomStyleUtils.getEduLevelInvisibleFieldMob(infoGroupFieldList, dy);
                invisibleFieldList.addAll(eduLevelInvisibleFields);
            }
        });
        return invisibleFieldList;
    }

    public static List<String> getEduLevelInvisibleFieldMob(List<InfoGroupEntity.InfoGroupField> infoGroupFieldList, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        infoGroupFieldList.stream().filter(infoGroupField -> InfoGroupFieldConstants.EDUCATIONID.equals(infoGroupField.getFieldId())).forEach(infoGroupField -> {
            if (dy.containsProperty(infoGroupField.getFieldKey()) && 0L != dy.getLong(infoGroupField.getFieldKey() + "_id")) {
                List fieldList = InfoGroupFieldConstants.EDU_FIELD_SET.stream().map(field -> "entryfield" + field).collect(Collectors.toList());
                String educationNumber = dy.getString(infoGroupField.getFieldKey() + ".number");
                EduPageServiceImpl service = new EduPageServiceImpl();
                String educationId = service.educationNumberToId(educationNumber);
                Set configSet = ((IHomConfigDomainService)ServiceFactory.getService(IHomConfigDomainService.class)).getConfigSet(null, "lower_edu_id", "lower_edu_id");
                if (configSet.contains(educationId)) {
                    invisibleFieldList.addAll(fieldList);
                }
            }
        });
        return invisibleFieldList;
    }

    public static List<String> getLangInvisibleFieldMob(List<InfoGroupEntity.InfoGroupField> infoGroupFieldList, DynamicObject dy) {
        ArrayList<String> invisibleFieldList = new ArrayList<String>();
        infoGroupFieldList.stream().filter(infoGroupField -> InfoGroupFieldConstants.LANGUAGE_TYPE.equals(infoGroupField.getFieldId())).forEach(infoGroupField -> {
            if (!dy.containsProperty(infoGroupField.getFieldKey()) || 0L == dy.getLong(infoGroupField.getFieldKey() + "_id")) {
                invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.LANG_OTHER_CERT);
                return;
            }
            long otherCertTypeId = dy.getLong(infoGroupField.getFieldKey() + "_id");
            if (!InfoGroupFieldConstants.OTHER_LANGCERT_ID.equals(otherCertTypeId)) {
                invisibleFieldList.add("entryfield" + InfoGroupFieldConstants.LANG_OTHER_CERT);
            }
        });
        return invisibleFieldList;
    }
}

