/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.common;

import java.text.DecimalFormat;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hom.business.application.common.CoordinateTransformUtil;

public class PointUtil {
    private static final Log LOGGER = LogFactory.getLog(PointUtil.class);
    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double[] local = CoordinateTransformUtil.wgs84tobd09((double)lng2, (double)lat2);
        lng2 = local[0];
        lat2 = local[1];
        double radLat1 = PointUtil.rad(lat1);
        double radLat2 = PointUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = PointUtil.rad(lng1) - PointUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        DecimalFormat df = new DecimalFormat("#.000");
        s = Double.parseDouble(df.format(s));
        LOGGER.info("PointUtil_getDistance:{}", (Object)s);
        LOGGER.info("lat1:{},lng1:{},lat2:{},lng2:{}", new Object[]{lat1, lng1, lat2, lng2});
        return s * 1000.0;
    }
}

