/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.formplugin.mobile.collect;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hcf.IHomToHcfAppService;
import kd.hr.hom.business.application.impl.page.LabelApAdatper;
import kd.hr.hom.business.domain.repository.common.HomCommonRepository;
import kd.hr.hom.business.domain.repository.config.CollectConfigRepository;
import kd.hr.hom.business.domain.service.ServiceFactory;
import kd.hr.hom.business.domain.service.activity.IActivityDomainService;
import kd.hr.hom.business.domain.service.collect.ICollectGroupStatusService;
import kd.hr.hom.business.domain.service.collect.ICollectService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdBillDomainService;
import kd.hr.hom.common.entity.InfoGroupConfigEntity;
import kd.hr.hom.common.enums.ActivityNumberEnum;
import kd.hr.hom.common.enums.CollectApproveStatusEnum;
import kd.hr.hom.common.enums.CollectManageStatusEnum;
import kd.hr.hom.common.enums.InfoGroupStatusEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.util.ErrorInfoUtils;
import kd.hr.hom.formplugin.common.CustomStyleUtils;
import kd.sdk.hr.hom.common.InfoGroupEntity;

public class CollectActivityMobilePlugin
extends AbstractMobFormPlugin
implements CellClickListener {
    private String title = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"CollectActivityMobilePlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]);
    private static final String ACTIVITY_STATUS_LABEL = "activitystatus";

    public void createNewData(BizDataEventArgs e) {
        Long onboardId = (Long)this.getView().getFormShowParameter().getCustomParam("onbrdid");
        DynamicObject collectActivity = HomCommonRepository.queryDynamicObject((String)"hom_collectphone", (String)"", (QFilter[])new QFilter[]{new QFilter("onboard", "=", (Object)onboardId)});
        DynamicObject collectGroupDyn = HomCommonRepository.queryDynamicObject((String)"hom_collectgroupstatus", (String)"", (QFilter[])new QFilter[]{new QFilter("collectactivity", "=", (Object)collectActivity.getLong("id"))});
        if (HRObjectUtils.isEmpty((Object)collectGroupDyn)) {
            ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).saveCollectGroupStatus(collectActivity);
        }
        Map<Long, String> groupStatusMap = collectGroupDyn.getDynamicObjectCollection("infogroupentry").stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("infogroup.id"), dynamicObject -> dynamicObject.getString("infogroupstatus")));
        Long collectConfigHisId = collectActivity.getLong("collectconfighis.id");
        DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
        HashMap mustInputMap = new HashMap();
        DynamicObjectCollection entityentryList = collectActivity.getDynamicObjectCollection("infogroupentity");
        String enrollStatus = collectActivity.getString("onboard.enrollstatus");
        this.getPageCache().put("onbrd_enrollstatus", enrollStatus);
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            DynamicObject dynamicObject = entityentryList.addNew();
            dynamicObject.set("infogroupname", (Object)infoGroupEntity.getInfoGroupName());
            dynamicObject.set("groupid", (Object)infoGroupEntity.getInfoGroupId());
            dynamicObject.set("infogrouptitle", (Object)infoGroupEntity.getInfoGroupDisplayTips());
            dynamicObject.set("status", groupStatusMap.get(infoGroupEntity.getInfoGroupId()));
            dynamicObject.set("multiple", (Object)(infoGroupEntity.isMultipleEntity() ? "1" : "0"));
            String mustInput = "0";
            if (infoGroupEntity.getMustInput().booleanValue()) {
                mustInputMap.put("mustinput" + infoGroupEntity.getInfoGroupId(), infoGroupEntity.getInfoGroupName());
                mustInput = "1";
            }
            dynamicObject.set("mustinput", (Object)mustInput);
            String pageKey = infoGroupEntity.getInfoGroupFieldList().stream().map(InfoGroupEntity.InfoGroupField::getPageKey).filter(page -> !HRStringUtils.equals((String)"hcf_canaddress", (String)page) || !HRStringUtils.equals((String)"hcf_educertificate", (String)page)).findFirst().orElse("");
            dynamicObject.set("pagekey", (Object)pageKey);
        });
        Function<String, Integer> getOrderIndex = status -> {
            if (HRStringUtils.equals((String)status, (String)"0")) {
                return 2;
            }
            if (HRStringUtils.equals((String)status, (String)"1")) {
                return 2;
            }
            if (HRStringUtils.equals((String)status, (String)"2")) {
                return 1;
            }
            return 2;
        };
        List orderBy = entityentryList.stream().sorted(Comparator.comparingInt(dy -> (Integer)getOrderIndex.apply(dy.getString("status")))).collect(Collectors.toList());
        entityentryList.clear();
        entityentryList.addAll(orderBy);
        e.setDataEntity((Object)collectActivity);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setActivityStatus();
        this.initInfoGroupStatus();
    }

    private void initInfoGroupStatus() {
        IPageCache cache = this.getView().getPageCache();
        DynamicObject collectActivity = this.getModel().getDataEntity(true);
        long candidateId = collectActivity.getLong("onboard.candidate.id");
        if (candidateId == 0L) {
            throw new KDBizException("candidate don't exist:" + candidateId);
        }
        cache.put("candidateid", String.valueOf(candidateId));
        cache.put("onbrdid", collectActivity.getString("onboard.id"));
        Long collectConfigHisId = this.getModel().getDataEntity().getLong("collectconfighis.id");
        DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
        InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis, Long.valueOf(this.getModel().getDataEntity().getLong("onboard.org.id")));
        HashMap mustInputMap = new HashMap();
        infoGroupConfigEntity.getInfoGroupEntityList().forEach(infoGroupEntity -> {
            if (infoGroupEntity.getMustInput().booleanValue()) {
                mustInputMap.put("mustinput" + infoGroupEntity.getInfoGroupId(), infoGroupEntity.getInfoGroupName());
            }
            cache.put(String.valueOf(infoGroupEntity.getInfoGroupId()), SerializationUtils.toJsonString((Object)infoGroupEntity));
        });
        cache.put("mustinput", SerializationUtils.toJsonString(mustInputMap));
        cache.put("infoGroupConfig", SerializationUtils.toJsonString((Object)infoGroupConfigEntity));
    }

    private boolean isView(DynamicObject collectActivity) {
        String approvestatus = collectActivity.getString("approvestatus");
        if (HRStringUtils.isEmpty((String)approvestatus)) {
            return false;
        }
        CollectApproveStatusEnum approvesStatus = CollectApproveStatusEnum.valueByStatus((String)approvestatus);
        return CollectApproveStatusEnum.PASS == approvesStatus || CollectApproveStatusEnum.FAIL == approvesStatus || CollectApproveStatusEnum.REMIT == approvesStatus || CollectApproveStatusEnum.APPROVING == approvesStatus;
    }

    private boolean isRejectView(DynamicObject collectActivity) {
        String approvestatus = collectActivity.getString("approvestatus");
        if (HRStringUtils.isEmpty((String)approvestatus)) {
            return false;
        }
        CollectApproveStatusEnum approvesStatus = CollectApproveStatusEnum.valueByStatus((String)approvestatus);
        return CollectApproveStatusEnum.REJECT == approvesStatus;
    }

    private void setActivityStatus() {
        DynamicObject collectActivity = this.getModel().getDataEntity();
        String approvestatus = collectActivity.getString("approvestatus");
        if (!HRStringUtils.isEmpty((String)approvestatus)) {
            String name;
            CollectApproveStatusEnum approvesStatus = CollectApproveStatusEnum.valueByStatus((String)approvestatus);
            if (this.isView(collectActivity)) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
            this.getView().setVisible(Boolean.valueOf(approvesStatus != CollectApproveStatusEnum.APPROVING), new String[]{"imageap2"});
            this.setLabelStyle(CollectApproveStatusEnum.APPROVING.getDesc(), "#276FF5", "#ffffff", ACTIVITY_STATUS_LABEL, "#276FF5");
            if (approvestatus.equals(CollectApproveStatusEnum.APPROVING.getStatus())) {
                this.setLabelStyle(CollectApproveStatusEnum.APPROVING.getDesc(), "#276FF5", "#ffffff", ACTIVITY_STATUS_LABEL, "#276FF5");
            }
            if (approvestatus.equals(CollectApproveStatusEnum.REJECT.getStatus())) {
                name = ResManager.loadKDString((String)"\u5df2\u9a73\u56de", (String)"CollectActivityMobilePlugin_5", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.setLabelStyle(name, "#FB2323", "#ffffff", ACTIVITY_STATUS_LABEL, "#FB2323");
            }
            if (approvestatus.equals(CollectApproveStatusEnum.PASS.getStatus()) || approvestatus.equals(CollectApproveStatusEnum.REMIT.getStatus())) {
                name = String.format(ResManager.loadKDString((String)"\u5df2\u901a\u8fc7%s", (String)"CollectActivityMobilePlugin_7", (String)"hr-hom-formplugin", (Object[])new Object[0]), approvestatus.equals(CollectApproveStatusEnum.PASS.getStatus()) ? "" : ">");
                this.setLabelStyle(name, "#1BA854", "#ffffff", ACTIVITY_STATUS_LABEL, "#1BA854");
            }
            if (approvestatus.equals(CollectApproveStatusEnum.FAIL.getStatus())) {
                name = ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7>", (String)"CollectActivityMobilePlugin_8", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.setLabelStyle(name, "#FB2323", "#ffffff", ACTIVITY_STATUS_LABEL, "#FB2323");
            }
        } else {
            String collectStatus = collectActivity.getString("collectstatus");
            if (collectStatus.equals(CollectManageStatusEnum.SUBMIT.getStatus())) {
                String name = ResManager.loadKDString((String)"\u5f85\u63d0\u4ea4", (String)"CollectActivityMobilePlugin_10", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.setLabelStyle(name, "#276FF5", "#ffffff", ACTIVITY_STATUS_LABEL, "#276FF5");
            } else {
                String name = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CollectActivityMobilePlugin_9", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                this.setLabelStyle(name, "#1BA854", "#ffffff", ACTIVITY_STATUS_LABEL, "#1BA854");
            }
        }
    }

    public void setLabelStyle(String name, final String borderStyle, String color, String labelEntityName, String backColor) {
        LabelApAdatper labelApAdatper = new LabelApAdatper(labelEntityName, name){

            public void setStyle() {
                this.border.setBottom(borderStyle);
                this.border.setLeft(borderStyle);
                this.border.setTop(borderStyle);
                this.border.setRight(borderStyle);
                this.padding.setLeft("7px");
                this.padding.setRight("7px");
            }
        };
        LabelAp labelAp = labelApAdatper.getLabelAp();
        labelAp.setForeColor(color);
        labelAp.setBackColor(backColor);
        labelAp.setLabelStyle("1");
        this.getView().updateControlMetadata(labelEntityName, labelAp.createControl());
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        CardEntry cardEntry;
        Object source = cellClickEvent.getSource();
        int row = cellClickEvent.getRow();
        if (source instanceof CardEntry && "infogroupentity".equals((cardEntry = (CardEntry)source).getKey())) {
            DynamicObject collectActivity = this.getModel().getDataEntity();
            String approvestatus = collectActivity.getString("approvestatus");
            String collectstatus = collectActivity.getString("collectstatus");
            OperationStatus status = OperationStatus.EDIT;
            if (HRStringUtils.isEmpty((String)approvestatus)) {
                if (CollectManageStatusEnum.SUBMIT != CollectManageStatusEnum.valueByStatus((String)collectstatus)) {
                    status = OperationStatus.VIEW;
                }
            } else {
                String infoEntityStatus;
                CollectApproveStatusEnum approvesStatus = CollectApproveStatusEnum.valueByStatus((String)approvestatus);
                if (this.isView(collectActivity)) {
                    status = OperationStatus.VIEW;
                }
                if (HRStringUtils.equals((String)(infoEntityStatus = cardEntry.getEntryData().getDataEntitys()[row].getString("status")), (String)"1") && approvesStatus != CollectApproveStatusEnum.REJECT) {
                    status = OperationStatus.VIEW;
                }
                if (approvesStatus == CollectApproveStatusEnum.REJECT) {
                    status = HRStringUtils.equals((String)infoEntityStatus, (String)"2") ? OperationStatus.EDIT : OperationStatus.VIEW;
                }
            }
            if (this.isValidTime()) {
                status = OperationStatus.VIEW;
            }
            this.showInfoGroupDetail(cardEntry, row, status);
        }
    }

    private boolean isValidTime() {
        IFormView formView = this.getView();
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        Long onbrdId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("onbrdid"));
        QFilter qFilter = new QFilter("id", "=", (Object)onbrdId);
        DynamicObject onbrdBillInfo = IOnbrdBillDomainService.getInstance().findOnbrdBill("validuntil", new QFilter[]{qFilter});
        Date validtime = onbrdBillInfo.getDate("validuntil");
        if (validtime == null) {
            return false;
        }
        return HRDateTimeUtils.dayBefore((Date)validtime, (Date)Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    private void showInfoGroupDetail(CardEntry cardEntry, int row, OperationStatus status) {
        String approvestatus = this.getModel().getDataEntity().getString("approvestatus");
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        String candidateId = this.getPageCache().get("candidateid");
        String onboardId = this.getPageCache().get("onbrdid");
        DynamicObject dyo = cardEntry.getEntryData().getDataEntitys()[row];
        String multiple = dyo.getString("multiple");
        String groupid = dyo.getString("groupid");
        String pageKey = dyo.getString("pagekey");
        if (HRStringUtils.equals((String)multiple, (String)"1")) {
            mobileFormShowParameter.setFormId("hom_multiplelist_h5");
            mobileFormShowParameter.setCustomParam("collectId", (Object)this.getModel().getDataEntity().getLong("id"));
            mobileFormShowParameter.setStatus(status);
            mobileFormShowParameter.setCustomParam("detailStatus", (Object)status);
        } else {
            String formId = "hom_collectinfodetail_h5";
            if (HRStringUtils.equals((String)groupid, (String)"1333291938488558592")) {
                formId = "hom_photo";
                mobileFormShowParameter.setCustomParam("groupid", (Object)groupid);
                DynamicObject homEntity = HomCommonRepository.queryDynamicObjectByPk((String)"hom_onbrdinfo", (String)"picturefield", (Object)Long.parseLong(onboardId));
                mobileFormShowParameter.setStatus(status);
                if (!HRObjectUtils.isEmpty((Object)homEntity)) {
                    mobileFormShowParameter.setCustomParam("photopath", (Object)homEntity.getString("picturefield"));
                }
            } else if (pageKey.contains("hom_onbrd")) {
                mobileFormShowParameter.setCustomParam("id", (Object)onboardId);
                mobileFormShowParameter.setStatus(status);
            } else {
                DynamicObjectCollection attachData = IHomToHcfAppService.getInstance().getHisMultiRowEntity(Long.valueOf(Long.parseLong(candidateId)), pageKey);
                if (attachData.size() == 0) {
                    mobileFormShowParameter.setCustomParam("id", (Object)"0");
                    mobileFormShowParameter.setStatus(OperationStatus.ADDNEW);
                } else {
                    mobileFormShowParameter.setCustomParam("id", (Object)((DynamicObject)attachData.get(0)).getString("id"));
                    mobileFormShowParameter.setStatus(status);
                }
            }
            mobileFormShowParameter.setFormId(formId);
        }
        String enrollStatus = this.getPageCache().get("onbrd_enrollstatus");
        boolean isWaitOnbrd = OnbrdStatusEnum.WAIT_ONBRD.getValue().equals(enrollStatus);
        if (!isWaitOnbrd) {
            mobileFormShowParameter.setStatus(OperationStatus.VIEW);
            mobileFormShowParameter.setCustomParam("detailStatus", (Object)OperationStatus.VIEW);
        }
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCustomParam("infoGroupEntity", (Object)this.getPageCache().get(groupid));
        mobileFormShowParameter.setCustomParam("infoGroupConfig", (Object)this.getPageCache().get("infoGroupConfig"));
        mobileFormShowParameter.setCustomParam("candidateid", (Object)candidateId);
        mobileFormShowParameter.setCustomParam("onbrdid", (Object)onboardId);
        mobileFormShowParameter.setCustomParam("approvestatus", (Object)approvestatus);
        mobileFormShowParameter.setCustomParam("activityId", (Object)this.getModel().getDataEntity().getLong("id"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void afterBindData(EventObject e) {
        CardEntry entryGrid;
        super.afterBindData(e);
        DynamicObject collectActivity = this.getModel().getDataEntity();
        String approvestatus = collectActivity.getString("approvestatus");
        String enrollStatus = this.getPageCache().get("onbrd_enrollstatus");
        boolean isWaitOnbrd = OnbrdStatusEnum.WAIT_ONBRD.getValue().equals(enrollStatus);
        boolean validTime = this.isValidTime();
        if (HRStringUtils.isEmpty((String)approvestatus)) {
            String collectstatus = collectActivity.getString("collectstatus");
            if (CollectManageStatusEnum.SUBMIT == CollectManageStatusEnum.valueByStatus((String)collectstatus) && !validTime && isWaitOnbrd) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"mtoolbarap"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
            }
        } else if (CollectApproveStatusEnum.REJECT == CollectApproveStatusEnum.valueByStatus((String)approvestatus) && !validTime && isWaitOnbrd) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"mtoolbarap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.getModel().setDataChanged(false);
        CollectActivityMobilePlugin.showNavigationBar("flexpanelap", this.getView().getFormShowParameter().getCustomParam("onbrdid").toString(), this.getView());
        if (this.isView(collectActivity)) {
            entryGrid = (CardEntry)this.getView().getControl("infogroupentity");
            IntStream.range(0, entryGrid.getEntryData().getDataEntitys().length).forEach(index -> entryGrid.setChildVisible(false, index, new String[]{"status"}));
        }
        if (this.isRejectView(collectActivity)) {
            entryGrid = (CardEntry)this.getView().getControl("infogroupentity");
            IntStream.range(0, entryGrid.getEntryData().getDataEntitys().length).forEach(index -> {
                DynamicObject dataEntity = entryGrid.getEntryData().getDataEntitys()[index];
                if (!InfoGroupStatusEnum.REJECT.getStatus().equals(dataEntity.get("status"))) {
                    entryGrid.setChildVisible(false, index, new String[]{"status"});
                }
            });
        }
    }

    public static void showNavigationBar(String targetKey, String onbrdId, IFormView view) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("hom_navigationbar");
        mobileFormShowParameter.getOpenStyle().setTargetKey(targetKey);
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        mobileFormShowParameter.setCustomParam("onbrdid", (Object)onbrdId);
        view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry infogroupentity = (CardEntry)this.getControl("infogroupentity");
        infogroupentity.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"submit", ACTIVITY_STATUS_LABEL});
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button submit;
        super.beforeClick(evt);
        if (evt.getSource() instanceof Button && "submit".equals((submit = (Button)evt.getSource()).getKey())) {
            boolean collectActivityChange;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            boolean isEnroll = IOnbrdBillDomainService.getInstance().isCanOperate(Long.valueOf(dataEntity.getLong("onboard.id")));
            if (isEnroll) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5f85\u5165\u804c\u4eba\u5458\u5165\u804c\u6d41\u7a0b\u5df2\u7ed3\u675f\uff0c\u8bf7\u6838\u5bf9\u5165\u804c\u72b6\u6001\u3002", (String)"CollectActivityPlugin_0", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                return;
            }
            long collectConfigHisId = dataEntity.getLong("collectconfighis.id");
            DynamicObject collectConfigHis = CollectConfigRepository.queryCollectConfigHisById((String)"", (Long)collectConfigHisId);
            InfoGroupConfigEntity infoGroupConfigEntity = ((ICollectService)ServiceFactory.getService(ICollectService.class)).transferDynToEntity(collectConfigHis);
            String groupInputErrorInfo = CustomStyleUtils.checkFieldListMob(infoGroupConfigEntity.getInfoGroupEntityList(), dataEntity.getDynamicObject("onboard"));
            if (HRStringUtils.isNotEmpty((String)groupInputErrorInfo)) {
                this.getView().showConfirm(groupInputErrorInfo, MessageBoxOptions.Toast);
                evt.setCancel(true);
            }
            if (collectActivityChange = ((ICollectService)ServiceFactory.getService(ICollectService.class)).isCollectActivityChange(dataEntity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"HR\u5df2\u4e3a\u60a8\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"CollectActivityPlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button submit = (Button)evt.getSource();
            DynamicObject collectActivity = this.getModel().getDataEntity();
            String approvestatus = collectActivity.getString("approvestatus");
            if ("submit".equals(submit.getKey())) {
                OperationResult operationResult;
                DynamicObject dbCollectActivity = HomCommonRepository.queryDynamicObject((String)"hom_collect", (String)"approvestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)collectActivity.getLong("id"))});
                String dbApprovestatus = dbCollectActivity.getString("approvestatus");
                if (!HRStringUtils.equals((String)dbApprovestatus, (String)approvestatus)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"CollectActivityMobilePlugin_3", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                    this.getView().invokeOperation("refresh");
                    return;
                }
                boolean isApprove = !HRStringUtils.isEmpty((String)approvestatus);
                ArrayList<Long> ids = new ArrayList<Long>();
                ids.add(this.getModel().getDataEntity().getLong("onboard.id"));
                if (!isApprove && !(operationResult = IActivityDomainService.getInstance().batchConsentTask(ids, ActivityNumberEnum.INFOCOLLECTION)).isSuccess()) {
                    String errorPrefix = ResManager.loadKDString((String)"\u786e\u8ba4\u5e76\u63d0\u4ea4\u5931\u8d25:", (String)"CollectActivityMobilePlugin_6", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(errorPrefix + ErrorInfoUtils.getMessage((OperationResult)operationResult));
                    return;
                }
                if (isApprove) {
                    this.getModel().setValue("approvestatus", (Object)CollectApproveStatusEnum.APPROVING.getStatus());
                } else {
                    this.getModel().setValue("collectstatus", (Object)CollectManageStatusEnum.FINISH.getStatus());
                }
                long collectactivity = this.getModel().getDataEntity().getLong("id");
                String onboardId = this.getModel().getDataEntity().getString("onboard.id");
                ((ICollectGroupStatusService)ServiceFactory.getService(ICollectGroupStatusService.class)).setActiveStatusCompleted(onboardId, Long.valueOf(collectactivity));
                HomCommonRepository.updateDynamicObject((String)"hom_collect", (DynamicObject)this.getModel().getDataEntity());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fe1\u606f\u63d0\u4ea4\u6210\u529f", (String)"CollectActivityMobilePlugin_4", (String)"hr-hom-formplugin", (Object[])new Object[0]));
                this.refresh();
                this.getView().invokeOperation("close");
            } else if (HRStringUtils.equals((String)submit.getKey(), (String)ACTIVITY_STATUS_LABEL) && !HRStringUtils.isEmpty((String)approvestatus)) {
                CollectApproveStatusEnum approvesStatus = CollectApproveStatusEnum.valueByStatus((String)approvestatus);
                if (CollectApproveStatusEnum.FAIL == approvesStatus) {
                    String remark = ResManager.loadKDString((String)"\u60a8\u7684\u91c7\u96c6\u4fe1\u606f\u672a\u901a\u8fc7\uff0c\u8bf7\u8054\u7cfbHR\u5904\u7406\u3002", (String)"CollectActivityMobilePlugin_1", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(this.title, remark, MessageBoxOptions.Toast, ConfirmTypes.Default, new ConfirmCallBackListener("", (IFormPlugin)this));
                } else if (CollectApproveStatusEnum.REMIT == approvesStatus) {
                    String remark = ResManager.loadKDString((String)"\u60a8\u7684\u91c7\u96c6\u4fe1\u606f\u65e0\u9700\u5ba1\u6838\uff0c\u8bf7\u7ee7\u7eed\u5176\u4ed6\u5165\u804c\u6d41\u7a0b\u3002", (String)"CollectActivityMobilePlugin_2", (String)"hr-hom-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(this.title, remark, MessageBoxOptions.Toast, ConfirmTypes.Default, new ConfirmCallBackListener("", (IFormPlugin)this));
                }
            }
        }
    }

    private void refresh() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
            IFormView lastView = parentView.getParentView();
            if (lastView != null) {
                lastView.invokeOperation("refresh");
                this.getView().sendFormAction(lastView);
            } else {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        }
    }
}

